#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `balance` double(18,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (2, 'SALARY', '', '-2000.00', '2022-03-14 13:23:33', '2022-05-12 10:24:52');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (3, 'DR PRIYA', '', '0.00', '2022-03-14 13:28:11', '2022-03-18 13:00:27');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (4, 'QSC EXPENSE', '', '-1738.00', '2022-03-14 14:09:21', '2022-03-18 13:49:37');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (6, 'PUYAPALLY', '', '100000.00', '2022-03-14 14:18:00', '2022-03-21 09:53:53');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (8, 'HOME EXPENSE', '', '-2030.00', '2022-03-18 12:54:30', '2022-03-18 13:34:44');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (9, 'DOCTORS FEE', '', '-2200.00', '2022-03-18 12:55:26', '2022-05-09 16:46:36');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (10, 'SALARY ADVANCE', '', '0.00', '2022-03-18 12:55:52', '2022-03-18 12:55:52');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (11, 'OLAYIL', '', '-8550.00', '2022-03-18 12:56:45', '2022-03-18 13:43:03');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (12, 'VEHICLE EXPENSE', '', '-100.00', '2022-03-18 12:57:02', '2022-03-18 13:39:32');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (13, 'INSURANCE', '', '0.00', '2022-03-18 12:57:10', '2022-03-18 12:57:10');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (14, 'NEW CENTRE KPLY', '', '-9750.00', '2022-03-18 12:57:45', '2022-04-20 17:24:56');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (15, 'DR VINOD JACOB', '', '-1601.00', '2022-03-18 12:58:14', '2022-05-09 16:41:14');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (16, 'ECHO,TMT,ECG,EEG,FNAC,NCV,BMD,OPG', '', '-1000.00', '2022-03-18 13:36:40', '2022-03-18 13:41:31');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (17, 'COLLECTION', '', '121240.00', '2022-03-26 11:11:56', '2022-04-23 18:31:49');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (18, 'PURCHASE', '', '-2881.00', '2022-04-20 13:03:55', '2022-05-12 10:20:07');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (19, 'TELEPHONE BILLS', '', '-235.00', '2022-04-20 13:26:30', '2022-04-20 13:27:37');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (20, 'DONATION', '', '-100.00', '2022-04-20 16:33:14', '2022-04-20 16:46:05');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (21, 'FUEL EXPENSE', '', '-2100.00', '2022-04-20 16:36:06', '2022-04-30 18:16:42');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (22, 'OFFICE EXPENSE', '', '-850.00', '2022-04-20 16:40:31', '2022-04-30 18:48:45');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (23, 'PRINTER INK', '', '-890.00', '2022-04-20 16:40:59', '2022-04-20 16:42:31');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (24, 'VEHICLE CHARGE', '', '-2500.00', '2022-04-20 16:43:04', '2022-04-20 16:44:15');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (25, 'DISCOUNT ALLOWED', '', '-2250.00', '2022-04-20 16:46:46', '2022-05-09 16:34:32');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (26, 'DDRC', '', '-810.00', '2022-04-20 17:17:31', '2022-04-20 17:20:29');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (27, 'MAINTANANCE', '', '-120.00', '2022-04-30 18:32:34', '2022-04-30 18:41:39');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` varchar(20) NOT NULL,
  `doctor_id` varchar(20) NOT NULL,
  `patient_id` varchar(20) NOT NULL,
  `consultation_fees` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL,
  `schedule` varchar(50) NOT NULL,
  `remarks` text NOT NULL,
  `appointment_date` date NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `category` varchar(100) NOT NULL,
  `test` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chemical
#

DROP TABLE IF EXISTS `chemical`;

CREATE TABLE `chemical` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(50) NOT NULL,
  `category_id` int(11) NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `sales_unit_id` int(11) NOT NULL,
  `unit_ratio` varchar(20) DEFAULT '1',
  `purchase_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `sales_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `available_stock` varchar(11) NOT NULL DEFAULT '0',
  `photo` varchar(100) DEFAULT NULL,
  `remarks` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `chemical` (`id`, `name`, `code`, `category_id`, `purchase_unit_id`, `sales_unit_id`, `unit_ratio`, `purchase_price`, `sales_price`, `available_stock`, `photo`, `remarks`, `created_at`, `updated_at`) VALUES (2, 'SANITIZER', 'SNTIZR', 4, 2, 2, '30', '515.00', '550.00', '0', NULL, '', '2022-03-14 18:04:38', '2022-03-14 18:04:38');


#
# TABLE STRUCTURE FOR: chemical_assigned
#

DROP TABLE IF EXISTS `chemical_assigned`;

CREATE TABLE `chemical_assigned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chemical_category
#

DROP TABLE IF EXISTS `chemical_category`;

CREATE TABLE `chemical_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (1, 'SGOT', '2022-03-14 11:07:05', '2022-03-14 11:07:05');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (2, 'Syringe', '2022-03-14 11:42:29', '2022-03-14 11:42:29');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (3, 'Fluoride Tube', '2022-03-14 11:43:23', '2022-03-14 11:43:23');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (4, 'STORES', '2022-03-14 18:02:40', '2022-03-14 18:02:40');


#
# TABLE STRUCTURE FOR: chemical_stock
#

DROP TABLE IF EXISTS `chemical_stock`;

CREATE TABLE `chemical_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inovice_no` varchar(25) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `date` date DEFAULT NULL,
  `stock_quantity` varchar(20) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `stock_by` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_stock` (`id`, `inovice_no`, `chemical_id`, `date`, `stock_quantity`, `remarks`, `stock_by`, `created_at`, `updated_at`) VALUES (1, 'C/05279', '1', '2022-03-14', '200', '', '1', '2022-03-14 11:49:03', '2022-03-14 11:49:03');


#
# TABLE STRUCTURE FOR: chemical_unit
#

DROP TABLE IF EXISTS `chemical_unit`;

CREATE TABLE `chemical_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (1, 'NOS', '2022-03-14 11:04:06', '2022-03-14 18:01:30');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (2, 'Ltr', '2022-03-14 11:04:11', '2022-03-14 11:04:11');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (3, 'Kit', '2022-03-14 11:31:37', '2022-03-14 11:31:37');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (4, 'Box', '2022-03-14 11:45:52', '2022-03-14 11:45:52');


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('082tu315vma1dle0hcohubqk82tfhovl', '61.1.225.114', 1655381939, '__ci_last_regenerate|i:1655381937;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0aandu4h8233cmlahejoeubm5god9up7', '61.1.224.237', 1654935961, '__ci_last_regenerate|i:1654935961;name|s:6:\"RESHMA\";uniqueid|s:7:\"a9c7bcc\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:3:\"919\";loggedin_role_id|s:1:\"5\";loggedin_userid|s:3:\"350\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0coso7g8dvhb9hb5tg15obr36fnfecqm', '117.211.44.80', 1654772015, '__ci_last_regenerate|i:1654771950;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0s574q3osoj85eevshkqh6k1bevq4ra3', '117.210.188.154', 1654852264, '__ci_last_regenerate|i:1654852214;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13j3m2igrh9sdc18ldqr1tdk2l5j3mjn', '117.210.187.54', 1655110098, '__ci_last_regenerate|i:1655109874;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1cl1cpm9uieebfi05nsivl5ihjba82ht', '117.217.237.75', 1654672733, '__ci_last_regenerate|i:1654672613;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1kcjrndnvifm2esp3pkmpqubda9moa5e', '117.210.187.54', 1655114465, '__ci_last_regenerate|i:1655114080;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1mouml54mlrdvbkbu63hhforjkpd89vj', '117.211.44.80', 1654768047, '__ci_last_regenerate|i:1654767237;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1nghpo5pa0slgapqh9i61t5l157r0t4q', '61.1.225.114', 1655354928, '__ci_last_regenerate|i:1655354874;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1q65aijt7dfs2fmj5u31u4c49jvgsqqf', '61.1.225.114', 1655370420, '__ci_last_regenerate|i:1655370342;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1r4t3h8tmr7km8jorbr5fqir0bkkkus7', '61.1.225.114', 1655388391, '__ci_last_regenerate|i:1655387766;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:40:\"Information Has Been Update Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2b1r1dkdotqpl9rpcch8rd00ce1lfl9i', '59.88.237.119', 1655528011, '__ci_last_regenerate|i:1655527844;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2gj0ricjojqau1c1s8ojeig8e372hpau', '117.210.187.54', 1655130418, '__ci_last_regenerate|i:1655130415;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('33itg08bfv9m7ahfdkr7ob52lmdih7li', '49.37.234.137', 1655372424, '__ci_last_regenerate|i:1655372373;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3h1ddklf0luevujjpo7eq2mvvq19m53r', '198.235.24.149', 1655308292, '__ci_last_regenerate|i:1655308291;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3m54k4t34veb34ru52act864n1pha237', '61.1.225.114', 1655371501, '__ci_last_regenerate|i:1655371079;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3r35ogmvf2gpragkn6tou6h6qc017he0', '117.217.237.75', 1654679202, '__ci_last_regenerate|i:1654679196;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3sktp0ho2s1i1su9tgc68gviptqr1c51', '61.3.101.211', 1655190989, '__ci_last_regenerate|i:1655190388;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:40:\"Information Has Been Update Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3tb7bd83ln4nbcvln4vnnvio36r9ubv6', '59.88.237.119', 1655542375, '__ci_last_regenerate|i:1655542198;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3tndgbg8thljg29vltkrd9dqjii550ie', '117.210.187.54', 1655106261, '__ci_last_regenerate|i:1655104970;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3ugknpu9t18eqiflbco5rf4atm2mshi0', '59.88.237.119', 1655541847, '__ci_last_regenerate|i:1655541551;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('46tj6j7fplcfr0lh4254me51dppl1sib', '117.217.237.75', 1654687671, '__ci_last_regenerate|i:1654687668;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('47s9otasjjul904sqa01m63f9ti1jq07', '49.37.234.137', 1655366626, '__ci_last_regenerate|i:1655366594;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4k2qli0bo9gsqr5c82rauhmkd9isj2ub', '61.1.224.237', 1654941023, '__ci_last_regenerate|i:1654940471;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4khdo9omn309trd7v480rn0jlunq4qff', '117.210.187.54', 1655118818, '__ci_last_regenerate|i:1655118603;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ldfvb7gq87faueri81s8u59p89go7ne', '61.3.101.211', 1655190989, '__ci_last_regenerate|i:1655190989;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:40:\"Information Has Been Update Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4no9t7vcb632sepctsj82cbeha8nekm6', '61.1.225.114', 1655378744, '__ci_last_regenerate|i:1655378526;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('52oes2at9jr31ccu9g1krfgl9hlsp1tl', '117.210.187.54', 1655129948, '__ci_last_regenerate|i:1655129948;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('53bbop5miv7h1t4anf0i0d6ls5et22rf', '117.211.44.80', 1654764134, '__ci_last_regenerate|i:1654763758;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('57pvkgv3imcsjlqh3ocpug7k5mbov2eo', '65.154.226.171', 1654765017, '__ci_last_regenerate|i:1654765017;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5eoso2c9k2mjp1hf9m4uajhgj4ppu47b', '59.89.232.250', 1655295298, '__ci_last_regenerate|i:1655294984;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5i5gcrl8f1jud5fikfqtlfso4l286vng', '61.1.226.82', 1654756911, '__ci_last_regenerate|i:1654756910;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5ku54kjjm2ko21jo321mjrap94ahneab', '117.217.237.75', 1654677615, '__ci_last_regenerate|i:1654677554;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5r81g0tb9uin647siuu9fci0l7tqr90b', '59.89.232.250', 1655284064, '__ci_last_regenerate|i:1655283950;name|s:6:\"RESHMA\";uniqueid|s:7:\"a9c7bcc\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:3:\"919\";loggedin_role_id|s:1:\"5\";loggedin_userid|s:3:\"350\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6c2am0eck569ba0uoud3qjl7bjcaj8cd', '117.211.44.80', 1654769254, '__ci_last_regenerate|i:1654769046;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6c517goueu2auol3v8bot739jmddmk46', '198.235.24.17', 1655454848, '__ci_last_regenerate|i:1655454848;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6mnofetuu2eb243hjp74h3rkq6ua231q', '103.149.158.68', 1655541907, '__ci_last_regenerate|i:1655541859;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6nkm9vnt7sosfmef3g52tdnol166l6b8', '79.104.53.14', 1654766379, '__ci_last_regenerate|i:1654766379;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('71affvo5t1spq1nbaa9n5cpkmeuvgri6', '117.210.187.54', 1655116720, '__ci_last_regenerate|i:1655116442;name|s:6:\"RESHMA\";uniqueid|s:7:\"a9c7bcc\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:3:\"919\";loggedin_role_id|s:1:\"5\";loggedin_userid|s:3:\"350\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7kgdv75jt7muvq9sjhnbscm61vbvqptm', '61.1.226.82', 1654755923, '__ci_last_regenerate|i:1654755922;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7logn5ggi393v95efki52q39fncfp4l9', '117.211.44.80', 1654768047, '__ci_last_regenerate|i:1654768047;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7n2liblut3tkhrpuc1e2fhqpg6okjs3u', '117.217.235.131', 1655442836, '__ci_last_regenerate|i:1655442836;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7o2gkht2qp187taf1sk4noln3eelepvn', '59.88.237.119', 1655537894, '__ci_last_regenerate|i:1655537689;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7q7pb4qt04kn31a596711ql1fle8c2iq', '117.210.187.54', 1655125213, '__ci_last_regenerate|i:1655125212;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7s4cademo3qotlptug918ug4jeclv9f4', '117.211.44.80', 1654770228, '__ci_last_regenerate|i:1654769729;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7sk8p1fp9mt7bbg0q0db6aai7k0me0n7', '59.89.232.250', 1655287859, '__ci_last_regenerate|i:1655287856;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7t2oeobv95fufnelv3rqbsana8ih8c2p', '61.1.224.237', 1654937508, '__ci_last_regenerate|i:1654937505;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('827s970971j62ghe5kd9tvit3dta7lvs', '117.217.237.75', 1654680213, '__ci_last_regenerate|i:1654680205;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('82ft2u22mbd5tdcn34sbku8kgsodf0q4', '103.149.158.68', 1655542550, '__ci_last_regenerate|i:1655542487;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('869s8aaoqeh3rasvvl034h99ao4b9iel', '59.88.237.119', 1655528379, '__ci_last_regenerate|i:1655528361;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('876vlgg82bts60uv8p3q7rbqt7lhd53c', '117.210.187.54', 1655107109, '__ci_last_regenerate|i:1655106847;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('88ja0975s745ak20iqbc6288es369ri9', '61.1.226.82', 1654755922, '__ci_last_regenerate|i:1654754482;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8kt0scm88a9kueenkcfmckfnflkhsb0m', '117.217.237.75', 1654678869, '__ci_last_regenerate|i:1654678785;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8uor1c94pj2s3iuesejk6e0cm3c8n64f', '61.1.224.237', 1654933396, '__ci_last_regenerate|i:1654933395;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9a3a6cmtbv2tj34c5lqnon5s4dpsef4e', '61.1.225.114', 1655373392, '__ci_last_regenerate|i:1655373392;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9blhhbd433ciaqtmu2alqv0m61gfp84o', '61.1.225.114', 1655371502, '__ci_last_regenerate|i:1655371501;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9jdl3gjqvgtincmgh240tvl2rl0obn1o', '61.1.225.114', 1655363312, '__ci_last_regenerate|i:1655363312;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9nr7g2scrdrg411hfghcp37gdrh6u9ns', '117.217.237.75', 1654682460, '__ci_last_regenerate|i:1654682453;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a6mu3q241dvhg9bptpjj7p9nsui7lhlt', '117.211.44.80', 1654770847, '__ci_last_regenerate|i:1654770228;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('adjfs0p3bin0vavtcu338os8c9gn16ro', '117.210.187.54', 1655111172, '__ci_last_regenerate|i:1655110874;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aib796q1d6s576l60vteg2e3ip9pe345', '117.217.237.75', 1654681065, '__ci_last_regenerate|i:1654680923;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apojjqaf290cndgvajcmur4puul3ldto', '61.3.101.211', 1655189934, '__ci_last_regenerate|i:1655189933;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ar480ijr1kl7d32k7aigh2tj0vh6pe95', '59.89.232.250', 1655293688, '__ci_last_regenerate|i:1655291818;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('atfa0fmiij2b5qolakrut78e9i7e7umg', '117.210.187.54', 1655119253, '__ci_last_regenerate|i:1655118971;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b262vb373g0dph76kh0ufh6oo4ahpeq6', '117.217.237.75', 1654674044, '__ci_last_regenerate|i:1654674044;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b47mfsa5aqc4air7a133okduc3ck8370', '117.211.44.80', 1654764949, '__ci_last_regenerate|i:1654764625;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b4jq5c3hc6r7bs32prbbis7m3vufkvsp', '117.211.44.80', 1654773632, '__ci_last_regenerate|i:1654773631;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b83sl6e90p2juv9uc3p864phdga2nnjf', '61.1.225.114', 1655369878, '__ci_last_regenerate|i:1655369176;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b8vch9eq1g98thofoiqas1m1fi79h1gj', '61.1.225.114', 1655378299, '__ci_last_regenerate|i:1655378039;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bdmhc9f586lrt84ke6udr83jksvk8bgu', '117.217.237.75', 1654676146, '__ci_last_regenerate|i:1654675925;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bsmrs765bvvmgofpv52b0hfbif8mcdvs', '61.1.224.237', 1654944150, '__ci_last_regenerate|i:1654944031;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c50ncigvpgi4cghs6irq7v3us210k3ql', '49.37.235.107', 1655120112, '__ci_last_regenerate|i:1655119950;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c8lpehrdhieb3f352s65e9f68399rkj3', '61.1.225.114', 1655372851, '__ci_last_regenerate|i:1655372108;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cdr9eqiu2j64909gp5ferr3a0h314m02', '117.217.237.75', 1654675247, '__ci_last_regenerate|i:1654675180;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cg34s5r6192cp0olrtdt2l155fmg383v', '117.217.237.75', 1654680692, '__ci_last_regenerate|i:1654680689;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('chgc1tigk8fcvk1rnts70b8pjippk4dt', '59.89.232.250', 1655283891, '__ci_last_regenerate|i:1655283596;name|s:6:\"RESHMA\";uniqueid|s:7:\"a9c7bcc\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:3:\"919\";loggedin_role_id|s:1:\"5\";loggedin_userid|s:3:\"350\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ck9gbe94fo02llelsjmr6tsr6vs87k61', '117.210.187.54', 1655112656, '__ci_last_regenerate|i:1655112280;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d2jjgki2u71jro4np70nu6b2i3v7kouc', '117.211.44.80', 1654773631, '__ci_last_regenerate|i:1654773209;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d401ijksui9dmfa8eie35uv2avgftav6', '117.210.187.54', 1655125212, '__ci_last_regenerate|i:1655121911;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('db4rrp02agl6lt0bobcqbrf9a7p6cea6', '117.217.237.75', 1654676768, '__ci_last_regenerate|i:1654676768;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ddjnhr6c731sfdce01hr6lgcekku3ljk', '117.211.44.80', 1654771300, '__ci_last_regenerate|i:1654771300;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dem0h945mi3fr5kkqi3mbrmjmke39nag', '59.89.232.250', 1655284607, '__ci_last_regenerate|i:1655284464;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('didijknoapghpt3s7c35ib36avmd24hv', '117.210.187.54', 1655106847, '__ci_last_regenerate|i:1655106261;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dmaahcrbkbq4bd2v6obm42960iaeuq79', '49.37.235.107', 1655119949, '__ci_last_regenerate|i:1655119310;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:40:\"Information Has Been Update Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dnh971il11sja1ajc4t9fa004oj4gtta', '117.211.44.80', 1654766657, '__ci_last_regenerate|i:1654766257;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e6mumi900hdpn8r3089umqn42p0vl6p5', '59.88.237.119', 1655535479, '__ci_last_regenerate|i:1655535406;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e8h44ed71tsc90havake0a6scmvsosjn', '117.217.235.131', 1655469364, '__ci_last_regenerate|i:1655469106;redirect_url|s:61:\"https://www.quilonscans.com/knpy/billing/category_bill_report\";name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e9mcipjp5l632h5dtc70s1ssq2oeivui', '61.1.224.237', 1654936943, '__ci_last_regenerate|i:1654936805;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ehi2gltlqh9gvuuud1tfn1vqh576tkn2', '117.217.237.75', 1654674756, '__ci_last_regenerate|i:1654674564;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('esmgr0odocll66lmk31v9m61o4nj10e1', '61.1.225.114', 1655372852, '__ci_last_regenerate|i:1655372851;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ev0kjkrklqp4puhhd6r34mc9hhtmkt4f', '117.217.237.75', 1654678383, '__ci_last_regenerate|i:1654678185;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f15bnr9lb7n947a5le35ojlh9lavos16', '59.88.237.119', 1655529874, '__ci_last_regenerate|i:1655529873;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f229hdff71a0m6mrkq5shsc3go9gsaiu', '117.211.44.80', 1654779832, '__ci_last_regenerate|i:1654779830;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f4ba9gqoln084nf677frj4sgj0bm7sq7', '61.1.224.237', 1654946638, '__ci_last_regenerate|i:1654946270;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f60rdapu4dtfvqesv3sdtqed9gc23vv0', '59.88.237.119', 1655539425, '__ci_last_regenerate|i:1655539204;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f8pcpoqpqdp56gf7vqg8a9bolh3lf109', '59.89.232.250', 1655281529, '__ci_last_regenerate|i:1655281392;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fsmesm6pjvu9cmmk6blnna225ken7lr8', '117.210.187.54', 1655113505, '__ci_last_regenerate|i:1655113114;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g5al6lkbvet93lehktfgcniuq6dlpaju', '117.217.235.131', 1655449322, '__ci_last_regenerate|i:1655449322;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g95qqhsgml9kengmcaq1g26np26o0d7b', '59.88.237.119', 1655542178, '__ci_last_regenerate|i:1655542178;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gburb7cqc3ar198otmn2qcat1cmnraas', '117.217.237.75', 1654677705, '__ci_last_regenerate|i:1654677646;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gf4cdmh40k084mlelas5s5cc3dd1qaho', '59.89.232.250', 1655286463, '__ci_last_regenerate|i:1655286207;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gj1ijr46bj866mnbv0mfq8s4fiq7cfe9', '59.88.237.119', 1655530449, '__ci_last_regenerate|i:1655530199;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gjnut6nckvc8hqqkk8qtu0r3o88uvoti', '59.88.237.119', 1655538887, '__ci_last_regenerate|i:1655538719;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gmkphn025413f6lds4139t41p17df08n', '117.211.44.80', 1654775763, '__ci_last_regenerate|i:1654775760;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gokj6r11esoao335bk77hd054ppud55a', '117.211.44.80', 1654771300, '__ci_last_regenerate|i:1654770847;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gr0blkri6rbhsbh7qjmodi6t4be23h3n', '117.210.187.54', 1655099952, '__ci_last_regenerate|i:1655099869;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gsiuivgmopqdg9butib4rq1rfgnaiggk', '117.210.188.154', 1654852188, '__ci_last_regenerate|i:1654852187;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gu1agsvah1tkgnnl9rc3ofc2tq9ott94', '117.210.187.54', 1655126786, '__ci_last_regenerate|i:1655126784;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h5cdvqhlk0v17n5lr13bfjmmc9ms4l7s', '61.3.101.211', 1655195782, '__ci_last_regenerate|i:1655195634;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h7tesd66hdqr9kk94cnfojm668j5edeb', '61.1.225.114', 1655379312, '__ci_last_regenerate|i:1655379153;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hcb9635e2otik76d6fmh7ho0rns8otrh', '61.1.224.237', 1654928647, '__ci_last_regenerate|i:1654928500;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hg2ahf8oqj5vsdj1so3mm4d9760q1q81', '117.210.187.54', 1655107997, '__ci_last_regenerate|i:1655107387;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i0s5gelo0l93aajff2ontto8q0u2k8dh', '59.88.237.119', 1655541319, '__ci_last_regenerate|i:1655540992;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i9nb2g6a1acu87slc5oj05ckps455e33', '61.1.225.114', 1655370044, '__ci_last_regenerate|i:1655369878;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('idgic2qo6vp1l8pcnmm0o3e2jna8qkjh', '61.1.224.237', 1654938852, '__ci_last_regenerate|i:1654938721;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ifge45mgkh8tg91b0v0bv748a0igho99', '61.1.225.114', 1655363312, '__ci_last_regenerate|i:1655362878;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ijf0iu067cu2lq0v4ndhh5cqjbn0uil4', '117.211.44.80', 1654779469, '__ci_last_regenerate|i:1654779234;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ir23b8oallr5tlctt6rfh3ul1141bu7a', '61.1.224.237', 1654927278, '__ci_last_regenerate|i:1654922076;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j3907ef9pvdh938osb92b7cj0hsa1b0u', '61.1.225.114', 1655389757, '__ci_last_regenerate|i:1655389569;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j4a8oqqq7ednumqs2u43brjdpuujgllp', '59.89.232.250', 1655282951, '__ci_last_regenerate|i:1655282950;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j4hnppriido312tdr8b0p99vulrsmv9o', '61.1.224.237', 1654941024, '__ci_last_regenerate|i:1654941023;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jb57flpq3qu1947b8vmoj1d3ef1acvq8', '59.89.232.250', 1655284077, '__ci_last_regenerate|i:1655283907;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jc6nbrh4rlef7aulbgu7uglb6sof6612', '61.1.225.114', 1655376316, '__ci_last_regenerate|i:1655376313;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jen9fq3fkau7colcf9qfcpnr879g3vdg', '49.37.232.6', 1655195278, '__ci_last_regenerate|i:1655195278;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jhtm87o6688ulqq2s7sc0vk4kog6sec8', '61.3.101.211', 1655189593, '__ci_last_regenerate|i:1655189350;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('joefuvqbdm076igh66l7tm4b2e955hjj', '59.89.232.250', 1655278942, '__ci_last_regenerate|i:1655278730;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jou3aii1ph94gmncco993jndklq5n0s9', '61.1.224.237', 1654946638, '__ci_last_regenerate|i:1654946638;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jukjf9agufv31f1e8sfv39psb33do4rf', '117.210.187.54', 1655107997, '__ci_last_regenerate|i:1655107997;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jv4232n6kbmp8dkpchdgk25jcpph1hmg', '61.1.224.237', 1654930145, '__ci_last_regenerate|i:1654930033;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k0ss97ebm87msq67ied5q9bh640v3u60', '61.1.225.114', 1655369055, '__ci_last_regenerate|i:1655368875;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k3spbq7tvmf7d4ed8qmpa2230eij84l6', '117.217.237.75', 1654677396, '__ci_last_regenerate|i:1654676874;name|s:6:\"RESHMA\";uniqueid|s:7:\"a9c7bcc\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:3:\"919\";loggedin_role_id|s:1:\"5\";loggedin_userid|s:3:\"350\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k6j8uisllq92v761d69n249cetpeudgv', '117.211.44.80', 1654763209, '__ci_last_regenerate|i:1654763208;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kdaeov56863q2n4lodog29263cvgleti', '117.211.44.80', 1654763208, '__ci_last_regenerate|i:1654762385;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kdikvqruvm2dae6r3pognpo816m1ka7h', '59.89.232.250', 1655279393, '__ci_last_regenerate|i:1655279393;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:19:\"Payment Successfull\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:10:\"active_tab\";s:3:\"old\";}active_tab|i:2;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ke6opiret630cv4pjm5041u75v686sp1', '59.89.232.250', 1655285830, '__ci_last_regenerate|i:1655285671;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('khjihciuorf8vbrmbsptqevmmdvk5hah', '61.1.225.114', 1655379512, '__ci_last_regenerate|i:1655379351;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('khlgs13l9e2r7tmqbjm0l9a48nqrni7o', '61.3.101.211', 1655199777, '__ci_last_regenerate|i:1655199770;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kkfj0ebhlhhhtnjr3kelpn5us5qk1muf', '59.89.232.250', 1655285025, '__ci_last_regenerate|i:1655284918;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kqqk63qga2stv6m5ssln9hefg9770346', '117.210.187.54', 1655116112, '__ci_last_regenerate|i:1655114466;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kvml72vid3kpgpc3l8urcamapptca379', '117.210.187.54', 1655116112, '__ci_last_regenerate|i:1655116112;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l4qs9ph1j19jsle7jg6jpqdr6gjg7u2p', '117.210.187.54', 1655104443, '__ci_last_regenerate|i:1655104325;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l5522jia6oeskbuc8oc9s6nu9mcilvap', '117.210.188.154', 1654837650, '__ci_last_regenerate|i:1654837551;redirect_url|s:42:\"https://quilonscans.com/knpy/doctor/create\";name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l568uji548ce66b5r458q0o158mqlv7h', '61.1.225.114', 1655358620, '__ci_last_regenerate|i:1655358433;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l6khhhblq9kc96354u4c4ckn9crsp26e', '61.1.224.237', 1654942495, '__ci_last_regenerate|i:1654941810;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('laqba4l1jk7bu4cgou9po429gt19ip0o', '61.1.224.237', 1654927278, '__ci_last_regenerate|i:1654927278;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lep2ahrbl908qfb6ecbpsfuu6267jf6o', '44.203.113.186', 1654823991, '__ci_last_regenerate|i:1654823991;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lj5pp8gv8184gec1n9tg6f4bh5u9a7v2', '198.235.24.33', 1655313922, '__ci_last_regenerate|i:1655313922;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('llgti3mt0qq3ncgb606u0vathdatnddt', '117.211.44.80', 1654764625, '__ci_last_regenerate|i:1654764134;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lropnk5pm9t0fu2ee5kvnl85mplo0lei', '59.89.232.250', 1655293688, '__ci_last_regenerate|i:1655293688;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lsg0k3gvrt3rqdcqq8kmshbmvl7p58jj', '61.1.225.114', 1655375866, '__ci_last_regenerate|i:1655375860;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m33dkv3scnadk4patv1gj7avvhrvehte', '61.1.226.82', 1654761793, '__ci_last_regenerate|i:1654761541;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mc8tfru5331ifgh02dtg05v4d22q2585', '59.88.237.119', 1655529180, '__ci_last_regenerate|i:1655529180;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mfsbbb8bbd7htvck6ooqog9litsm2ind', '61.1.224.237', 1654927823, '__ci_last_regenerate|i:1654927594;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mitohm0pshfkukr70qvjt7k6e8jnhbah', '117.217.237.75', 1654688533, '__ci_last_regenerate|i:1654688530;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mmdd69p868smk0v5ln1bj3aj5791qonb', '117.210.187.54', 1655114080, '__ci_last_regenerate|i:1655113505;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n02n2pnnkulq32kqhd0ismv2jikl2b48', '117.210.187.54', 1655109564, '__ci_last_regenerate|i:1655109329;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n1ecmsmvv1j44naragcojji41m2a4c6s', '59.89.232.250', 1655295298, '__ci_last_regenerate|i:1655295298;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ne5ajk3st3gtu17db3rhduej5utarfl7', '117.210.187.54', 1655121298, '__ci_last_regenerate|i:1655121154;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nenm0gujo82ta63gikv3atogk3vmg4ke', '59.88.237.119', 1655541877, '__ci_last_regenerate|i:1655541877;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nf9eghss71n8fi00d2d9kvmn5n7doikd', '117.217.237.75', 1654681357, '__ci_last_regenerate|i:1654681356;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nj99id2vdio6sckk4bf763a75ogqpsfc', '61.1.224.237', 1654934596, '__ci_last_regenerate|i:1654934595;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nrmu72qgk8qv6tf57ar6adjoj3mt4ivl', '59.89.232.250', 1655279304, '__ci_last_regenerate|i:1655279052;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nsbk7nsj3rvtoqi30je311motfnfufhv', '117.210.188.154', 1654837274, '__ci_last_regenerate|i:1654837215;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o21pa1ldkhgia8cn40buv2sufrpckb4k', '117.217.237.75', 1654683205, '__ci_last_regenerate|i:1654682783;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o3el2nap2qo3bl6m21c1bdb0cia3msmp', '117.217.235.131', 1655449322, '__ci_last_regenerate|i:1655448907;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o5rfjdrjq5f96dju5275q9d21s26ioms', '59.89.232.250', 1655280189, '__ci_last_regenerate|i:1655279873;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oavc8t8rs4pl3i794o5pm0vropupi4sc', '61.1.225.114', 1655385864, '__ci_last_regenerate|i:1655385772;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:19:\"Payment Successfull\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:10:\"active_tab\";s:3:\"old\";}active_tab|i:2;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oeb15ldtli7dh6prbmj8gp99dakrp7t8', '59.89.232.250', 1655282950, '__ci_last_regenerate|i:1655282453;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ogi14621l3u1i5cpescq25nd391s76f1', '61.1.224.237', 1654934595, '__ci_last_regenerate|i:1654934234;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oi0d4n35dkp565j2dgp84ute8qc06mon', '117.210.187.54', 1655117860, '__ci_last_regenerate|i:1655116833;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p0e8njfdgpvbdp2nnl1a0j734o07nrmd', '117.217.237.75', 1654683205, '__ci_last_regenerate|i:1654683205;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p3fk3vchef91hekbblee5ica37nu116k', '61.3.101.211', 1655189344, '__ci_last_regenerate|i:1655189047;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p4iv5aeqf2j5jfg7rrgdaraaiddocjhj', '61.1.225.114', 1655354122, '__ci_last_regenerate|i:1655353966;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p5en1rhtn3cuvj5tvq6qh8bcm2cf16au', '61.1.224.237', 1654942496, '__ci_last_regenerate|i:1654942495;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p7dr6cd8rmpk36c2pc42g6dr3aql2shu', '59.89.232.250', 1655280952, '__ci_last_regenerate|i:1655280189;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p803qbd81icl58uhrueneu063g6frn8i', '61.1.224.237', 1654935040, '__ci_last_regenerate|i:1654934920;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p89d8468e25i0illufqv1gmt3ch0oef9', '117.210.187.54', 1655117861, '__ci_last_regenerate|i:1655117860;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pk0d145qqlofkanl00l414jjos15ebd6', '61.1.225.114', 1655357789, '__ci_last_regenerate|i:1655357632;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('povshrk4pkv3is1gtlieurctge3t3ojh', '117.217.237.75', 1654685992, '__ci_last_regenerate|i:1654685856;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qltlhi0s1fv5qgf26kdold531gtn6fls', '61.1.225.114', 1655370750, '__ci_last_regenerate|i:1655370718;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qtgigoib3fg3811aqune1rgpabacv9ch', '117.217.237.75', 1654676771, '__ci_last_regenerate|i:1654676771;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qtnmoiuiobhurbkmpe8ttkgonp40m5mu', '117.211.44.80', 1654766658, '__ci_last_regenerate|i:1654766658;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rd8po92ddohqhev4gc794l4bn3bk87ho', '61.1.225.114', 1655362878, '__ci_last_regenerate|i:1655359056;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ri2208ccul62s92d6lq3jfhm6cd9jd7p', '59.88.237.119', 1655528758, '__ci_last_regenerate|i:1655528758;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rpk4j4obf8tr4itm8evqu5uudj1mdjct', '59.89.232.250', 1655283900, '__ci_last_regenerate|i:1655283889;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s5csb33qh3dm3cv8buf82pj08dg96euv', '117.217.237.75', 1654674044, '__ci_last_regenerate|i:1654673432;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s9ced7caplptgms7n9eg9mm40n338ojg', '49.37.234.137', 1655371185, '__ci_last_regenerate|i:1655370960;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sd9k0ac0ntf89q00a4a90beh4op3c6v7', '61.1.225.114', 1655388391, '__ci_last_regenerate|i:1655388391;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:40:\"Information Has Been Update Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('shvjko15cuji58vvlt66td30k3brs2a3', '117.217.237.75', 1654681816, '__ci_last_regenerate|i:1654681644;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('smapsfbgt7epn5h1qrg9lne5bkfc59if', '61.1.225.114', 1655373822, '__ci_last_regenerate|i:1655373820;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sr9atprqe1734a5itjt9afcr0phlb859', '49.37.232.6', 1655190334, '__ci_last_regenerate|i:1655190067;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sschudl4mda04kv6mhp8b1h0jpl5am1r', '61.1.224.237', 1654935780, '__ci_last_regenerate|i:1654935654;name|s:6:\"RESHMA\";uniqueid|s:7:\"a9c7bcc\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:3:\"919\";loggedin_role_id|s:1:\"5\";loggedin_userid|s:3:\"350\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t43m3gpart2240akuuh3dupf4pu0fva1', '117.210.187.54', 1655110874, '__ci_last_regenerate|i:1655110414;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t45obhlfip9jej39l4n6qmiurdhual1m', '59.88.237.119', 1655540235, '__ci_last_regenerate|i:1655540091;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t7am3rbe4llh17th0jf3hfp9ehtevd85', '117.211.44.80', 1654774829, '__ci_last_regenerate|i:1654774544;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tc9hl0jk7ggcucmb15jncok5c7eilavm', '205.210.31.16', 1655049710, '__ci_last_regenerate|i:1655049710;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tk8hi4of1qpgvhqk02ca29cclrmkrvd6', '61.1.224.237', 1654933395, '__ci_last_regenerate|i:1654932786;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ttgfvl0ssbam3gq9n4sag3car4ggp9nc', '117.211.44.80', 1654764950, '__ci_last_regenerate|i:1654764949;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uclqgf1vl1u8gssure7pd8qbr165uiu3', '49.37.234.3', 1654837492, '__ci_last_regenerate|i:1654837420;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ucr491sjumf8a4ho6pi6n72lto90oc44', '117.217.237.75', 1654681257, '__ci_last_regenerate|i:1654681245;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('udrdlngoptp3nl0nptrluh4lu3996qef', '59.89.232.250', 1655284150, '__ci_last_regenerate|i:1655284150;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uk4q7br2iju4mturb0q3op2u0vehm6ge', '117.217.237.75', 1654679178, '__ci_last_regenerate|i:1654679178;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('unutacc1kaoq7cq3cg9uol3ckj5gqb42', '59.89.232.250', 1655298582, '__ci_last_regenerate|i:1655298407;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uova0gj9400gu6u30d0pm0vdbbre9av8', '117.210.187.54', 1655111626, '__ci_last_regenerate|i:1655111499;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('usg5b4epsro2fpav5cm2rch30u6ulboe', '117.217.237.75', 1654679178, '__ci_last_regenerate|i:1654678260;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v3mrprl9jetbck5f6r42v9a7lpqkjn0n', '61.1.225.114', 1655381337, '__ci_last_regenerate|i:1655381072;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v63njeptmd9o3b0vaof8qtj6mptv3431', '117.210.187.54', 1655112952, '__ci_last_regenerate|i:1655112656;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v8nhj45fi5u44ij2185n6k03icoqaer3', '49.37.232.6', 1655189590, '__ci_last_regenerate|i:1655189426;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vejojbjaghdkjtauquj5s2kpfqi2ncl9', '117.210.187.54', 1655129947, '__ci_last_regenerate|i:1655129120;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vjrg5s4ekfkitvqa1gjm85505b74sqfk', '117.210.187.54', 1655120766, '__ci_last_regenerate|i:1655120763;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vot6b0opkn0gbemhvl71n4opaomp01co', '59.89.232.250', 1655280952, '__ci_last_regenerate|i:1655280952;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(200) DEFAULT NULL,
  `email_protocol` varchar(10) NOT NULL,
  `smtp_host` varchar(25) NOT NULL,
  `smtp_user` varchar(25) DEFAULT NULL,
  `smtp_pass` text NOT NULL,
  `smtp_port` varchar(100) NOT NULL,
  `smtp_encryption` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email`, `email_protocol`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `smtp_encryption`) VALUES (1, 'example@gmail.com', 'sendmail', 'smtp.gmail.com', 'example@gmail.com', '1234', '25', 'ssl');


#
# TABLE STRUCTURE FOR: email_templates
#

DROP TABLE IF EXISTS `email_templates`;

CREATE TABLE `email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_type` varchar(200) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `template_body` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `notified` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (1, 'account_registered', 'Account Registered', '', '{institute_name}, {name}, {username}, {password}, {user_role}, {login_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (2, 'forgot_password', 'Forgot Password', '', '{institute_name}, {name}, {username}, {reset_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (5, 'payslip_generated', 'Payslip generated', '', '{institute_name}, {name}, {month_year}, {payslip_no}, {payslip_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (6, 'absent', 'Absent Notice', '', '{institute_name}, {name}, {date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (7, 'leave_approve', 'Your leave request has been approved', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (8, 'leave_reject', 'Your leave request has been reject', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (9, 'appointment_confirmation', 'Appointment Confirmation', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (10, 'appointment_canceled', 'Appointment Canceled', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);


#
# TABLE STRUCTURE FOR: front_cms_about
#

DROP TABLE IF EXISTS `front_cms_about`;

CREATE TABLE `front_cms_about` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `page_title` varchar(255) NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `about_image` varchar(255) NOT NULL,
  `elements` mediumtext NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_about` (`id`, `title`, `subtitle`, `page_title`, `content`, `banner_image`, `about_image`, `elements`, `meta_description`, `meta_keyword`) VALUES (1, 'Welcome to Hospitals', 'Best Medical &amp; Healthcare Needs to Our Patients', 'About Us', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut volutpat rutrum eros amet sollicitudin interdum. Suspendisse pulvinar, velit nec pharetra interdum, ante tellus ornare mi, et mollis tellus neque vitae elit. Mauris adipiscing mauris fringilla turpis interdum sed pulvinar nisi malesuada. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n\r\n<p>Donec sed odio dui. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Duis mollis, est non commodo luctus, nisi erat porttitor ligula. Mauris sit amet neque nec nunc gravida.</p>\r\n\r\n<div class=\"row\">\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n	<li><a href=\"#\">Dermitology</a></li>\r\n</ul>\r\n</div>\r\n\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n</ul>\r\n</div>\r\n</div>', 'about.jpg', 'about.jpg', '{\"cta_title\":\"Get in touch to join our community\",\"button_text\":\"Contact Our Office\",\"button_url\":\"contact\"}', '', '');


#
# TABLE STRUCTURE FOR: front_cms_appointment
#

DROP TABLE IF EXISTS `front_cms_appointment`;

CREATE TABLE `front_cms_appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_appointment` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Make An Appoinment', '<p><span style=\"color: rgb(156, 156, 156); font-family: Poppins, sans-serif; font-size: 14px; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;\">Lorem ipsum dolor sit amet, eum illum dolore concludaturque ex, ius latine adipisci no. Pro at nullam laboramus definitiones. Mandamusconceptam omittantur cu cum. Brute appetere it scriptorem ei eam, ne vim velit novum nominati. Causae volutpat percipitur at sed ne.</span></p>\r\n', 'Appointment', 'appointment.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_contact
#

DROP TABLE IF EXISTS `front_cms_contact`;

CREATE TABLE `front_cms_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `box_title` varchar(255) DEFAULT NULL,
  `box_description` varchar(500) DEFAULT NULL,
  `box_image` varchar(255) DEFAULT NULL,
  `form_title` varchar(355) DEFAULT NULL,
  `address` varchar(355) DEFAULT NULL,
  `phone` varchar(355) DEFAULT NULL,
  `email` varchar(355) DEFAULT NULL,
  `submit_text` varchar(355) NOT NULL,
  `map_iframe` text,
  `page_title` varchar(255) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_contact` (`id`, `box_title`, `box_description`, `box_image`, `form_title`, `address`, `phone`, `email`, `submit_text`, `map_iframe`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'WE\'D LOVE TO HEAR FROM YOU', 'Fusce convallis diam vitae velit tempus rutrum. Donec nisl nisl, vulputate eu sapien sed, adipiscing vehicula massa. Mauris eget commodo neque, id molestie enim.', 'contact-info-box.png', 'Get in touch by filling the form below', '4896  Romrog Way, LOS ANGELES,\r\nCalifornia', '954-648-1802, \r\n963-612-1782', 'info@example.com\r\nsupport@example.com', 'Send', '<iframe width=\"100%\" height=\"350\" id=\"gmap_canvas\" src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3313.3833161665298!2d-118.03745848530627!3d33.85401093559897!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80dd2c6c97f8f3ed%3A0x47b1bde165dcc056!2sOak+Dr%2C+La+Palma%2C+CA+90623%2C+USA!5e0!3m2!1sen!2sbd!4v1544238752504\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\"></iframe>', 'Contact Us', 'contact.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_doctor_bio
#

DROP TABLE IF EXISTS `front_cms_doctor_bio`;

CREATE TABLE `front_cms_doctor_bio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(20) NOT NULL,
  `biography` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_doctor_bio` (`id`, `doctor_id`, `biography`) VALUES (1, '2', '<p>Senior Surgeon</p>');


#
# TABLE STRUCTURE FOR: front_cms_doctors
#

DROP TABLE IF EXISTS `front_cms_doctors`;

CREATE TABLE `front_cms_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Doctors', 'doctors.jpg', '', '');
INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (2, 'Doctor Profile', 'doctor_profile.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq
#

DROP TABLE IF EXISTS `front_cms_faq`;

CREATE TABLE `front_cms_faq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_faq` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Frequently Asked Questions', '<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.</p>\r\n\r\n<p>Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven&#39;t heard of them accusamus labore sustainable VHS.</p>', 'Faq', 'faq.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq_list
#

DROP TABLE IF EXISTS `front_cms_faq_list`;

CREATE TABLE `front_cms_faq_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (1, 'Any Information you provide on applications for disability, life or accidental insurance ?', '<p>\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.\r\n</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</li>\r\n<li>Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact.</li>\r\n<li>That a reader will be distracted by the readable content of a page when looking at its layout.</li>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</li>\r\n<li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n<li>Readable content of a page when looking at its layout.</li>\r\n<li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n<li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n</ul>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (2, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (3, 'Opposed to using \'Content here, content here\', making it look like readable English ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (4, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (5, 'What types of documents are required to travel?', '<p><strong>Lorem ipsum</strong> dolor sit amet, an labores explicari qui, eu nostrum copiosae argumentum has. Latine propriae quo no, unum ridens expetenda id sit, at usu eius eligendi singulis. Sea ocurreret principes ne. At nonumy aperiri pri, nam quodsi copiosae intellegebat et, ex deserunt euripidis usu. Per ad ullum lobortis. Duo volutpat imperdiet ut, postea salutatus imperdiet ut per, ad utinam debitis invenire has.</p>\r\n\r\n<ol>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari quilabores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n</ol>');


#
# TABLE STRUCTURE FOR: front_cms_home
#

DROP TABLE IF EXISTS `front_cms_home`;

CREATE TABLE `front_cms_home` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `item_type` varchar(20) NOT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `elements` mediumtext NOT NULL,
  `active` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (1, 'We Offer Fast &amp; Reliable', 'Medical &amp; Healthcare Needs', 'wellcome', 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using content.\r\n\r\nMaking it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).', '{\"image\":\"wellcome.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (2, 'Experience Doctor Team', NULL, 'doctors', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident.', '{\"doctor_start\":\"1\",\"image\":\"featured-parallax.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (3, 'Our Best Medical Services', NULL, 'services', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (4, 'Online Hassle Free Appointment Booking', 'Medical Services', 'cta', '', '{\"mobile_no\":\"+2484-398-8987\",\"button_text\":\"Book your Appointment\",\"button_url\":\"appointment\",\"image\":\"appointment-booking-img.png\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (5, 'Best <span>Digital</span> Experience', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-left\",\"button_text1\":\"View Services\",\"button_url1\":\"#\",\"button_text2\":\"Learn More\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743357.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (6, 'Main Heading <span>Some Caption</span> Here', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-center\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Get Started\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743366.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (7, 'Here creative & professional <span>PHP</span> template', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-right\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Contact us\",\"button_url2\":\"contact\",\"image\":\"home-slider-1578743373.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (8, 'Qualified Doctors', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-user-md\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (9, 'Regular Checkup', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-stethoscope\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (10, 'Neurosurgeon', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-vial\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (11, '24 Hours  Service', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"far fa-clock\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (12, 'Our Happy Patients Opinion', NULL, 'testimonial', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);


#
# TABLE STRUCTURE FOR: front_cms_home_seo
#

DROP TABLE IF EXISTS `front_cms_home_seo`;

CREATE TABLE `front_cms_home_seo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_home_seo` (`id`, `page_title`, `meta_keyword`, `meta_description`) VALUES (1, 'Home', '', '');


#
# TABLE STRUCTURE FOR: front_cms_menu
#

DROP TABLE IF EXISTS `front_cms_menu`;

CREATE TABLE `front_cms_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `ordering` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT '0',
  `open_new_tab` int(11) NOT NULL DEFAULT '0',
  `ext_url` int(11) NOT NULL DEFAULT '0',
  `ext_url_address` text,
  `publish` int(11) NOT NULL,
  `system` varchar(10) NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (1, 'Home', 'index', 1, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (2, 'Appointment', 'appointment', 3, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (3, 'Doctors', 'doctors', 4, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (4, 'About Us', 'about', 2, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (5, 'FAQ', 'faq', 5, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (6, 'Contact Us', 'contact', 6, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');


#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `content` longtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `menu_id` int(11) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_services
#

DROP TABLE IF EXISTS `front_cms_services`;

CREATE TABLE `front_cms_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `parallax_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_services` (`id`, `title`, `subtitle`, `parallax_image`) VALUES (1, 'Get Well Soon', 'Our Hosptial <span>Services</span>', 'service_parallax.jpg');


#
# TABLE STRUCTURE FOR: front_cms_services_list
#

DROP TABLE IF EXISTS `front_cms_services_list`;

CREATE TABLE `front_cms_services_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (1, 'First Aid', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text.', 'fas fa-medal');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (2, 'Dental Care', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-heartbeat');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (3, '24x7 Ambulance', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model.', 'fas fa-ambulance');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (4, 'Qualified Doctors', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will.', 'fas fa-capsules');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (5, 'Medical Pharmacy', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-stethoscope');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (6, 'Pulmonary', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a for \'lorem ipsum\' will uncover.', 'fas fa-medkit');


#
# TABLE STRUCTURE FOR: front_cms_setting
#

DROP TABLE IF EXISTS `front_cms_setting`;

CREATE TABLE `front_cms_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_title` varchar(255) NOT NULL,
  `captcha_status` varchar(20) NOT NULL,
  `recaptcha_site_key` varchar(255) NOT NULL,
  `recaptcha_secret_key` varchar(255) NOT NULL,
  `address` varchar(350) NOT NULL,
  `mobile_no` varchar(60) NOT NULL,
  `fax` varchar(60) NOT NULL,
  `receive_contact_email` varchar(255) NOT NULL,
  `email` varchar(60) NOT NULL,
  `footer_text` varchar(255) NOT NULL,
  `fav_icon` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `working_hours` varchar(300) NOT NULL,
  `facebook_url` varchar(100) NOT NULL,
  `twitter_url` varchar(100) NOT NULL,
  `youtube_url` varchar(100) NOT NULL,
  `google_plus` varchar(100) NOT NULL,
  `linkedin_url` varchar(100) NOT NULL,
  `pinterest_url` varchar(100) NOT NULL,
  `instagram_url` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_setting` (`id`, `application_title`, `captcha_status`, `recaptcha_site_key`, `recaptcha_secret_key`, `address`, `mobile_no`, `fax`, `receive_contact_email`, `email`, `footer_text`, `fav_icon`, `logo`, `working_hours`, `facebook_url`, `twitter_url`, `youtube_url`, `google_plus`, `linkedin_url`, `pinterest_url`, `instagram_url`) VALUES (1, 'DMS- Diagnostic Management System With CMS', 'disable', '', '', 'Quilon Scans', '+1-954-648-1802', '001 - 785 987 1234', 'info@example.com', 'info@demo.com', '©2022 <span>Quilon Scans</span> - Developed by Logiprompt Techno Solutions India Pvt Ltd', 'fav_icon.ico', 'logo.png', '<span>Hours : </span>  Mon To Fri - 9:00 - 20:00,  Sunday Closed', 'https://facebook.com', 'https://twitter.com', 'https://youtube.com', 'https://google.com', 'https://linkedin.com', 'https://pinterest.com', 'https://instagram.com');


#
# TABLE STRUCTURE FOR: front_cms_testimonial
#

DROP TABLE IF EXISTS `front_cms_testimonial`;

CREATE TABLE `front_cms_testimonial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_name` varchar(255) NOT NULL,
  `surname` varchar(355) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `rank` int(5) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (1, 'Gartrell Wright', 'Los Angeles', 'defualt.png', 'Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 1, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (2, 'Clifton Hyde', 'Newyork City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (3, 'Emily Lemus', 'Los Angeles', 'defualt.png', '“Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 5, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (4, 'Michel Jhon', 'CEO', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 3, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (5, 'Hilda Howard', 'Chicago City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, '2019-08-23 18:26:42');


#
# TABLE STRUCTURE FOR: global_settings
#

DROP TABLE IF EXISTS `global_settings`;

CREATE TABLE `global_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(255) NOT NULL,
  `institute_email` varchar(100) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(50) NOT NULL,
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `translation` varchar(20) NOT NULL,
  `footer_text` text NOT NULL,
  `animations` varchar(50) NOT NULL,
  `timezone` varchar(30) NOT NULL,
  `date_format` varchar(20) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `facebook_url` varchar(255) NOT NULL,
  `twitter_url` varchar(255) NOT NULL,
  `linkedin_url` varchar(255) NOT NULL,
  `youtube_url` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `global_settings` (`id`, `institute_name`, `institute_email`, `address`, `mobileno`, `currency`, `currency_symbol`, `translation`, `footer_text`, `animations`, `timezone`, `date_format`, `facebook_url`, `twitter_url`, `linkedin_url`, `youtube_url`, `created_at`, `updated_at`) VALUES (1, 'Quilon Scans', 'quilonscans@yahoo.com', 'Ground Floor, Chungathu Jewellery Arcade,Opp. To KFC, Near Lalaji Jn , Karunagappally-690818', '0476 2982982 / 2626982 / 8111982982', 'INR', '₹', 'english', '© 2022 Quilon Scans - Developed by Logiprompt Techno Solutions India Pvt Ltd', 'fadeInUp', 'Asia/Dhaka', '%d-%b-%Y', '', '', '', '', '2018-10-22 15:07:49', '2022-04-11 10:16:19');


#
# TABLE STRUCTURE FOR: lab_report_template
#

DROP TABLE IF EXISTS `lab_report_template`;

CREATE TABLE `lab_report_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `template` longtext NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=utf8;

INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (16, 'EXAMINATION OF STOOL', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">EXAMINATION OF STOOL</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;&nbsp;&nbsp;Brown&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Consistency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Formed&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Blood&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Mucus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>MICROSCOPICAL EXAMINATION</strong></span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ova&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Not Seen&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cysts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Not Seen&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;4-6 /HPF&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">R B Cs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Undigested food particles&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 11:11:22', '2022-04-05 12:44:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (17, 'OCCULT BLOOD TEST', '<p style=\"margin-bottom:14px\"><u><strong>OCCULT BLOOD TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Occult Blood&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;&nbsp;Negative</span></span></span></p>\r\n', '2022-03-17 11:14:06', '2022-04-05 12:52:46');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (18, 'EXAMINATION OF URINE ', '<p ><strong><u>EXAMINATION OF URINE</u></strong>&nbsp;</p>\r\n\r\n<p ><strong><span style=\"font-size:11pt\"><span style=\"line-height:100%\"><span style=\"font-family:Calibri,sans-serif\">a) PHYSICAL CHARACTERS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p ><span style=\"font-size:11pt\"><span style=\"line-height:100%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Pale Yellow&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p ><span style=\"font-size:11pt\"><span style=\"line-height:100%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Transparency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Clear&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Acidic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>b) CHEMICAL CONSTITUENTS :&nbsp;</strong>&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c) MICROSCOPICAL EXAMINATION :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Amorphous Urates&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n', '2022-03-17 11:25:47', '2022-04-21 15:19:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (19, 'THYROID FUNCTION TEST (Child)            ', '<p style=\"margin-bottom:14px\"><u><strong>THYROID FUNCTION TEST (Child)</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;T3(CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;141.8ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Cord blood:15.0-75.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-3 Days:32.0-216.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-30 Days::50.0-250.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1-12 Months:105.0-280.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-5 Years:105.0-269.0,ng/dL&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">5-10Years:94.0-241.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">10-16Years:83.0-213.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">15-18 Years:80.0-210.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp; &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;9.3 ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cord blood :&nbsp;4.6-&nbsp;13.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 3 Days&nbsp; :&nbsp; 11.8-23.2,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-10 Days&nbsp; :&nbsp;&nbsp; 9.9-21.9,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10-45 Days :&nbsp;&nbsp; 8.2-16.2ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45-95 Days :&nbsp;&nbsp; 6.4-14.0ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3-12 Months:&nbsp;&nbsp; 7.8-16.5,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1- 5 Years :&nbsp;&nbsp; 7.3-15.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5-10 Years :&nbsp;&nbsp; 6.4-13.3,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0-15 Years :&nbsp;&nbsp; 5.6-11.7,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 15-18 Years :&nbsp;&nbsp; 4.2-11.8&#39;ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (CLIA-ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4.31 uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;1 Month : 0.4 - 20.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 Month to 10 Year : 0.4 - 10.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Above 10 Year : 0.4 - 4.5 uIU/mL</span></span></span></p>\r\n', '2022-03-17 11:36:11', '2022-04-05 13:18:12');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (20, 'DENGUE  IgM TEST', '<p style=\"margin-bottom:14px\"><u><strong>DENGUE &nbsp;IgM TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DENGUE&nbsp; IgM (serum by EIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;EQUIVOCAL(9.20)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Negative&nbsp; &nbsp;&lt; 9.0 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Equivocal 9-11 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive &gt; 11 PanBio Units</span></span></span></p>\r\n', '2022-03-17 11:53:23', '2022-04-05 13:22:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (21, 'LACTATE,PLASMA TEST                  ', '<p style=\"margin-bottom:14px\"><u><strong>LACTATE,PLASMA TEST</strong></u> &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lactate,Plasma&nbsp;(Plasma,Colorimetry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.3 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.4&nbsp;-&nbsp;2.0mmol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 11:58:12', '2022-04-05 13:30:14');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (22, 'E2 - ESTRADIOL LEVEL      ', '<p style=\"margin-bottom:14px\"><u><strong>E2 - ESTRADIOL LEVEL</strong></u><em><strong> </strong></em>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">E2 - Estradiol level&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 79.7 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal Menstruating Women:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Follicular phase: 21 to 251 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid cycle peak :38 - 649 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;Luteal phase :21 to 312 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;Menopause :&lt; 10 to 28 pg/mL</span></span></span></p>\r\n', '2022-03-17 12:04:42', '2022-04-05 15:52:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (23, 'SERUM PHOSPHORUS TEST', '<p style=\"margin-bottom:14px\"><u><strong>SERUM PHOSPHORUS TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Phosphorus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;5.4 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2.3 &ndash; 4.7 mg/dL</span></span></span></span></p>\r\n', '2022-03-17 12:13:08', '2022-04-05 13:31:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (24, 'SERUM CALCIUM TEST', '<p><u><strong>SERUM CALCIUM TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">S.Calcium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10.1 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Adult : 8.5 - 10. 1 mg/dL</span></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Children : 9 - 11 mg/dL</span></span></span></span></p>\r\n', '2022-03-17 12:23:24', '2022-04-05 13:34:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (25, 'WIDAL TEST TUBE METHOD', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">WIDAL TEST TUBE METHOD</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong>TEST&nbsp;</strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<strong>DILUTION</strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;<strong>NORMAL RANGE</strong></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;&nbsp; &nbsp;Salmonella typhi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;O&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella typhi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;H&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella paratyphi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&quot;AH&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella Paratyphi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;BH&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; 1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; (Significant Dilution&nbsp; 1: 80 or more)&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 12:31:44', '2022-04-05 13:39:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (26, 'URINE MICROALBUMINURIA REPORT', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE MICROALBUMINURIA REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microalbumin,urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;92.5 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Urine by Drychemistry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 505.7 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microalbuminuria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;18.3 ug/mgC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;30ug/mgC</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Microalbuminuria&nbsp; 30 - 300ug/mgC</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Clinical albuminuria &gt; 300ug/mgC</span></span></span></p>\r\n', '2022-03-17 12:36:50', '2022-04-05 15:13:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (27, ' LDH TEST', '<p><strong>&nbsp;</strong><u><strong>LDH TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LDH Lactate Dehydrogenase &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 241 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;125&nbsp; -&nbsp; 220 U/L</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;(Serum IFCC method )</span></span></span></p>\r\n', '2022-03-17 12:47:00', '2022-04-05 15:18:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (28, 'BETA HCG TEST', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">BETA HCG TEST</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCG Beta Subunit.Serum</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,ECLIA)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCG Beta Subunit&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1213.0 IU/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Non Pregnant:&lt; 10 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; Peri&amp;Post menopausal:5-50 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Pregnant: ReferInterpretation</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp;1 to2 Weeks:50 to 500 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; 2 to 3 Weeks:100 to 500 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; 3 to 4 Weeks:500 to 10000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp;4 to 5 Weeks:1000 to 50000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;5 to 6 Weeks:10.000 to1.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;6 to 8 Weeks:15.0000 to 2.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2&nbsp;to 3 Weeks : 10.000 to1.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;11 to 16 Weeks : 6000 to 30. 000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16 to 21 Weeks : 400 to 15,000 IU/L</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 21 to 39 Weeks:2,700 to 78,100&nbsp; IU/L</span></span></span></p>\r\n', '2022-03-17 12:58:57', '2022-04-05 15:42:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (29, 'FREE TESTOSTERONE', '<p><u><strong>FREE TESTOSTERONE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free Testosterone(serum by RIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.70 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal Female:0.29-3.18 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase: 0.45-3.17 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Luteal Phase:0.46-2.48 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Oral Contraceptives:0.29-1.73 pg/mL</span></span></span></p>\r\n', '2022-03-17 13:02:11', '2022-04-05 15:40:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (30, 'ANTI CARDIOLIPIN ANTIBODY-IgG ', '<p><u><strong>ANTI CARDIOLIPIN ANTIBODY-IgG&nbsp;</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Cardiolipin antibody-IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative(4.00) GPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Negative : &lt;10 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;High Positive:&gt;=40 GPL U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Low Positive:10-20 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Moderate Positive:20.01-40 GPLU/mL</span></span></span></p>\r\n', '2022-03-17 13:05:22', '2022-04-05 15:38:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (31, 'Anti CARDIOLIPIN ANTIBODY-IgM ', '<p><u><strong>Anti CARDIOLIPIN ANTIBODY-IgM&nbsp;</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Cardiolipin Antibody-IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative(3.80)&nbsp; MPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative :&lt; 7 MPL U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive :&gt; = 7 MPL U/mL</span></span></span></p>\r\n', '2022-03-17 13:08:44', '2022-04-05 16:12:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (32, 'APA -(PHOSPHOLIPIDS)-lgG ', '<p><u><strong>APA -(PHOSPHOLIPIDS)-lgG&nbsp;</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">APA -(Phospholipids)-lgG(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative(6.40) GPL/U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Negative: &lt;=10 GPLU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive: &gt;10 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 13:12:38', '2022-04-05 16:11:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (33, 'APA -(PHOSPHOLIPIDS)-lgM ', '<p><strong><u>APA -(PHOSPHOLIPIDS)-lgM&nbsp;</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">APA -(Phospholipids)-lgM(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Negative(5.20) MPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative &lt;=10 MPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive: &gt; 10 MPL U/mL</span></span></span></p>\r\n', '2022-03-17 13:18:16', '2022-04-05 16:13:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (34, 'LUPUS ANTICOAGULANT *             ', '<p><u><strong>LUPUS ANTICOAGULANT * </strong></u>&nbsp; &nbsp; &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lupus Anticoagulant * (Citrated Plasma)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.0&nbsp; Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -1.3 Ratio </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 13:21:41', '2022-04-05 16:14:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (35, 'BETA-2-GLYCOPROTEIN 1-IgG* ', '<p><u><strong>BETA-2-GLYCOPROTEIN 1-IgG*&nbsp;</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Glycoprotein 1-IgG* (Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Negative(7) RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-17 13:26:34', '2022-04-05 16:17:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (36, 'BETA-2-GLYCOPROTEIN 1-IgM*', '<p><u><strong>BETA-2-GLYCOPROTEIN 1-IgM*</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Glycoprotein 1-IgM*&nbsp;(Serum,ELA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative(8.8) RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-17 13:30:03', '2022-04-05 16:20:15');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (37, 'TESTOSTERONE(TOTAL)', '<p><u><strong>TESTOSTERONE(TOTAL)</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Testosterone(Total),(serum by CLIA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;751.56 ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; 260-1000&nbsp; ng/dL</span></span></span></p>\r\n', '2022-03-17 14:37:07', '2022-04-05 16:23:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (38, 'FSH-FOLLICLE STIMULATING HORMONE', '<p><u><strong>FSH-FOLLICLE STIMULATING HORMONE</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">FSH-Follicle Stimulating Hormone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;2.00mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Follicular Phase:1.4-9.9 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid Cycle Peak :0.2-17.2 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Luteal Phase&nbsp;&nbsp; :1.1-9.2 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post Menopausal:19.3-100.6 mIU/mL</span></span></span></p>\r\n', '2022-03-17 14:39:45', '2022-04-05 16:27:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (39, 'LH-LEUTINISING HORMONE', '<p><u><strong>LH-LEUTINISING HORMONE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LH-Leutinising Hormone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;8.40 mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase:1.7-15 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid Cycle Peak:21.9-56.6 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Lutel Phase&nbsp;&nbsp;&nbsp;&nbsp; :0.6-16.3 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post Menopausal :14.2-52.3mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 14:41:29', '2022-04-05 16:32:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (40, 'PROGESTERONE', '<p><u><strong>PROGESTERONE</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Progesterone&nbsp;(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.00 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Menstrual Cycle:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; FollicularPhase: &lt;0.3ng/mL&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;LutealPhase:1.2-15.9ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post menopausal:&lt;0.2ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Pregnancy:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; First Trimester:2.8-147.3ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:22.5-95.3ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; Third trimester:27.9-242.5ng/mL</span></span></span></p>\r\n', '2022-03-17 14:45:04', '2022-04-05 16:37:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (42, 'DHEAS', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">DHEAS</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DHEAS Serum bby RIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100 - 800 ng/dL</span></span></span></p>\r\n', '2022-03-17 14:46:53', '2022-04-05 16:43:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (43, 'ALDOSTERONE', '<p><u><strong>ALDOSTERONE</strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Aldosterone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;380.0 pg/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Supine:8-12 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Upright:30-355 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Children:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; At birth:300-1900 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;1month to 2years:20-1100 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;From 3-16years:12-340 pg/ml&nbsp;</span></span></span></p>\r\n', '2022-03-17 14:48:31', '2022-04-05 16:49:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (44, 'LEPTOSPIRA-IgM              ', '<p><u><strong>LEPTOSPIRA-IgM</strong></u></p>\r\n\r\n<p>&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Leptospira-IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative(2) PanBio Units&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Negative:&lt;9 PanBio Units </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; Equivocal 9-11 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Positive:&gt;=11 PanBio Units</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 14:52:00', '2022-04-05 17:15:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (45, 'LEPTOSPIRA-IgG       ', '<p><u><strong>LEPTOSPIRA-IgG </strong></u>&nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Leptospira-IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive 2.8 NTU&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt;9 NTU</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Weak Reactive:9 -11 NTU</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive:&gt;=9 NTU&nbsp; </span></span></span></p>\r\n', '2022-03-17 14:53:40', '2022-04-05 17:23:18');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (47, ' CPK', '<p><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span></strong><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CPK</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Phospho Kinase(CPK)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;170.0 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;30 - 200 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum by IFCC)</span></span></span></p>\r\n', '2022-03-17 15:02:22', '2022-04-05 17:26:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (48, 'CK MB', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CK MB</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MB Fraction of Creatinine Kinase(CK MB)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 30.0 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 24.0 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,ECLIA&nbsp;)</span></span></span></p>\r\n', '2022-03-17 15:03:28', '2022-04-05 17:30:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (49, 'TROPONIN T QUANTITATIVE', '<p><u><strong>TROPONIN T QUANTITATIVE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Troponin T Quantitative(Serum by ECLIA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.01 ug/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative : 0.01 ug/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive : &gt; 0.01 ug/L</span></span></span></p>\r\n', '2022-03-17 15:05:30', '2022-04-05 17:34:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (50, 'TROPONIN-I               ', '<p><u><strong>TROPONIN-I</strong></u><strong> &nbsp; &nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Troponin-l&nbsp;&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.00 ug/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative : &lt;0.11ug/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 15:08:37', '2022-04-05 17:42:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (51, 'URINE VMA', '<p><u><strong>URINE VMA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Vanillyl Mandelic Acid(VMA),Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.8 ug/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal &lt; 4.5 ug/mL</span></span></span></p>\r\n', '2022-03-17 15:09:25', '2022-04-05 17:45:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (52, 'HELICOBACTER PYLORI -IgG       ', '<p><u><strong>HELICOBACTER PYLORI -IgG</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Helicobacter pylori -IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15.3 Eu/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt;20 Eu/ml</span></span></span>&nbsp;</p>\r\n', '2022-03-17 15:10:51', '2022-04-05 17:47:46');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (53, 'HELICOBACTER PYLORI -IgM       ', '<p><u><strong>HELICOBACTER PYLORI -IgM</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Helicobacter pylori -IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0&nbsp; U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Negative:&lt; 8 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; quivocal:8-12U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;12 U/mL</span></span></span></p>\r\n', '2022-03-17 15:12:38', '2022-04-05 17:52:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (54, 'FREE-PSA*', '<p><u><strong>FREE-PSA*</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free-PSA(Prostate Specific Antigen)*&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 0.975 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0 - 0.5 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,CMIA)</span></span></span></p>\r\n', '2022-03-17 15:14:31', '2022-04-06 10:09:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (55, 'PSA', '<p><strong><u>PSA</u></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PSA-Prostate Specific Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Coventional for all ages : 0 - 4ng/mL&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; (Serum,ECLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 60 - 69 Yrs : 0- 4.5 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:16:35', '2022-04-07 15:14:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (56, 'CEA', '<p><strong><u><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CEA</span></span></span></u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Carcino Embryonic Antigen(CEA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;NonSmoking0-2.5 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum by CLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Smoking 0 - 50.0 ng/mL&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 15:18:00', '2022-04-06 10:24:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (57, 'LITHIUM TEST', '<p><strong><u>LITHIUM TEST</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lithium(Serum,Colorimetry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Therapeutic range : 0.6 - 1.2 mmol/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Toxic :Potentially: &gt; 1.5 mmol/L&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Toxic :Severely&nbsp;&nbsp; : &gt; 2.0 mmol/L</span></span></span></p>\r\n', '2022-03-17 15:19:40', '2022-04-06 10:32:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (58, 'ANTI HCV', '<p><u><strong>ANTI HCV</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IMMUNOASSAY :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCV-Antibody&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.08(Non-Reactive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Reactive : &gt;=1.0 Cut Off Index</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Non-Reactive : &lt;1.0 Cut Off Index</span></span></span></p>\r\n', '2022-03-17 15:22:23', '2022-04-06 10:41:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (59, 'HEV-IgM', '<p><strong><u>HEV-IgM</u></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HEV-IgM Hepatitis E virus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;NEGATIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;COV:Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &gt;COV:Positive</span></span></span></p>\r\n', '2022-03-17 15:23:13', '2022-04-06 10:50:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (60, 'HAV-IgG', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgG</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgG Ab to Hepatitis A Virus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive(14.1) S/CO&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Non Reactive : &lt; 1.0 S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive : &gt;=1.0 S/CO</span></span></span></p>\r\n', '2022-03-17 15:26:50', '2022-04-06 10:59:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (61, 'HAV-IgM', '<p><strong><u><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HAV-IgM</span></span></span></u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgM Ab to Hepatitis A Virus &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive(0.377) &nbsp;S/COratio&nbsp; &nbsp; &nbsp; &nbsp; NonRactive:&lt;0.80 S/COratio</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Grayzone:0.80-1.2 S/COratio</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Reactive: &gt;1.2 S/COratio</span></span></span></p>\r\n', '2022-03-17 15:28:34', '2022-04-06 11:11:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (62, 'ANTI HBs', '<p><u><strong>ANTI HBs</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti HBs by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Immune : &gt;=10 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Immune : &lt;10 mIU/mL</span></span></span></p>\r\n', '2022-03-17 15:31:04', '2022-04-06 11:15:17');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (63, 'ANTI HBc', '<p><u><strong>ANTI HBc</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti HBc by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 13.2(Reactive)&nbsp;&nbsp; COI&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Reactive : &gt; 1.01 COI</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive : &lt;=1.00 COI</span></span></span></p>\r\n', '2022-03-17 15:31:59', '2022-04-06 11:17:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (64, 'CORTISOL', '<p><u><strong>CORTISOL</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cortisol,Serum(8AM)by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0&nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AM: 5 - 23 ug/dL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; PM: 3 - 16 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; PM:Values are normally 50% of AM value</span></span></span></p>\r\n', '2022-03-17 15:33:32', '2022-04-06 11:24:27');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (65, 'PROLACTIN', '<p><strong><u>PROLACTIN</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Prolactin,serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0&nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;2.5 - 18.2 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:38:57', '2022-04-06 11:31:34');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (66, 'THYROID ANTIBODY REPORT', '<p><u><strong>THYROID ANTIBODY REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microsomal ( TPO ) Antibody&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0 IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 60.0 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Thyroglobulin Antibody ( ATA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;&lt; 60.0 IU/mL&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 15:41:20', '2022-04-06 11:43:24');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (67, 'VIT D3(25 HYDROXY)', '<p><u><strong>VIT D3(25 HYDROXY)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">25 Hydroxy (OH) Vit D3,Serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Deficiency : &lt; 10 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Insufficiency : 10-30ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sufficiency :30-100 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypervitaminosis:&gt;100 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:43:11', '2022-04-06 11:54:09');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (68, 'THYROID FUNCTION TEST (TFT) FEMALE', '<p><strong><u>THYROID FUNCTION TEST (TFT)</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">THYROID PANEL-1 (T3,T4,TSH) Serum, ECLIA</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;180ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1st Trimester:81-190 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2nd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3rd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 11.5ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5.0&nbsp; -&nbsp; 11.5 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (Ultrasensitive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.5uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.4&nbsp; -&nbsp; 4.5 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1st&nbsp;Trimester:0.1-&nbsp;2.5uIU/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">2nd Trimester:0.2-3.0uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:0.3-3.0uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n', '2022-03-17 15:51:00', '2022-04-06 12:05:43');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (69, 'T3 (Total)Female', '<p><u><strong>T3 (Total)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 180ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1st Trimester:81-190 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2nd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:100-260ng/dL</span></span></span></p>\r\n', '2022-03-17 15:53:00', '2022-04-05 15:49:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (70, 'T4 (Total)Female', '<p><u><strong>T4 (Total)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;11.5ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5.0&nbsp; -&nbsp; 11.5 ug/dL</span></span></span></p>\r\n', '2022-03-17 15:56:03', '2022-04-05 15:55:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (71, ' TSH (FEMALE)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">TSH</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (Ultrasensitive)(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.5uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.4&nbsp; -&nbsp; 4.5 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1st Trimester:0.1-2.5uIU/mL&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2nd Trimester:0.2-3.0uIU/mL&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:0.3-3.0uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 15:57:00', '2022-04-07 15:30:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (72, 'E3', '<p><u><strong>E3</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">E3-Unconjugated Estriol serum by RIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Weeks&nbsp;&nbsp; Ref.Range</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post LMP&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; (ng/ mL)</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 12&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.25-0.95&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 13&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.28-1.10&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 14&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.34-1.30&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 15&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.38-1.60&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 16&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.43-2.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 17&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.48-2.40&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 18&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.53-2.90&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 19&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.58-3.40&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 20&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.65-4.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 21&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.75-4.70&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 22-24&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.80-6.20&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 24-26&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.10-7.60&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 26-28&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.50-9.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 28-30&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.30-10.3&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30-32&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.10-11.9&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32-34&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.00-15.7&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 34-36&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.90-20.1&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 36-38&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5.80-22.7&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 38-40&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.40-24.0&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40-42&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.50-24.4&nbsp; ng/ mL</span></span></span></p>\r\n', '2022-03-17 16:07:11', '2022-04-05 16:21:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (73, 'AFP', '<p><u><strong>AFP</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Alpha Feto Protein(AFP)(Serum ,CLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;47.2ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nonpregnant :0.0-10.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15weeks : 6.5-70.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16weeks : 7.0-82.9 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;18weeks : 10.5-102 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;19-23weeks : 26.5-165 ng/ mL</span></span></span></p>\r\n', '2022-03-17 16:08:21', '2022-04-05 16:26:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (74, 'ANA', '<p><u><strong>ANA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody Screening(Serum,EIA)&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative (2.4)U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=10 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt;10 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 16:09:21', '2022-04-06 12:14:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (75, 'ANTI CCP', '<p><u><strong>ANTI CCP</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CCP Antibody Cyclic Citrullinated Peptide&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative &lt;5 U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative &lt;5 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; (Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Positive &gt;= 5 U/mL </span></span></span></p>\r\n', '2022-03-17 16:11:36', '2022-04-06 12:21:52');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (76, 'LE Cell', '<p><u><strong>LE Cell</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Systemic Lupus Erythematosus Cells (LE Cell)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Not Detected</span></span></span></p>\r\n', '2022-03-17 16:13:00', '2022-04-06 12:23:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (77, 'HBeAg', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HBeAg</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HBeAg-HepatitsBEnvelopeAntigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 1.0 COI: NON REACTIVE</span></span></span></p>\r\n', '2022-03-17 16:14:02', '2022-04-06 12:25:02');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (78, 'RA Factor     ', '<p><u><strong>RA Factor</strong></u>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RA Factor&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 8 IU/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Slide Agglutination Method Dillution : 1:16 </span></span></span></strong></p>\r\n\r\n<p><strong>&nbsp; &nbsp; &nbsp;</strong></p>\r\n', '2022-03-17 16:15:20', '2022-04-06 12:27:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (79, 'A.S.O Titre    ', '<p><u><strong>A.S.O Titre</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;A.S.O Titre&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 200 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Silde Agglutination Method Dillution : 1:2</span></span></span></p>\r\n\r\n<p>&nbsp; &nbsp;</p>\r\n', '2022-03-17 16:16:28', '2022-04-06 12:33:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (80, 'C.R.P (C - REACTIVE PROTEIN )  ', '<p><u><strong>C.R.P (C - REACTIVE PROTEIN </strong></u><strong><u>)</u> </strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C.R.P (C - Reactive Protein )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative : &lt; 6 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Slide Agglutination Method Dillution : 1:16&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 16:17:53', '2022-04-06 12:35:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (81, 'CA-125', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CA-125</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cancer Antigen-125(CA-125)(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30.1 U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;30.2 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:18:43', '2022-04-05 16:56:46');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (82, 'CERULOPLASMIN', '<p><u><strong>CERULOPLASMIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ceruloplasmin&nbsp;(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 60 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 20 - 60 mg/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:26:53', '2022-04-06 12:39:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (83, 'SERUM IgE', '<p><u><strong>SERUM IgE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IgE Total antibody,(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100 IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 100 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:28:29', '2022-04-06 12:41:08');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (84, 'SERUM lgG', '<p><u><strong>SERUM lgG</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lgG Total&nbsp;(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1600 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 700 -1600 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:29:28', '2022-04-06 12:43:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (85, 'HbcAb-Total', '<p><u><strong>HbcAb-Total</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbcAb-Total Ab to Hep-B Core Ag (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive(0.21) &lt;1 Index&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt;1 Index</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive: &gt;= 1 Index</span></span></span></p>\r\n', '2022-03-17 16:32:11', '2022-04-05 17:14:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (86, 'HbcAb-lgM Ab', '<p><u><strong>HbcAb-lgM Ab</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbcAb-lgM Ab Hepatitis B Core antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt; 1.0 S/CO&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt; 1.0 S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive: &gt;= 1.0 S/CO</span></span></span></p>\r\n', '2022-03-17 16:38:06', '2022-04-05 17:21:02');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (87, 'INDIRECT COOMB&amp;amp;amp;amp;amp;#039;S TEST(ICT', '<p><u><strong>INDIRECT COOMB&#39;S TEST(ICT)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Coomb&#39;s Test -lndirect(Serum,Gel Card&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Centrifugation)&nbsp;</span></span></span></p>\r\n', '2022-03-17 16:40:04', '2022-04-06 12:49:49');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (89, 'FREE T3 (FEMALE)', '<p><u><strong>FREE T3</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free T3 (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4.2 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.4 - 4.2 pg/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Pregnacy : 2.3-8 pg/mL</span></span></span></strong></p>\r\n', '2022-03-17 16:41:18', '2022-04-06 12:51:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (90, 'FREE T4 (FEMALE)                                  ', '<p><u><strong>FREE T4</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free T4(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.8 - 1.8 ng/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; First Trimester:0.7 -2.0 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Second Trimester:0.5 -1.6 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Third Trimester:0.5-1.6 ng/dL&nbsp;&nbsp;</span></span></span></strong></p>\r\n', '2022-03-17 16:42:48', '2022-04-06 12:55:44');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (91, 'AMYLASE TEST   ', '<p><u><strong>AMYLASE TEST</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Amylase Level&nbsp;(Serum CNPG3 Substrate)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 125 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 25-125 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:44:13', '2022-04-06 12:53:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (92, 'LIPASE TEST', '<p><u><strong>LIPASE TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lipase(Serum Neumann Colorimetric)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10 - 160U/L</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 16:45:30', '2022-04-06 13:02:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (93, 'D-DlMER Quantitative          ', '<p><u><strong>D-DlMER Quantitative</strong></u> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">D-DlMER Quantitative&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;163 ngFEU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 - 500 ngFEU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Citrated plasma,lmmunoturbidimetry)&nbsp; &nbsp; </span></span></span></p>\r\n', '2022-03-17 16:46:41', '2022-04-06 13:04:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (94, 'PROTHROBIN TIME(PT INR)', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PROTHROBIN TIME (PT) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TEST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 11&nbsp; -&nbsp; 16 Seconds&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CONTROL&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PT(INR) Value&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Normal Population:0.8 - 1.2</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Standard Therapy:2 to 3</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;High dose Therapy: 3 to 4.5</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 16:51:54', '2022-04-06 13:05:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (95, 'APTT', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ACTIVATED PARTIAL THROMBOPLASTIN TIME (APTT) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TEST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 - 40 Seconds</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CONTROL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:53:40', '2022-04-06 13:06:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (96, 'HbA1C', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">GLYCATED HAEMOGLOBIN (HbA1C) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbA1C-Glycated Haemoglobin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;5.6 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non diabetic:&lt;= 5.6 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Pre diabetic:5.7-6.4 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Diabetic : &gt;= 6.5 %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Estimated Average Glucose(eAG)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 122.63 mg/dL</span></span></span></p>\r\n', '2022-03-17 16:58:51', '2022-04-07 11:44:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (97, 'PERIPHERAL SMEAR', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PERIPHERAL SMEAR REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RBCs appear&nbsp; Normochromic and Normocytic. </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">WBC count normal.No atypical cells seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Platelets adequate&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; P 58%&nbsp;&nbsp; L 37 %&nbsp;&nbsp; E 05%&nbsp;&nbsp; M 00%&nbsp;&nbsp;&nbsp; B 00%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IMPRESSION: Peripheral smear appears within normal limit.</span></span></span></p>\r\n', '2022-03-17 17:00:16', '2022-03-17 17:00:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (98, 'PTH', '<p><u><strong>PTH REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PTH-(lNTACT Molecule)(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;65 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 15 -65 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:01:38', '2022-04-06 13:08:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (99, 'URINE PROTEIN/CREATININE RATIO', '<p><u><strong>URINE PROTEIN/CREATININE RATIO</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE CHEMISTRY</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE PROTEIN/CREATININE RATIO: </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein,Urine by Pyrogallol red method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by Jaffe Method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein - Creatinine Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 0-0.3</span></span></span></p>\r\n', '2022-03-17 17:03:41', '2022-04-06 13:09:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (100, 'INSULIN', '<p><u><strong>INSULIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Insulin(Random)*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post glucose samples after:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 minutes : 18 - 172 ulU/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;60 minutes : 12 - 134 ulU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;90 minutes : 12 - 107 ulU/mL&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;120 minutes: 12 - 82 ulU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;180 minutes: 2 -23 ulU/mL</span></span></span></p>\r\n', '2022-03-17 17:06:32', '2022-04-06 13:10:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (101, 'FERRITIN', '<p><u><strong>FERRITIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ferritin&nbsp;(Serum,ECILA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.6 -204 ng/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:20:30', '2022-04-06 13:10:52');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (102, '24 HR URINE CREATININE CLEARANCE TEST', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">24 hr Urine Creatinine Clearance Test</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Clearance Test</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.9- 1.3 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by jaffe Method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(24 Hrs Urine jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Urine volume in 24 hours&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,24hrs Urine(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 58 mg/ 24 hrs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1000 - 2000</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Body surface area&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Sq m</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Clearence (Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;44 ml/min/1.73 sq m&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 76-120</span></span></span></p>\r\n', '2022-03-17 17:26:09', '2022-04-06 13:11:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (103, 'AMH', '<p><u><strong>AMH</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">AMH Mullerian Inhibiting Substance(Serum,ECLlA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.9 -9.5 ng/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 17:28:07', '2022-04-06 13:13:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (104, 'HbsAg( CMIA)', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HbsAg</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbsAg,CMlA*&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive(4640.39)S/CO&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt;1.0S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive: &gt;=1.0S/CO</span></span></span></p>\r\n', '2022-03-17 17:30:05', '2022-04-06 11:44:12');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (105, 'CA- 15.3                      ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>CA- 15.3</strong></u></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CA- 15.3&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 31.3&nbsp; U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 - 31.3 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><strong>&nbsp;</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 17:31:05', '2022-04-06 11:51:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (106, 'VITAMIN B12', '<p><u><strong>VITAMIN B12</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Vitamin B12 level(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 771 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 197 - 771 pg/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:31:57', '2022-04-06 11:56:08');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (107, 'CMV IgG', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CMV IgG</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CMV IgG,Serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.0 a U/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive : &lt;6.0 aU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive&nbsp; : &gt;=6.0 aU/ml&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:14:59', '2022-04-06 12:02:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (108, 'SPUTUM AFB', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">SPUTUM AFB</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SPUTUM EXAMINATION REPORT</span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(1). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum&nbsp; (1st day)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(2). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum (2nd day)&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(3). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum (3rd day)&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:18:29', '2022-04-06 12:01:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (109, 'FOLIC ACID               ', '<p><u><strong>Folic Acid</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Folic Acid&nbsp;(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0&nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;1.2 - 7.1 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 22:20:17', '2022-04-06 12:05:37');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (110, 'Urea Nitrogen(BUN)', '<p><u><strong>Urea Nitrogen(BUN)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">BUN- Blood Urea Nitrogen(Serum,Urease)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 8.9 - 20.6 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 22:21:32', '2022-04-06 12:10:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (111, 'MANTOUX TEST', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MANTOUX TEST REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PPD 10TU GIVEN ON THE LEFT FORE ARM&nbsp; AT 12:30 PM</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">INDURATION&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2 X 2 mm</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ERYTHEMA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RESULTS &amp; INTERPRETATION</span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">POSITIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;INDURATION MEASURING 10mm OR MORE.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DOUBTFUL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; INDURATION MEASURING BETWEEN 5mm AND 9mm.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">NEGATIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;INDURATION OF LESS THAN 5mm.&nbsp;</span></span></span></p>\r\n', '2022-03-17 22:24:16', '2022-04-06 12:36:10');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (112, 'LDL CHOLESTEROL          ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>LDL CHOLESTEROL TEST</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LDL CHOLESTEROL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;000 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Optimal : &lt; 100 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Near Optimal/above Potimal :</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;100-129 mg/ dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Borderline High : 130-159 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; High : 160-189 mg/dL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Very High : &gt;=189 mg/ dL</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:26:13', '2022-04-06 12:43:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (113, 'Toxoplasma IgG', '<p><u><strong>Toxoplasma IgG</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Toxoplasma IgG(Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0 IU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive : &lt;1.6 IU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Grayzone : 1.6-3.0 IU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive : &gt;=3.0 IU/ml</span></span></span></p>\r\n', '2022-03-17 22:28:01', '2022-04-06 12:52:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (114, 'Toxoplasma IgM', '<p><u><strong>Toxoplasma IgM</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Toxoplasma IgM(Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 Index&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; Non Reactive: &lt; 0.5&nbsp;&nbsp; Index&nbsp; &nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Grayzone:0.5-0.59 Index&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive:&gt;=0.6 Index</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:30:17', '2022-04-06 13:07:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (115, 'Anti Sperm Antibody (ASAB)', '<p><u><strong>Anti Sperm Antibody (ASAB) TEST</strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Sperm Antibody (ASAB)(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 U/mL&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt;=60 U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Positive:&gt; 60U/mL&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:33:40', '2022-04-06 13:25:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (116, 'Albumin/Creatinine Ratio Urine          ', '<p><u><strong>Albumin/Creatinine Ratio Urine</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Creatinine Ratio Urine&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Urine)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin in Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(immuno Turbidiometry)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&gt; 50 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Jaffes kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &lt; 0.3 &gt; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:36:01', '2022-04-06 13:34:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (117, '125 VITAMIN D', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">125 VITAMIN D</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Vitamin D-125 Dihydroxy,serum by CLIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00.0 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;19.9&nbsp; -&nbsp; 79.3 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Please note&nbsp;change&nbsp;</span></span></span><font face=\"Calibri, sans-serif\">&nbsp;</font></p>\r\n\r\n<p style=\"margin-bottom:14px\"><font face=\"Calibri, sans-serif\"><span style=\"font-size: 14.6667px;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span>&nbsp;</font><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">in ref.range and method.</span></span></span></p>\r\n', '2022-03-22 10:33:41', '2022-04-06 13:41:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (118, 'S.Acid Phosphatase(Total)', '<p><u><strong>S.Acid Phosphatase(Total)</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">S.Acid Phosphatase(Total)</span></span><span style=\"tab-stops:346.85pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Enzymatic</span></span></span><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.3 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.3 &nbsp;-&nbsp; 9.2 U/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:346.85pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></span></p>\r\n', '2022-03-22 10:34:45', '2022-04-06 13:49:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (119, '24 HRS URINE PROTEINS', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PROTEINS URINE 24Hrs</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-family: Calibri, sans-serif; font-size: 11pt;\">Urine Chemistry :</span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein Urine 24 hrs,Colourimetry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;150mg/24hrs.&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;upto 150mg/24hrs.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein,Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by Drychemistry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein-Creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal:&lt;0.3:1</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Calcium Creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt; 0.3:1</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 10:47:24', '2022-04-05 12:39:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (120, 'ANTI DS  DNA', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>DNA(Double Strand)Antibody</strong></u></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DNA(Double Strand)Antibody(Serum,ELISA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:20 IU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt; 25 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt; 25 IU/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 10:58:40', '2022-04-05 12:45:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (121, ' ACE', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ACE (Angiotensin Converting Enzyme)</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ACE (Angiotensin Converting Enzyme)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;50 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 40 U/L</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; (Serum,Kinetic Assay)&nbsp;</span></span></span></strong></p>\r\n', '2022-03-22 11:00:39', '2022-04-05 12:51:52');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (122, ' DHEA', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">DHEA TEST</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-left:250px; text-indent:-186.75pt; margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DHEA &ndash; Dehydroepiandrostenedione&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.2 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1.2 - 6.3 ng/mL </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; (Serum,ELISA)&nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom: 14px;\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; Please note the change&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">in&nbsp;reference range</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span></p>\r\n', '2022-03-22 11:03:21', '2022-04-05 13:26:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (123, ' Iron', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Iron Test</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Iron(Serum,Ferrozine Method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;100 Ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 33-193 Ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:04:21', '2022-04-05 13:28:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (124, 'TIBC', '<p><u><strong>TIBC TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TIBC&nbsp;&nbsp;(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 300&nbsp;Ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 250-450 Ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ferritin&nbsp;(SERUM,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 13 -150 ng/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Transferin Saturation(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;39 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 14 - 50 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 11:05:53', '2022-04-05 13:32:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (125, 'lron, lCPMS**           ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>lron,Serum, lCPMS**</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lron,Serum, lCPMS**(Serum,lCPMS)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100 ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 55 - 120 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reference : Rodushkin l. et al.,Pure &amp; Applied Chem.,2001,5,pp 51-66.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:09:11', '2022-04-05 13:36:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (126, 'GAMMA GT                ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Gamma GT (GGTP)</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Gamma GT (GGTP)(Serum,IFCC method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;32 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;9 -36 U/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:11:26', '2022-04-05 13:38:37');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (127, 'Anti Nuclear Antibody, IFA', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody, IFA</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody , lFA&nbsp;&nbsp;(Serum,lmmunofluorescence)&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Result&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pattern&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; -&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Grade&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; -&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; -</span></span></span></p>\r\n', '2022-03-22 11:13:32', '2022-03-22 11:13:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (128, 'AFP-Alpha Feto Protein             ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>AFP-Alpha Feto Protein</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">AFP-Alpha Feto ProteinSerum,ECLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 7 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:14:36', '2022-04-05 14:56:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (129, 'C3(Complement-3)', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">C3(Complement-3)</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C3(Complement-3),Serum by Nephelometry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 110 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 90&nbsp;-&nbsp;180 mg/dL</span></span></span></p>\r\n', '2022-03-22 11:15:43', '2022-04-05 14:58:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (130, 'C4(Complement-4)', '<p><u><strong>C4(Complement-4)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C4(Complement-4),Serum by Nephelometry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10&nbsp;-&nbsp;40 mg/dL</span></span></span></p>\r\n', '2022-03-22 11:16:38', '2022-04-05 15:01:04');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (131, 'Homogentisic Acid   ', '<p><u><strong>Homogentisic Acid Test</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Homogentisic Acid(Alkaptanuria)(Urine)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:24:06', '2022-04-05 15:02:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (132, 'Osmolality Urine*             ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Osmolality Urine*</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Osmolality Urine*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1300 mOsm/kg&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 50 -1400 mosm/kg</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Urine,Freezing Point Depression)&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:25:01', '2022-04-05 15:08:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (133, 'Valproic Acid                  ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Valproic Acid</strong></u>&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Valproic Acid(Serum,CLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;50 ug/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Therapeutic range:50-100 ug/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:25:45', '2022-04-05 15:11:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (134, 'S.Homocysteine', '<p><u><strong>S.Homocysteine</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Homocysteine(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10.2 umol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5.46 -16.2 umol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:26:32', '2022-04-05 15:15:24');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (135, 'C-Peptide                   ', '<p style=\"margin-bottom:14px\"><u><strong>C-Peptide</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C-Peptide(Serum CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1676 pMol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Fasting:259 -1728 pMol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Stimulated: 500 -3000pMol/L</span></span></span></p>\r\n', '2022-03-22 11:27:39', '2022-04-05 15:19:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (136, 'CRP-C Reactive protein        ', '<p><u><strong>CRP-C Reactive protein</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CRP-C Reactive protein&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;&nbsp;6 mg/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,Nephelometry)</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:28:58', '2022-04-05 15:24:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (137, 'ASO titre        ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>ASO titre&nbsp;</strong></u>&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ASO titre Quantitative&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;150 IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 200 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum Nephelometry)&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:30:11', '2022-04-05 15:25:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (138, 'URINE CULTURE &  SENSITIVITY', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE CULTURE &amp; SENSITIVITY</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Urine</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH&nbsp; : Culture shows no growth after 48 hours of incubation at 37 C.</span></span></span></p>\r\n', '2022-03-22 11:32:18', '2022-04-05 15:56:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (139, ' SODIUM', '<p><u><strong>SODIUM</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SODIUM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;137 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 135 - 148 mmol/L&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:33:52', '2022-04-05 15:30:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (140, 'POTASSIUM', '<p><u><strong>POTASSIUM TEST</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">POTASSIUM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4.1 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.5 - 5.1 mmol/L</span></span></span></p>\r\n', '2022-03-22 11:34:35', '2022-04-05 15:32:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (141, 'Serotonin', '<p><span style=\"font-size:18px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Serotonin</span></span></strong></u></span></p>\r\n\r\n<p><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Serotonin , Serum&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 200 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 - 400 ng/mL</span></span></span></strong></p>\r\n', '2022-03-22 11:35:15', '2022-04-05 15:35:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (142, 'CA-19.9                       ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>CA-19.9</strong></u>&nbsp;</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CA-19.9(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 25 U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;&nbsp;27 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:35:58', '2022-04-05 15:37:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (143, 'BLOOD CULTURE & SENSITIVITY ', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">BLOOD CULTURE &amp; SENSITIVITY </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;:&nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH : Blood culture shows no Pathogenic Organism seen after 7 days of incubation at 37 C.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CULTURE&amp;SENSITIVITY-BLOOD</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Microscopy Result&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;Sample Date :</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Report Date :</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Blood&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Gram Stain&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;No micro-Organisms seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <u>Final Report</u></span></span></b></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Organism(s)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; :&nbsp;&nbsp;&nbsp; No growth after one week of incubation.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:37:33', '2022-04-05 15:46:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (144, 'SEMEN ANALYSIS', '<p><u><strong>SEMEN ANALYSIS REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PHYSICAL CHARACTERISTICS</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Volume&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ml&nbsp;( 2&nbsp; -&nbsp; 5 ml )</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; :</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Consistency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Liquefaction Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROSCOPICAL EXAMINATION</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Total Sperm Count&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Millions/ml&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MOTILITY GRADING</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a).(Rapid Progressive)&nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">b).(Slow Progressive)&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c).(Non-progressive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;20 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">d).(Immobile)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MORPHOLOGICAL GRADING</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Normal&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 40 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Abnormal&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 60 %&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; 1-2 /hpf</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;Nil /hpf</span></span></span></p>\r\n', '2022-03-22 11:43:46', '2022-04-05 15:47:44');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (145, 'HLA B27', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27(Human Luecocyte Antigen B27)&nbsp;(EDTA Whole Blood)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27 Detection&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Remark&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp;:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Result Confirmed by Molecularmethod</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Method&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Flow Cytometry&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:59:57', '2022-04-05 15:48:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (146, '17 Hydroxy Progesterone ', '<p style=\"margin-bottom:14px\"><u><strong>17 Hydroxy Progesterone</strong></u><strong>&nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">17 Hydroxy Progesterone &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.12 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Adult Female&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;(serum by RIA Method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Follicular Phase 0.15 - 1.1ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Luteal phase 0.7 - 5.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Pregnancy&nbsp; 2.5&nbsp; -&nbsp; 18.9 ng/ mL</span></span></span></p>\r\n', '2022-03-22 12:02:53', '2022-04-05 15:51:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (147, 'Dengue (NS1)', '<p><u><strong>Dengue (NS1)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Dengue (NS1) Antigen(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Negative :&nbsp; 9PanBio Units&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative : &lt;9PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Equivocal:9-11PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;11PanBio Units</span></span></span></p>\r\n', '2022-03-22 12:04:16', '2022-04-05 15:56:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (148, 'ACTH', '<p><u><strong>ACTH</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ACTH-Adreno Corticotropic Hormone(Plasma)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;3.6 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 to 46pg/mL&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:05:22', '2022-04-05 15:58:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (149, 'AMMONIA', '<p><u><strong>AMMONIA</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ammonia(Heparin Whole Blood,Enzymatic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;40 umol/L&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;30 - 65 umol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:06:56', '2022-04-05 16:00:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (150, 'SEMEN CULTURE & SENSITIVITY', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SEMEN CULTURE &amp; SENSITIVITY</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH&nbsp; :&nbsp; Culture shows no growth after 48 hours of incubation at 37 C.</span></span></span></p>\r\n', '2022-03-22 12:08:56', '2022-04-05 16:06:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (151, 'TPHA', '<p><u><strong>TPHA</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TPHA(Serum)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lnterpretation:&nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Treponema Pallidium Haemagglutination (TPHA)</span></span></span></p>\r\n', '2022-03-22 12:09:50', '2022-04-05 16:07:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (152, 'HIV 1&11', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HIV 1&amp;11</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HIV 1&amp;11,CMIA*&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive:&nbsp; &nbsp; &nbsp;COl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive: &lt; 1.0 COl</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive&nbsp;&nbsp;&nbsp; : &gt;=1.0 COl</span></span></span></p>\r\n', '2022-03-22 12:11:44', '2022-04-05 16:10:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (153, 'Hepatitis B Surface Antibody', '<p><u><strong>Hepatitis B Surface Antibody</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Hepatitis B Surface Antibody(Anti HBs)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;10 mlU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp;(Serum,CMlA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;(Below Protection):&lt;10mlU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive(Protective):&gt;=10mlU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span></p>\r\n', '2022-03-22 12:14:03', '2022-04-05 16:16:15');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (154, 'MPO- ANCA', '<p><u><strong>MPO- ANCA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MPO- ANCA(p-ANCA)*(Serum,ELISA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt; 20 RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt; 20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-22 12:29:56', '2022-04-05 16:18:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (155, 'PR3 -ANCA                         ', '<p><u><strong>PR3 -ANCA</strong></u><strong> </strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PR3 -ANCA (c -ANCA)*(Serum,EIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;20 RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;=20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ADDITIONAL TEST : PLA2R(phospholipase A2 receptor)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Antibody : A novel marker for IMN(ldiopathic Membranous Nephropathy)</span></span></span></p>\r\n\r\n<p><strong>&nbsp;</strong> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>\r\n', '2022-03-22 12:31:17', '2022-04-05 16:20:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (156, 'GFR', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">GFR</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">GFR With Creatinine(Serum)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine(jaffes kinetic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;0.9 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.8-1.3 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">eGFR(CKD-EPl)(jaffe)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ml/min/1.73 sqm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal OR high:&gt;=90</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mild or decrease:60 -89</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mild to moderate decrease:45-59</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mild to severe decrease:30-44</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; severe decrease:15-29</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Kidney failure:&lt;15</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Note: Equation is notvalid for patients below 18 years of age Caculated</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;by lDMS-TraceableCKD-EPl Creatinine equation.</span></span></span></p>\r\n', '2022-03-22 12:34:43', '2022-04-05 16:26:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (157, 'HsCRP', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HsCRP</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HsCRP-High Sensitivity CRP*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;= 2mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;= 3 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;(Serum,Nephelometry)&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:35:54', '2022-04-05 16:28:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (158, 'Lipoprotein(a)*               ', '<p><u><strong>Lipoprotein(a)*</strong></u> &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lipoprotein(a)*(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;23 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -30 mg/dl</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 12:36:39', '2022-04-05 16:28:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (159, 'Bicarbonate', '<p><u><strong>Bicarbonate</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Bicarbonate&nbsp;(Serum,Enzymatic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 17&nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 16 - 25 mmol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:37:26', '2022-04-05 16:31:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (160, ' G6PD', '<p><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span></strong><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">G6PD</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">G6PD-quantitative,&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Not Deficiennt(7.1)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;6.97-20.5 Units/gm of HB</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">blood by kinetic method*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Units/gm of HB&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(EDTA Whole Blood,Enzymatic)</span></span></span></p>\r\n', '2022-03-22 12:38:23', '2022-04-05 16:37:12');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (161, 'Protein S Activity*            ', '<p><u><strong>Protein S Activity*</strong></u><strong> &nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein S Activity*&nbsp;(Citrated plasma)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;55 -123 &nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Pregnant: 55 -123 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;First Trimester: 57 -95%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:42 68%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Third Trimester: 16 42%</span></span></span></p>\r\n', '2022-03-22 12:39:55', '2022-04-05 16:44:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (162, 'Protein C Activity*           ', '<p><u><strong>Protein C Activity*</strong></u>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein C Activity*(Citrated plasma)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;70 -130 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Pregnant: 70 -130%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;First Trimester:78 -121%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:83 -133%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Third Trimester:67 -135%</span></span></span></p>\r\n', '2022-03-22 12:41:44', '2022-04-05 16:46:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (163, 'Beta-2-Microglobulin*                ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Beta-2-Microglobulin*</strong></u><strong>&nbsp;</strong>&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Microglobulin*(Serum,ELFA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.143 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.670-2.143 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:43:19', '2022-04-05 16:48:08');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (164, 'MICRO FILARIA ', '<p><u><strong>MICRO FILARIA<span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">(MF)</span></span></span></strong></u>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Filaria Antigen detection(EDTA Whole Blood)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Filaria Antibody detection(Serum)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Method&nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Immunochromatography</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 12:45:52', '2022-04-05 16:49:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (165, 'HSV-1&amp;2', '<p><u><strong>HSV-1&amp;2</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HSV-1&amp;2 (Herpes Simplex&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 0.8 lndex&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Negative:&lt; 0.8 lndex</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Virus-1&amp;2)lgG antibody*(Serum,CLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Equivocal:0.8-1.1 lndex</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;=1.1 lndex</span></span></span></p>\r\n', '2022-03-22 12:47:31', '2022-04-05 16:52:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (166, 'HSV-1&2 IgM', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HSV-1&amp;2 IgM</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HSV-1&amp;2 IgM antibody*(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&lt;0.8&nbsp;Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;0.8 Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Borderline:0.8-1.1 Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;1.1 Ratio&nbsp;&nbsp;&nbsp;&nbsp;</strong>&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:49:36', '2022-04-05 16:55:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (167, '24 HRS Urine  Albumin Quantitative ', '<p><u><strong>24 HRS Urine &nbsp;Albumin Quantitative</strong></u><strong>&nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin QuantitativeUrine 24H(24 Hrs URINE)</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin in Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;23 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;= 30 mg/L</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; (lmmunoturbidimetry)&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Urine Volume in 24 hours&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin urea&nbsp; by&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;200 mg/24hrs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Normal: &lt; 150 mg/24hrs&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lmmunoturbidimetry</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;(lmmunoturbidimetry)</span></span></span></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 13:06:38', '2022-04-05 16:59:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (168, ' EPTOIN', '<p><strong>&nbsp;</strong><u><strong>EPTOIN</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Phenytoin(Eptoin)(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 14&nbsp; ug/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Therapeutic range : 10-20 ugmL </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Toxic range : &gt; 20 ug/mL</span></span></span></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 13:08:04', '2022-04-05 17:01:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (169, 'LIVER FUNCTION TEST           ', '<p><u><strong>LIVER FUNCTION TEST</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><strong>Serum Bilirubin - Total&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Upto 1.2 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong></p>\r\n\r\n<p><strong>Serum Bilirubin -&nbsp; Direct&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Upto 0.2 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong></p>\r\n\r\n<p><strong>SGOT / AST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L </strong></p>\r\n\r\n<p><strong>SGPT / ALT&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L&nbsp; </strong></p>\r\n\r\n<p><strong>Serum Alkaline Phosphatase&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;80 - 290 U/L&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong></p>\r\n\r\n<p><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Children 245 - 770 U/L&nbsp;&nbsp; </strong></p>\r\n\r\n<p><strong>Total Protein &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;6.0 - 8.0 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong></p>\r\n\r\n<p><strong>Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 3.7 - 5.3 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong></p>\r\n\r\n<p><strong>Globulin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 2.3 - 3.6 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong></p>\r\n\r\n<p><strong>A/G Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.0 -2.3&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>&nbsp;&nbsp;&nbsp; </b></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 14:56:36', '2022-05-26 13:45:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (170, 'Serum Bilirubin - Total       ', '<p><span style=\"font-size:16px;\"><u><strong>Serum Bilirubin - Total</strong></u><strong> &nbsp;</strong></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Serum Bilirubin - Total&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.2&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Upto 1.2 mg/dL</span></span></b></span></p>\r\n', '2022-03-22 15:16:48', '2022-04-05 17:43:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (171, 'Serum Bilirubin -  Direct     ', '<p><span style=\"font-size:16px;\"><u><strong>Serum Bilirubin - &nbsp;Direct</strong></u></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Serum Bilirubin -&nbsp; Direct&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.1 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Upto 0.2 mg/dL &nbsp;&nbsp;</span></span></b></span></p>\r\n', '2022-03-22 15:18:33', '2022-04-05 17:45:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (172, 'SGOT / AST                    ', '<p><span style=\"font-size:16px;\"><u><strong>SGOT / AST&nbsp;</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">SGOT / AST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L&nbsp;&nbsp;</span></span></b></span></p>\r\n', '2022-03-22 15:20:06', '2022-04-05 17:47:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (173, 'SGPT / ALT                    ', '<p><span style=\"font-size:16px;\"><u><strong>SGPT / ALT</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"color:#000000;\">SGPT / ALT</span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L&nbsp;</span> &nbsp; &nbsp;</span></span></span></b></p>\r\n', '2022-03-22 15:21:58', '2022-04-05 17:49:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (174, 'Serum Alkaline Phosphatase    ', '<p><span style=\"font-size:16px;\"><u><strong>Serum Alkaline Phosphatase</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:14px;\"><strong>Serum Alkaline Phosphatase&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-family:Arial,Helvetica,sans-serif;\">&nbsp;</span></strong><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"line-height:115%\">290 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;80 - 290 U/L&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></b></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"line-height:115%\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></b><span style=\"line-height:normal\"><b>Children 245 - 770 U/L</b></span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:14px;\"> </span>&nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b></p>\r\n', '2022-03-22 15:25:29', '2022-04-05 17:53:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (175, 'Total Protein                 ', '<p><span style=\"font-size:16px;\"><u><strong>Total Protein</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Total Protein&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;7.1 gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.0 - 8.0 gm %</span></span></b></span></p>\r\n', '2022-03-22 15:26:39', '2022-04-06 10:03:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (176, 'S.Albumin', '<p><span style=\"font-size:16px;\"><u><strong>S.Albumin</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.3 gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.7 - 5.3 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></b></span></p>\r\n', '2022-03-22 15:28:02', '2022-04-06 10:08:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (177, 'Globulin', '<p><span style=\"font-size:18px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Globulin</span></span></strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Globulin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.4 gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.3 - 3.6 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></b></span></p>\r\n', '2022-03-22 15:29:09', '2022-04-06 10:10:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (178, 'COMPLETE  BLOOD  COUNT        ', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><b><span style=\"line-height:100%\"><u>COMPLETE&nbsp; BLOOD&nbsp; COUNT</u></span></b></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;Hb&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 11.5&nbsp;gm%&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;M:12.5-18 F:11.5-16gm%</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">WBC:-</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10,000 Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4,000 -11,000 Cells/cmm</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;Differential Count:-</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Polymorphs&nbsp;</span></b></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">45&nbsp;</span></b></span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;45 - 74 %&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16 - 45 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;7&nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0 -&nbsp; 7 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4 - 10 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;0 -&nbsp; 2 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;millions/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M: 5.5-6.5 F:4.0-5.5milli</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Platelet Count&nbsp;</span></b></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; 1.5</span></b></span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;lakhs/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.5 - 4.0 lakhs/cmm</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">PCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 40 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M : 40-54 % F: 36-47 %&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">MCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;82.0&nbsp; fl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;82.0 - 96.0 fl&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">MCH&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;27.0&nbsp;pg&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 27.0 - 34.0 pg&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">MCHC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32.0&nbsp;g/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32.0 - 38.0 g/dl&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15 mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:0-9F:0-15 mm/hr</span></b></span></span></span></p>\r\n', '2022-03-22 15:40:29', '2022-04-22 11:36:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (179, 'Hb  ', '<p><span style=\"font-size:16px;\"><u><strong>Hb</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"line-height:115%\">Hb</span></b><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.00&nbsp;</strong></span><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">gm%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:12.5-18 F:11.5-16gm%&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span> &nbsp;&nbsp;</span></span></b></span></p>\r\n\r\n<p>&nbsp; &nbsp;</p>\r\n', '2022-03-22 15:42:54', '2022-04-06 10:37:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (180, 'WBC', '<p><span style=\"font-size:16px;\"><u><strong>WBC</strong></u></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00,000 Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4,000 -11,000 Cells/cmm&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:44:30', '2022-04-06 11:48:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (181, 'Differential Count', '<p><span style=\"font-size:16px;\"><u><strong>Differential Count</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Polymorphs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 45 - 74 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16 - 45 %&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0 -&nbsp; 7 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4 - 10 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0&nbsp;-&nbsp; 2 %&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:49:05', '2022-04-06 12:02:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (182, 'RBC', '<p><span style=\"font-size:16px;\"><u><strong>RBC</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.0 millions/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M: 5.5-6.5 F:4.0-5.5millions/cmm</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:51:27', '2022-04-08 10:14:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (183, 'Platelet Count                ', '<p><span style=\"font-size:16px;\"><u><strong>Platelet Count</strong></u><strong>&nbsp;</strong></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"line-height:normal\"><b>&nbsp;Platelet Count&nbsp;&nbsp;</b></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;<strong>3.0&nbsp;</strong><span style=\"line-height:normal\"><b>lakhs/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.5 - 4.0 lakhs/cmm&nbsp;&nbsp;</b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\n&nbsp;</p>\r\n', '2022-03-22 15:52:53', '2022-04-07 09:59:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (184, ' PCV                           ', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><span style=\"line-height:115%\">&nbsp;</span><strong><u><span style=\"line-height:115%\">PCV</span></u><span style=\"line-height:115%\">&nbsp;</span></strong></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;PCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M : 40-54 % F: 36-47 %&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:54:34', '2022-04-06 12:16:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (185, 'ESR', '<p><span style=\"font-size:16px;\"><u><strong>ESR</strong></u></span></p>\r\n\r\n<p><br />\r\n<span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0-15 mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:0-9F:0-15 mm/hr</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:56:01', '2022-04-06 12:21:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (186, 'LIPID PROFILE                 ', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:14px;\"><u><strong>LIPID PROFILE</strong></u><strong>&nbsp;</strong></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Total Cholesterol&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><span style=\"font-size:14px;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">140 mg/dL&nbsp;</span></span></span><span style=\"font-size:14px;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">Adults:140-200mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span>C<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">hildren :&lt;150 mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Triglycerides&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100&nbsp;</span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 40-165&nbsp; mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">HDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45&nbsp;</span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:30-55 F: 45-65 mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">LDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">140 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Upto 150&nbsp; mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">VLDL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; Upto 40&nbsp; mg/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\n&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:02:53', '2022-04-07 10:59:22');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (187, 'Total Cholesterol             ', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><strong><u><span style=\"line-height:115%\">Total Cholesterol</span></u></strong></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">&nbsp;&nbsp;</span>&nbsp;</span></span></span></b></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Total Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;200&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Adults:140-200mg/dL&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">children :&lt;150 mg/dL&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:05:18', '2022-04-06 12:34:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (188, 'Triglycerides', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\">Triglycerides</span></strong></u></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><strong><span style=\"line-height:115%\">Triglycerides&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;100&nbsp;</span></strong></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;40-165&nbsp; mg/dL&nbsp;&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:06:35', '2022-04-06 12:57:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (189, 'HDL - Cholesterol             ', '<p><span style=\"font-size:16px;\"><u><strong>HDL - Cholesterol</strong></u><strong> </strong></span>&nbsp; &nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">HDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 55 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M:30-55 F: 45-65 mg/dL&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:10:19', '2022-04-06 12:59:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (191, 'RENAL FUNCTION TEST           ', '<p><span style=\"font-size:16px;\"><u><strong>RENAL FUNCTION TEST</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Blood Urea&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 87 mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;14 - 40&nbsp;&nbsp; mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">S.Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2.0&nbsp;mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M :- 0.6 - 1.2 mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;F :- 0.5 - 1.1 mg%&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">S.Uric Acid&nbsp;</span></b></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\"font-size:16px;\"><strong>10.2&nbsp;</strong></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\"><span style=\"font-size:16px;\">mg%&nbsp; </span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;M :- 3.5 - 7.2 mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; F : - 2.6 - 6.0 mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><strong>&nbsp;</strong></span> &nbsp; &nbsp;</p>\r\n', '2022-03-22 16:16:22', '2022-04-06 14:04:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (192, 'Blood Urea   ', '<p><span style=\"font-size:16px;\"><u><strong>Blood Urea</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Blood Urea&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;14 - 40&nbsp;mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:19:50', '2022-04-06 13:23:07');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (193, ' S.Creatinine                  ', '<p><span style=\"font-size:20px;\"><strong>&nbsp;</strong><u><strong>S.Creatinine</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:20px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"line-height:normal\"><b>&nbsp;S.Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.2 mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M :- 0.6 - 1.2 mg%&nbsp;&nbsp;</b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:20px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"line-height:normal\"><b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;F :- 0.5 - 1.1 mg%</b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:21:24', '2022-04-12 15:59:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (194, 'S.Uric Acid                   ', '<p><span style=\"font-size:16px;\"><u><strong>S.Uric Acid</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;S.Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;7.2 mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M :- 3.5 - 7.2 mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;F : - 2.6 - 6.0 mg%&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:23:25', '2022-04-05 15:21:55');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (195, 'Blood Sugar (Random)          ', '<p><span style=\"font-size:16px;\"><u><strong>Blood Sugar</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Blood Sugar (Random)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;150 mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Upto 150 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Corr .Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:31:16', '2022-04-06 11:20:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (196, 'Blood Sugar(Fasting)', '<p><strong><u><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">BLOOD SUGAR</span></span></span></u></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Sugar(Fasting)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;110 mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;70-110 mg/dl&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Corr .Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 16:32:57', '2022-04-07 10:40:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (197, 'Blood Sugar ( PPBS )          ', '<p><u><strong><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">BLOOD&nbsp; SUGAR</span></span></span></strong></u><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;</span></span></span></b></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Sugar ( PPBS )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;140 mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Up to 140 mg/dl&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Corr. Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Green</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:34:25', '2022-04-07 10:38:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (198, 'BLOOD GROUPING                ', '<p><u><strong>BLOOD GROUPING</strong></u>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;BLOOD GROUPING&nbsp; &nbsp;</span></b></span></span></span><span style=\"font-size:16px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&quot;B&quot;&nbsp;&nbsp;&nbsp;&nbsp;</span></b></span></span><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Rh TYPING</span></b></span></span></span><span style=\"font-size:16px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;</span></b></span></span><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:38:00', '2022-04-05 15:57:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (199, 'GLUCOSE TOLERANCE TEST', '<p><u><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">GLUCOSE TOLERANCE TEST</span></span></span></b></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;After 75gm Glucose :-&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp;2&nbsp; Hour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;110 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp;Corr. Urine Sugar&nbsp;&nbsp;</span></span></b></span></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Nil&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span>&nbsp;</p>\r\n', '2022-03-22 16:39:34', '2022-04-06 13:37:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (200, 'GCT ', '<p><span style=\"font-size:16px;\"><u><strong>GCT&nbsp;</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Blood Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 140 mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Up to 140 mg/dl&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;(1 hr after 50gm glucose given)</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Corr.Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:41:32', '2022-04-05 16:16:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (201, 'BLOOD  ROUTINE(R/E)', '<p><span style=\"font-size:16px;\"><u><strong>BLOOD &nbsp;ROUTINE(R/E)</strong></u></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-size:14px;\">EXAMINATION OF BLOOD&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></b></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><b>&nbsp;Hb&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;12.2 gm%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:12.5-18 F:11.5-16gm%</b></p>\r\n\r\n<p><b>WBC:-</b></p>\r\n\r\n<p><b>Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 8,900&nbsp;Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4,000 -11,000 Cells/cmm</b></p>\r\n\r\n<p><b>Differential Count:-</b></p>\r\n\r\n<p><b>Polymorphs&nbsp;</b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<strong>75</strong><b><strong>%&nbsp; &nbsp;</strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;45 - 74 %</b></p>\r\n\r\n<p><b>Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;22%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6 - 45 %</b></p>\r\n\r\n<p><b>Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;03%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -&nbsp; 7 %</b></p>\r\n\r\n<p><b>Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;4 - 10 %</b></p>\r\n\r\n<p><b>Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -&nbsp; 2 %</b></p>\r\n\r\n<p><b>ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;05mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M:0-9F:0-15 mm/hr</b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:48:36', '2022-04-07 09:57:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (202, 'SEROLOGY', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">SEROLOGY</span></span></strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HBs Ag&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HIV 1 &amp; 2&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:53:25', '2022-04-05 16:44:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (203, 'HBs Ag(Card)                    ', '<p><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:18px;\"><strong><u>HBs Ag</u></strong>&nbsp;</span>&nbsp;</span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HBs Ag&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:56:03', '2022-04-05 16:49:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (204, 'HIV 1&2                     ', '<p><span style=\"font-size:16px;\"><u><strong>HIV 1 &amp; 2 </strong></u></span>&nbsp; &nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">HIV 1 &amp; 2&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Negative&nbsp;&nbsp; </span></span></b></span></p>\r\n', '2022-03-22 16:57:05', '2022-04-07 11:17:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (205, 'VDRL', '<p><span style=\"font-size:18px;\"><u><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL</span></span></b></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:58:05', '2022-04-05 16:54:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (206, 'HCV ', '<p><span style=\"font-size:16px;\"><u><strong>HCV</strong></u><strong>&nbsp;</strong></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:59:24', '2022-04-05 16:58:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (207, 'Bleeding Time, Clotting Time', '<p><u><strong><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bleeding Time, Clotting Time</span></span></span></strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Bleeding Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1&#39; 15&quot;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 - 3&nbsp; minutes&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Clotting Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2&#39; 50&quot;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3- 7&nbsp; minutes&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:00:53', '2022-04-05 17:08:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (208, 'ABSOLUTE EOSINOPHIL COUNT (AEC)', '<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">ABSOLUTE EOSINOPHIL COUNT (AEC)</span></span></span></b></span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">ABOLUTE EOSINOPHIL COUNT&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40-440 Cells/ cmm&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:02:07', '2022-04-05 17:14:42');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (210, 'Urine Pregnancy', '<p><span style=\"font-size:16px;\"><u><strong>Urine Pregnancy Test</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Urine Pregnancy Test&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:04:23', '2022-04-05 17:24:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (211, 'Urine B J Protein             ', '<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:16px;\"><u>Urine B J Protein&nbsp;</u></span>&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Urine B J Protein&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:05:23', '2022-04-05 17:28:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (212, ' ELECTROPHORESIS', '<p><span style=\"font-size:16px;\"><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></strong><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ELECTROPHORESIS</span></span></strong></u></span></p>\r\n', '2022-03-22 17:06:28', '2022-03-22 17:06:28');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (213, 'ANA PROFILE', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ANA PROFILE</span></span></strong></u></span></p>\r\n', '2022-03-22 17:06:48', '2022-03-22 17:06:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (214, 'SERUM ELECTROLYTES          ', '<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><u>SERUM ELECTROLYTES</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Sodium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 155&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;135 -&nbsp; 155&nbsp; mmol / L&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><font face=\"Times New Roman, serif\"><span style=\"font-size: 16px;\"><b>Potassium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5.5&nbsp;</b></span></font><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.5 -&nbsp; 5.5&nbsp; mmol /&nbsp; L&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Bicarbonate&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;21 - 32 mmol/L&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Chloride&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;107&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;98 - 107 mmol/L&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:10:26', '2022-04-06 12:01:18');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (215, 'Chloride', '<p><span style=\"font-size:16px;\"><u><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Chloride</span></span></b></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Chloride&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;107 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 98 - 107 mmol/L&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:11:37', '2022-04-06 12:07:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (216, 'Urine Albumin', '<p><span style=\"font-size:16px;\"><u><strong>Urine Albumin</strong></u></span></p>\r\n\r\n<p><strong>Urine Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; Nill</strong></p>\r\n', '2022-03-22 17:16:06', '2022-04-06 12:25:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (217, 'Urine Sugar', '<p><span style=\"font-size:16px;\"><strong><u>Urine Sugar</u>&nbsp;</strong></span>&nbsp;</p>\r\n\r\n<p><strong>Urine Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil</strong></p>\r\n', '2022-03-22 17:17:17', '2022-04-06 12:34:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (218, 'MICROSCOPICAL EXAMINATION (Deposit)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">MICROSCOPICAL EXAMINATION (Deposit)</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Amorphous Urates&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:23:10', '2022-04-06 13:02:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (219, 'Urine Bile                    ', '<p><span style=\"font-size:16px;\"><u><strong>Urine Bile</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bile Pigment&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bile salt&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:24:56', '2022-04-06 13:08:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (220, 'THYROID FUNCTION TEST (MALE)', '<p style=\"margin-bottom:14px\"><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">THYROID FUNCTION TEST</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (CLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;180ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 60 - 180 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 60 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 180 ng/dL </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 ( CLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;11.5ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Euthyroid : 5 - 11.5 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Hypothyroid : Below 5.0 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 11.5 ug/dL&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T.S.H(CLIA- ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.0uIU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid:0.4-4.0 uIU/ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Above 4.0uIU/ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Below 0.4 uIU/ml</span></span></span></strong></p>\r\n', '2022-03-22 17:27:31', '2022-04-05 13:06:10');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (221, 'T3(MALE)', '<p><span style=\"font-size:16px;\"><u><strong>T3</strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (ECLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;120&nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 60 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 180 ng/dL </span></span></span></p>\r\n', '2022-03-22 17:30:23', '2022-04-05 12:55:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (222, 'T4 (MALE)', '<p><u><strong><span style=\"font-size:16px;\">T4</span></strong></u><strong><span style=\"font-size:16px;\">&nbsp;</span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 ( ECLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 5 - 11.5 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 5.0 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 11.5 ug/dL</strong>&nbsp; </span></span></span></p>\r\n', '2022-03-22 17:37:22', '2022-04-05 12:50:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (223, 'TSH(MALE)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">T.S.H(MALE)</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T.S.H(ECLIA- ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;uIU/ mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Euthyroid:0.4-4.0 uIU/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Above 4.0uIU/ mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Below 0.4 uIU/ mL</span></span></span></strong></p>\r\n', '2022-03-22 17:38:45', '2022-04-05 12:43:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (224, 'FREE T4(MALE)', '<p><span style=\"font-size:14px;\"><u><strong>FREE T4</strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>Free T4(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.8 - 1.8 ng/ dL&nbsp;&nbsp;</strong>&nbsp; </span></span></span></p>\r\n', '2022-03-22 17:40:48', '2022-04-05 12:36:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (225, 'FREE T3 (MALE)', '<p><u><strong>FREE T3</strong></u></p>\r\n\r\n<p><strong>Free T3 (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.4 - 4.2 pg/mL</strong></p>\r\n\r\n<p><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</strong></p>\r\n', '2022-03-22 17:55:38', '2022-04-05 12:29:17');


#
# TABLE STRUCTURE FOR: lab_test
#

DROP TABLE IF EXISTS `lab_test`;

CREATE TABLE `lab_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `name` varchar(155) NOT NULL,
  `patient_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `production_cost` decimal(18,2) NOT NULL DEFAULT '0.00',
  `test_code` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=477 DEFAULT CHARSET=utf8;

INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (4, 16, 'OPG', '600.00', '500.00', 'OPG', '2022-03-14', 1, '2022-03-14 13:56:20', '2022-03-28 15:22:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (6, 10, 'CONSUMERABLE ITEMS', '50.00', '35.00', 'CONS', '2022-03-14', 1, '2022-03-14 16:00:17', '2022-03-14 16:00:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (8, 9, 'X-RAY LUMBO SACRAL SPINE AP-LAT', '300.00', '250.00', 'LSS', '2022-03-14', 1, '2022-03-14 17:07:27', '2022-04-07 19:08:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (9, 9, 'X-RAY CERVICAL SPINE AP-LAT', '300.00', '250.00', 'CS', '2022-03-14', 1, '2022-03-14 17:07:56', '2022-04-07 19:10:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (10, 9, 'X-RAY THORACIC SPINE AP-LAT', '300.00', '250.00', 'TS', '2022-03-14', 1, '2022-03-14 17:08:30', '2022-04-07 19:10:35');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (11, 9, 'X-RAY PELVIS AP', '250.00', '200.00', 'PEL', '2022-03-14', 1, '2022-03-14 17:09:01', '2022-04-07 19:10:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (12, 9, 'X-RAY CHEST PA', '250.00', '200.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:09:53', '2022-04-07 19:11:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (13, 9, 'X-RAY CHEST PA WITH REPORT', '300.00', '250.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:13:41', '2022-04-07 19:11:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (14, 9, 'X-RAY CHEST AP', '300.00', '250.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:14:06', '2022-04-07 19:11:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (15, 9, 'X-RAY KUB', '250.00', '200.00', 'KUB', '2022-03-14', 1, '2022-03-14 17:17:13', '2022-04-07 19:12:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (16, 9, 'X-RAY KNEE RIGHT AP-LAT', '300.00', '250.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:17:47', '2022-04-07 19:12:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (17, 9, 'X-RAY KNEE LEFT AP-LAT', '300.00', '250.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:18:48', '2022-04-07 19:13:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (18, 9, 'X-RAY KNEE AP-LAT-SUNRISE', '350.00', '300.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:19:24', '2022-04-07 19:13:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (23, 16, 'CEPH', '250.00', '100.00', 'CEPH', '2022-03-15', 1, '2022-03-15 15:49:30', '2022-03-28 15:22:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (24, 24, '5D ANOMALY', '3000.00', '2000.00', '5D', '2022-03-15', 1, '2022-03-15 16:27:25', '2022-05-12 17:41:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (30, 14, 'ECG WITH REPORT', '250.00', '100.00', 'ECG REPORT', '2022-03-16', 1, '2022-03-16 13:27:11', '2022-03-16 13:27:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (31, 23, 'DOPPLER NECK', '1300.00', '500.00', 'DOPP.', '2022-03-16', 1, '2022-03-16 13:29:32', '2022-03-29 09:36:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (33, 7, 'USG NB/NT', '1250.00', '1000.00', 'NB/NT', '2022-03-16', 1, '2022-03-16 13:31:59', '2022-04-27 14:14:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (34, 7, 'USG ABDOMEN PELVIS(F)', '950.00', '400.00', 'ABD/PEL(F)', '2022-03-16', 1, '2022-03-16 13:33:42', '2022-03-16 13:37:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (36, 7, 'USG ABDOMEM(M)', '850.00', '400.00', 'ABD(M)', '2022-03-16', 1, '2022-03-16 13:37:05', '2022-03-16 13:37:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (37, 9, 'OPG...', '650.00', '300.00', 'MEDICITY', '2022-03-16', 1, '2022-03-16 13:41:18', '2022-03-16 13:41:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (40, 15, 'BMD', '2500.00', '1000.00', 'BMD MEDICITY', '2022-03-16', 1, '2022-03-16 13:46:45', '2022-03-16 13:46:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (41, 8, 'CT BRAIN AND LIMITED PNS', '3850.00', '2500.00', 'CT', '2022-03-16', 1, '2022-03-16 13:47:42', '2022-03-17 12:38:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (42, 10, 'CONSUMERABLE 5D', '100.00', '50.00', 'CONS', '2022-03-16', 1, '2022-03-16 17:15:32', '2022-03-16 17:15:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (43, 9, 'X-RAY SKULL AP-LAT', '350.00', '300.00', 'SKL', '2022-03-17', 1, '2022-03-17 13:54:55', '2022-04-07 19:13:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (44, 9, 'X-RAY PNS', '250.00', '200.00', 'PNS', '2022-03-17', 1, '2022-03-17 13:55:23', '2022-04-07 19:14:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (45, 9, 'X-RAY MASTOID', '250.00', '200.00', 'MAST', '2022-03-17', 1, '2022-03-17 13:55:58', '2022-04-07 19:15:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (46, 9, 'X-RAY NASAL BONE LAT', '250.00', '200.00', 'NSL B', '2022-03-17', 1, '2022-03-17 13:56:57', '2022-04-07 19:16:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (47, 9, 'X-RAY ADENOID', '250.00', '200.00', 'ADN', '2022-03-17', 1, '2022-03-17 13:57:32', '2022-04-07 19:16:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (48, 9, 'X-RAY NECK AP-LAT', '300.00', '250.00', 'NECK', '2022-03-17', 1, '2022-03-17 13:58:14', '2022-04-07 19:17:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (49, 9, 'X-RAY NECK LAT', '250.00', '200.00', 'NE', '2022-03-17', 1, '2022-03-17 13:59:06', '2022-04-07 19:18:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (50, 9, 'X-RAY SHOULDER AP', '250.00', '200.00', 'SHLD', '2022-03-17', 1, '2022-03-17 13:59:37', '2022-04-07 19:18:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (51, 9, 'X-RAY SHOULDER AP-LAT', '300.00', '250.00', 'SHLD', '2022-03-17', 1, '2022-03-17 14:00:15', '2022-04-07 19:19:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (52, 9, 'X-RAY SHOULDER AP-AXIAL', '250.00', '200.00', 'SHLD', '2022-03-17', 1, '2022-03-17 14:00:44', '2022-04-07 19:20:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (53, 9, 'X-RAY CLAVICLE AP', '250.00', '200.00', 'CVCL', '2022-03-17', 1, '2022-03-17 14:06:27', '2022-04-07 19:20:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (54, 7, 'USG ABDOMEN PELVIS UNM', '850.00', '500.00', 'UNM', '2022-03-17', 1, '2022-03-17 15:27:52', '2022-03-17 15:27:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (56, 11, 'BLOOD SUGAR FASTING', '30.00', '20.00', 'FB', '2022-03-24', 1, '2022-03-24 09:34:00', '2022-04-13 10:46:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (57, 11, 'BLOOD SUGAR PPBS', '30.00', '20.00', 'PPBS', '2022-03-24', 1, '2022-03-24 09:34:58', '2022-04-13 10:44:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (58, 11, 'BLOOD SUGAR RANDAM', '50.00', '30.00', 'RBS', '2022-03-24', 1, '2022-03-24 09:37:17', '2022-03-24 09:37:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (59, 11, 'BLOOD RE', '200.00', '150.00', 'BRE', '2022-03-24', 1, '2022-03-24 09:37:51', '2022-03-24 09:37:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (60, 11, 'COMPLET BLOOD COUNT', '250.00', '200.00', 'CBC', '2022-03-24', 1, '2022-03-24 09:40:05', '2022-03-24 09:40:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (61, 11, 'HEMO GLOBIN', '40.00', '30.00', 'HB', '2022-03-24', 1, '2022-03-24 09:41:17', '2022-03-24 09:41:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (62, 11, 'ESR', '30.00', '20.00', 'ESR', '2022-03-24', 1, '2022-03-24 09:45:07', '2022-03-24 09:45:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (63, 11, 'LIVER FUNCTION TEST', '400.00', '350.00', 'LFT', '2022-03-24', 1, '2022-03-24 09:45:57', '2022-03-24 09:45:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (64, 11, 'THYROID FUNCTION TEST', '450.00', '400.00', 'TFT', '2022-03-24', 1, '2022-03-24 09:46:38', '2022-03-24 09:46:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (65, 11, 'RENAL FUNCTION TEST', '400.00', '350.00', 'RFT', '2022-03-24', 1, '2022-03-24 09:48:03', '2022-03-24 09:48:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (66, 11, 'LIPID PROFILE', '400.00', '350.00', 'LIPID', '2022-03-24', 1, '2022-03-24 09:51:44', '2022-03-24 09:51:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (67, 11, 'HBA1C', '500.00', '300.00', 'HBA1C', '2022-03-24', 1, '2022-03-24 09:52:20', '2022-03-24 09:52:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (68, 11, 'THYROID ANTIBODIES', '1000.00', '800.00', 'THYROID PROFILE', '2022-03-24', 1, '2022-03-24 09:53:28', '2022-03-24 09:53:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (69, 11, 'UREA', '130.00', '50.00', 'UREA', '2022-03-24', 1, '2022-03-24 09:53:56', '2022-03-24 09:53:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (70, 11, 'CREATINE', '130.00', '100.00', 'CREATINE', '2022-03-24', 1, '2022-03-24 09:54:16', '2022-03-24 09:54:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (71, 11, 'URIC ACID', '130.00', '100.00', 'UA', '2022-03-24', 1, '2022-03-24 09:54:43', '2022-03-24 09:54:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (72, 11, 'PLATELET COUNT', '130.00', '100.00', 'PLATELET', '2022-03-24', 1, '2022-03-24 09:55:30', '2022-03-24 09:55:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (73, 11, 'PSA', '500.00', '300.00', 'PSA', '2022-03-24', 1, '2022-03-24 09:55:47', '2022-03-24 09:55:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (75, 11, 'URINE RE', '120.00', '70.00', 'URINE ROUTINE', '2022-03-24', 1, '2022-03-24 09:57:14', '2022-04-22 13:07:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (76, 11, 'URINE CULTURE', '250.00', '150.00', 'UC', '2022-03-24', 1, '2022-03-24 09:57:35', '2022-04-22 13:11:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (77, 11, 'SGPT', '130.00', '100.00', 'SGPT', '2022-03-24', 1, '2022-03-24 09:57:57', '2022-03-24 09:57:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (78, 11, 'SGOT', '130.00', '100.00', 'SGOT', '2022-03-24', 1, '2022-03-24 09:58:15', '2022-03-24 09:58:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (79, 11, 'CA 125', '990.00', '500.00', 'CA', '2022-03-24', 1, '2022-03-24 09:58:56', '2022-03-24 09:58:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (80, 11, 'BETA 2 GLYCOPROTEIN', '1300.00', '1000.00', 'BETA', '2022-03-24', 1, '2022-03-24 10:00:28', '2022-03-24 10:00:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (81, 11, 'BICARBONATE', '130.00', '120.00', 'BICARBONATE', '2022-03-24', 1, '2022-03-24 10:02:13', '2022-03-24 10:02:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (82, 11, 'BILLRUBINE(T)', '130.00', '120.00', 'BILLRUBINE TOTAL', '2022-03-24', 1, '2022-03-24 10:04:27', '2022-03-24 10:04:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (83, 11, 'BILLRUBIN(D)', '130.00', '120.00', 'BLIIRUBIN DIRECT', '2022-03-24', 1, '2022-03-24 10:05:27', '2022-03-24 10:05:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (84, 11, 'AMH', '1700.00', '1000.00', 'AMH', '2022-03-24', 1, '2022-03-24 10:35:28', '2022-03-24 10:35:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (85, 11, 'BJ PROTEIN', '300.00', '250.00', 'BJP', '2022-03-24', 1, '2022-03-24 10:40:17', '2022-03-24 10:40:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (86, 11, 'BLOOD GROUP &RH TYPE', '100.00', '90.00', 'BLOOD GROUP', '2022-03-24', 1, '2022-03-24 10:42:03', '2022-03-24 10:42:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (87, 11, 'PREGNANCY TEST', '150.00', '100.00', 'PREGNANCY TEST', '2022-03-24', 1, '2022-03-24 10:44:33', '2022-03-24 10:44:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (88, 11, 'PROGESTERONE', '500.00', '450.00', 'PROGESTRONE', '2022-03-24', 1, '2022-03-24 10:45:48', '2022-03-24 10:45:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (89, 11, 'PROJESTRONE 17 OH', '1400.00', '1300.00', 'P 17 OH', '2022-03-24', 1, '2022-03-24 10:47:37', '2022-03-24 10:47:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (90, 11, 'PROLACTIN', '500.00', '450.00', 'PROLACTIN', '2022-03-24', 1, '2022-03-24 10:48:24', '2022-03-24 10:48:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (91, 11, 'PROSTATE SPECIFIC ANTIGEN (PSA)', '500.00', '400.00', 'PSA', '2022-03-24', 1, '2022-03-24 10:50:00', '2022-03-24 10:50:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (92, 11, 'TSH', '200.00', '150.00', 'TSH', '2022-03-24', 1, '2022-03-24 11:18:18', '2022-03-24 11:18:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (93, 11, 'PROSTATIC ACID PROSTATE (PAP)', '200.00', '150.00', 'PAP', '2022-03-24', 1, '2022-03-24 11:19:56', '2022-03-24 11:19:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (94, 11, 'PAPPA', '900.00', '800.00', 'PAPPA', '2022-03-24', 1, '2022-03-24 11:26:00', '2022-03-24 11:26:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (95, 11, 'DS DNA', '1100.00', '1000.00', 'DS DNA', '2022-03-24', 1, '2022-03-24 12:16:34', '2022-03-24 12:16:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (96, 11, 'ELECTROLYTE', '450.00', '400.00', 'ELECTROLYTE', '2022-03-24', 1, '2022-03-24 12:23:12', '2022-03-24 12:23:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (97, 11, 'ELECTROPHORSIS', '600.00', '450.00', 'ELEPH', '2022-03-24', 1, '2022-03-24 12:25:20', '2022-03-24 12:25:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (98, 11, 'ERYTHROPROTIEN(EPO)', '2000.00', '1900.00', 'EPO', '2022-03-24', 1, '2022-03-24 12:27:52', '2022-03-24 12:27:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (99, 11, 'ESTRADIOL', '500.00', '400.00', 'ESTRADIOL', '2022-03-24', 1, '2022-03-24 12:30:10', '2022-03-24 12:30:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (100, 11, 'FREE PSA', '1200.00', '1100.00', 'F PSA', '2022-03-24', 1, '2022-03-24 12:31:43', '2022-03-24 12:31:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (101, 11, 'FREE T3', '180.00', '150.00', 'FREE T3', '2022-03-24', 1, '2022-03-24 12:32:21', '2022-03-24 12:32:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (102, 11, 'FREE T4', '180.00', '170.00', 'FREE T4', '2022-03-24', 1, '2022-03-24 12:32:54', '2022-03-24 12:32:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (103, 11, 'FREE TESTISTRONE', '1800.00', '1700.00', 'F TEST', '2022-03-24', 1, '2022-03-24 12:34:19', '2022-03-24 12:34:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (104, 11, 'FSH', '500.00', '400.00', 'FSH', '2022-03-24', 1, '2022-03-24 12:37:40', '2022-03-24 12:37:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (105, 11, 'FTA ABS', '2350.00', '1250.00', 'FTA', '2022-03-24', 1, '2022-03-24 12:39:20', '2022-03-24 12:39:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (106, 11, 'FTA ABS 1GG', '1250.00', '1200.00', 'FA IGG', '2022-03-24', 1, '2022-03-24 12:40:30', '2022-03-24 12:40:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (107, 11, 'CULTURE FUNGUS', '130.00', '120.00', 'FUNGUS', '2022-03-24', 1, '2022-03-24 12:41:22', '2022-03-24 12:41:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (108, 11, 'G6PD', '550.00', '500.00', 'G6PD', '2022-03-24', 1, '2022-03-24 12:42:14', '2022-03-24 12:42:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (109, 11, 'GAMA GT', '350.00', '300.00', 'GGT', '2022-03-24', 1, '2022-03-24 12:43:40', '2022-03-24 12:43:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (110, 11, 'GCT', '200.00', '150.00', 'GCT', '2022-03-24', 1, '2022-03-24 12:44:17', '2022-03-24 12:44:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (111, 11, 'GLOBULIN', '160.00', '150.00', 'GLOBULIN', '2022-03-24', 1, '2022-03-24 12:46:34', '2022-03-24 12:46:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (112, 11, 'FTI (FREE THYROXINE INDEX)', '300.00', '200.00', 'FTI', '2022-03-24', 1, '2022-03-24 12:50:17', '2022-03-24 12:50:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (113, 11, 'GLUCOESTOLERENT TEST(EXTENDED)', '300.00', '200.00', 'GT', '2022-03-24', 1, '2022-03-24 12:55:34', '2022-03-24 12:55:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (114, 11, 'GLYCATE HB (HBA1C)', '500.00', '400.00', 'GHB', '2022-03-24', 1, '2022-03-24 14:11:50', '2022-03-24 14:11:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (115, 11, 'GRAMSTAIN', '60.00', '40.00', 'GRAMSTAIN', '2022-03-24', 1, '2022-03-24 14:13:06', '2022-03-24 14:13:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (116, 11, 'GRAM STAINING FOR GONOCOCCI', '80.00', '70.00', 'G S G', '2022-03-24', 1, '2022-03-24 14:14:50', '2022-03-24 14:14:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (117, 11, 'GROUP RH TYPING', '100.00', '90.00', 'GROUP', '2022-03-24', 1, '2022-03-24 14:16:28', '2022-03-24 14:16:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (118, 11, 'GROWTH HORMONE', '600.00', '500.00', 'GH', '2022-03-24', 1, '2022-03-24 14:17:09', '2022-03-24 14:17:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (119, 11, 'GTT', '300.00', '200.00', 'GTT', '2022-03-24', 1, '2022-03-24 14:17:39', '2022-03-24 14:17:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (120, 11, 'HPYLORI IGG', '1450.00', '1400.00', 'H IGG', '2022-03-24', 1, '2022-03-24 14:18:54', '2022-03-24 14:18:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (121, 11, 'HPYLORI IGM', '950.00', '900.00', 'H IGM', '2022-03-24', 1, '2022-03-24 14:20:30', '2022-03-24 14:20:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (122, 11, 'HAEMOGLOBIN ELECTROPHO', '800.00', '700.00', 'HB ELECTROPHORISIS', '2022-03-24', 1, '2022-03-24 14:35:14', '2022-03-24 14:35:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (123, 11, 'HAEMOGRAM', '150.00', '100.00', 'HG', '2022-03-24', 1, '2022-03-24 14:46:44', '2022-03-24 14:46:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (124, 11, 'HANGING DROP (VIBRIO CHOLERAC)', '200.00', '190.00', 'HD', '2022-03-24', 1, '2022-03-24 14:49:15', '2022-03-24 14:49:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (125, 11, 'HAV 1GM', '1300.00', '600.00', 'HAV', '2022-03-24', 1, '2022-03-24 14:50:16', '2022-06-18 11:00:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (126, 11, 'HB  ANTIBODY(ANTI HBEG)', '500.00', '400.00', 'HB ANTIBODY', '2022-03-24', 1, '2022-03-24 14:53:43', '2022-03-24 14:53:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (127, 11, 'HBA2', '350.00', '300.00', 'HBA2', '2022-03-24', 1, '2022-03-24 14:56:13', '2022-03-24 14:56:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (128, 11, 'HBC 1GM', '600.00', '500.00', 'HBC', '2022-03-24', 1, '2022-03-24 15:01:42', '2022-03-24 15:01:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (129, 11, 'HB ELECTRO PHORASIS', '1200.00', '1000.00', 'HB E', '2022-03-24', 1, '2022-03-24 15:03:33', '2022-03-24 15:03:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (130, 11, 'HBCAB', '400.00', '300.00', 'HBCAB', '2022-03-24', 1, '2022-03-24 15:06:36', '2022-03-24 15:06:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (131, 11, 'HBEAB', '700.00', '600.00', 'HBE', '2022-03-24', 1, '2022-03-24 15:07:08', '2022-03-24 15:07:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (132, 11, 'HB TITER', '950.00', '900.00', 'HBT', '2022-03-24', 1, '2022-03-24 15:07:48', '2022-03-24 15:07:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (133, 11, 'HBV ANTOBODY', '550.00', '500.00', 'HBV', '2022-03-24', 1, '2022-03-24 15:10:00', '2022-03-24 15:10:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (134, 11, 'HCV//', '600.00', '500.00', 'HCV', '2022-03-24', 1, '2022-03-24 15:10:30', '2022-03-24 15:10:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (135, 11, 'HCV 1 GM', '600.00', '500.00', 'HCV 1 GM', '2022-03-24', 1, '2022-03-24 15:11:02', '2022-03-24 15:11:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (136, 11, 'HDL', '200.00', '150.00', 'HDL', '2022-03-24', 1, '2022-03-24 15:11:30', '2022-03-24 15:11:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (137, 11, 'HDL CHOLESTEROL', '200.00', '150.00', 'HDL', '2022-03-24', 1, '2022-03-24 15:13:08', '2022-03-24 15:13:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (138, 11, 'HIV 1&2', '400.00', '300.00', 'HIV', '2022-03-24', 1, '2022-03-24 15:13:54', '2022-03-24 15:13:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (139, 11, 'HIV ELISA', '400.00', '300.00', 'HIV ELISA', '2022-03-24', 1, '2022-03-24 15:14:32', '2022-03-24 15:14:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (140, 11, 'HLAB27', '2000.00', '1900.00', 'HLA', '2022-03-24', 1, '2022-03-24 15:15:24', '2022-03-24 15:15:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (141, 11, 'HOMOCYSTINURIA', '200.00', '180.00', 'HOMO', '2022-03-24', 1, '2022-03-24 15:16:38', '2022-03-24 15:16:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (142, 11, 'HSV 1&2 IGG & 1GM', '1280.00', '1200.00', 'HSV', '2022-03-24', 1, '2022-03-24 15:17:56', '2022-03-24 15:17:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (143, 11, 'HSV IGG &IGM', '600.00', '500.00', 'HSV', '2022-03-24', 1, '2022-03-24 15:19:47', '2022-03-24 15:19:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (144, 11, 'HZV IGG& IGM', '700.00', '600.00', 'HZV', '2022-03-24', 1, '2022-03-24 15:20:49', '2022-03-24 15:20:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (145, 11, 'IGA', '500.00', '400.00', 'IGA', '2022-03-24', 1, '2022-03-24 15:21:21', '2022-03-24 15:21:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (146, 11, 'IGE', '650.00', '600.00', 'IGE', '2022-03-24', 1, '2022-03-24 15:21:53', '2022-03-24 15:21:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (147, 11, 'IGG', '520.00', '500.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:23:14', '2022-03-24 15:23:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (148, 11, 'IGG HBC', '600.00', '500.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:23:52', '2022-03-24 15:23:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (149, 11, 'IGM', '520.00', '500.00', 'IGM', '2022-03-24', 1, '2022-03-24 15:24:19', '2022-03-24 15:24:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (150, 11, 'IMMUNOGLOBULIN IGE', '400.00', '300.00', 'IG IGE', '2022-03-24', 1, '2022-03-24 15:25:29', '2022-03-24 15:25:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (151, 11, 'IMMUNO PROFILE', '800.00', '700.00', 'IP', '2022-03-24', 1, '2022-03-24 15:26:55', '2022-03-24 15:26:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (152, 11, 'INDIAN INK CRYPTOCOCCI', '100.00', '90.00', 'IIC', '2022-03-24', 1, '2022-03-24 15:27:40', '2022-03-24 15:27:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (153, 11, 'INDIRECT COOMBS TEST(ICT)', '400.00', '300.00', 'ICT', '2022-03-24', 1, '2022-03-24 15:29:02', '2022-03-24 15:29:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (154, 11, 'INSULIN', '500.00', '400.00', 'INSULIN', '2022-03-24', 1, '2022-03-24 15:29:37', '2022-03-24 15:29:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (155, 11, 'KETONE', '70.00', '60.00', 'KT', '2022-03-24', 1, '2022-03-24 15:30:08', '2022-03-24 15:30:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (156, 11, 'LA IGG IGM', '700.00', '600.00', 'LA', '2022-03-24', 1, '2022-03-24 15:30:58', '2022-03-24 15:30:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (157, 11, 'LACATE', '100.00', '90.00', 'LA', '2022-03-24', 1, '2022-03-24 15:31:34', '2022-03-24 15:31:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (158, 11, 'LDH', '250.00', '200.00', 'LDH', '2022-03-24', 1, '2022-03-24 15:33:21', '2022-03-24 15:33:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (159, 11, 'LDL', '250.00', '200.00', 'LDL', '2022-03-24', 1, '2022-03-24 15:33:53', '2022-03-24 15:33:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (160, 11, 'LE CELL', '330.00', '300.00', 'LE', '2022-03-24', 1, '2022-03-24 15:34:36', '2022-03-24 15:34:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (161, 11, 'LACTATE', '600.00', '400.00', 'LACTATE', '2022-03-24', 1, '2022-03-24 15:35:36', '2022-03-24 15:35:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (162, 11, 'LEPTO SPIRAL ANTIBODY IGM ELIS', '900.00', '800.00', 'LEPTO', '2022-03-24', 1, '2022-03-24 15:36:50', '2022-03-24 15:36:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (163, 11, 'LEPTO SPIRAL ANTIBODY IGG', '900.00', '800.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:37:55', '2022-03-24 15:37:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (164, 11, 'LEPTO SPIRAL ANTIBODY IGG..', '900.00', '800.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:38:48', '2022-03-24 15:38:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (165, 11, 'LUPUS ANTICOAGULANT', '450.00', '400.00', 'LUPAS', '2022-03-24', 1, '2022-03-24 15:39:47', '2022-03-24 15:39:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (166, 11, 'LH', '500.00', '400.00', 'LH', '2022-03-24', 1, '2022-03-24 15:40:04', '2022-03-24 15:40:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (167, 11, 'LIPOPROTIN', '500.00', '300.00', 'LIPO', '2022-03-24', 1, '2022-03-24 15:41:11', '2022-03-24 15:41:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (168, 11, 'LIPOPROTIN..', '500.00', '300.00', 'LIPO', '2022-03-24', 1, '2022-03-24 15:41:34', '2022-03-24 15:41:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (169, 11, 'LITHIUM', '250.00', '200.00', 'LITHIYAM', '2022-03-24', 1, '2022-03-24 15:41:56', '2022-03-24 15:41:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (170, 11, 'LUPOUS ANTICOAGULANT(LA)', '500.00', '400.00', 'LA', '2022-03-24', 1, '2022-03-24 15:42:48', '2022-03-24 15:42:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (171, 11, 'LYMES ANTIBODY', '750.00', '700.00', 'LYMES', '2022-03-24', 1, '2022-03-24 15:43:15', '2022-03-24 15:43:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (172, 11, 'MAGNESIUM', '350.00', '300.00', 'MEG', '2022-03-24', 1, '2022-03-24 15:43:42', '2022-03-24 15:43:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (173, 11, 'MALARIAL PARASITE', '200.00', '150.00', 'MALA', '2022-03-24', 1, '2022-03-24 15:44:08', '2022-03-24 15:44:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (174, 11, 'MANTOUX TEST', '150.00', '100.00', 'MANTO', '2022-03-24', 1, '2022-03-24 15:44:31', '2022-03-24 15:44:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (175, 11, 'MCV,PCV,MCH,MCHC', '100.00', '90.00', 'MCV', '2022-03-24', 1, '2022-03-24 15:45:04', '2022-03-24 15:45:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (176, 11, 'METANEPHRINE', '1300.00', '1200.00', 'METAN', '2022-03-24', 1, '2022-03-24 15:45:38', '2022-03-24 15:45:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (177, 11, 'MICRO ALBUMIN', '500.00', '400.00', 'MICRO', '2022-03-24', 1, '2022-03-24 15:46:51', '2022-03-24 15:46:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (178, 11, 'MICRFILERIA', '60.00', '50.00', 'MICRO', '2022-03-24', 1, '2022-03-24 15:47:21', '2022-03-24 15:47:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (179, 11, 'MOTION OCCULT BLOOD', '120.00', '100.00', 'OCCULT MBLOOD', '2022-03-24', 1, '2022-03-24 15:48:24', '2022-03-24 15:48:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (180, 11, 'MOTION RE', '100.00', '90.00', 'REM', '2022-03-24', 1, '2022-03-24 15:49:02', '2022-03-24 15:49:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (181, 11, 'MAYOGLOBIN', '350.00', '300.00', 'MAYO', '2022-03-24', 1, '2022-03-24 15:49:44', '2022-03-24 15:49:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (182, 11, 'NEONATAL BILRUBIN', '60.00', '50.00', 'NEO', '2022-03-24', 1, '2022-03-24 15:50:24', '2022-03-24 15:50:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (183, 11, 'NEUTROPHIL COUNT', '40.00', '30.00', 'COUNT', '2022-03-24', 1, '2022-03-24 15:51:22', '2022-03-24 15:51:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (184, 11, 'OESTROGEN', '600.00', '400.00', 'OES', '2022-03-24', 1, '2022-03-24 15:52:04', '2022-03-24 15:52:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (185, 11, 'OZMOTIC FRAGILITY', '350.00', '300.00', 'OF', '2022-03-24', 1, '2022-03-24 15:53:14', '2022-03-24 15:53:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (186, 11, 'P ANCA', '850.00', '800.00', 'P ANCA', '2022-03-24', 1, '2022-03-24 15:53:46', '2022-03-24 15:53:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (187, 11, 'PAPPA..', '900.00', '800.00', 'PAPPA', '2022-03-24', 1, '2022-03-24 15:54:27', '2022-03-24 15:54:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (188, 11, 'PAPPA TEST', '1500.00', '1400.00', 'PA', '2022-03-24', 1, '2022-03-24 15:54:58', '2022-03-24 15:54:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (189, 11, 'PARA THYROID HORMONEITACT(PTH)', '1000.00', '900.00', 'PTH', '2022-03-24', 1, '2022-03-24 15:57:29', '2022-03-24 15:57:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (190, 11, 'PAUL BUNNEL TEST(IM)', '130.00', '100.00', 'IM', '2022-03-24', 1, '2022-03-24 15:58:54', '2022-03-24 15:58:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (191, 8, 'CT ABDOMEN PLAIN', '4900.00', '4000.00', 'CT A', '2022-03-24', 1, '2022-03-24 16:01:12', '2022-03-24 16:01:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (192, 8, 'CT ANKLE', '4500.00', '4000.00', 'CT A', '2022-03-24', 1, '2022-03-24 16:02:40', '2022-03-24 16:02:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (193, 8, 'CT BRAIN PLAIN', '2350.00', '2000.00', 'CT B', '2022-03-24', 1, '2022-03-24 16:03:38', '2022-03-24 16:03:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (194, 8, 'CT BRAIN AND PNS PLAIN', '4800.00', '4000.00', 'CT BRA P', '2022-03-24', 1, '2022-03-24 16:06:04', '2022-03-24 16:06:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (195, 8, 'CT CERVICAL SPINE', '4750.00', '4000.00', 'CT C', '2022-03-24', 1, '2022-03-24 16:06:58', '2022-03-24 16:06:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (196, 8, 'CT THORAX PLAIN', '4900.00', '4000.00', 'CT T', '2022-03-24', 1, '2022-03-24 16:07:59', '2022-03-24 16:07:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (197, 8, 'CT HRCT PLAIN', '4900.00', '400.00', 'CT H', '2022-03-24', 1, '2022-03-24 16:08:30', '2022-03-24 16:08:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (198, 8, 'CT THORACIC SPINE', '4900.00', '4000.00', 'CT TS', '2022-03-24', 1, '2022-03-24 16:09:30', '2022-03-24 16:09:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (199, 8, 'CT LUMBO SACRAL SPINE', '4750.00', '4000.00', 'CT LS', '2022-03-24', 1, '2022-03-24 16:12:05', '2022-04-08 09:43:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (200, 8, 'CT PELVIS', '4500.00', '4000.00', 'CT PEL', '2022-03-24', 1, '2022-03-24 16:13:15', '2022-03-24 16:13:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (201, 8, 'CT  CLAVICLE', '3500.00', '2500.00', 'CT C', '2022-03-24', 1, '2022-03-24 16:14:27', '2022-03-24 16:14:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (202, 8, 'CT ELBOW JOINT', '3750.00', '2500.00', 'CT EL', '2022-03-24', 1, '2022-03-24 16:15:23', '2022-03-24 16:15:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (203, 8, 'CT SHOULDER  JOINT', '3750.00', '3500.00', 'CT SH', '2022-03-24', 1, '2022-03-24 16:16:56', '2022-03-24 16:16:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (205, 8, 'CT WRIST JOINT', '3750.00', '2500.00', 'CT WR', '2022-03-24', 1, '2022-03-24 16:18:17', '2022-03-24 16:18:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (206, 8, 'CT FACIAL BONE AXIAL & CORONAL', '4500.00', '3500.00', 'CT FB', '2022-03-24', 1, '2022-03-24 16:19:39', '2022-03-24 16:19:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (207, 8, 'CT FINGER', '3250.00', '2500.00', 'CT FR', '2022-03-24', 1, '2022-03-24 16:20:16', '2022-03-24 16:20:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (208, 8, 'CT HAND', '3500.00', '3000.00', 'CT HA', '2022-03-24', 1, '2022-03-24 16:20:56', '2022-03-24 16:20:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (209, 8, 'CT HIP JOINT', '4000.00', '3500.00', 'CT HI', '2022-03-24', 1, '2022-03-24 16:21:47', '2022-03-24 16:21:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (210, 8, 'CT KNEE SINGLE', '3750.00', '3000.00', 'CT KNEE', '2022-03-24', 1, '2022-03-24 16:22:50', '2022-03-24 16:22:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (211, 8, 'CT KNEE  BOTH', '4000.00', '3500.00', 'CT KN', '2022-03-24', 1, '2022-03-24 16:23:38', '2022-03-24 16:23:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (212, 8, 'CT MANDIBLE AXIAL & CORONAL', '4500.00', '3500.00', 'CT MAN', '2022-03-24', 1, '2022-03-24 16:24:44', '2022-03-24 16:24:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (213, 8, 'CT NECK PLAIN', '4900.00', '4000.00', 'CT NE', '2022-03-24', 1, '2022-03-24 16:25:18', '2022-03-24 16:25:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (214, 8, 'CT THYROID PLAIN', '4500.00', '3500.00', 'CT THY', '2022-03-24', 1, '2022-03-24 16:25:47', '2022-03-24 16:25:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (215, 8, 'CT ORBIT AXIAL& CORONAL', '4500.00', '3500.00', 'CT ORB', '2022-03-24', 1, '2022-03-24 16:26:29', '2022-03-24 16:26:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (216, 8, 'CT PNS PLAIN', '2450.00', '2000.00', 'CT PN', '2022-03-24', 1, '2022-03-24 16:27:02', '2022-03-24 16:27:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (217, 8, 'CT PNS PLAIN.', '2450.00', '2000.00', 'CT PN', '2022-03-24', 1, '2022-03-24 16:27:16', '2022-03-24 16:27:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (218, 8, 'CT SACRUM', '3500.00', '3000.00', 'CT SC', '2022-03-24', 1, '2022-03-24 16:27:44', '2022-03-24 16:27:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (220, 8, 'CT SCAPULA', '3500.00', '3000.00', 'CT SCA', '2022-03-24', 1, '2022-03-24 16:28:45', '2022-03-24 16:28:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (221, 8, 'CT SI JOINT', '3500.00', '3000.00', 'CT SI', '2022-03-24', 1, '2022-03-24 16:29:35', '2022-03-24 16:29:35');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (222, 8, 'CT TM JOINT AXIAL &CORONAL', '4000.00', '3000.00', 'CT TM', '2022-03-24', 1, '2022-03-24 16:30:21', '2022-03-24 16:30:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (223, 8, 'CT HRCT TEMPRAL BONE', '4000.00', '3500.00', 'CT HR', '2022-03-24', 1, '2022-03-24 16:31:05', '2022-03-24 16:31:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (224, 8, 'CT FOOT', '3750.00', '3000.00', 'CT FOO', '2022-03-24', 1, '2022-03-24 16:32:49', '2022-03-24 16:32:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (225, 8, 'CT LEG SINGLE', '4500.00', '3500.00', 'CT LE', '2022-03-24', 1, '2022-03-24 16:33:51', '2022-03-24 16:33:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (226, 8, 'CT FEMOUR', '4500.00', '3500.00', 'CT FE', '2022-03-24', 1, '2022-03-24 16:34:39', '2022-03-24 16:34:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (228, 8, 'CT FOREARM', '3750.00', '3500.00', 'CT FO', '2022-03-24', 1, '2022-03-24 16:36:02', '2022-03-24 16:36:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (229, 8, 'CT ARM', '3750.00', '3500.00', 'CT AR', '2022-03-24', 1, '2022-03-24 16:36:43', '2022-03-24 16:36:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (230, 8, 'CT DORASL SPINE', '4750.00', '4000.00', 'CT DOR', '2022-03-24', 1, '2022-03-24 16:43:20', '2022-03-24 16:43:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (231, 8, 'CT NASOPHARYNX', '3750.00', '3000.00', 'CT NS', '2022-03-24', 1, '2022-03-24 16:45:47', '2022-03-24 16:45:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (232, 8, 'CT FACIAL BONE 3D', '4750.00', '4000.00', 'CT F3D', '2022-03-24', 1, '2022-03-24 16:47:01', '2022-03-24 16:47:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (233, 8, 'CT CARPAL BONE', '3750.00', '3000.00', 'CT CAR', '2022-03-24', 1, '2022-03-24 16:48:07', '2022-03-24 16:48:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (234, 8, 'CT TOE', '2750.00', '2500.00', 'CT TOE', '2022-03-24', 1, '2022-03-24 16:49:58', '2022-03-24 16:49:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (235, 8, 'CT CALCANEUM', '3750.00', '3500.00', 'CT CAL', '2022-03-24', 1, '2022-03-24 16:51:59', '2022-03-24 16:51:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (236, 8, 'CT PAROTID GLAND', '4500.00', '3500.00', 'CT PARO', '2022-03-24', 1, '2022-03-24 16:52:54', '2022-03-24 16:52:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (237, 8, 'CT KUB PLAIN', '4900.00', '4000.00', 'CT KUB', '2022-03-24', 1, '2022-03-24 16:58:03', '2022-03-24 16:58:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (238, 11, 'MICROFILARIA', '60.00', '50.00', 'MF', '2022-03-25', 1, '2022-03-25 09:03:46', '2022-03-25 09:03:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (239, 11, 'PH', '30.00', '20.00', 'PH', '2022-03-25', 1, '2022-03-25 09:06:30', '2022-03-25 09:06:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (240, 11, 'PHENO BARBITONE', '400.00', '350.00', 'PB', '2022-03-25', 1, '2022-03-25 09:07:29', '2022-03-25 09:07:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (241, 11, 'PHOSPHOROUS', '130.00', '120.00', 'PP', '2022-03-25', 1, '2022-03-25 09:08:59', '2022-03-25 09:08:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (242, 11, 'PLASMA PROGESTRONE', '400.00', '300.00', 'PRG', '2022-03-25', 1, '2022-03-25 09:10:20', '2022-03-25 09:10:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (243, 11, 'PULERLE FLUID', '450.00', '400.00', 'PF', '2022-03-25', 1, '2022-03-25 09:17:52', '2022-03-25 09:17:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (244, 11, 'PLEURAL MICRO', '30.00', '20.00', 'PM', '2022-03-25', 1, '2022-03-25 09:18:36', '2022-03-25 09:18:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (245, 11, 'PLEURAL PROTEIN', '60.00', '50.00', 'PPROTEIN', '2022-03-25', 1, '2022-03-25 09:20:04', '2022-03-25 09:20:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (246, 11, 'PLEURAL SUGAR', '30.00', '20.00', 'PS', '2022-03-25', 1, '2022-03-25 09:21:05', '2022-03-25 09:21:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (247, 11, 'QUADRIPLET TEST', '3850.00', '3000.00', 'QT', '2022-03-25', 1, '2022-03-25 09:21:46', '2022-03-25 09:21:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (248, 11, 'RA TEST', '400.00', '300.00', 'RT', '2022-03-25', 1, '2022-03-25 09:22:25', '2022-03-25 09:22:25');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (249, 11, 'RBC COUNT', '40.00', '30.00', 'RC', '2022-03-25', 1, '2022-03-25 09:23:06', '2022-03-25 09:23:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (250, 11, 'RUBELLA IGG', '500.00', '450.00', 'R IGG', '2022-03-25', 1, '2022-03-25 10:55:55', '2022-03-25 10:55:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (251, 11, 'RUBELLA IGM', '500.00', '400.00', 'R IGM', '2022-03-25', 1, '2022-03-25 10:56:41', '2022-03-25 10:56:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (252, 11, 'RUBELLA IGG & IGM', '500.00', '450.00', 'R IGG&IGM', '2022-03-25', 1, '2022-03-25 10:57:26', '2022-03-25 10:57:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (253, 11, 'LAB', '0.00', '0.00', '0 BILL', '2022-03-25', 1, '2022-03-25 11:05:29', '2022-03-25 11:05:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (254, 11, 'SERUM IRON', '450.00', '250.00', 'SI', '2022-03-25', 1, '2022-03-25 11:15:44', '2022-05-05 11:23:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (255, 11, 'SCALP VEIN', '20.00', '10.00', 'SV', '2022-03-25', 1, '2022-03-25 11:16:36', '2022-03-25 11:16:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (256, 11, 'SEL.70', '1500.00', '1300.00', 'S 70', '2022-03-25', 1, '2022-03-25 11:17:26', '2022-03-25 11:17:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (257, 11, 'SEMEN ANALYSIS', '250.00', '200.00', 'SA', '2022-03-25', 1, '2022-03-25 11:19:02', '2022-03-25 11:19:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (258, 11, 'SERUM PHOSPHORUS', '130.00', '120.00', 'SP', '2022-03-25', 1, '2022-03-25 11:20:17', '2022-03-25 11:20:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (259, 11, 'SERUM ALBUMIN', '160.00', '100.00', 'SA', '2022-03-25', 1, '2022-03-25 11:20:50', '2022-03-25 11:20:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (260, 11, 'SERUM FERTIN', '750.00', '650.00', 'SF', '2022-03-25', 1, '2022-03-25 11:21:47', '2022-04-16 12:04:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (261, 11, 'SERUM FOLATE', '1200.00', '1000.00', 'SF', '2022-03-25', 1, '2022-03-25 11:22:43', '2022-03-25 11:22:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (262, 11, 'SERUM PROTEINE', '160.00', '150.00', 'SP', '2022-03-25', 1, '2022-03-25 11:23:29', '2022-03-25 11:23:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (263, 11, 'SERUM ACE', '850.00', '800.00', 'ACE', '2022-03-25', 1, '2022-03-25 11:24:09', '2022-03-25 11:24:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (264, 11, 'SERUM AMALYIS', '300.00', '250.00', 'SA', '2022-03-25', 1, '2022-03-25 11:25:34', '2022-03-25 11:25:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (265, 11, 'SERUM ANTROGEN', '1850.00', '1800.00', 'SA', '2022-03-25', 1, '2022-03-25 11:26:41', '2022-03-25 11:26:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (266, 11, 'SERUM CALCIUM', '160.00', '140.00', 'SC', '2022-03-25', 1, '2022-03-25 11:27:20', '2022-03-25 11:27:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (267, 11, 'SERUM CHOLESTEROL', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:28:10', '2022-03-25 11:28:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (268, 11, 'SERUM COPPER', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:29:33', '2022-03-25 11:29:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (269, 11, 'SERUM COPPER ..', '2100.00', '1800.00', 'SC', '2022-03-25', 1, '2022-03-25 11:32:27', '2022-04-04 10:58:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (271, 11, 'SERUM CORTISOL', '500.00', '400.00', 'SC', '2022-03-25', 1, '2022-03-25 11:34:02', '2022-03-25 11:34:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (272, 11, 'SERUM CREATININE', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:36:01', '2022-03-25 11:36:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (273, 11, 'SERUM GONADO TROPY', '700.00', '400.00', 'SGT', '2022-03-25', 1, '2022-03-25 11:37:04', '2022-03-25 11:37:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (274, 11, 'SERUM IGE', '650.00', '500.00', 'S IGE', '2022-03-25', 1, '2022-03-25 11:37:37', '2022-03-25 12:34:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (276, 11, 'SERUM  LIPAISE', '400.00', '300.00', 'SL', '2022-03-25', 1, '2022-03-25 11:40:05', '2022-03-25 11:40:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (277, 11, 'SERUM MAYOGLOBIN', '400.00', '300.00', 'SM', '2022-03-25', 1, '2022-03-25 11:40:45', '2022-03-25 11:40:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (278, 11, 'SERUM VITAMIN B12', '650.00', '600.00', 'S VB12', '2022-03-25', 1, '2022-03-25 11:42:46', '2022-03-25 11:42:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (279, 11, 'SERUM ZINC', '1900.00', '1800.00', 'S Z', '2022-03-25', 1, '2022-03-25 11:43:55', '2022-03-25 11:43:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (280, 11, 'SPUTUM A F P', '250.00', '200.00', 'S AFP', '2022-03-25', 1, '2022-03-25 11:45:29', '2022-03-25 11:45:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (281, 11, 'SPUTUM AFP 3 DAYS', '600.00', '500.00', 'S AFP 3 DAYS', '2022-03-25', 1, '2022-03-25 11:47:15', '2022-03-25 11:47:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (282, 11, 'T3', '160.00', '150.00', 'T3', '2022-03-25', 1, '2022-03-25 11:47:44', '2022-03-25 11:47:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (283, 11, 'T4', '160.00', '150.00', 'T4', '2022-03-25', 1, '2022-03-25 11:48:11', '2022-03-25 11:48:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (284, 11, 'TB IGA', '350.00', '300.00', 'TB IGA', '2022-03-25', 1, '2022-03-25 11:49:11', '2022-03-25 11:49:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (285, 11, 'TB IGA IGG IGM', '1100.00', '1000.00', 'TIII', '2022-03-25', 1, '2022-03-25 11:50:29', '2022-03-25 11:50:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (286, 11, 'TB IGG', '350.00', '240.00', 'TB IGG', '2022-03-25', 1, '2022-03-25 11:52:30', '2022-03-25 12:34:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (287, 11, 'TB IGM', '500.00', '300.00', 'TBI', '2022-03-25', 1, '2022-03-25 11:54:16', '2022-03-25 11:54:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (288, 11, 'TC', '40.00', '30.00', 'TC', '2022-03-25', 1, '2022-03-25 11:55:00', '2022-03-25 11:55:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (289, 11, 'TC,DC,HB', '120.00', '110.00', 'TDH', '2022-03-25', 1, '2022-03-25 11:56:42', '2022-03-25 11:56:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (290, 11, 'TIBC', '300.00', '200.00', 'TIBC', '2022-03-25', 1, '2022-03-25 11:57:28', '2022-03-25 11:57:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (291, 11, 'TORCH IGB IGM', '2500.00', '2400.00', 'T II', '2022-03-25', 1, '2022-03-25 12:00:44', '2022-03-25 12:00:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (292, 11, 'TROCH IGM', '1200.00', '1100.00', 'TI', '2022-03-25', 1, '2022-03-25 12:01:26', '2022-03-25 12:01:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (293, 11, 'TORCH SCREENING', '2200.00', '2100.00', 'TS', '2022-03-25', 1, '2022-03-25 12:02:31', '2022-03-25 12:02:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (294, 11, 'TORCH TEST IGB IGM', '2050.00', '2000.00', 'T T I I', '2022-03-25', 1, '2022-03-25 12:03:57', '2022-03-25 12:03:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (295, 11, 'TORCH IGG', '750.00', '700.00', 'TI', '2022-03-25', 1, '2022-03-25 12:04:34', '2022-03-25 12:04:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (296, 11, 'TOTAL IRON BINDING CAPACITY', '300.00', '200.00', 'TI', '2022-03-25', 1, '2022-03-25 12:05:56', '2022-03-25 12:05:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (297, 11, 'TOTAL PROTEIN', '160.00', '150.00', 'TP', '2022-03-25', 1, '2022-03-25 12:06:43', '2022-03-25 12:06:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (298, 11, 'TOTAL PROTEINS (AIB,GLB)', '160.00', '150.00', 'TP', '2022-03-25', 1, '2022-03-25 12:07:53', '2022-03-25 12:07:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (299, 11, 'TOTAL TESTISTRONE', '400.00', '300.00', 'TT', '2022-03-25', 1, '2022-03-25 12:08:53', '2022-03-25 12:08:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (300, 11, 'TOXOPLASMA IGG', '450.00', '400.00', 'TI', '2022-03-25', 1, '2022-03-25 12:10:41', '2022-03-25 12:10:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (301, 11, 'TOXOPLASMA IGM', '500.00', '450.00', 'TP', '2022-03-25', 1, '2022-03-25 12:11:36', '2022-03-25 12:11:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (302, 11, 'TPHA', '700.00', '600.00', 'TPHA', '2022-03-25', 1, '2022-03-25 12:12:16', '2022-03-25 12:12:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (303, 11, 'TPO', '450.00', '400.00', 'TPO', '2022-03-25', 1, '2022-03-25 12:13:57', '2022-03-25 12:13:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (304, 11, 'TPSH', '350.00', '300.00', 'TPSH', '2022-03-25', 1, '2022-03-25 12:14:26', '2022-03-25 12:14:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (305, 11, 'TRAN FERIN FLARATION', '800.00', '700.00', 'TF', '2022-03-25', 1, '2022-03-25 12:16:20', '2022-03-25 12:16:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (306, 11, 'TRIGLYCERIDES', '200.00', '150.00', 'T', '2022-03-25', 1, '2022-03-25 12:18:14', '2022-03-25 12:18:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (307, 11, 'TRIPPIL TEST', '2100.00', '2000.00', 'TT', '2022-03-25', 1, '2022-03-25 12:19:01', '2022-03-25 12:19:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (308, 11, 'TROP I', '950.00', '900.00', 'TROP I', '2022-03-25', 1, '2022-03-25 12:19:49', '2022-03-25 12:19:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (309, 11, 'TROPINE I', '1300.00', '1200.00', 'TROPINE I', '2022-03-25', 1, '2022-03-25 12:24:58', '2022-03-25 12:24:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (310, 11, 'TROPINE T', '850.00', '800.00', 'TT', '2022-03-25', 1, '2022-03-25 12:25:45', '2022-03-25 12:25:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (311, 11, 'URINE VMA', '1300.00', '1200.00', 'URINE VMA', '2022-03-25', 1, '2022-03-25 12:28:13', '2022-03-25 12:28:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (312, 11, 'URINE AFB', '80.00', '70.00', 'UA', '2022-03-25', 1, '2022-03-25 12:28:50', '2022-03-25 12:28:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (313, 11, 'URINE ACETONE', '50.00', '40.00', 'UA', '2022-03-25', 1, '2022-03-25 12:29:59', '2022-03-25 12:29:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (314, 11, 'URINE ALBUMIN', '70.00', '60.00', 'UA', '2022-03-25', 1, '2022-03-25 12:30:42', '2022-03-25 12:30:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (315, 11, 'URINE BJ PROTEIN', '250.00', '200.00', 'U BJ P', '2022-03-25', 1, '2022-03-25 12:33:33', '2022-03-25 12:33:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (316, 11, 'URINE BP & BS', '50.00', '40.00', 'U BP BS', '2022-03-25', 1, '2022-03-25 12:37:19', '2022-03-25 12:37:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (317, 11, 'URINE COMPLETE', '40.00', '30.00', 'UC', '2022-03-25', 1, '2022-03-25 12:37:56', '2022-03-25 12:37:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (318, 11, 'URINE DEPOSIT', '30.00', '20.00', 'UD', '2022-03-25', 1, '2022-03-25 12:38:41', '2022-03-25 12:38:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (319, 11, 'URINE GC', '70.00', '60.00', 'U GC', '2022-03-25', 1, '2022-03-25 12:39:14', '2022-03-25 12:39:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (320, 11, 'URINE MICROSCOPY', '30.00', '20.00', 'UM', '2022-03-25', 1, '2022-03-25 12:39:57', '2022-03-25 12:39:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (321, 11, 'URINE PC RATIO', '400.00', '300.00', 'UPR', '2022-03-25', 1, '2022-03-25 12:40:36', '2022-03-25 12:40:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (322, 11, 'URINE PROTEIN', '140.00', '120.00', 'UP', '2022-03-25', 1, '2022-03-25 12:42:06', '2022-03-25 12:42:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (323, 11, 'URINE PROTEIN 24 HRS', '2250.00', '2150.00', 'UP', '2022-03-25', 1, '2022-03-25 12:43:12', '2022-04-16 12:05:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (324, 11, 'URINE PROTEIN CREATINE RATIO', '400.00', '300.00', 'UPCR', '2022-03-25', 1, '2022-03-25 12:44:32', '2022-03-25 12:44:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (325, 11, 'ABSOLUTE ESINOPHIL COUNT', '140.00', '130.00', 'AEC', '2022-03-25', 1, '2022-03-25 12:46:59', '2022-03-25 12:46:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (326, 11, 'ACA,IGG,IGM', '1400.00', '1000.00', 'ACA', '2022-03-25', 1, '2022-03-25 12:47:54', '2022-03-25 12:47:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (327, 11, 'ACA&IGM', '950.00', '900.00', 'ACA', '2022-03-25', 1, '2022-03-25 12:48:39', '2022-03-25 12:48:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (328, 11, 'ACA IGG', '950.00', '900.00', 'AI', '2022-03-25', 1, '2022-03-25 12:49:21', '2022-03-25 12:49:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (329, 11, 'ACCP', '1200.00', '1100.00', 'ACCP', '2022-03-25', 1, '2022-03-25 12:49:50', '2022-03-25 12:49:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (330, 11, 'ACE', '800.00', '700.00', 'ACE', '2022-03-25', 1, '2022-03-25 12:51:51', '2022-03-25 12:51:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (331, 11, 'ACETAMINOPHAN/PARACETAMOL', '1500.00', '1000.00', 'AP', '2022-03-25', 1, '2022-03-25 12:57:50', '2022-03-25 12:57:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (332, 11, 'ACID PHOSPHATUSE', '180.00', '170.00', 'AP', '2022-03-25', 1, '2022-03-25 12:59:13', '2022-03-25 12:59:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (333, 11, 'ACID PHOSPATUSE (PROSTATIC)', '300.00', '200.00', 'ACID PP', '2022-03-25', 1, '2022-03-25 13:00:34', '2022-03-25 13:00:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (334, 11, 'ACTH', '1200.00', '1100.00', 'ACTH', '2022-03-25', 1, '2022-03-25 13:01:14', '2022-03-25 13:01:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (335, 11, 'ADA (ADENOSINE DEAMINASE)', '550.00', '400.00', 'ADA', '2022-03-25', 1, '2022-03-25 13:02:38', '2022-03-25 13:02:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (336, 11, 'AFB C&S', '1000.00', '900.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:03:28', '2022-03-25 13:03:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (337, 11, 'AFB SPUTUM (CONCENTRATION)', '150.00', '120.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:04:49', '2022-03-25 13:04:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (338, 11, 'AFB PCR', '2500.00', '2000.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:05:46', '2022-03-25 13:05:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (339, 11, 'AFP', '750.00', '700.00', 'AFP', '2022-03-25', 1, '2022-03-25 13:06:12', '2022-03-25 13:06:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (340, 11, 'ALBUMIN', '70.00', '60.00', 'ALBUMIN', '2022-03-25', 1, '2022-03-25 13:06:55', '2022-03-25 13:06:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (341, 11, 'ALDOSTERONE', '1000.00', '900.00', 'ALD', '2022-03-25', 1, '2022-03-25 13:07:44', '2022-03-25 13:07:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (342, 11, 'ALKALINE PHOSPHATASE', '200.00', '100.00', 'AP', '2022-03-25', 1, '2022-03-25 13:08:44', '2022-03-25 13:08:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (343, 11, 'ALPHA FETA PROTIEN', '750.00', '700.00', 'AFP', '2022-03-25', 1, '2022-03-25 13:09:45', '2022-03-25 13:09:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (344, 11, 'AMALYSE', '500.00', '400.00', 'AMLYSE', '2022-03-25', 1, '2022-03-25 13:10:14', '2022-03-25 13:10:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (345, 11, 'AMINI ACIDS QUANTITATIVE', '6200.00', '6000.00', 'AAQ', '2022-03-25', 1, '2022-03-25 13:12:26', '2022-03-25 13:12:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (346, 11, 'AMONIA', '700.00', '600.00', 'AMONIA', '2022-03-25', 1, '2022-03-25 13:12:56', '2022-03-25 13:12:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (347, 11, 'ANA', '1000.00', '900.00', 'ANA', '2022-03-25', 1, '2022-03-25 13:13:20', '2022-03-25 13:13:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (348, 11, 'ANA PROFILE', '4950.00', '4000.00', 'ANAP', '2022-03-25', 1, '2022-03-25 13:14:01', '2022-03-25 13:14:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (349, 11, 'ANCA', '1590.00', '1500.00', 'ANCA', '2022-03-25', 1, '2022-03-25 13:14:56', '2022-03-25 13:14:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (350, 11, 'ANDROGEN PROFILE', '3880.00', '3000.00', 'AP', '2022-03-25', 1, '2022-03-25 13:15:51', '2022-03-25 13:15:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (351, 11, 'ANTI CARDIOLIPINE', '1200.00', '1100.00', 'ACL', '2022-03-25', 1, '2022-03-25 13:59:23', '2022-03-25 13:59:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (352, 11, 'ANTIGEN', '600.00', '500.00', 'AN', '2022-03-25', 1, '2022-03-25 14:05:08', '2022-03-25 14:05:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (353, 11, 'ANTIHERPEX 1&2', '1300.00', '1200.00', 'AN 1&2', '2022-03-25', 1, '2022-03-25 14:07:27', '2022-03-25 14:07:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (354, 11, 'ANTIPHOSPHO LIPID', '950.00', '850.00', 'AL', '2022-03-25', 1, '2022-03-25 14:09:04', '2022-03-25 14:09:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (355, 11, 'ANTISERUM ANTIBODY', '750.00', '650.00', 'AA', '2022-03-25', 1, '2022-03-25 14:10:10', '2022-03-25 14:10:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (356, 11, 'APLA', '1610.00', '1510.00', 'APLA', '2022-03-25', 1, '2022-03-25 14:11:07', '2022-03-25 14:11:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (357, 11, 'APTT', '250.00', '150.00', 'APTT', '2022-03-25', 1, '2022-03-25 14:12:12', '2022-03-25 14:12:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (358, 11, 'ASO TITRE', '400.00', '300.00', 'AT', '2022-03-25', 1, '2022-03-25 14:13:41', '2022-03-25 14:13:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (359, 11, 'B2 GLYCOPROTEIN IGG IGGM', '1800.00', '1700.00', 'B2G', '2022-03-25', 1, '2022-03-25 14:16:37', '2022-03-25 14:16:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (360, 11, 'CA-15', '1050.00', '950.00', 'CA', '2022-03-25', 1, '2022-03-25 14:35:10', '2022-03-25 14:35:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (361, 11, 'CALCITONIM', '1350.00', '1250.00', 'CAL', '2022-03-25', 1, '2022-03-25 14:35:55', '2022-03-25 14:35:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (362, 11, 'CALCIUM', '160.00', '150.00', 'CAL', '2022-03-25', 1, '2022-03-25 14:36:30', '2022-03-25 14:36:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (363, 11, 'CARBAMAPZINE', '450.00', '440.00', 'CAR', '2022-03-25', 1, '2022-03-25 14:38:01', '2022-03-25 14:38:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (364, 11, 'CARDIOLIPIN AB IGG', '500.00', '480.00', 'CARD', '2022-03-25', 1, '2022-03-25 14:39:18', '2022-03-25 14:39:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (365, 11, 'CARDIOLIPIN AB IGM', '500.00', '480.00', 'CARD', '2022-03-25', 1, '2022-03-25 14:40:22', '2022-03-25 14:40:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (366, 11, 'CEA', '580.00', '550.00', 'CE', '2022-03-25', 1, '2022-03-25 14:40:56', '2022-03-25 14:40:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (368, 11, 'CERUOPLASMIN', '1200.00', '1100.00', 'CP', '2022-03-25', 1, '2022-03-25 14:55:44', '2022-03-25 14:55:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (369, 11, 'CERVICAL SMEAR', '200.00', '100.00', 'CS', '2022-03-25', 1, '2022-03-25 15:00:34', '2022-03-25 15:00:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (370, 11, 'CHLAMYDIAL AB IGG', '700.00', '600.00', 'CA', '2022-03-25', 1, '2022-03-25 15:01:40', '2022-03-25 15:01:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (371, 11, 'CHLORIDE', '120.00', '110.00', 'CH', '2022-03-25', 1, '2022-03-25 15:11:54', '2022-03-25 15:11:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (372, 11, 'CHLAMYDIAL IGM', '700.00', '600.00', 'CH, IGM', '2022-03-25', 1, '2022-03-25 15:13:43', '2022-03-25 15:13:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (373, 11, 'CK-MB(CL)', '200.00', '100.00', 'CK', '2022-03-25', 1, '2022-03-25 15:17:14', '2022-03-25 15:17:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (374, 11, 'CHOLINESTERASE', '350.00', '250.00', 'CHOL', '2022-03-25', 1, '2022-03-25 15:29:06', '2022-03-25 15:29:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (375, 11, 'CHROMOSOMAL ANTIBODY', '2250.00', '2150.00', 'CHR AN', '2022-03-25', 1, '2022-03-25 15:30:32', '2022-03-25 15:30:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (376, 11, 'CHROMOSOMAL STUDY', '2750.00', '2650.00', 'CHR ST', '2022-03-25', 1, '2022-03-25 15:31:29', '2022-03-25 15:31:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (377, 11, 'CK-MB(ENZYMATIC)', '200.00', '100.00', 'CK-EN', '2022-03-25', 1, '2022-03-25 15:32:33', '2022-03-25 15:32:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (378, 11, 'CK(CPK)', '280.00', '270.00', 'CK (C)', '2022-03-25', 1, '2022-03-25 15:33:41', '2022-03-25 15:33:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (379, 11, 'BETA-HCG', '600.00', '500.00', 'B-H', '2022-03-25', 1, '2022-03-25 15:36:06', '2022-03-28 14:17:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (380, 11, 'BRUCELLA AGGLUTINATION', '850.00', '750.00', 'BA', '2022-03-25', 1, '2022-03-25 15:39:07', '2022-03-25 15:39:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (381, 11, 'BRUCELLA IGG', '840.00', '740.00', 'B I', '2022-03-25', 1, '2022-03-25 15:40:34', '2022-03-25 15:40:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (382, 11, 'BRUCELLA IGM', '800.00', '700.00', 'BR IGM', '2022-03-25', 1, '2022-03-25 15:41:32', '2022-03-25 15:41:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (383, 11, 'BSL-13', '1350.00', '1250.00', 'BSL', '2022-03-25', 1, '2022-03-25 15:42:23', '2022-03-25 15:42:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (384, 11, 'BT&CT', '80.00', '70.00', 'BT- CT', '2022-03-25', 1, '2022-03-25 15:43:04', '2022-03-25 15:43:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (385, 11, 'CA 15.3', '1500.00', '1400.00', 'CA.15.3', '2022-03-25', 1, '2022-03-25 15:44:42', '2022-03-25 15:44:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (386, 11, 'C ANCA', '1350.00', '1250.00', 'C ANCA', '2022-03-25', 1, '2022-03-25 15:46:13', '2022-03-25 15:46:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (387, 11, 'CPK', '280.00', '180.00', 'CPK', '2022-03-25', 1, '2022-03-25 15:47:15', '2022-03-25 15:47:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (388, 11, 'C PEPTIDE', '1450.00', '1350.00', 'C P', '2022-03-25', 1, '2022-03-25 15:48:48', '2022-03-25 15:48:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (389, 11, 'C-REACTIVE PROTEIN', '300.00', '400.00', 'C-R P', '2022-03-25', 1, '2022-03-25 15:50:23', '2022-03-25 15:50:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (390, 11, 'CA 19.9', '1050.00', '950.00', 'CA 19.9', '2022-03-25', 1, '2022-03-25 15:53:14', '2022-03-25 15:53:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (391, 14, 'ECG', '200.00', '150.00', 'ECG', '2022-03-26', 1, '2022-03-26 09:23:43', '2022-03-26 09:23:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (392, 15, 'BONE MINERAL DENSITY', '2300.00', '2000.00', 'BMD', '2022-03-26', 1, '2022-03-26 12:39:16', '2022-03-26 12:39:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (393, 8, 'CT CHEST', '4900.00', '0.00', 'CT', '2022-03-26', 1, '2022-03-26 13:58:41', '2022-03-26 14:02:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (394, 9, 'XRAY', '250.00', '250.00', 'XX', '2022-03-26', 1, '2022-03-26 14:19:24', '2022-03-26 14:19:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (395, 7, 'USG OBG', '850.00', '300.00', 'OBG', '2022-03-26', 1, '2022-03-26 15:11:23', '2022-03-26 15:11:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (397, 25, '5D FOLLOW UP', '1000.00', '1000.00', '5DF', '2022-03-26', 1, '2022-03-26 15:28:59', '2022-05-12 17:43:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (398, 23, 'DOPPLER OBG', '1300.00', '1300.00', 'OBG', '2022-03-26', 1, '2022-03-26 15:46:04', '2022-03-29 09:37:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (399, 17, 'SONOMAMMOGRAM(SINGLE)', '1300.00', '600.00', 'SONO', '2022-03-26', 1, '2022-03-26 16:32:31', '2022-04-27 11:17:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (400, 17, 'SONOMAMMOGRAM(BOTH)', '2500.00', '1000.00', 'SONO', '2022-03-26', 1, '2022-03-26 16:34:46', '2022-04-27 11:20:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (401, 13, 'EEG', '1500.00', '1000.00', 'EEG', '2022-03-26', 1, '2022-03-26 17:42:28', '2022-03-26 17:42:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (402, 12, 'NCV', '1750.00', '1000.00', 'NCV', '2022-03-26', 1, '2022-03-26 17:43:10', '2022-03-26 17:43:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (403, 20, 'TMT', '1850.00', '1000.00', 'TMT', '2022-03-26', 1, '2022-03-26 17:44:19', '2022-03-29 09:33:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (404, 22, 'ECHO', '1650.00', '1000.00', 'ECHO', '2022-03-26', 1, '2022-03-26 17:47:18', '2022-03-26 17:47:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (405, 19, 'HSG', '2100.00', '1500.00', 'HSG', '2022-03-26', 1, '2022-03-26 17:48:04', '2022-03-26 17:48:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (406, 23, 'DOPPLER THYROID', '1100.00', '1000.00', 'DOP THY', '2022-03-28', 1, '2022-03-28 09:11:52', '2022-03-29 09:38:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (407, 23, 'DOPPLER LOWER LIMB(BOTH)', '3000.00', '1200.00', 'DOP LIMB', '2022-03-28', 1, '2022-03-28 09:14:46', '2022-03-29 09:38:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (408, 23, 'DOPPLER CAROTID(EYE)', '1850.00', '1000.00', 'DOP CAROTID EYE', '2022-03-28', 1, '2022-03-28 09:17:10', '2022-04-23 13:31:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (409, 23, 'DOPPLER PAROTID(EYE)', '1300.00', '1000.00', 'DOP PAROTID EYE', '2022-03-28', 1, '2022-03-28 09:21:11', '2022-04-23 13:31:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (410, 7, 'FOLLICULAR STUDY', '1500.00', '1000.00', 'FOLLICULAR', '2022-03-28', 1, '2022-03-28 09:26:54', '2022-04-14 10:42:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (411, 23, 'DOPPLER SCROTUM', '1300.00', '1000.00', 'DOP SCROTUM', '2022-03-28', 1, '2022-03-28 09:33:05', '2022-03-29 09:39:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (412, 7, 'ANOMALY SCAN', '1300.00', '1000.00', 'ANOMALY', '2022-03-28', 1, '2022-03-28 09:34:28', '2022-03-28 09:34:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (413, 23, 'DOPPLER UPPER LIMB(BOTH)', '3000.00', '2000.00', 'DOPPLER U LIMB', '2022-03-28', 1, '2022-03-28 09:42:13', '2022-05-12 17:37:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (414, 23, 'DOPPLER UPPER LIMB (SINGLE)', '1500.00', '1400.00', 'DOPPLER U LIMB SINGL', '2022-03-28', 1, '2022-03-28 09:44:02', '2022-03-29 09:40:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (415, 7, 'NEUROSONOGRAME', '1300.00', '1200.00', 'NSG', '2022-03-28', 1, '2022-03-28 09:44:43', '2022-03-28 09:44:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (416, 7, 'B SCAN (BOTH EYE)', '1750.00', '1700.00', 'EYE', '2022-03-28', 1, '2022-03-28 09:45:36', '2022-03-28 09:45:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (417, 7, 'USG CHEST', '1300.00', '1200.00', 'CHEST', '2022-03-28', 1, '2022-03-28 09:47:33', '2022-03-28 09:47:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (418, 7, 'USG PELVIS', '850.00', '800.00', 'PELVIS', '2022-03-28', 1, '2022-03-28 10:04:24', '2022-03-28 10:04:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (420, 11, 'VITAMIN D3', '1250.00', '1000.00', 'D3', '2022-03-28', 1, '2022-03-28 13:02:49', '2022-03-28 13:02:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (421, 11, 'WIDAL TEST', '200.00', '150.00', 'WT', '2022-03-28', 1, '2022-03-28 13:17:26', '2022-03-28 13:17:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (422, 11, 'WESTERN BLOAT', '2000.00', '1800.00', 'WB', '2022-03-28', 1, '2022-03-28 13:19:00', '2022-03-28 13:19:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (423, 11, 'WBC COUNT', '30.00', '20.00', 'WC', '2022-03-28', 1, '2022-03-28 13:19:36', '2022-03-28 13:19:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (424, 11, 'WATER ANALYSIS', '200.00', '150.00', 'WA', '2022-03-28', 1, '2022-03-28 13:21:26', '2022-03-28 13:21:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (425, 11, 'VMA', '1050.00', '1000.00', 'VMA', '2022-03-28', 1, '2022-03-28 13:21:53', '2022-03-28 13:21:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (426, 11, 'VLDL', '20.00', '10.00', 'VLDL', '2022-03-28', 1, '2022-03-28 13:22:30', '2022-03-28 13:22:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (427, 11, 'VITAMIN 25 OH', '1250.00', '1200.00', 'VIT 25 OH', '2022-03-28', 1, '2022-03-28 13:23:13', '2022-03-28 13:23:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (428, 11, 'VITAMIN 125 OH-', '3200.00', '300.00', 'VIT 125OH', '2022-03-28', 1, '2022-03-28 13:24:45', '2022-03-28 13:24:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (429, 11, 'VDRL', '130.00', '100.00', 'VD', '2022-03-28', 1, '2022-03-28 13:25:49', '2022-03-28 13:25:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (430, 11, 'URINE ALBUMIN DEPOSIT', '70.00', '40.00', 'UAD', '2022-03-28', 1, '2022-03-28 13:27:01', '2022-03-28 13:27:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (431, 11, 'URINE UROBILIN OGEN', '70.00', '40.00', 'UUO', '2022-03-28', 1, '2022-03-28 13:28:38', '2022-03-28 13:28:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (432, 11, 'URINE SPECIFIC GRAVITY', '50.00', '20.00', 'PH', '2022-03-28', 1, '2022-03-28 13:30:01', '2022-05-12 17:53:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (433, 23, 'DOPPLER AXICILLA', '1300.00', '1000.00', 'DOP AXICILLA', '2022-03-28', 1, '2022-03-28 14:07:55', '2022-03-29 09:41:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (434, 16, 'OPG/CEPH', '850.00', '500.00', 'OPG CEPH', '2022-03-29', 1, '2022-03-29 09:36:03', '2022-03-29 09:36:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (435, 11, 'ANTI SPERM ANTI BODY', '1350.00', '1200.00', 'ASAB', '2022-04-01', 1, '2022-04-01 11:52:00', '2022-04-01 11:52:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (436, 11, 'PHERIPHERAL SMEAR', '280.00', '150.00', 'PS', '2022-04-01', 1, '2022-04-01 11:52:51', '2022-06-02 14:53:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (437, 11, 'CHOLESTEROL', '130.00', '120.00', 'CHOL', '2022-04-01', 1, '2022-04-01 12:12:02', '2022-04-01 12:12:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (439, 23, 'DOPPLER LOWER LIMB(SINGLE)', '1500.00', '1400.00', 'DLL', '2022-04-02', 1, '2022-04-02 14:50:38', '2022-05-12 17:48:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (440, 11, 'CRP', '400.00', '300.00', 'CRP', '2022-04-04', 1, '2022-04-04 09:41:00', '2022-04-04 09:41:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (441, 11, 'HBA', '900.00', '800.00', 'HBA', '2022-04-04', 1, '2022-04-04 10:11:01', '2022-04-04 10:11:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (442, 11, 'HBSAG', '800.00', '700.00', 'HBSAG', '2022-04-04', 1, '2022-04-04 10:11:36', '2022-04-04 10:11:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (443, 11, 'HCV', '800.00', '700.00', 'HCV', '2022-04-04', 1, '2022-04-04 10:12:34', '2022-04-04 10:12:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (444, 11, 'HEV', '1000.00', '900.00', 'HEV', '2022-04-04', 1, '2022-04-04 10:13:15', '2022-04-04 10:13:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (445, 25, '5D FOLLOW UP (TWINS)', '1500.00', '1200.00', 'FOLLOW UP', '2022-04-04', 1, '2022-04-04 13:26:54', '2022-05-12 17:44:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (446, 18, 'FNAC', '2250.00', '1800.00', 'FNAC', '2022-04-04', 1, '2022-04-04 15:47:44', '2022-04-22 15:54:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (447, 16, 'TMJ', '500.00', '400.00', 'TMJ', '2022-04-06', 1, '2022-04-06 13:01:11', '2022-04-06 13:02:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (448, 11, 'ABSLUTE ESNOPHIL COUNT', '140.00', '100.00', 'AEC', '2022-04-06', 1, '2022-04-06 17:14:56', '2022-04-06 17:14:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (449, 24, '5D ANOMALY (TWINS)', '3500.00', '2000.00', '4D/5D', '2022-04-07', 1, '2022-04-07 18:08:05', '2022-05-12 17:42:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (450, 9, 'X-RAY THORACO LUMBAR SPINE AP-LAT', '300.00', '250.00', 'TLS', '2022-04-07', 1, '2022-04-07 18:55:34', '2022-04-07 19:21:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (451, 9, 'LSS WITH PELVIS AP LSS LAT', '350.00', '300.00', 'LSS', '2022-04-07', 1, '2022-04-07 18:56:18', '2022-04-07 18:56:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (452, 9, 'TOE AP-OBL', '300.00', '250.00', 'TOE', '2022-04-07', 1, '2022-04-07 18:56:57', '2022-04-07 18:56:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (453, 9, 'FINGER AP LAT', '300.00', '250.00', 'FING', '2022-04-07', 1, '2022-04-07 18:57:41', '2022-04-07 18:57:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (454, 9, 'XRAY PELVIS INLET VIEW', '250.00', '200.00', 'PEL', '2022-04-07', 1, '2022-04-07 19:23:47', '2022-04-07 19:23:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (455, 9, 'X-RAY PELVIS OUTLET VIEW', '250.00', '200.00', 'PEL OUT', '2022-04-07', 1, '2022-04-07 19:24:25', '2022-04-07 19:24:25');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (456, 9, 'X-RAY BOTH HIP AP/ OBL', '300.00', '200.00', 'HIP A', '2022-04-07', 1, '2022-04-07 19:25:17', '2022-04-07 19:25:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (457, 11, 'HBSAG(ELIZA)', '500.00', '400.00', 'HBSAG', '2022-04-08', 1, '2022-04-08 14:32:13', '2022-04-08 14:32:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (458, 11, 'SODIUM', '130.00', '100.00', 'SODIUM', '2022-04-09', 1, '2022-04-09 08:04:03', '2022-04-09 08:04:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (459, 11, 'POTTASIUM', '130.00', '100.00', 'K+', '2022-04-09', 1, '2022-04-09 08:04:44', '2022-04-09 08:04:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (460, 11, 'D DIMER', '950.00', '900.00', 'DD', '2022-04-09', 1, '2022-04-09 10:11:03', '2022-04-09 10:11:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (461, 7, '4D/5D ABD/PEL', '1800.00', '1000.00', '3D/4D/5D ABDO', '2022-04-11', 1, '2022-04-11 15:40:46', '2022-05-09 13:34:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (462, 11, 'ANTI TPO', '900.00', '800.00', 'ANTI TPO', '2022-04-11', 1, '2022-04-11 17:31:30', '2022-04-11 17:31:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (463, 11, 'THYRO GLOBULIN ANTIBODY', '500.00', '400.00', 'ANTI TG', '2022-04-11', 1, '2022-04-11 17:32:45', '2022-04-11 17:32:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (464, 7, 'USG RIGHT ANKLE(FOOT)', '1300.00', '1400.00', 'USG RIGHT ANLKE', '2022-04-21', 1, '2022-04-21 16:48:55', '2022-04-21 16:48:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (465, 11, 'URINE RE.', '120.00', '100.00', 'URINE RE.', '2022-04-22', 339, '2022-04-22 12:56:48', '2022-04-22 12:56:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (466, 11, 'URINE CULTURE.', '250.00', '150.00', 'URINE CULTURE', '2022-04-22', 339, '2022-04-22 13:02:24', '2022-04-22 13:02:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (468, 7, 'FOLLICULAR STUDY(EXTRA DAYS)', '500.00', '300.00', 'FOLLICULAR', '2022-04-27', 1, '2022-04-27 13:07:50', '2022-04-27 13:07:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (469, 11, 'BLOOD COLLECTION', '300.00', '200.00', 'BLOOD COLLECTION', '2022-04-29', 1, '2022-04-29 11:22:09', '2022-04-29 11:22:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (470, 7, 'OBSTETRICS', '1000.00', '800.00', 'OBG VIABILITY', '2022-05-02', 1, '2022-05-02 12:57:54', '2022-05-02 12:57:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (471, 23, 'VENUS DOPPLER', '1500.00', '1000.00', 'VENUS', '2022-05-02', 1, '2022-05-02 13:25:05', '2022-05-02 13:25:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (472, 17, 'SONO MAMMOGRAM WITH AXILLA', '1500.00', '1250.00', 'AXILA', '2022-05-07', 1, '2022-05-07 13:25:28', '2022-05-07 13:25:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (473, 7, '4D/5D ABDOMEN PELVIS', '1850.00', '1500.00', '4D/5D ABD PEL', '2022-05-09', 1, '2022-05-09 13:37:11', '2022-05-09 13:37:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (474, 23, 'VENUS DOPPLER BOTH', '3000.00', '2500.00', 'VENUS', '2022-05-12', 1, '2022-05-12 13:10:05', '2022-05-12 13:10:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (475, 23, 'DOP.NECK', '1500.00', '1000.00', 'NECK', '2022-05-25', 1, '2022-05-25 15:13:58', '2022-05-25 15:13:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (476, 23, 'DOPPLER OBG..', '1500.00', '1000.00', 'OBG', '2022-06-13', 1, '2022-06-13 19:38:55', '2022-06-13 19:38:55');


#
# TABLE STRUCTURE FOR: lab_test_category
#

DROP TABLE IF EXISTS `lab_test_category`;

CREATE TABLE `lab_test_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (7, 'USG', '2022-03-14 12:10:04', '2022-03-14 12:10:04');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (8, 'CT Scaning', '2022-03-14 12:10:31', '2022-03-14 12:10:31');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (9, 'X-RAY', '2022-03-14 13:54:45', '2022-03-14 13:54:45');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (10, 'CONSUMERABLE', '2022-03-14 15:59:19', '2022-03-14 15:59:19');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (11, 'LAB', '2022-03-14 16:47:09', '2022-03-14 16:47:09');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (12, 'NCV', '2022-03-15 13:01:47', '2022-03-15 13:01:47');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (13, 'EEG', '2022-03-15 13:01:59', '2022-03-15 13:01:59');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (14, 'ECG', '2022-03-15 13:02:13', '2022-03-15 13:02:13');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (15, 'BMD / DEXA', '2022-03-15 13:02:27', '2022-03-28 15:20:05');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (16, 'OPG', '2022-03-15 13:02:35', '2022-03-15 13:02:35');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (17, 'MAMMOGRAM', '2022-03-15 13:03:01', '2022-03-15 13:03:01');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (18, 'FNAC', '2022-03-15 15:46:03', '2022-03-15 15:46:03');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (19, 'HSG', '2022-03-17 17:52:54', '2022-03-17 17:52:54');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (20, 'TMT', '2022-03-17 17:53:07', '2022-03-17 17:53:07');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (22, 'ECHO', '2022-03-26 17:46:13', '2022-03-26 17:46:13');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (23, 'DOPPLER', '2022-03-28 15:17:47', '2022-03-28 15:17:47');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (24, '5D / 4D', '2022-03-28 15:18:18', '2022-04-05 11:07:13');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (25, 'FOLLOW UP  5D', '2022-04-05 11:08:01', '2022-05-12 17:45:27');


#
# TABLE STRUCTURE FOR: labtest_bill
#

DROP TABLE IF EXISTS `labtest_bill`;

CREATE TABLE `labtest_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(10) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `referral_id` int(11) NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `tax_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission` decimal(18,2) DEFAULT '0.00',
  `paid` decimal(18,2) NOT NULL DEFAULT '0.00',
  `due` decimal(18,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL,
  `date` date DEFAULT NULL,
  `hash` varchar(50) NOT NULL,
  `prepared_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=527 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (6, '0006', 6, 81, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-11', 'b41c411f8e5a8358a82847e75e57c34d', 1, '2022-04-11 10:32:13', '2022-04-11 10:32:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (7, '0007', 7, 312, '6830.00', '0.00', '0.00', '0.00', '6830.00', '0.00', 3, '2022-04-11', '4edcd04775fbd4f18384a69dba772097', 1, '2022-04-11 11:25:12', '2022-04-11 11:25:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (8, '0008', 8, 313, '1050.00', '0.00', '0.00', '0.00', '1050.00', '0.00', 3, '2022-04-11', 'f3942882c83028f5d02c18bd6f740af5', 1, '2022-04-11 11:34:11', '2022-04-11 11:34:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (9, '0009', 9, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-11', '337631ada5d82647917787491b542600', 1, '2022-04-11 11:45:35', '2022-04-11 11:45:35');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (10, '0010', 10, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-11', '40a20489d382ab0069e8e50d2024fd66', 1, '2022-04-11 11:56:26', '2022-04-11 11:56:26');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (11, '0011', 11, 314, '700.00', '0.00', '0.00', '0.00', '700.00', '0.00', 3, '2022-04-11', 'b74b1d4321ae4ec3f3e13cbbe2921be4', 1, '2022-04-11 12:11:20', '2022-04-11 12:11:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (12, '0012', 12, 314, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-11', '46e309bdfd92b4b89a18714195bf37cf', 1, '2022-04-11 12:14:52', '2022-04-11 12:14:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (13, '0013', 13, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-11', '311db5efd60df667af814a2dd1c254e9', 1, '2022-04-11 12:25:48', '2022-04-11 12:25:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (14, '0014', 14, 312, '200.00', '0.00', '0.00', '0.00', '200.00', '0.00', 3, '2022-04-11', 'c5aa023efc91bdfc2a8504c78090ea0e', 1, '2022-04-11 12:36:02', '2022-04-11 12:36:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (15, '0015', 15, 294, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-11', '662209a0d7d2072b8b51f6b490203ee8', 1, '2022-04-11 12:46:09', '2022-04-11 12:46:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (17, '0017', 17, 43, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-11', 'c11347003785cdac02cfa1a8252958ff', 1, '2022-04-11 13:06:18', '2022-04-11 13:06:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (18, '0018', 18, 316, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-11', 'cb439d9baccc47d309cf1effdaca36fb', 1, '2022-04-11 13:15:48', '2022-04-11 13:15:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (19, '0019', 19, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-11', '958c47a7d3349b067e72395775eaddc7', 1, '2022-04-11 13:33:52', '2022-04-11 13:33:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (20, '0020', 20, 81, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-11', '8136c9f1dd4b53340eeb9e556aca2770', 1, '2022-04-11 13:44:13', '2022-04-11 13:44:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (21, '0021', 21, 315, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-04-11', '03ca5e2396b62e0fdfb6eedd74897b6d', 1, '2022-04-11 14:10:31', '2022-04-11 14:10:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (22, '0022', 22, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-11', '1afe77b1a62d952c92e130ce33312ed7', 1, '2022-04-11 14:18:19', '2022-04-11 14:18:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (24, '0024', 24, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-11', '9e514b5cb97c4fc618995218c673ce03', 1, '2022-04-11 14:45:11', '2022-04-11 14:45:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (25, '0025', 25, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-11', '0ae9ba8742bbbfd795738ef703e621c9', 1, '2022-04-11 14:56:41', '2022-04-11 14:56:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (26, '0026', 26, 318, '1790.00', '0.00', '0.00', '0.00', '1790.00', '0.00', 3, '2022-04-11', '21b5d3fbc21911c3c34a68b02732cb93', 1, '2022-04-11 15:35:13', '2022-04-11 15:35:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (27, '0027', 26, 318, '1800.00', '0.00', '0.00', '0.00', '1800.00', '0.00', 3, '2022-04-11', 'c48aaef382fb21968afcc03aa6eb6c8e', 1, '2022-04-11 15:42:18', '2022-04-11 15:42:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (28, '0028', 27, 319, '200.00', '0.00', '0.00', '0.00', '200.00', '0.00', 3, '2022-04-11', '2dc4adad81b117568da44f0e4e1a8aed', 1, '2022-04-11 16:55:20', '2022-04-11 16:55:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (29, '0029', 28, 320, '4660.00', '0.00', '0.00', '0.00', '4660.00', '0.00', 3, '2022-04-11', '49451440b7401ca00ea8dce2da7f9437', 1, '2022-04-11 17:29:11', '2022-04-11 17:29:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (30, '0030', 28, 320, '1400.00', '0.00', '0.00', '0.00', '1400.00', '0.00', 3, '2022-04-11', '1e16fa7b1fd118ed18fe337ccc211d0c', 1, '2022-04-11 17:40:42', '2022-04-11 17:40:42');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (31, '0031', 28, 320, '1950.00', '0.00', '0.00', '0.00', '1950.00', '0.00', 3, '2022-04-11', '1700cab3f47250ef314829c16f4dd171', 1, '2022-04-11 17:45:53', '2022-04-11 17:45:53');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (32, '0032', 29, 216, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-12', 'f370a9adeacdec57bffc1e1852ca64dd', 1, '2022-04-12 13:58:22', '2022-04-12 13:58:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (33, '0033', 30, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-12', 'a19d8ea2ca2e1bd729e05ffc8dba18a1', 1, '2022-04-12 15:45:11', '2022-04-12 15:45:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (34, '0034', 31, 321, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-12', '367356193a9a138bc3af286c078326ed', 1, '2022-04-12 16:25:03', '2022-04-12 16:25:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (35, '0035', 32, 322, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-12', '42120e164ae3b2e283af8ed81d833e59', 1, '2022-04-12 17:16:58', '2022-04-12 17:16:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (36, '0036', 33, 323, '2350.00', '0.00', '0.00', '0.00', '2350.00', '0.00', 3, '2022-04-12', '6645ab0f0d02d95aa565ed52dab89ef4', 1, '2022-04-12 17:40:40', '2022-04-12 17:40:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (37, '0037', 34, 324, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-12', '4e48f70a37f21571a43718b48ac93c11', 1, '2022-04-12 17:56:03', '2022-04-12 17:56:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (38, '0038', 35, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-12', '7ccb348f1de6ef9b8a45f18f9662abb1', 1, '2022-04-12 18:15:06', '2022-04-12 18:15:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (39, '0039', 36, 325, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-12', '3f669b026e6e907d0fbc6ade9f39ca17', 1, '2022-04-12 19:16:23', '2022-04-12 19:16:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (40, '0040', 37, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-13', 'a5ef648f29ac2b79ad7a51ada055df86', 1, '2022-04-13 10:15:47', '2022-04-13 10:15:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (41, '0041', 38, 326, '30.00', '0.00', '0.00', '0.00', '30.00', '0.00', 3, '2022-04-13', '64e67909ef1d93ae74da04d4bbbe2ce9', 1, '2022-04-13 10:48:28', '2022-04-13 10:48:28');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (42, '0042', 39, 148, '460.00', '0.00', '0.00', '0.00', '460.00', '0.00', 3, '2022-04-13', '03f2bb3476d3a02899a7c574676df0f7', 1, '2022-04-13 10:52:53', '2022-04-13 10:52:53');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (43, '0043', 40, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-13', '75965231d6be856ff1f44f0e66388162', 1, '2022-04-13 11:18:24', '2022-04-13 11:18:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (44, '0044', 41, 250, '2450.00', '350.00', '0.00', '0.00', '2100.00', '0.00', 3, '2022-04-13', '83e141ccb8133efda93343acc1f591d0', 1, '2022-04-13 11:43:43', '2022-04-13 11:43:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (45, '0045', 42, 327, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-13', 'ee09f8ba69dd5a805f06ba7b3f77cb1d', 1, '2022-04-13 11:53:41', '2022-04-13 11:53:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (46, '0046', 43, 327, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-13', 'de8dc2cfcb54d4aedfe1f83d355e6aa9', 1, '2022-04-13 12:06:24', '2022-04-13 12:06:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (47, '0047', 44, 328, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-13', 'c52164fbbf3ecb6abae3aa8fc9031ad5', 1, '2022-04-13 12:16:32', '2022-04-13 12:16:32');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (48, '0048', 45, 250, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-13', '5fed1c748104321d7030772cf102a0db', 1, '2022-04-13 12:39:43', '2022-04-13 12:39:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (49, '0049', 46, 329, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-04-13', '6de1042d43c391af3f0bfe58708d9df2', 1, '2022-04-13 13:55:26', '2022-04-13 13:55:26');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (50, '0050', 47, 330, '1500.00', '200.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-04-13', 'bebc17df64333399804a7cb7af091a00', 1, '2022-04-13 14:39:12', '2022-04-13 14:39:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (51, '0051', 48, 256, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-13', 'c9e0f0fb54fd66fe21e4398ed3988709', 1, '2022-04-13 16:06:23', '2022-04-13 16:06:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (52, '0052', 49, 41, '790.00', '0.00', '0.00', '0.00', '790.00', '0.00', 3, '2022-04-13', '100b956e42a0244989ab7d8ed15b50ee', 1, '2022-04-13 16:48:51', '2022-04-13 16:48:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (53, '0053', 50, 325, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-14', '81d79df52146fe505d1d8a52778f3ec0', 1, '2022-04-14 10:27:37', '2022-04-14 10:27:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (54, '0054', 51, 250, '2450.00', '150.00', '0.00', '0.00', '2300.00', '0.00', 3, '2022-04-14', '05cf5059c695a3a6739a9a8aed228ea8', 1, '2022-04-14 10:46:13', '2022-04-14 10:46:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (55, '0055', 52, 250, '250.00', '50.00', '0.00', '0.00', '200.00', '0.00', 3, '2022-04-14', 'd5b525f36c36afce782dc0f33feee761', 1, '2022-04-14 10:49:15', '2022-04-14 10:49:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (56, '0056', 53, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-14', 'ea141f944cf22a428d0f9ac2fa97d51a', 1, '2022-04-14 11:20:11', '2022-04-14 11:20:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (57, '0057', 54, 316, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-14', 'c64ab94d917fc1af8402392e0952d163', 1, '2022-04-14 11:27:23', '2022-04-14 11:27:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (58, '0058', 55, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-14', 'a78dae5fc52294eacb446efbfc9b7ea0', 1, '2022-04-14 11:43:26', '2022-04-14 11:43:26');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (59, '0059', 56, 332, '2350.00', '0.00', '0.00', '0.00', '2350.00', '0.00', 3, '2022-04-16', 'e68e6f0b33e19c2d5f628d210e26d23f', 1, '2022-04-16 09:44:02', '2022-04-16 09:44:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (60, '0060', 57, 333, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-16', '1d7dff74ecbf0fda8a5db064fd530cd1', 1, '2022-04-16 10:09:30', '2022-04-16 10:09:30');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (61, '0061', 58, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-16', '78917391f4863217cac60ef76cdc5534', 1, '2022-04-16 10:38:20', '2022-04-16 10:38:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (62, '0062', 59, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-16', '05a6d1c73303c11c6f7bc41375f48ac5', 1, '2022-04-16 10:54:45', '2022-04-16 10:54:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (63, '0063', 60, 316, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-16', '5eb328044f70a98fa12cfb38bc73b7a5', 1, '2022-04-16 11:08:31', '2022-04-16 11:08:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (64, '0064', 61, 334, '200.00', '0.00', '0.00', '0.00', '200.00', '0.00', 3, '2022-04-16', '473a2aa4b2629dd081ef3aee5ca2ca89', 1, '2022-04-16 11:40:09', '2022-04-16 11:40:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (65, '0065', 62, 335, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-04-16', '2ecf94418ef19ecd6ecd83f7c030b30a', 1, '2022-04-16 11:54:20', '2022-04-16 11:54:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (66, '0066', 56, 332, '1500.00', '0.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-04-16', 'f21a65b788e5d9140b200fd559a87ff9', 1, '2022-04-16 12:21:59', '2022-04-16 12:21:59');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (67, '0067', 56, 332, '2350.00', '0.00', '0.00', '0.00', '2350.00', '0.00', 3, '2022-04-16', 'ebc74153faf161446c0201865855e9c1', 1, '2022-04-16 12:25:14', '2022-04-16 12:25:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (68, '0068', 63, 336, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-16', '07f3a21dae9d922eb8df546400932087', 1, '2022-04-16 12:46:16', '2022-04-16 12:46:16');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (69, '0069', 64, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-16', '6ae6c5db5e8caebc5db9d4779b837d35', 1, '2022-04-16 12:55:37', '2022-04-16 12:55:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (70, '0070', 65, 337, '1600.00', '0.00', '0.00', '0.00', '1600.00', '0.00', 3, '2022-04-16', '3c187a578b3889964cde09748cefe511', 1, '2022-04-16 13:37:37', '2022-04-16 13:37:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (71, '0071', 66, 317, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-16', '868e7ad3ef7bbf2e2b52ba97a5fbb36c', 1, '2022-04-16 14:06:33', '2022-04-16 14:06:33');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (72, '0072', 67, 338, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-16', 'b823eadca8a921790fcc0e717e3c6e7c', 1, '2022-04-16 14:45:43', '2022-04-16 14:45:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (73, '0073', 65, 337, '990.00', '0.00', '0.00', '0.00', '990.00', '0.00', 3, '2022-04-16', 'e8914b91b0ff890b096570598895fc7f', 1, '2022-04-16 16:56:27', '2022-04-16 16:56:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (74, '0074', 68, 325, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-19', 'a5fadd5f3adaf165864dff1f4b57d35b', 1, '2022-04-19 09:17:12', '2022-04-19 09:17:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (75, '0075', 69, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-19', '8b849e39b6e38fad5eeb91b098e94a5a', 1, '2022-04-19 09:22:15', '2022-04-19 09:22:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (76, '0076', 70, 325, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-19', '8fbc729d403a9933c6fec81438d33fec', 1, '2022-04-19 09:25:04', '2022-04-19 09:25:04');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (77, '0077', 71, 340, '1110.00', '0.00', '0.00', '0.00', '1110.00', '0.00', 3, '2022-04-19', '89309e824a1fcf56b9e366918ce499cd', 1, '2022-04-19 09:32:21', '2022-04-19 09:32:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (78, '0078', 72, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-19', 'fb75c684aa62baed9d1e12db6388356e', 1, '2022-04-19 10:17:38', '2022-04-19 10:17:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (79, '0079', 73, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-19', '4c2ef8df2df864777ce41db87b7d67aa', 1, '2022-04-19 10:47:07', '2022-04-19 10:47:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (80, '0080', 74, 325, '1800.00', '0.00', '0.00', '0.00', '1800.00', '0.00', 3, '2022-04-19', 'acbd6df8b493713cc20884b8a4abbfa6', 1, '2022-04-19 11:08:05', '2022-04-19 11:08:05');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (81, '0081', 75, 340, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-19', '70887af221f38ec5587d45d82f64821f', 1, '2022-04-19 11:21:38', '2022-04-19 11:21:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (82, '0082', 76, 46, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-19', 'ff25ae3220631b74367e1d467d85e118', 1, '2022-04-19 11:35:47', '2022-04-19 11:35:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (83, '0083', 77, 341, '950.00', '100.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-19', '3ed3ea032f8ffd26d09006b09d617a70', 1, '2022-04-19 11:53:32', '2022-04-19 11:53:32');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (84, '0084', 78, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-19', '5924dd66cb7f89325840fe8359f5f6e4', 1, '2022-04-19 12:49:24', '2022-04-19 12:49:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (85, '0085', 79, 318, '3350.00', '0.00', '0.00', '0.00', '3350.00', '0.00', 3, '2022-04-19', '7678e000505f6a8f2a15435f77da4c16', 1, '2022-04-19 13:16:56', '2022-04-19 13:16:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (86, '0086', 80, 342, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-19', '63256dbe90614b7ba817037bef599e2a', 1, '2022-04-19 13:44:19', '2022-04-19 13:44:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (87, '0087', 81, 343, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-20', 'bce90a1fc48a82465088d1500bb59933', 1, '2022-04-20 09:48:28', '2022-04-20 09:48:28');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (88, '0088', 82, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-20', 'ad461bd2519199a256c4bde7f42b7773', 339, '2022-04-20 10:17:41', '2022-04-20 10:17:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (89, '0089', 83, 344, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-20', 'a70767a85ecbe19f63ab40e49ddfa965', 339, '2022-04-20 10:36:34', '2022-04-20 10:36:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (90, '0090', 84, 345, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-20', '3d12d1e1f92616868472d9a9a8e427e1', 339, '2022-04-20 10:45:28', '2022-04-20 10:45:28');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (91, '0091', 85, 346, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-20', '09cfcf35ee1cf73756918bfccdd53ca6', 339, '2022-04-20 10:53:21', '2022-04-20 10:53:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (92, '0092', 86, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-20', '920bd0d65654b6e6f0151369c87d12c4', 339, '2022-04-20 11:02:12', '2022-04-20 11:02:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (93, '0093', 87, 347, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-20', '2e26274557c263141bb436deef7d6ef8', 339, '2022-04-20 11:19:17', '2022-04-20 11:19:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (94, '0094', 88, 348, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-20', '36b80d3fc61e400ec76e8508874a3b19', 339, '2022-04-20 11:41:19', '2022-04-20 11:41:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (95, '0095', 89, 349, '380.00', '0.00', '0.00', '0.00', '380.00', '0.00', 3, '2022-04-20', '405b03feb40a10366ad114611bd187b7', 339, '2022-04-20 12:18:38', '2022-04-20 12:18:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (96, '0096', 60, 46, '2380.00', '0.00', '0.00', '0.00', '2380.00', '0.00', 3, '2022-04-20', 'a9d3ff16fd8cc93e378b1f2f1cdf1064', 1, '2022-04-20 13:49:54', '2022-04-20 13:49:54');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (97, '0097', 90, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-21', 'c69ae66c76c361f636e2f86f2d8a19e1', 1, '2022-04-21 09:26:41', '2022-04-21 09:26:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (98, '0098', 91, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-21', '8e04e1b0f370ee3292d7cde4326821b8', 1, '2022-04-21 10:15:29', '2022-04-21 10:15:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (99, '0099', 92, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-21', 'ad9f767e6b481003076874dfecf30a6f', 1, '2022-04-21 10:50:31', '2022-04-21 10:50:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (100, '0100', 93, 325, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-21', '3a4c6bc9c0ef47ede090844fb232dac8', 1, '2022-04-21 11:12:47', '2022-04-21 11:12:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (101, '0101', 93, 325, '440.00', '0.00', '0.00', '0.00', '440.00', '0.00', 3, '2022-04-21', 'e65efe5437a442ed835db17c156fa401', 1, '2022-04-21 11:18:09', '2022-04-21 11:18:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (102, '0102', 94, 335, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-21', 'c0255082e36553da0b674bbdcb737dc6', 1, '2022-04-21 11:51:21', '2022-04-21 11:51:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (103, '0103', 95, 351, '450.00', '0.00', '0.00', '0.00', '450.00', '0.00', 3, '2022-04-21', '74bab3e361f6a4ebc2db26cdf4164b76', 1, '2022-04-21 12:08:21', '2022-04-21 12:08:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (104, '0104', 96, 351, '100.00', '0.00', '0.00', '0.00', '100.00', '0.00', 3, '2022-04-21', 'f0c436a4d2535b6122296babdb1af6c6', 1, '2022-04-21 12:18:57', '2022-04-21 12:18:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (105, '0105', 96, 351, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-21', '591f1819277a6973919b802c55c2fcf1', 1, '2022-04-21 12:21:32', '2022-04-21 12:21:32');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (106, '0106', 97, 352, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-21', '8063b4f09ab843cccabfd3b792d9e563', 1, '2022-04-21 12:29:51', '2022-04-21 12:29:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (107, '0107', 98, 353, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-21', '0b18bcc8b0a144d095007e054119c512', 1, '2022-04-21 12:40:49', '2022-04-21 12:40:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (108, '0108', 99, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-21', 'e22790a2f223c6e31f356b7bafe80546', 1, '2022-04-21 12:47:12', '2022-04-21 12:47:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (109, '0109', 100, 316, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-21', '8184e9feae3472da07eb40ae2efa4c7a', 1, '2022-04-21 13:17:44', '2022-04-21 13:17:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (110, '0110', 101, 354, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-21', '71416c837347e8d6a3c35026681fbd42', 1, '2022-04-21 14:41:30', '2022-04-21 14:41:30');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (111, '0111', 102, 355, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-21', '743a4aa31f3afbc1d49102d73da69294', 1, '2022-04-21 15:02:37', '2022-04-21 15:02:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (112, '0112', 103, 356, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-21', 'bd9eb3001eb855c828f2bae849c806c0', 1, '2022-04-21 15:20:32', '2022-04-21 15:20:32');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (113, '0113', 104, 325, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-21', '39795947af2e1f3d2c315bd32b9332fe', 1, '2022-04-21 15:27:25', '2022-04-21 15:27:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (114, '0114', 105, 357, '2200.00', '0.00', '0.00', '0.00', '2200.00', '0.00', 3, '2022-04-21', '5fd8d3e00bac84f160727ad9731cdc7b', 1, '2022-04-21 15:52:07', '2022-04-21 15:52:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (115, '0115', 103, 356, '1300.00', '300.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-21', '87a1ef54ad9705263fa307104742ad3b', 1, '2022-04-21 16:51:14', '2022-04-21 16:51:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (116, '0116', 106, 335, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-04-22', 'a2c9e802b071cbbfe7fb6d0a6f2ae156', 1, '2022-04-22 10:23:04', '2022-04-22 10:23:04');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (117, '0117', 107, 358, '320.00', '0.00', '0.00', '0.00', '320.00', '0.00', 3, '2022-04-22', '0242f287a70ac97a8ae35e26b20e1f54', 1, '2022-04-22 10:29:18', '2022-04-22 10:29:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (118, '0118', 108, 317, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-22', 'bc41a424f7de8892090db2c435daa285', 1, '2022-04-22 10:33:07', '2022-04-22 10:33:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (119, '0119', 108, 317, '130.00', '0.00', '0.00', '0.00', '130.00', '0.00', 3, '2022-04-22', 'bdb2058d00db8488d68bf8a5cdcc7165', 1, '2022-04-22 10:36:12', '2022-04-22 10:36:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (120, '0120', 109, 359, '3210.00', '0.00', '0.00', '0.00', '3210.00', '0.00', 3, '2022-04-22', 'b57c32a05c5e71c05d0f1f18dc503655', 1, '2022-04-22 10:43:08', '2022-04-22 10:43:08');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (121, '0121', 110, 359, '3610.00', '0.00', '0.00', '0.00', '3610.00', '0.00', 3, '2022-04-22', '4558891e06317b82912a839fcb2a5d4f', 1, '2022-04-22 10:47:08', '2022-04-22 10:47:08');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (122, '0122', 111, 360, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-22', '06e496a76509296d3b95292fe8ba331c', 1, '2022-04-22 10:53:38', '2022-04-22 10:53:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (123, '0123', 112, 335, '100.00', '0.00', '0.00', '0.00', '100.00', '0.00', 3, '2022-04-22', 'dcbd10224054fdec27e363888fbb85e5', 1, '2022-04-22 11:25:48', '2022-04-22 11:25:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (124, '0124', 113, 361, '1720.00', '300.00', '0.00', '0.00', '1420.00', '0.00', 3, '2022-04-22', 'a0f33d49c0c267758736442065600590', 1, '2022-04-22 13:14:48', '2022-04-22 13:14:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (125, '0125', 114, 362, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-04-22', 'f50feaa720fcf5f9434caaca9b249d64', 1, '2022-04-22 13:30:12', '2022-04-22 13:30:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (126, '0126', 115, 363, '1800.00', '0.00', '0.00', '0.00', '1800.00', '0.00', 3, '2022-04-22', 'e05d77562efc34e884f35053561e1e2d', 1, '2022-04-22 13:56:04', '2022-04-22 13:56:04');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (127, '0127', 116, 338, '2200.00', '0.00', '0.00', '0.00', '2200.00', '0.00', 3, '2022-04-22', '364869fe5b1a9e230a4b4e111a4f8739', 1, '2022-04-22 14:14:24', '2022-04-22 14:14:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (128, '0128', 117, 364, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-22', '09af18f38d446d7750094954f98f58c5', 1, '2022-04-22 14:26:25', '2022-04-22 14:26:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (129, '0129', 14, 318, '3450.00', '250.00', '0.00', '0.00', '3200.00', '0.00', 3, '2022-04-22', '5ce7794e6c3934d900c214f7a8594352', 1, '2022-04-22 16:00:46', '2022-04-22 16:00:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (130, '0130', 110, 365, '2250.00', '250.00', '0.00', '0.00', '2000.00', '0.00', 3, '2022-04-22', '9aaf5a99cefb8aaef64a3b62e8656e27', 1, '2022-04-22 16:04:52', '2022-04-22 16:04:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (131, '0131', 118, 360, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-25', '035a762a2ac5cd13a61567a20ae2b7a4', 1, '2022-04-25 10:00:31', '2022-04-25 10:00:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (132, '0132', 119, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-25', 'bea3225ebb46ec6376ba723c0c769aeb', 1, '2022-04-25 10:23:34', '2022-04-25 10:23:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (133, '0133', 120, 366, '920.00', '0.00', '0.00', '0.00', '920.00', '0.00', 3, '2022-04-25', 'eb837b05c8d9a3ca6a7aed25b4045765', 1, '2022-04-25 10:33:30', '2022-04-25 10:33:30');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (134, '0134', 121, 367, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-04-25', '40364fc4d4f320911114a35f0a9210bb', 1, '2022-04-25 10:42:06', '2022-04-25 10:42:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (135, '0135', 122, 368, '1500.00', '0.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-04-25', 'dcdb18caa47dfcb5651b8fab7d625dd0', 1, '2022-04-25 10:51:06', '2022-04-25 10:51:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (136, '0136', 123, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-25', '31a5b5e60866c3ef72e463579fa64be9', 1, '2022-04-25 10:57:55', '2022-04-25 10:57:55');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (137, '0137', 124, 369, '2200.00', '0.00', '0.00', '0.00', '2200.00', '0.00', 3, '2022-04-25', '5d2f863491a2e2bdab28c2c5ecd51745', 1, '2022-04-25 11:27:17', '2022-04-25 11:27:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (138, '0138', 125, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-25', 'bfd5ceb43ff71487e9636462badcba85', 1, '2022-04-25 11:36:10', '2022-04-25 11:36:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (139, '0139', 126, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-25', '255d64b22b8e407c6eec70fbbcb9153b', 1, '2022-04-25 12:19:49', '2022-04-25 12:19:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (140, '0140', 127, 369, '2200.00', '0.00', '0.00', '0.00', '2200.00', '0.00', 3, '2022-04-25', '2addfd5452db8d29ad0daf6de6e2f22c', 1, '2022-04-25 12:32:37', '2022-04-25 12:32:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (141, '0141', 128, 370, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-25', 'aef715e00f5c9ab314f4c611127faf6b', 1, '2022-04-25 12:54:09', '2022-04-25 12:54:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (142, '0142', 129, 330, '1800.00', '0.00', '0.00', '0.00', '1800.00', '0.00', 3, '2022-04-25', '8b067850221c3392c8ceb40f1a19d649', 1, '2022-04-25 14:32:48', '2022-04-25 14:32:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (143, '0143', 130, 371, '3350.00', '0.00', '0.00', '0.00', '3350.00', '0.00', 3, '2022-04-27', '7aa8a60e1a445ab33f340d6cf59ea866', 1, '2022-04-27 09:14:03', '2022-04-27 09:14:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (144, '0144', 131, 372, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-27', '2ec697b59638ff808105df7703d10df8', 1, '2022-04-27 09:50:36', '2022-04-27 09:50:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (145, '0145', 132, 317, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-27', 'a57d7944441057d8808308fe00e06661', 1, '2022-04-27 10:03:10', '2022-04-27 10:03:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (146, '0146', 133, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-27', 'ec84df5e094a3c9a2abeb09f17f18f3a', 1, '2022-04-27 10:16:31', '2022-04-27 10:16:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (147, '0147', 134, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-27', '56babd8c5c18caa54e66eecd73e2acc0', 1, '2022-04-27 10:29:13', '2022-04-27 10:29:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (148, '0148', 135, 373, '850.00', '200.00', '0.00', '0.00', '650.00', '0.00', 3, '2022-04-27', '59fa736b170b956c704ba16c28471700', 1, '2022-04-27 10:52:46', '2022-04-27 10:52:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (149, '0149', 136, 318, '800.00', '0.00', '0.00', '0.00', '800.00', '0.00', 3, '2022-04-27', '88d506cd6a561c5cdd251b86477e23c4', 1, '2022-04-27 11:03:57', '2022-04-27 11:03:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (150, '0150', 137, 360, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-27', '5324e0e8115a5ae5effb47f19d7dda24', 1, '2022-04-27 11:06:59', '2022-04-27 11:06:59');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (151, '0151', 138, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-27', 'ffaa2ba696f2747ccd61691cc33d4fba', 1, '2022-04-27 11:22:27', '2022-04-27 11:22:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (152, '0152', 139, 316, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-27', '09a505537e14a1e9405efbf0a60dc483', 1, '2022-04-27 11:35:16', '2022-04-27 11:35:16');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (153, '0153', 140, 335, '2500.00', '0.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-27', '4db1c19ee27f1c223499b0f9860fc742', 1, '2022-04-27 11:48:25', '2022-04-27 11:48:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (154, '0154', 141, 317, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-27', 'b936b774afbd035b3c4b212a30649729', 1, '2022-04-27 12:04:22', '2022-04-27 12:04:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (155, '0155', 142, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-27', '8ae584b5ad4c2175163a34dc3ff45202', 1, '2022-04-27 12:22:49', '2022-04-27 12:22:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (156, '0156', 143, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-04-27', '068056d5e2768482d6e0e9a215f67cce', 1, '2022-04-27 12:36:01', '2022-04-27 12:36:01');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (157, '0157', 144, 374, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-27', '39f22866748bef10e091f7917612e778', 1, '2022-04-27 12:53:30', '2022-04-27 12:53:30');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (158, '0158', 145, 375, '500.00', '0.00', '0.00', '0.00', '500.00', '0.00', 3, '2022-04-27', '246e762d1f598932ed4aaa38a6fa1395', 1, '2022-04-27 13:11:39', '2022-04-27 13:11:39');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (159, '0159', 146, 376, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-27', '0a5bf44c062f1cc9394d70d7e49d3456', 1, '2022-04-27 14:53:00', '2022-04-27 14:53:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (160, '0160', 147, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-04-27', '2360c0caba835cb1a988db649e97113b', 1, '2022-04-27 15:06:23', '2022-04-27 15:06:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (161, '0161', 148, 377, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-28', 'f9d4429aa85aff561c600aa45158fb81', 1, '2022-04-28 09:39:27', '2022-04-28 09:39:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (162, '0162', 149, 378, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-28', 'd21c6265c8830fa42c451248d60857c7', 1, '2022-04-28 10:25:11', '2022-04-28 10:25:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (163, '0163', 150, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-04-28', 'fd20a71674d5d67e7744fd1109f72a98', 1, '2022-04-28 11:42:52', '2022-04-28 11:42:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (164, '0164', 151, 379, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-28', '41831e87a43eee77b6a1ffe259f3730c', 1, '2022-04-28 11:58:41', '2022-04-28 11:58:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (165, '0165', 152, 317, '3000.00', '500.00', '0.00', '0.00', '3000.00', '-500.00', 2, '2022-04-28', '0f1ca1d735225555435731e949c519e1', 1, '2022-04-28 12:14:19', '2022-04-28 12:14:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (166, '0166', 153, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-28', '86cd82ef1e66483b7626d7b535701dce', 1, '2022-04-28 12:36:00', '2022-04-28 12:36:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (167, '0167', 154, 317, '3500.00', '500.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-28', 'c98e374d73ee4fcf18bac87f54bf384d', 1, '2022-04-28 12:53:42', '2022-04-28 12:53:42');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (168, '0168', 155, 360, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-28', 'eac88563ed71acaaa586174fc0663a5a', 1, '2022-04-28 13:04:37', '2022-04-28 13:04:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (169, '0169', 156, 380, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-28', 'e096041331d04a2ffcc30e6da5d1e374', 1, '2022-04-28 13:22:51', '2022-04-28 13:22:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (170, '0170', 157, 381, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-28', 'a048a58abae913fb423a2aacfa6ad096', 1, '2022-04-28 14:12:47', '2022-04-28 14:12:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (171, '0171', 158, 382, '3000.00', '350.00', '0.00', '0.00', '2650.00', '0.00', 3, '2022-04-28', '4a0194068775c9980c883b0e6ccbb166', 1, '2022-04-28 17:03:44', '2022-04-28 17:03:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (172, '0172', 159, 383, '540.00', '0.00', '0.00', '0.00', '540.00', '0.00', 3, '2022-04-29', '78ca65e1530a31aff29989c4807535df', 1, '2022-04-29 08:33:07', '2022-04-29 08:33:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (173, '0173', 160, 384, '2250.00', '0.00', '0.00', '0.00', '2250.00', '0.00', 3, '2022-04-29', '904f7756f5eb70ea16e2a82865a3b0ad', 1, '2022-04-29 08:50:23', '2022-04-29 08:50:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (174, '0174', 161, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-04-29', '02da48c8578505afb17ce1d8e80c3dd4', 1, '2022-04-29 10:57:24', '2022-04-29 10:57:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (175, '0175', 162, 385, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-04-29', '4a39f93960e6e27c82dc9aa3b09ae0d7', 1, '2022-04-29 11:39:02', '2022-04-29 11:39:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (176, '0176', 163, 176, '300.00', '0.00', '0.00', '0.00', '300.00', '0.00', 3, '2022-04-29', '294b32bb9b9380519b007cde38b82cb3', 1, '2022-04-29 11:46:15', '2022-04-29 11:46:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (177, '0177', 164, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-04-29', 'b72e257bfd9beb493590d9707f62129d', 1, '2022-04-29 11:51:49', '2022-04-29 11:51:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (178, '0178', 165, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-04-29', '46778615634932cf335301e26f31a0be', 1, '2022-04-29 12:48:13', '2022-04-29 12:48:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (179, '0179', 166, 372, '990.00', '0.00', '0.00', '0.00', '990.00', '0.00', 3, '2022-04-29', '75baeb7b79d5bcc10875e22cd7a58da2', 1, '2022-04-29 13:44:09', '2022-04-29 13:44:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (180, '0180', 167, 386, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-02', '359b96fe8a6f16f2cfaab7c38e2c7cde', 1, '2022-05-02 11:22:09', '2022-05-02 11:22:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (181, '0181', 168, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-02', 'fdf4e3fa6df411f964f6fb1f85599a46', 1, '2022-05-02 11:33:27', '2022-05-02 11:33:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (182, '0182', 169, 347, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-02', 'de4309ff5621594a50578bae101bd33f', 1, '2022-05-02 11:47:49', '2022-05-02 11:47:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (183, '0183', 170, 387, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-02', 'a415b3132dd724b9d3227db34debdf6c', 1, '2022-05-02 12:02:20', '2022-05-02 12:02:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (184, '0184', 171, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-02', '1cd667cc8106bf539f8237e2fc3d387a', 1, '2022-05-02 12:11:37', '2022-05-02 12:11:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (185, '0185', 172, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-02', 'f6472fc60648d670dc7373c8793927e6', 1, '2022-05-02 12:30:11', '2022-05-02 12:30:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (186, '0186', 173, 389, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-02', 'b084c9b26a7ed2d4c6223b8b20f4cc26', 1, '2022-05-02 12:56:13', '2022-05-02 12:56:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (188, '0188', 174, 41, '1000.00', '150.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-02', '15000244b5165240a23aa7488afbd40e', 1, '2022-05-02 13:02:30', '2022-05-02 13:02:30');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (189, '0189', 175, 148, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-02', '16884edbfc27df9c6c82119bedf09de9', 1, '2022-05-02 13:11:16', '2022-05-02 13:11:16');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (190, '0190', 176, 390, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-02', '674ad1b02149111119af7581667ac5ba', 1, '2022-05-02 13:23:21', '2022-05-02 13:23:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (191, '0191', 177, 391, '1500.00', '150.00', '0.00', '0.00', '1350.00', '0.00', 3, '2022-05-02', '8ec6b7f8fe74fb9923b81217d1c94f32', 1, '2022-05-02 13:38:46', '2022-05-02 13:38:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (192, '0192', 178, 392, '2500.00', '0.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-02', '548dd41f76f513795ab7f7e8f97d1af7', 1, '2022-05-02 13:50:16', '2022-05-02 13:50:16');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (193, '0193', 179, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-02', 'baf6d87ab920b280df4e912411c8bddb', 1, '2022-05-02 14:08:17', '2022-05-02 14:08:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (194, '0194', 180, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-02', '9f0b3908bd419720eaaee5237b19d3f0', 1, '2022-05-02 14:11:18', '2022-05-02 14:11:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (195, '0195', 181, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-02', '2b9dfff52a47cfa23441659321d41ae3', 1, '2022-05-02 14:19:37', '2022-05-02 14:19:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (196, '0196', 182, 393, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-02', 'efe1ff5c973a35a7cd4f9cc58f3ddd21', 1, '2022-05-02 14:27:42', '2022-05-02 14:27:42');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (197, '0197', 183, 394, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-02', '06b57b468cd49117de628d55528fd5b6', 1, '2022-05-02 14:36:19', '2022-05-02 14:36:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (198, '0198', 184, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-02', '9487a62108aaf8c45cef1dc01a4b1386', 1, '2022-05-02 16:21:05', '2022-05-02 16:21:05');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (199, '0199', 185, 395, '850.00', '850.00', '0.00', '0.00', '0.00', '0.00', 3, '2022-05-02', '2fd1d41bf985bae13f739f3269444834', 1, '2022-05-02 18:11:23', '2022-05-02 18:11:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (200, '0200', 186, 396, '1430.00', '0.00', '0.00', '0.00', '1430.00', '0.00', 3, '2022-05-03', '504dae15aae2966531bfb532c9935263', 1, '2022-05-03 08:56:10', '2022-05-03 08:56:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (201, '0201', 187, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-04', '9fc504dca37eea5b0d1709f28ec12a46', 1, '2022-05-04 10:12:25', '2022-05-04 10:12:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (202, '0202', 188, 360, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-04', '9ad35a3e8655dd0f5c278a786d8ce699', 1, '2022-05-04 10:35:36', '2022-05-04 10:35:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (203, '0203', 189, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-04', '9ac1d410cf33ce932161c6e73c4e6167', 1, '2022-05-04 11:21:56', '2022-05-04 11:21:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (204, '0204', 190, 397, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-04', '993fda60fef0f637485adfdd1c8de7f1', 1, '2022-05-04 11:35:07', '2022-05-04 11:35:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (205, '0205', 191, 398, '950.00', '150.00', '0.00', '0.00', '800.00', '0.00', 3, '2022-05-04', '7a3dbe5974b1dd2abca58e2b8277f76d', 1, '2022-05-04 11:46:21', '2022-05-04 11:46:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (206, '0206', 192, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-04', 'cf0cd431066420dbe99cf422e8064f1c', 1, '2022-05-04 12:13:58', '2022-05-04 12:13:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (207, '0207', 193, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-04', '3c1e1759182aee76691fbcbae418f4de', 1, '2022-05-04 12:32:17', '2022-05-04 12:32:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (208, '0208', 194, 398, '2700.00', '300.00', '0.00', '0.00', '2400.00', '0.00', 3, '2022-05-04', '73190a6380bb000fcf5431b8a508910c', 1, '2022-05-04 12:52:32', '2022-05-04 12:52:32');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (209, '0209', 195, 399, '3000.00', '250.00', '0.00', '0.00', '2750.00', '0.00', 3, '2022-05-04', 'b0ceb0ce90e48b2de66028b5d4e58411', 1, '2022-05-04 13:19:10', '2022-05-04 13:19:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (210, '0210', 196, 400, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-05', '0b084e61a96bee55c00493066f4914ac', 1, '2022-05-05 10:55:13', '2022-05-05 10:55:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (211, '0211', 197, 401, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-05', '68adc8001c0edb79b1313ffc29474acf', 1, '2022-05-05 11:07:52', '2022-05-05 11:07:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (212, '0212', 198, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-05', '1323de4a3596e74606c3ac5a7433eda8', 1, '2022-05-05 11:19:19', '2022-05-05 11:19:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (213, '0213', 199, 402, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-05', '35ac248fa6b34b1f4a411b79e5d89ed3', 1, '2022-05-05 11:32:16', '2022-05-05 11:32:16');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (214, '0214', 200, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-05', 'cf5aa0c3d0b0e337af29ac2648a83cdb', 1, '2022-05-05 11:44:11', '2022-05-05 11:44:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (215, '0215', 201, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-05', '57b8e252c94d351fabc65c84a6b2d1c5', 1, '2022-05-05 12:10:08', '2022-05-05 12:10:08');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (216, '0216', 202, 403, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-05', 'ecf365dee020db40e52d1b17340506b3', 1, '2022-05-05 12:44:38', '2022-05-05 12:44:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (217, '0217', 203, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-05', 'b679df065a1fc09d5d2b94b81b69b33b', 1, '2022-05-05 12:55:09', '2022-05-05 12:55:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (218, '0218', 204, 316, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-05', '00a4a05d9b166421642810c32b2e7cc7', 1, '2022-05-05 13:24:19', '2022-05-05 13:24:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (219, '0219', 205, 347, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-05', 'ea00f5e088f601af5eb696ed0adf5fd3', 1, '2022-05-05 13:58:03', '2022-05-05 13:58:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (220, '0220', 206, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-05', 'ff5a8b9ac04d91fafdd24b14083acd9d', 1, '2022-05-05 15:02:52', '2022-05-05 15:02:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (221, '0221', 207, 404, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-07', 'cbb05bdaaa04a46d2c3ed2ed13906b04', 1, '2022-05-07 11:02:19', '2022-05-07 11:02:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (222, '0222', 208, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-07', '7a5bdc8df74403c2cd910339685dadc4', 1, '2022-05-07 12:01:21', '2022-05-07 12:01:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (223, '0223', 209, 325, '1350.00', '0.00', '0.00', '0.00', '1350.00', '0.00', 3, '2022-05-07', '35d6a42e4ad28876d8e7c228d0d8da13', 1, '2022-05-07 12:24:05', '2022-05-07 12:24:05');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (224, '0224', 210, 388, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-07', 'bd03e525732a4712a6efdf00f08c30ca', 1, '2022-05-07 12:43:15', '2022-05-07 12:43:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (225, '0225', 211, 360, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-07', '9bca9d70636fb243a5d1ed8dbc4f546e', 1, '2022-05-07 12:51:54', '2022-05-07 12:51:54');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (226, '0226', 212, 405, '1500.00', '250.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-07', '9a3270a57118c5bfc4edc42578003024', 1, '2022-05-07 13:30:28', '2022-05-07 13:30:28');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (227, '0227', 213, 406, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-07', 'f8f1a6345594a172e89ed3852f624a89', 1, '2022-05-07 13:44:24', '2022-05-07 13:44:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (228, '0228', 214, 407, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-07', '731111954ee41441e70252aab0eb4302', 1, '2022-05-07 16:33:11', '2022-05-07 16:33:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (229, '0229', 215, 369, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-07', '16cd374e4b79fd5cbe53cd99743d5dd2', 1, '2022-05-07 17:12:02', '2022-05-07 17:12:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (230, '0230', 216, 318, '7120.00', '0.00', '0.00', '0.00', '7120.00', '0.00', 3, '2022-05-09', 'bc503f1f14f226a0f42fd97259b6355d', 1, '2022-05-09 12:11:23', '2022-05-09 12:11:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (231, '0231', 217, 35, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-09', 'bcb9d99248204bddfd42b247be9c2770', 1, '2022-05-09 12:22:29', '2022-05-09 12:22:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (232, '0232', 218, 408, '1850.00', '200.00', '0.00', '0.00', '1650.00', '0.00', 3, '2022-05-09', '4292a1f3696bc36057814cef25d2d345', 1, '2022-05-09 13:45:06', '2022-05-09 13:45:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (233, '0233', 219, 317, '3500.00', '500.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-09', 'e855a6eb923a4dcf87019ca2c6a9d8dc', 1, '2022-05-09 14:17:45', '2022-05-09 14:17:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (234, '0234', 220, 388, '3500.00', '0.00', '0.00', '0.00', '3500.00', '0.00', 3, '2022-05-09', '07a779c0ffe0415d1aa4b349443e4115', 1, '2022-05-09 14:53:34', '2022-05-09 14:53:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (235, '0235', 221, 148, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-09', '30019d0fffaebe3c0f8e54c63b9b5791', 1, '2022-05-09 15:15:34', '2022-05-09 15:15:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (236, '0236', 222, 379, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-09', 'e59deba2fc19315add86889d1f50e78c', 1, '2022-05-09 15:46:24', '2022-05-09 15:46:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (237, '0237', 223, 388, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-09', '30eaf898f9878be7ecb88565ab98e267', 1, '2022-05-09 16:42:40', '2022-05-09 16:42:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (238, '0238', 224, 409, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-11', 'd27c4af242f734e68e676f6735916a69', 1, '2022-05-11 11:32:36', '2022-05-11 11:32:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (239, '0239', 225, 410, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-11', 'd50b71d4df05c484e3c18fb867976665', 1, '2022-05-11 11:41:24', '2022-05-11 11:41:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (240, '0240', 226, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-11', '9a50ca49e2a6b56cd7cb88bb72459fff', 1, '2022-05-11 11:48:23', '2022-05-11 11:48:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (241, '0241', 227, 411, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-11', '6d8ca34567797b029552866298f0e40b', 1, '2022-05-11 12:00:20', '2022-05-11 12:00:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (242, '0242', 227, 373, '50.00', '0.00', '0.00', '0.00', '50.00', '0.00', 3, '2022-05-11', 'f0bca547e3c71aafb5c58e77f774c4fa', 1, '2022-05-11 12:03:38', '2022-05-11 12:03:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (243, '0243', 228, 388, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-11', 'df8e98719c29cda6850b7cbc8c11bbe3', 1, '2022-05-11 12:20:55', '2022-05-11 12:20:55');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (244, '0244', 6, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-11', '5dadf0f4f8d1cdf6f1676828169c8e89', 1, '2022-05-11 12:27:38', '2022-05-11 12:27:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (245, '0245', 229, 412, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-11', '9ef90358b61744b3c483c1693726bbb7', 1, '2022-05-11 12:43:57', '2022-05-11 12:43:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (246, '0246', 230, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-11', 'bec77dead363f6632b33f6d95592b486', 1, '2022-05-11 13:03:13', '2022-05-11 13:03:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (247, '0247', 231, 347, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-11', 'b386383938bfb0f725a8d2802caea785', 1, '2022-05-11 13:37:33', '2022-05-11 13:37:33');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (248, '0248', 18, 316, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-11', '839ee7fde606610df973564bc31851e2', 1, '2022-05-11 13:41:42', '2022-05-11 13:41:42');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (249, '0249', 232, 413, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-05-11', '80211e217cf6b57529eaad1226bfe00b', 1, '2022-05-11 14:09:17', '2022-05-11 14:09:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (250, '0250', 233, 414, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-11', '3ffe6157e97362e84b94b86b3870a55e', 1, '2022-05-11 14:25:36', '2022-05-11 14:25:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (251, '0251', 234, 351, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-11', '72e7ef1e52cfc20007eff8e2a602ede0', 1, '2022-05-11 14:35:27', '2022-05-11 14:35:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (252, '0252', 235, 415, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-11', '427d98021626c68c5799968de5a86539', 1, '2022-05-11 16:17:58', '2022-05-11 16:17:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (253, '0253', 236, 372, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-11', '34283a2724be6e4cc2ebecf58ff5b572', 1, '2022-05-11 16:57:43', '2022-05-11 16:57:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (254, '0254', 237, 325, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-12', '1c5209599adfc9a2a0b07964dbdcaf51', 1, '2022-05-12 11:06:22', '2022-05-12 11:06:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (255, '0255', 238, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-12', '29e3145700b8b2600b46db3cf98edb62', 1, '2022-05-12 11:15:52', '2022-05-12 11:15:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (256, '0256', 239, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-12', '3ca11f2984a44c3900c069978fc5f861', 1, '2022-05-12 12:26:21', '2022-05-12 12:26:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (257, '0257', 240, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-12', '928890272522aafd8a5a58e34f8a2e4d', 1, '2022-05-12 12:35:29', '2022-05-12 12:35:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (258, '0258', 241, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-12', '94fbdf05983d5be7f911fb71656d2eb6', 1, '2022-05-12 12:41:04', '2022-05-12 12:41:04');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (259, '0259', 242, 416, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-12', '7fd65f84c897c7918f7262421b22def6', 1, '2022-05-12 13:03:40', '2022-05-12 13:03:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (261, '0260', 244, 148, '3000.00', '250.00', '0.00', '0.00', '2750.00', '0.00', 3, '2022-05-12', '93f5b00f0d2a4496dbdc98636c3f410c', 1, '2022-05-12 13:20:06', '2022-05-12 13:20:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (262, '0261', 245, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-12', '6b8d8f9ae158a898d9ad0e37c04dadcd', 1, '2022-05-12 13:25:11', '2022-05-12 13:25:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (263, '0262', 246, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-12', '882946699b1b4c8dac6aa1dfa889fd13', 1, '2022-05-12 14:55:10', '2022-05-12 14:55:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (264, '0263', 248, 330, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-14', '3d65eea921fad78ed6404ff8284144d4', 1, '2022-05-14 12:18:34', '2022-05-14 12:18:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (265, '0264', 249, 375, '1300.00', '200.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-05-14', '156c6ee4d77fba0449b96fdc35ed3e97', 1, '2022-05-14 12:35:41', '2022-05-14 12:35:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (266, '0265', 250, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-14', '0c6b32a8d54283f767b1b1349ff492af', 1, '2022-05-14 12:43:31', '2022-05-14 12:43:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (267, '0266', 251, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-14', 'a61733ec9b1b410fa72423df9f4c7d1e', 1, '2022-05-14 13:03:21', '2022-05-14 13:03:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (268, '0267', 252, 381, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-14', '08a110223b51500556f29130bde66a14', 1, '2022-05-14 13:23:44', '2022-05-14 13:23:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (269, '0268', 253, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-14', '80a56e0656cc502080db0328b128776f', 1, '2022-05-14 13:39:27', '2022-05-14 13:39:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (270, '0269', 254, 398, '1750.00', '200.00', '0.00', '0.00', '1550.00', '0.00', 3, '2022-05-14', '17bb0fab97ac50b4c9312d766369725b', 1, '2022-05-14 15:05:58', '2022-05-14 15:05:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (271, '0270', 255, 360, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-14', 'c181605de855cfeaeea732d1d15779ad', 1, '2022-05-14 15:35:05', '2022-05-14 15:35:05');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (272, '0271', 256, 250, '2250.00', '0.00', '0.00', '0.00', '2250.00', '0.00', 3, '2022-05-16', 'd1365d59e5fd3d581010109344e2f2df', 1, '2022-05-16 07:59:56', '2022-05-16 07:59:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (273, '0272', 257, 250, '2250.00', '0.00', '0.00', '0.00', '2250.00', '0.00', 3, '2022-05-16', '1523a26ac0f8db6c7336f704d093cd3f', 1, '2022-05-16 08:39:06', '2022-05-16 08:39:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (274, '0273', 258, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-16', '53f8a7fd47a67a01c8e8eba094ad7720', 1, '2022-05-16 11:42:44', '2022-05-16 11:42:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (275, '0274', 259, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-16', '682548730f17d7bcad63421b9b4db330', 1, '2022-05-16 12:05:37', '2022-05-16 12:05:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (276, '0275', 260, 388, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-16', 'fccf888fd2bc18f3b1b212039c112375', 1, '2022-05-16 12:25:58', '2022-05-16 12:25:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (277, '0276', 261, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-16', 'f6f55934f92c143f45b24e3ba727b31e', 1, '2022-05-16 12:38:18', '2022-05-16 12:38:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (278, '0277', 262, 338, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-16', '4f2127718d5344d850d26002775d83fa', 1, '2022-05-16 12:56:06', '2022-05-16 12:56:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (279, '0278', 263, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-16', 'c7627edc6f2e6b08ccbf9556f904ab61', 1, '2022-05-16 13:03:28', '2022-05-16 13:03:28');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (280, '0279', 264, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-16', 'e1965c6c1539c15d86446564230388e1', 1, '2022-05-16 13:23:39', '2022-05-16 13:23:39');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (281, '0280', 265, 316, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-16', '92e7ac49955f2cd3fc58bc2631fa8e62', 1, '2022-05-16 13:38:00', '2022-05-16 13:38:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (282, '0281', 266, 314, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-16', 'cf2e0a5c2f3f4f416ba8751d350e7042', 1, '2022-05-16 13:51:34', '2022-05-16 13:51:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (283, '0282', 267, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-16', '99bc56120590fc635cac473cee85bf1e', 1, '2022-05-16 13:59:45', '2022-05-16 13:59:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (284, '0283', 268, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-16', 'ba5299898a3230977145f4562f7010b5', 1, '2022-05-16 14:18:32', '2022-05-16 14:18:32');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (285, '0284', 269, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-16', '1910f9a4f35f8a70a1d0b9e19e885f50', 1, '2022-05-16 15:41:18', '2022-05-16 15:41:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (286, '0285', 270, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-18', '1e199681886e76aaf67c1a4f4d74011d', 1, '2022-05-18 11:16:15', '2022-05-18 11:16:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (287, '0286', 271, 384, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-05-18', '6f558ef3ad1da4178de96b464462a6e9', 1, '2022-05-18 11:56:04', '2022-05-18 11:56:04');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (288, '0287', 272, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-18', '6beb8cddbaa7d0bab02bd773e92be50f', 1, '2022-05-18 12:05:15', '2022-05-18 12:05:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (289, '0288', 273, 102, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-18', '35dd4d69d5f1f214e3b61ac737f4e733', 1, '2022-05-18 12:13:03', '2022-05-18 12:13:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (290, '0289', 274, 417, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-18', '1da8677031d66dd74db53b5bb1e47133', 1, '2022-05-18 13:31:52', '2022-05-18 13:31:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (291, '0290', 275, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-18', '519424f8d3da80bed69ff212c3b945ce', 1, '2022-05-18 13:36:53', '2022-05-18 13:36:53');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (292, '0291', 276, 418, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-05-18', '5da157ef131fb099b18d821c4cac3907', 1, '2022-05-18 13:51:51', '2022-05-18 13:51:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (293, '0292', 277, 388, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-18', 'c34fe96d9f54fcd1b7ce6ccbf4566936', 1, '2022-05-18 14:03:54', '2022-05-18 14:03:54');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (294, '0293', 278, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-20', '63c3c2452fb71cfb15ed06320c62651c', 1, '2022-05-20 13:54:25', '2022-05-20 13:54:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (295, '0294', 279, 325, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-20', '16e6c3611998e921cef25450109c90ef', 1, '2022-05-20 14:12:50', '2022-05-20 14:12:50');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (296, '0295', 280, 407, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-20', '6a2631ef5fcce0f983cbf8f63e424b06', 1, '2022-05-20 14:23:58', '2022-05-20 14:23:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (297, '0296', 281, 62, '1850.00', '0.00', '0.00', '0.00', '1850.00', '0.00', 3, '2022-05-20', '0dbc62654961ddf8e5e3d12cdf693373', 1, '2022-05-20 15:15:16', '2022-05-20 15:15:16');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (300, '0299', 283, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-20', 'c2280200ba011e8c728fdec23a3f880c', 1, '2022-05-20 15:49:53', '2022-05-20 15:49:53');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (301, '0300', 284, 66, '2500.00', '0.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-20', 'cd7e8e81858bfd19aaf36f46b2734f71', 1, '2022-05-20 16:00:36', '2022-05-20 16:00:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (302, '0301', 285, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-20', '12c5af5f20bc3112754d6336caf78bcc', 1, '2022-05-20 16:10:41', '2022-05-20 16:10:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (303, '0302', 286, 421, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-20', '297536ea0fd9ac80c8bc9e2055880f85', 1, '2022-05-20 16:24:22', '2022-05-20 16:24:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (304, '0303', 282, 407, '3000.00', '400.00', '0.00', '0.00', '2600.00', '0.00', 3, '2022-05-20', '3ef68cdac829b942c91a6e5343b46ffa', 1, '2022-05-20 16:30:59', '2022-05-20 16:30:59');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (305, '0304', 287, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-20', 'df7273d00dc5dfed962aa9e595bec1a6', 1, '2022-05-20 16:40:25', '2022-05-20 16:40:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (306, '0305', 288, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-20', '2dc901dffee49f619f20990d22c275fd', 1, '2022-05-20 17:49:03', '2022-05-20 18:04:50');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (307, '0306', 289, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-23', '1b0963507014b3dd28875c733a69472f', 1, '2022-05-23 11:18:10', '2022-05-23 11:18:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (308, '0307', 290, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-23', '2036ddf962a8cdb255b713783999debf', 1, '2022-05-23 11:40:28', '2022-05-23 11:40:28');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (309, '0308', 291, 424, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-23', 'a2fe2c527a1098392bccc0719f6b93de', 1, '2022-05-23 12:02:48', '2022-05-23 12:02:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (310, '0309', 292, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-23', '195dc695e9dc6130499cf23756f6dd2a', 1, '2022-05-23 12:19:55', '2022-05-23 12:19:55');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (311, '0310', 293, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-23', '3acc7698016db1c35e8894b26f9d2370', 1, '2022-05-23 12:37:49', '2022-05-23 12:37:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (312, '0311', 294, 425, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-23', 'e309cadd2ec5595dc43a2d5829705229', 1, '2022-05-23 13:12:29', '2022-05-23 13:12:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (313, '0312', 295, 423, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-23', 'e4260fc7a69364ea8f89c157e954871d', 1, '2022-05-23 13:30:44', '2022-05-23 13:30:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (314, '0313', 296, 351, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-23', '832881dc46c820b8e2231467b8a1182d', 1, '2022-05-23 13:38:58', '2022-05-23 13:38:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (315, '0314', 297, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-23', 'eff0910b9cc68856ac82548984e71d3b', 1, '2022-05-23 13:47:26', '2022-05-23 13:47:26');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (316, '0315', 298, 401, '950.00', '150.00', '0.00', '0.00', '800.00', '0.00', 3, '2022-05-23', 'aca9730f337a1cb0a3f35e3b6517c956', 1, '2022-05-23 14:04:45', '2022-05-23 14:04:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (317, '0316', 299, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-23', '90ef6fcdbde61d43f739d05c09f7bc00', 1, '2022-05-23 14:25:18', '2022-05-23 14:25:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (318, '0317', 300, 360, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-23', 'ab00864a66bd8e78867bc3f92ab2c9b6', 1, '2022-05-23 14:39:29', '2022-05-23 14:39:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (319, '0318', 301, 328, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-23', 'acd059e38a3df582092317348e85ddb2', 1, '2022-05-23 14:53:23', '2022-05-23 14:53:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (320, '0319', 302, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-23', 'af3e17239c17478dd4719c99bf6daa78', 1, '2022-05-23 15:17:37', '2022-05-23 15:17:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (321, '0320', 303, 426, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-23', '9afd532578ee47f53ff03e06d71db7ee', 1, '2022-05-23 15:26:33', '2022-05-23 15:26:33');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (322, '0321', 304, 427, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-23', 'b2803d480a43a2b6b73fc83edee43362', 1, '2022-05-23 18:13:45', '2022-05-23 18:13:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (323, '0322', 305, 193, '1500.00', '250.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-23', 'f4359ce45d6c3990032dd79c650f79dc', 1, '2022-05-23 19:29:52', '2022-05-23 19:29:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (324, '0323', 306, 428, '4910.00', '410.00', '0.00', '0.00', '4500.00', '0.00', 3, '2022-05-25', '6f9cc9f94fc998f469d77e1775e14f3c', 1, '2022-05-25 10:07:02', '2022-05-25 10:07:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (325, '0324', 307, 365, '1550.00', '0.00', '0.00', '0.00', '1550.00', '0.00', 3, '2022-05-25', '5585ad29d044f175b9e3d3214033b13b', 1, '2022-05-25 12:05:10', '2022-05-25 12:05:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (326, '0325', 308, 429, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-25', 'dfe62309aa69ae396fe32a124ef82cfa', 1, '2022-05-25 12:12:38', '2022-05-25 12:12:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (327, '0326', 309, 430, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-25', 'c30dcf87d9b9eb8dae632f9c24bd1b55', 1, '2022-05-25 12:18:22', '2022-05-25 12:18:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (328, '0327', 310, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-25', '8f0ef23301048ff5280a78b645a64dca', 1, '2022-05-25 12:28:40', '2022-05-25 12:28:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (329, '0328', 311, 419, '850.00', '100.00', '0.00', '0.00', '750.00', '0.00', 3, '2022-05-25', '33d7c4b8b80cbcde10d0ad11b077ca63', 1, '2022-05-25 12:40:41', '2022-05-25 12:40:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (330, '0329', 312, 431, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-25', 'd88ea4d4ce4b6502289c1fab17d88f21', 1, '2022-05-25 12:51:46', '2022-05-25 12:51:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (331, '0330', 78, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-25', '01b20e290bfa9d0f90cfd9b2a427b1fe', 1, '2022-05-25 12:55:01', '2022-05-25 12:55:01');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (332, '0331', 313, 148, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-25', '8e256a1f4583a2c859dee23bdafb4d58', 1, '2022-05-25 12:58:47', '2022-05-25 12:58:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (333, '0332', 314, 148, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-25', 'feae3470af3fb63caa36459963c1532a', 1, '2022-05-25 13:06:46', '2022-05-25 13:06:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (334, '0333', 315, 148, '100.00', '20.00', '0.00', '0.00', '80.00', '0.00', 3, '2022-05-25', '48c7a902e7dc6b4419ac56b77afc1160', 1, '2022-05-25 13:15:08', '2022-05-25 13:15:08');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (335, '0334', 316, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-25', 'cfb0628e4251a87d4188efd8cd77366c', 1, '2022-05-25 13:27:50', '2022-05-25 13:27:50');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (336, '0335', 317, 417, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-25', '4b38483bcbaf97f14c1a332629ed303a', 1, '2022-05-25 13:46:18', '2022-05-25 13:46:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (337, '0336', 314, 432, '2830.00', '0.00', '0.00', '0.00', '2830.00', '0.00', 3, '2022-05-25', 'ce80a0075868d08b8a4f9c1b90926240', 1, '2022-05-25 14:54:48', '2022-05-26 13:23:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (338, '0337', 314, 430, '1500.00', '250.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-05-25', '025a620bc1121fdda34aa92bbf7c0d43', 1, '2022-05-25 15:16:56', '2022-05-26 13:23:59');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (339, '0338', 318, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-25', '2f9c077d2dde782e9306168aa8ba8223', 1, '2022-05-25 15:45:52', '2022-05-25 15:45:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (340, '0339', 319, 433, '930.00', '0.00', '0.00', '0.00', '930.00', '0.00', 3, '2022-05-27', '67d016e2b86d6e365ec4a0d0f247560b', 1, '2022-05-27 10:09:11', '2022-05-27 10:09:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (341, '0340', 320, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-27', '91972a9b0982fd77363411e14e00e978', 1, '2022-05-27 11:25:00', '2022-05-27 11:25:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (342, '0341', 321, 388, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-27', '8c84be44732c9a8b2096a15a0b355b20', 1, '2022-05-27 11:38:49', '2022-05-27 11:38:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (343, '0342', 69, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-27', '84beedc4a1cc9664c5a3f21f03b0b142', 1, '2022-05-27 11:43:22', '2022-05-27 11:43:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (344, '0343', 322, 359, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-27', 'cd7e96ec58e61a26211e63459ac7fba6', 1, '2022-05-27 11:54:43', '2022-05-27 11:54:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (345, '0344', 323, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-27', 'c26bc3d0ff30a96d76708ea41f7ec2cb', 1, '2022-05-27 12:15:59', '2022-05-27 12:15:59');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (346, '0345', 324, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-27', '009f2a5f3b939aaec8dc2bee8c7233db', 1, '2022-05-27 12:23:19', '2022-05-27 12:23:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (347, '0346', 325, 417, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-27', 'be40a5732f24931507a5fcb397860b29', 1, '2022-05-27 12:48:06', '2022-05-27 12:48:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (348, '0347', 326, 388, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-27', '9e18354a1052f2191a3a6319bc7fe79d', 1, '2022-05-27 12:52:26', '2022-05-27 12:52:26');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (349, '0348', 327, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-27', 'f8a954699a667b9a04234a8bb7679fa3', 1, '2022-05-27 13:01:53', '2022-05-27 13:01:53');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (350, '0349', 328, 35, '1500.00', '0.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-05-27', '30680a91b01a41fa487f9161fb035be6', 1, '2022-05-27 13:09:47', '2022-05-27 13:09:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (351, '0350', 329, 417, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-27', '41789423827637562f0c12bd6e5b3584', 1, '2022-05-27 13:15:06', '2022-05-27 13:15:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (352, '0351', 330, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-27', '4881662c6a24e9d60ae751260c3f4271', 1, '2022-05-27 14:14:10', '2022-05-27 14:14:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (353, '0352', 331, 434, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-27', '8e81928fdbca13324e053460e4d82e36', 1, '2022-05-27 14:37:31', '2022-05-27 14:37:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (354, '0353', 332, 435, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-27', 'c077ee39321f16c5e7af711bbabe175e', 1, '2022-05-27 15:08:57', '2022-05-27 15:08:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (355, '0354', 333, 436, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-27', '2bef4deebb126ef622f4ce5dc4b26870', 1, '2022-05-27 17:43:41', '2022-05-27 17:43:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (356, '0355', 334, 417, '3000.00', '150.00', '0.00', '0.00', '2850.00', '0.00', 3, '2022-05-27', 'ade9c623e4e661e1242d4f44fbd65cc6', 1, '2022-05-27 18:11:52', '2022-05-27 18:11:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (357, '0356', 335, 366, '260.00', '0.00', '0.00', '0.00', '260.00', '0.00', 3, '2022-05-28', '0a6828753d5249b3b444dc424fdb1947', 1, '2022-05-28 10:44:59', '2022-05-28 10:44:59');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (358, '0357', 336, 437, '250.00', '0.00', '0.00', '0.00', '250.00', '0.00', 3, '2022-05-28', 'a9bcf19cd3ee829b3849c05a8ce85d58', 1, '2022-05-28 11:45:56', '2022-05-28 11:45:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (359, '0358', 337, 438, '2250.00', '50.00', '0.00', '0.00', '2200.00', '0.00', 3, '2022-05-30', 'e7d17fe2413bfefd79e9d51b00219ab8', 1, '2022-05-30 11:30:56', '2022-05-30 11:30:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (360, '0359', 87, 347, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-30', '136f7bf7b4b00bcf40c66af768dff632', 1, '2022-05-30 11:40:34', '2022-05-30 11:40:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (361, '0360', 139, 316, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-30', '5d3b7a79905d3e2b0148a46e9f92aca3', 1, '2022-05-30 11:57:44', '2022-05-30 11:57:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (362, '0361', 338, 439, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-30', '9b63335111bb4fab38d6168d6874ec2b', 1, '2022-05-30 12:09:42', '2022-05-30 12:09:42');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (363, '0362', 339, 381, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-30', '92e41bdddacbb434798e0d0ade8bbf63', 1, '2022-05-30 12:23:22', '2022-05-30 12:23:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (364, '0363', 340, 384, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-30', '35be42d7bdb0e8205443a802f316bec4', 1, '2022-05-30 12:40:27', '2022-05-30 12:40:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (365, '0364', 341, 440, '1070.00', '0.00', '0.00', '0.00', '1070.00', '0.00', 3, '2022-05-30', '8944d3f0008816d88749f600b976b037', 1, '2022-05-30 13:00:58', '2022-05-30 13:00:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (366, '0365', 342, 441, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-30', 'e4cff859d189a4f0e88bfca29500a99e', 1, '2022-05-30 13:10:29', '2022-05-30 13:10:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (367, '0366', 343, 442, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-30', '55f387d4b7f2ec08c1712f8252870fc9', 1, '2022-05-30 13:20:41', '2022-05-30 13:20:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (368, '0367', 344, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-30', '20548fdb6b0adbedb58eac99d4899454', 1, '2022-05-30 13:34:16', '2022-05-30 13:34:16');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (369, '0368', 345, 443, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-30', 'f41f668488e5baee30d6a2918151a841', 1, '2022-05-30 13:52:44', '2022-05-30 13:52:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (370, '0369', 346, 444, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-30', '8f115d44dcc4217b5277e06cd760c4a4', 1, '2022-05-30 14:03:43', '2022-05-30 14:03:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (371, '0370', 347, 442, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-30', '691115ccb0eff240e3172ed29dd5d468', 1, '2022-05-30 14:19:00', '2022-05-30 14:19:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (372, '0371', 348, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-30', '21b0a4102767b47b3d7e492296ce4a96', 1, '2022-05-30 14:48:50', '2022-05-30 14:48:50');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (373, '0372', 153, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-30', 'bc377b5fa1517de13051140d5fefb1be', 1, '2022-05-30 14:54:00', '2022-05-30 14:54:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (374, '0373', 349, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-30', '11fffba7ed11822b10c77a862367016b', 1, '2022-05-30 14:59:21', '2022-05-30 14:59:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (375, '0374', 350, 445, '1070.00', '0.00', '0.00', '0.00', '1070.00', '0.00', 3, '2022-05-30', '6dc01993df6a9af6f10930157f433ff7', 1, '2022-05-30 15:05:54', '2022-05-30 15:05:54');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (376, '0375', 351, 419, '850.00', '100.00', '0.00', '0.00', '750.00', '0.00', 3, '2022-05-30', 'f48e332070ed5d5c78e03015f376eed8', 1, '2022-05-30 17:34:20', '2022-05-30 17:34:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (377, '0376', 352, 381, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-31', '4cc553a8ea47ed0bd309aac3468f613d', 1, '2022-05-31 12:12:48', '2022-05-31 12:12:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (378, '0377', 353, 446, '970.00', '0.00', '0.00', '0.00', '970.00', '0.00', 3, '2022-05-31', '3027f020fc6f83e201a0a5e4e1a92716', 1, '2022-05-31 12:25:20', '2022-05-31 12:25:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (379, '0378', 354, 360, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-05-31', '95603a2725fbbfd9b67a1e669f674f7d', 1, '2022-05-31 12:36:04', '2022-05-31 12:36:04');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (380, '0379', 355, 425, '3350.00', '0.00', '0.00', '0.00', '3350.00', '0.00', 3, '2022-05-31', 'a158917facc2ccbf014500929a2607ca', 1, '2022-05-31 12:57:11', '2022-05-31 12:57:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (381, '0380', 356, 412, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-05-31', '5c9f33983733823a62add0290bfcd402', 1, '2022-05-31 13:07:33', '2022-05-31 13:07:33');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (382, '0381', 357, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-05-31', 'a4578ab86245600986e9a78ed0fa8b2f', 1, '2022-05-31 13:18:46', '2022-05-31 13:18:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (383, '0382', 358, 442, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-31', '3b51037c1f17889567c348c0921fdb12', 1, '2022-05-31 13:35:45', '2022-05-31 13:35:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (384, '0383', 359, 417, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-31', '4ecba885588bd0837b4fd84217e792ec', 1, '2022-05-31 13:48:47', '2022-05-31 13:48:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (385, '0384', 360, 417, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-05-31', 'd12d3a89f2a3413afeabadcc3119f3fa', 1, '2022-05-31 14:00:35', '2022-05-31 14:00:35');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (386, '0385', 361, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-05-31', 'b6a377eb7cdf9e66aede73e790106a28', 1, '2022-05-31 14:14:05', '2022-05-31 14:14:05');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (387, '0386', 362, 398, '950.00', '150.00', '0.00', '0.00', '800.00', '0.00', 3, '2022-05-31', '830422cdf9c45b9445236b5b2b15015b', 1, '2022-05-31 14:26:47', '2022-05-31 14:26:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (388, '0387', 363, 388, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-05-31', '4a483342c9335e43a6b30aff4517c874', 1, '2022-05-31 14:34:13', '2022-05-31 14:34:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (389, '0388', 364, 417, '3350.00', '0.00', '0.00', '0.00', '3350.00', '0.00', 3, '2022-05-31', 'cc84ffb90a5adfa41440d5601def8c71', 1, '2022-05-31 14:43:16', '2022-05-31 14:43:16');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (390, '0389', 133, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-02', 'd7eabaccb1bacda11585412727edd23b', 1, '2022-06-02 11:39:11', '2022-06-02 11:39:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (391, '0390', 365, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-02', 'acdfa05b2e3775ed333ba15f8d0bdbde', 1, '2022-06-02 12:18:44', '2022-06-02 12:18:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (392, '0391', 366, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-02', 'bf4bcf5ce9b33a5b7fa50c377d1a9673', 1, '2022-06-02 12:34:45', '2022-06-02 12:34:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (393, '0392', 367, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-06-02', 'b1c9cac714997cdd64b1f9d48f1b4ec7', 1, '2022-06-02 12:50:19', '2022-06-02 12:50:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (394, '0393', 368, 448, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-02', 'af0cf5174acd4be3743f3a5275e9878d', 1, '2022-06-02 13:06:43', '2022-06-02 13:06:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (395, '0394', 369, 352, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-02', '7f2d960fcc4d81e236bc2b0d00e0f8c6', 1, '2022-06-02 13:16:54', '2022-06-02 13:16:54');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (396, '0395', 370, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-02', '56af5502abb092e50fa0029cf3f73822', 1, '2022-06-02 13:27:00', '2022-06-02 13:27:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (397, '0396', 371, 449, '2640.00', '0.00', '0.00', '0.00', '2640.00', '0.00', 3, '2022-06-02', 'eb5c832eec720deb66cd18fc508f70d0', 1, '2022-06-02 14:18:02', '2022-06-02 14:18:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (398, '0397', 372, 449, '1500.00', '0.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-06-02', 'bf2f1604544612f9ab3369cb2b256599', 1, '2022-06-02 14:27:34', '2022-06-02 14:27:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (399, '0398', 373, 388, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-02', '4d6a7b7233f4cbba0ec5b8e45c3ac8af', 1, '2022-06-02 14:43:10', '2022-06-02 14:43:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (400, '0399', 319, 318, '1650.00', '0.00', '0.00', '0.00', '1650.00', '0.00', 3, '2022-06-02', '4db392c5b9b28b17917ca2e905add008', 1, '2022-06-02 14:55:59', '2022-06-02 14:55:59');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (401, '0400', 134, 317, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-02', '6a13abbb4e56470be344b7356647b4d2', 1, '2022-06-02 15:02:51', '2022-06-02 15:02:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (402, '0401', 374, 329, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-02', 'b4f5e2c70337eeccb77420a294fcf7d2', 1, '2022-06-02 15:59:14', '2022-06-02 15:59:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (403, '0402', 375, 360, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-02', '5387b0b3c9ca16cb2344d4999e39d54c', 1, '2022-06-02 16:35:28', '2022-06-02 16:35:28');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (404, '0403', 376, 450, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-06-04', '1ad00b41f0082aa150b836a61fd48a75', 1, '2022-06-04 12:03:50', '2022-06-04 12:03:50');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (405, '0404', 377, 351, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-04', 'ff27ef6432d8f8774f8f28719dae3a76', 1, '2022-06-04 12:41:38', '2022-06-04 12:41:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (406, '0405', 378, 398, '1940.00', '200.00', '0.00', '0.00', '1740.00', '0.00', 3, '2022-06-04', '896ae94219259beadeb4a4d60b530e38', 1, '2022-06-04 12:44:39', '2022-06-04 12:44:39');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (407, '0406', 379, 316, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-04', 'd4daa787779ad4056f9f89097b805f52', 1, '2022-06-04 12:52:13', '2022-06-04 12:52:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (408, '0407', 380, 316, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-04', 'c5bfabfe5c56f29c7b3be2ecc3dcbe3f', 1, '2022-06-04 13:14:20', '2022-06-04 13:14:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (409, '0408', 381, 451, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-04', 'c4ac1adc9fd56145af5484e7afe2d143', 1, '2022-06-04 13:40:49', '2022-06-04 13:40:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (410, '0409', 382, 449, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-04', '1f6880cfd99ebf0f0cf3f518c02c7e17', 1, '2022-06-04 14:02:14', '2022-06-04 14:02:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (411, '0410', 383, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-04', 'a1457b12b8fae4514e7b1c41abc18ea7', 1, '2022-06-04 14:05:45', '2022-06-04 14:05:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (412, '0411', 384, 362, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-04', '321974b48961530dae1ea6db7cbbeb65', 1, '2022-06-04 15:22:24', '2022-06-04 15:22:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (413, '0412', 385, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-04', '0aa606e0d2afdca033a942d6adb37ecb', 1, '2022-06-04 15:27:22', '2022-06-04 15:27:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (414, '0413', 386, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-04', '89c75dfa430bb0ec4b061158221d8ec2', 1, '2022-06-04 16:06:50', '2022-06-04 16:06:50');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (415, '0414', 387, 148, '2500.00', '200.00', '0.00', '0.00', '2300.00', '0.00', 3, '2022-06-04', 'c297b4b96806bc216889d8996230a45b', 1, '2022-06-04 16:36:30', '2022-06-04 16:36:30');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (416, '0415', 388, 398, '950.00', '150.00', '0.00', '0.00', '800.00', '0.00', 3, '2022-06-04', '249a9b11b2f1e9bd6e0a17142d515c2f', 1, '2022-06-04 16:42:48', '2022-06-04 16:42:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (417, '0416', 389, 449, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-06-04', 'bc18fee92c76ddc38fc53b5fc2f1b0b6', 1, '2022-06-04 18:20:10', '2022-06-04 18:20:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (418, '0417', 390, 388, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-06', 'e7813befc753315268a6a5104079b904', 1, '2022-06-06 12:24:57', '2022-06-06 12:24:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (419, '0418', 391, 342, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-06', '14348580e740508c904c84f8c57bdcfb', 1, '2022-06-06 12:36:57', '2022-06-06 12:36:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (420, '0419', 392, 439, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-06', '1d151a49aadd652bea8b27a354bb70f3', 1, '2022-06-06 12:40:56', '2022-06-06 12:40:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (421, '0420', 393, 329, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-06', '55db2d967a3bef4e8dd1521e19a00834', 1, '2022-06-06 12:46:17', '2022-06-06 12:46:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (422, '0421', 394, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-06', 'ef479a0026a31a9dbd4076beba887e51', 1, '2022-06-06 12:52:31', '2022-06-06 12:52:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (423, '0422', 395, 397, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-06', '6d7ece01b21fce9aebc91e78492737bd', 1, '2022-06-06 12:59:47', '2022-06-06 12:59:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (424, '0423', 396, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-06', '333e6381f9edc778374ed83a44711def', 1, '2022-06-06 14:36:52', '2022-06-06 14:36:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (425, '0424', 397, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-06', '7cdd481148df467fd9acda1506039cf8', 1, '2022-06-06 14:48:03', '2022-06-06 14:48:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (426, '0425', 184, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-06', '11b876030583655994b86a482b6bc03a', 1, '2022-06-06 14:53:38', '2022-06-06 14:53:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (427, '0426', 398, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-06', '5ec4dd3f6495f41c7fda44a8b6f93d0b', 1, '2022-06-06 15:00:54', '2022-06-06 15:00:54');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (429, '0427', 399, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-06', '9d5e103504f4bb04d7e0076cf6d6b009', 1, '2022-06-06 15:10:09', '2022-06-06 15:10:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (430, '0428', 400, 394, '1950.00', '0.00', '0.00', '0.00', '1950.00', '0.00', 3, '2022-06-06', '7688d530b50192a3addc505d62ee3e21', 1, '2022-06-06 15:18:05', '2022-06-06 15:18:05');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (431, '0429', 401, 176, '50.00', '20.00', '0.00', '0.00', '30.00', '0.00', 3, '2022-06-06', '935df4e9a50f9559d149db1e2c1d0d11', 1, '2022-06-06 15:58:41', '2022-06-06 15:58:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (432, '0430', 402, 442, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-06', '3f6114e23fe68367a005eb8715fdbe7e', 1, '2022-06-06 17:43:11', '2022-06-06 17:43:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (433, '0431', 403, 379, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-06', 'bc42a251a3680158cacd5cfcfaff9a91', 1, '2022-06-06 17:49:17', '2022-06-06 17:49:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (434, '0432', 404, 452, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-06', 'f88b4bda86cfb68a9ac81a1e74e44312', 1, '2022-06-06 18:28:53', '2022-06-06 18:28:53');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (435, '0433', 405, 360, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-08', 'e8d832b81cd704604330e085f45fcbdd', 1, '2022-06-08 10:33:52', '2022-06-08 10:33:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (436, '0434', 406, 453, '3380.00', '0.00', '0.00', '0.00', '3380.00', '0.00', 3, '2022-06-08', 'f82a985e99164dd4214ea21fef254c70', 1, '2022-06-08 10:49:24', '2022-06-08 10:49:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (437, '0435', 407, 454, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-08', '88a924d56eee70b882ffb566e9b1ffa2', 1, '2022-06-08 12:27:44', '2022-06-08 12:27:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (438, '0436', 408, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-08', 'f56f81ee9a756b5cc032591748a71496', 1, '2022-06-08 12:48:53', '2022-06-08 12:48:53');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (439, '0437', 409, 398, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-08', '3fb56a5d91d3aadf0bcb50d40a8413cb', 1, '2022-06-08 13:10:44', '2022-06-08 13:10:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (440, '0438', 410, 455, '1850.00', '0.00', '0.00', '0.00', '1850.00', '0.00', 3, '2022-06-08', '99fa814a5425c6466ca324ea3bb7a42b', 1, '2022-06-08 13:22:36', '2022-06-08 13:22:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (441, '0439', 280, 407, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-08', '1818c27561d743eca410b9d68f7350be', 1, '2022-06-08 13:30:46', '2022-06-08 13:30:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (442, '0440', 411, 456, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-08', '40f22e4df6d9e743fde54b88fc28d688', 1, '2022-06-08 13:45:46', '2022-06-08 13:45:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (443, '0441', 201, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-08', '2238e02ea5ee195c1c512ad7ae806937', 1, '2022-06-08 14:10:15', '2022-06-08 14:10:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (444, '0442', 412, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-08', '6a80487426df10238cebc28320879b5d', 1, '2022-06-08 14:23:02', '2022-06-08 14:23:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (445, '0443', 413, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-08', 'b1bbf861437db5249fe11915643c96f6', 1, '2022-06-08 14:31:09', '2022-06-08 14:31:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (446, '0444', 414, 148, '950.00', '300.00', '0.00', '0.00', '650.00', '0.00', 3, '2022-06-08', '0e59dd7f56cb78c432b4ec894bf6bb0b', 1, '2022-06-08 14:36:18', '2022-06-08 14:36:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (447, '0445', 405, 360, '120.00', '0.00', '0.00', '0.00', '120.00', '0.00', 3, '2022-06-08', 'c04b3a678f3e91d279ef21a2b470b89c', 1, '2022-06-08 15:07:44', '2022-06-08 15:07:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (448, '0446', 415, 379, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-08', 'b4e0c6ce64d62d626e9037575ea204db', 1, '2022-06-08 15:43:25', '2022-06-08 15:43:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (449, '0447', 416, 425, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-08', '56db3485084a185e126f14ace65dd551', 1, '2022-06-08 16:29:52', '2022-06-08 16:29:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (450, '0448', 417, 347, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-09', '307935b64e64ac67a7d7e28148c2f0c3', 1, '2022-06-09 11:55:22', '2022-06-09 11:55:22');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (451, '0449', 418, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-09', '991229363d9c00b8f93b50b8154f7c45', 1, '2022-06-09 13:33:13', '2022-06-09 13:33:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (452, '0450', 419, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-09', 'c0779f8b04512ad9bb3f67db6b09310d', 1, '2022-06-09 13:56:48', '2022-06-09 13:56:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (453, '0451', 420, 379, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-09', 'c6f62f764c0370ce5ddeb5cafe22eb1a', 1, '2022-06-09 14:12:14', '2022-06-09 14:12:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (454, '0452', 421, 449, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-09', 'fbd0a9253757ade3987c8d7cfd61bec7', 1, '2022-06-09 14:20:25', '2022-06-09 14:20:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (455, '0453', 187, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-09', 'ace60f3d8864d51547d1341f7ba82d81', 1, '2022-06-09 14:25:49', '2022-06-09 14:25:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (456, '0454', 422, 331, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-09', '33ae0c8c6649e80a791a31b03d333ffa', 1, '2022-06-09 14:54:17', '2022-06-09 14:54:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (457, '0455', 189, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-09', 'c353cac284c3736fc55fae57f5f07c47', 1, '2022-06-09 15:17:27', '2022-06-09 15:17:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (458, '0456', 423, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-09', 'a8bc296860de179a963df5370c348580', 1, '2022-06-09 15:37:33', '2022-06-09 15:37:33');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (459, '0457', 424, 347, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-09', 'fcb75302cf499fd17cbcaae425137855', 1, '2022-06-09 15:53:48', '2022-06-09 15:53:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (460, '0458', 425, 457, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-09', '776b81d7523da977e9d9520b11dc5b92', 1, '2022-06-09 16:04:07', '2022-06-09 16:04:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (461, '0459', 426, 388, '1500.00', '150.00', '0.00', '0.00', '1350.00', '0.00', 3, '2022-06-09', '759de8e0e1ca611ea5c834ad31b15ed0', 1, '2022-06-09 16:11:40', '2022-06-09 16:11:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (462, '0460', 427, 458, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-09', '9151047756c790a9ba4f00ee946bc164', 1, '2022-06-09 16:50:31', '2022-06-09 16:50:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (463, '0461', 428, 448, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-09', '51da2e125c790befedd12f77ece8d4e6', 1, '2022-06-09 17:10:29', '2022-06-09 17:10:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (464, '0462', 429, 459, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-09', '7061267f5949af41cb7b810682b48ba4', 1, '2022-06-09 18:27:49', '2022-06-09 18:27:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (465, '0463', 430, 461, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-11', '04f57b88c455a1d09a5f371197c573bb', 1, '2022-06-11 11:31:18', '2022-06-11 11:31:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (466, '0464', 430, 461, '390.00', '0.00', '0.00', '0.00', '390.00', '0.00', 3, '2022-06-11', '28026e4d2533caf7189432a739c37b26', 1, '2022-06-11 11:40:23', '2022-06-11 11:40:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (467, '0465', 431, 462, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-11', 'b5f1be419019d90829a44e69b2495fe7', 1, '2022-06-11 11:54:07', '2022-06-11 11:54:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (468, '0466', 213, 354, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-11', '996870adb6e80bbdfaf94fddfabd74e1', 1, '2022-06-11 12:19:05', '2022-06-11 12:19:05');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (469, '0467', 195, 399, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-11', '27a414b97f5f3834d1669c8a269ed7ab', 1, '2022-06-11 13:13:15', '2022-06-11 13:13:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (470, '0468', 432, 463, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-11', 'dd3a12e36429d9af4aee10c452ecc0be', 1, '2022-06-11 13:33:15', '2022-06-11 13:33:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (471, '0469', 161, 331, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-11', 'dec3daaa2d271da571a03a3dda8abc41', 1, '2022-06-11 13:40:40', '2022-06-11 13:40:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (472, '0470', 433, 412, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-11', '4c0166ab9a20b7fef0cb407c86d60200', 1, '2022-06-11 14:12:23', '2022-06-11 14:12:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (473, '0471', 434, 417, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-11', '4b3f2ffedb8814fdf83f88012c64a63d', 1, '2022-06-11 15:20:23', '2022-06-11 15:20:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (474, '0472', 435, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-11', 'fcf7a5ca6a56737cdd179a4b9eb6c045', 1, '2022-06-11 15:44:55', '2022-06-11 15:44:55');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (475, '0473', 436, 449, '950.00', '150.00', '0.00', '0.00', '800.00', '0.00', 3, '2022-06-11', 'f09ace07eff18ad287892aa0f248e9b7', 1, '2022-06-11 16:53:58', '2022-06-11 16:53:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (476, '0474', 437, 347, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-06-13', 'c23107b43feedd18c7a66f9eb80426f0', 1, '2022-06-13 12:44:02', '2022-06-13 17:02:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (477, '0475', 438, 464, '1350.00', '0.00', '0.00', '0.00', '1350.00', '0.00', 3, '2022-06-13', 'b6b175b32068c95e70841015af836436', 1, '2022-06-13 13:14:21', '2022-06-13 17:03:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (478, '0476', 26, 433, '1940.00', '0.00', '0.00', '0.00', '1940.00', '0.00', 3, '2022-06-13', 'fd6dbec1abbd6fa98f905f2da508da8d', 1, '2022-06-13 13:24:07', '2022-06-13 13:24:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (479, '0477', 438, 464, '450.00', '0.00', '0.00', '0.00', '450.00', '0.00', 3, '2022-06-13', 'bba2db7c5b7cbaf17bc907cd0c483743', 1, '2022-06-13 13:35:36', '2022-06-13 13:35:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (480, '0478', 439, 342, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-13', '1b5da9ff7206d59bacb57779e368953d', 1, '2022-06-13 13:43:17', '2022-06-14 12:46:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (481, '0479', 440, 449, '1500.00', '0.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-06-13', '38a16c22f1bde50fbe24a5c74c3f8af8', 1, '2022-06-13 14:09:24', '2022-06-13 14:09:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (482, '0480', 441, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-13', '2d42c5c345032779be0a6f073db83969', 1, '2022-06-13 14:18:17', '2022-06-13 14:18:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (483, '0481', 442, 347, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-13', '4910724130f8ab2c98f56558df7c2e14', 1, '2022-06-13 14:31:14', '2022-06-13 14:31:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (484, '0482', 443, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-06-13', '563573c527860c21e19b59534c97a1f7', 1, '2022-06-13 14:43:45', '2022-06-13 14:43:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (485, '0483', 444, 417, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-13', '4af2c652340521b3db2772da758bbd92', 1, '2022-06-13 15:00:56', '2022-06-13 15:00:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (486, '0484', 240, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-13', 'b91443d3ed1cf597bd216f38e7dbeb1c', 1, '2022-06-13 15:05:52', '2022-06-13 15:05:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (487, '0485', 445, 158, '1500.00', '0.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-06-13', '7b329ab85a8992c672fbdb3efeda92e9', 1, '2022-06-13 15:15:05', '2022-06-16 18:54:24');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (488, '0486', 446, 439, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-13', '0fd66e54b599ce4f221de98f57c55952', 1, '2022-06-13 15:24:40', '2022-06-13 15:24:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (489, '0487', 447, 331, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-13', 'da514ddaabe854648cd269b77ae5667c', 1, '2022-06-13 15:31:05', '2022-06-13 15:31:05');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (490, '0488', 448, 439, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-13', '97affa1acfb81d23af1441634ddb4ed2', 1, '2022-06-13 15:58:32', '2022-06-13 15:58:32');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (491, '0489', 449, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-13', '9a960f845d2d6f979368a71ec87bca6e', 1, '2022-06-13 16:27:40', '2022-06-13 16:27:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (492, '0490', 450, 329, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-13', 'bbae4ca29391bf6c3f2a1aeb2bcb60cf', 1, '2022-06-13 16:43:38', '2022-06-13 16:43:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (493, '0491', 451, 399, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-06-13', '28a03b9339282d62f29f326abe34b536', 1, '2022-06-13 16:50:52', '2022-06-13 16:50:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (494, '0492', 174, 41, '3350.00', '0.00', '0.00', '0.00', '3350.00', '0.00', 3, '2022-06-13', '085f473999b27d74d0881fd238b66fe2', 1, '2022-06-13 18:30:12', '2022-06-13 18:30:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (495, '0493', 452, 442, '1500.00', '0.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-06-13', '676f8c4e46777b3b89ef84166dbee6f6', 1, '2022-06-13 19:49:07', '2022-06-13 19:49:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (496, '0494', 453, 347, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-14', '76df098ef12a7f8f4ca64f7c11b77a48', 1, '2022-06-14 14:06:22', '2022-06-15 13:19:53');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (497, '0495', 438, 148, '400.00', '0.00', '0.00', '0.00', '400.00', '0.00', 3, '2022-06-15', '13159c5aeaeec34f1ba85e7448c1ce31', 1, '2022-06-15 13:12:21', '2022-06-15 13:12:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (498, '0496', 454, 398, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-15', '1d91c85aa2270c7a05b9ac0cf44c3fba', 1, '2022-06-15 13:33:09', '2022-06-15 13:33:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (499, '0497', 455, 148, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-15', '6cdd2d2f74488d548d3eb6825a67d500', 1, '2022-06-15 13:45:52', '2022-06-15 13:45:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (500, '0498', 241, 66, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-15', '3668170a6e417d54ed3eeb1877e25b2e', 1, '2022-06-15 13:55:28', '2022-06-15 13:55:28');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (501, '0499', 456, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-15', 'a4431f8f09b3a2c422f21a8ba439cf7d', 1, '2022-06-15 14:19:10', '2022-06-15 14:19:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (502, '0500', 457, 380, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-15', '825699feb7b1065ed9270cc7de22545a', 1, '2022-06-15 14:37:56', '2022-06-15 14:37:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (503, '0501', 458, 449, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-15', '1f0634c7b76f6dced40a22e1946bb755', 1, '2022-06-15 14:46:47', '2022-06-15 14:46:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (504, '0502', 459, 317, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-06-15', '1174f8d22bc4b16abd6e4b9f18c0989c', 1, '2022-06-15 14:53:45', '2022-06-15 14:53:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (505, '0503', 460, 366, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-06-15', '17524bd623a5c323f48857f41048b2f2', 1, '2022-06-15 15:07:10', '2022-06-15 15:07:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (506, '0504', 461, 317, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-15', '7c15844af66661dabf7c1cf5e2324923', 1, '2022-06-15 15:17:43', '2022-06-15 15:17:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (507, '0505', 462, 465, '1500.00', '250.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-06-15', '888c1618227c4c32c5192d48b721eae2', 1, '2022-06-15 17:18:08', '2022-06-15 17:18:08');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (508, '0506', 463, 449, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-15', '8109830cd2f353513665bffe5c40d5c3', 1, '2022-06-15 17:44:58', '2022-06-15 17:44:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (509, '0507', 464, 362, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-16', '4143983f61173ea8923161df55bdbb55', 1, '2022-06-16 10:05:21', '2022-06-16 10:05:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (510, '0508', 465, 66, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-06-16', '3e68a89f26d679ef7c851f8ebf3ab1e2', 1, '2022-06-16 11:06:29', '2022-06-16 11:06:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (511, '0509', 466, 316, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-16', '0f217cee87987a1241fa198a85ba8a0a', 1, '2022-06-16 11:20:19', '2022-06-16 11:20:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (512, '0510', 467, 347, '3000.00', '300.00', '0.00', '0.00', '2700.00', '0.00', 3, '2022-06-16', 'b71229689091d60c2af9a77018eba1f0', 1, '2022-06-16 12:31:18', '2022-06-16 19:36:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (513, '0511', 468, 148, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-16', 'd875f689d4e26414b75583be3d382be6', 1, '2022-06-16 12:38:32', '2022-06-16 12:38:32');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (514, '0512', 469, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-16', '9b561d30149ca3a09fdb97df29867e28', 1, '2022-06-16 14:14:14', '2022-06-16 14:14:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (515, '0513', 470, 466, '3350.00', '150.00', '0.00', '0.00', '3200.00', '0.00', 3, '2022-06-16', 'aa5f30ba8391c349c3fbbe64d2802943', 1, '2022-06-16 14:27:58', '2022-06-16 19:59:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (516, '0514', 229, 412, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-06-16', '60a6b73dfe3076e0e8a370c8d6d6a144', 1, '2022-06-16 14:30:44', '2022-06-16 14:49:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (517, '0515', 471, 399, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-16', 'ac166e5ab20d7cd9f7290c32790df402', 1, '2022-06-16 14:55:01', '2022-06-16 14:55:01');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (518, '0516', 472, 467, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-16', 'eab31ffc504c88e54bd55a2d9ca275d0', 1, '2022-06-16 15:17:31', '2022-06-16 15:17:31');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (519, '0517', 473, 468, '3000.00', '500.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-06-16', '09a4baad264341393a35ed4694f05b13', 1, '2022-06-16 16:48:19', '2022-06-16 16:48:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (520, '0518', 474, 469, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-06-16', 'e0aca4de81336a1438b96ec0e02edf31', 1, '2022-06-16 16:55:44', '2022-06-16 16:55:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (521, '0519', 475, 470, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-16', 'e20cb4cb15393e847985bd28693103a5', 1, '2022-06-16 17:38:57', '2022-06-16 17:38:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (522, '0520', 476, 449, '1680.00', '0.00', '0.00', '0.00', '1680.00', '0.00', 3, '2022-06-17', 'bb777b3bd97a95a3befebab31264546a', 1, '2022-06-17 12:32:02', '2022-06-17 12:32:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (523, '0521', 477, 325, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-18', '95ceb4d5216b349fcc23c71381c7e441', 1, '2022-06-18 13:08:14', '2022-06-18 13:08:14');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (524, '0522', 478, 347, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-06-18', 'dfc7c9c53db7ffa02d0505cbd48b7d55', 1, '2022-06-18 13:24:46', '2022-06-18 13:24:46');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (525, '0523', 479, 471, '3350.00', '0.00', '0.00', '0.00', '3350.00', '0.00', 3, '2022-06-18', '0b187bbb8fc6942cf303c78b1428e8e2', 1, '2022-06-18 13:33:45', '2022-06-18 13:33:45');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (526, '0524', 480, 388, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-06-18', '80eeaa7a848edefc18453b5bfdfdb3e3', 1, '2022-06-18 13:47:15', '2022-06-18 13:47:15');


#
# TABLE STRUCTURE FOR: labtest_bill_details
#

DROP TABLE IF EXISTS `labtest_bill_details`;

CREATE TABLE `labtest_bill_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=669 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (6, 6, 7, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (7, 7, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (8, 7, 11, 71, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (9, 7, 11, 440, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (10, 7, 11, 67, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (11, 7, 23, 407, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (12, 7, 23, 31, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (13, 7, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (14, 8, 11, 75, '100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (15, 8, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (16, 9, 7, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (17, 10, 7, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (18, 11, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (19, 11, 11, 67, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (20, 12, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (21, 13, 7, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (22, 14, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (23, 15, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (25, 17, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (26, 18, 7, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (27, 19, 7, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (28, 20, 7, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (29, 21, 7, 410, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (30, 22, 7, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (32, 24, 7, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (33, 25, 7, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (34, 26, 11, 58, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (35, 26, 11, 61, '40.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (36, 26, 11, 84, '1700.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (37, 27, 7, 461, '1800.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (38, 28, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (39, 29, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (40, 29, 11, 362, '160.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (41, 29, 11, 172, '350.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (42, 29, 11, 254, '300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (43, 29, 11, 309, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (44, 29, 11, 420, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (45, 29, 11, 146, '650.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (46, 29, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (47, 30, 11, 463, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (48, 30, 11, 462, '900.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (49, 31, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (50, 31, 23, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (51, 32, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (52, 33, 24, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (53, 34, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (54, 35, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (55, 36, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (56, 36, 23, 414, '1500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (57, 37, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (58, 38, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (59, 39, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (60, 40, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (61, 41, 11, 56, '30.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (62, 42, 11, 56, '30.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (63, 42, 11, 57, '30.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (64, 42, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (65, 43, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (66, 44, 11, 92, '200.00', '50.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (67, 44, 7, 31, '1300.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (68, 44, 7, 34, '950.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (69, 45, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (70, 46, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (71, 47, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (72, 48, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (73, 49, 23, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (74, 50, 23, 439, '1500.00', '200.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (75, 51, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (76, 52, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (77, 52, 11, 61, '40.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (78, 52, 11, 58, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (79, 52, 11, 90, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (80, 53, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (81, 54, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (82, 54, 7, 410, '1500.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (83, 55, 11, 257, '250.00', '50.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (84, 56, 7, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (85, 57, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (86, 58, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (87, 59, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (88, 59, 23, 414, '1500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (89, 60, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (90, 61, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (91, 62, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (92, 63, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (93, 64, 11, 110, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (94, 65, 17, 399, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (95, 66, 23, 414, '1500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (96, 67, 11, 63, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (97, 67, 11, 260, '750.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (98, 67, 11, 368, '1200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (99, 68, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (100, 69, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (101, 70, 11, 146, '650.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (102, 70, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (103, 71, 7, 33, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (104, 72, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (105, 73, 11, 79, '990.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (106, 74, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (107, 75, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (108, 76, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (109, 77, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (110, 77, 11, 64, '450.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (111, 77, 11, 362, '160.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (112, 77, 11, 254, '300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (113, 78, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (114, 79, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (115, 80, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (116, 80, 11, 67, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (117, 81, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (118, 82, 7, 395, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (119, 83, 7, 34, '950.00', '100.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (120, 84, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (121, 85, 24, 461, '1800.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (122, 85, 11, 75, '100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (123, 85, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (124, 85, 11, 440, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (125, 85, 11, 63, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (126, 85, 11, 65, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (127, 86, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (128, 87, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (129, 88, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (130, 89, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (131, 90, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (132, 91, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (133, 92, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (134, 93, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (135, 94, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (136, 95, 11, 102, '180.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (137, 95, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (138, 96, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (139, 96, 11, 72, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (140, 96, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (141, 96, 11, 138, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (142, 96, 11, 134, '600.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (143, 96, 11, 442, '800.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (144, 96, 11, 58, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (145, 97, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (146, 98, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (147, 99, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (148, 100, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (149, 101, 11, 110, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (150, 101, 11, 61, '40.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (151, 101, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (152, 102, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (153, 103, 11, 64, '450.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (154, 104, 11, 75, '100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (155, 105, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (156, 106, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (157, 107, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (158, 108, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (159, 109, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (160, 110, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (161, 111, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (162, 112, 23, 407, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (163, 113, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (164, 114, 17, 400, '2200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (165, 115, 7, 464, '1300.00', '300.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (166, 116, 11, 420, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (167, 117, 11, 56, '30.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (168, 117, 11, 57, '30.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (169, 117, 11, 78, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (170, 117, 10, 77, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (171, 118, 7, 33, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (172, 119, 11, 72, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (173, 120, 23, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (174, 120, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (175, 120, 11, 64, '450.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (176, 120, 11, 420, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (177, 120, 11, 266, '160.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (178, 121, 23, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (179, 121, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (180, 121, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (181, 121, 11, 64, '450.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (182, 121, 11, 420, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (183, 121, 11, 266, '160.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (184, 122, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (185, 123, 11, 86, '100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (186, 124, 7, 34, '950.00', '300.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (187, 124, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (188, 124, 11, 75, '120.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (189, 124, 11, 76, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (190, 125, 7, 415, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (191, 126, 7, 461, '1800.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (192, 127, 17, 400, '2200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (193, 128, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (194, 129, 11, 329, '1200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (195, 129, 18, 446, '2250.00', '250.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (196, 130, 18, 446, '2250.00', '250.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (197, 131, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (198, 132, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (199, 133, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (200, 133, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (201, 133, 11, 65, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (202, 133, 11, 75, '120.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (203, 134, 23, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (204, 135, 7, 410, '1500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (205, 136, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (206, 137, 17, 400, '2200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (207, 138, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (208, 139, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (209, 140, 17, 400, '2200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (210, 141, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (211, 142, 23, 461, '1800.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (212, 143, 18, 446, '2250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (213, 143, 17, 399, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (214, 144, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (215, 145, 7, 33, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (216, 146, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (217, 147, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (218, 148, 7, 36, '850.00', '200.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (219, 149, 11, 62, '30.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (220, 149, 11, 102, '180.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (221, 149, 11, 325, '140.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (222, 149, 11, 440, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (223, 149, 11, 58, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (224, 150, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (225, 151, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (226, 152, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (227, 153, 17, 400, '2500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (228, 154, 7, 33, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (229, 155, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (230, 156, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (231, 157, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (232, 158, 7, 468, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (233, 159, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (234, 160, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (235, 161, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (236, 162, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (237, 163, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (238, 164, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (239, 165, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (240, 166, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (241, 167, 24, 449, '3500.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (242, 168, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (243, 169, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (244, 170, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (245, 171, 24, 24, '3000.00', '350.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (246, 172, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (247, 172, 11, 448, '140.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (248, 173, 18, 446, '2250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (249, 174, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (250, 175, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (251, 176, 11, 469, '300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (252, 177, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (253, 178, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (254, 179, 11, 79, '990.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (255, 180, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (256, 181, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (257, 182, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (258, 183, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (259, 184, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (260, 185, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (261, 186, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (263, 188, 7, 470, '1000.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (264, 189, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (265, 190, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (266, 191, 23, 471, '1500.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (267, 192, 17, 20, '2500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (268, 193, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (269, 194, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (270, 195, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (271, 196, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (272, 197, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (273, 198, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (274, 199, 7, 54, '850.00', '850.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (275, 200, 11, 71, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (276, 200, 11, 70, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (277, 200, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (278, 200, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (279, 200, 11, 440, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (280, 200, 11, 75, '120.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (281, 201, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (282, 202, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (283, 203, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (284, 204, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (285, 205, 7, 34, '950.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (286, 206, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (287, 207, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (288, 208, 11, 64, '450.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (289, 208, 23, 31, '1300.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (290, 208, 7, 34, '950.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (291, 209, 24, 24, '3000.00', '250.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (292, 210, 17, 399, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (293, 211, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (294, 212, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (295, 213, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (296, 214, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (297, 215, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (298, 216, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (299, 217, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (300, 218, 7, 395, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (301, 219, 7, 395, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (302, 220, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (303, 221, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (304, 222, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (305, 223, 11, 63, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (306, 223, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (307, 224, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (308, 225, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (309, 226, 17, 472, '1500.00', '250.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (310, 227, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (311, 228, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (312, 229, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (313, 230, 11, 75, '120.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (314, 230, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (315, 230, 11, 58, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (316, 230, 11, 347, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (317, 230, 11, 348, '4950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (318, 230, 11, 440, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (319, 230, 11, 65, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (320, 231, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (321, 232, 7, 473, '1850.00', '200.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (322, 233, 24, 449, '3500.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (323, 234, 24, 449, '3500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (324, 235, 23, 411, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (325, 236, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (326, 237, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (327, 238, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (328, 239, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (329, 240, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (330, 241, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (331, 241, 11, 63, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (332, 242, 11, 58, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (333, 243, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (334, 244, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (335, 245, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (336, 246, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (337, 247, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (338, 248, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (339, 249, 7, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (340, 250, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (341, 251, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (342, 252, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (343, 253, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (344, 254, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (345, 255, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (346, 256, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (347, 257, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (348, 258, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (349, 259, 7, 415, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (351, 261, 23, 474, '3000.00', '250.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (352, 262, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (353, 263, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (354, 264, 7, 31, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (355, 265, 23, 31, '1300.00', '200.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (356, 266, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (357, 267, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (358, 268, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (359, 269, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (360, 270, 23, 31, '1300.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (361, 270, 11, 64, '450.00', '50.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (362, 271, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (363, 272, 18, 446, '2250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (364, 273, 18, 446, '2250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (365, 274, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (366, 275, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (367, 276, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (368, 277, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (369, 278, 17, 399, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (370, 279, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (371, 280, 7, 412, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (372, 281, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (373, 282, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (374, 283, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (375, 284, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (376, 285, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (377, 286, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (378, 287, 23, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (379, 288, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (380, 289, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (381, 290, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (382, 291, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (383, 292, 23, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (384, 293, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (385, 294, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (386, 295, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (387, 296, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (388, 297, 7, 473, '1850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (391, 300, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (392, 301, 17, 400, '2500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (393, 302, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (394, 303, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (395, 304, 24, 24, '3000.00', '400.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (396, 305, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (397, 306, 7, 412, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (398, 307, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (399, 308, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (400, 309, 23, 31, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (401, 310, 7, 412, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (402, 311, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (403, 312, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (404, 313, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (405, 314, 23, 31, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (406, 315, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (407, 316, 7, 34, '950.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (408, 317, 24, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (409, 318, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (410, 319, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (411, 320, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (412, 321, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (413, 322, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (414, 323, 23, 471, '1500.00', '250.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (415, 324, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (416, 324, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (417, 324, 11, 73, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (418, 324, 11, 58, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (419, 324, 11, 266, '160.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (420, 324, 11, 420, '1250.00', '250.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (421, 324, 11, 63, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (422, 324, 11, 65, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (423, 324, 11, 309, '1300.00', '160.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (424, 324, 11, 391, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (425, 325, 11, 64, '450.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (426, 325, 23, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (427, 326, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (428, 327, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (429, 328, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (430, 329, 7, 54, '850.00', '100.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (431, 330, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (432, 331, 25, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (433, 332, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (434, 333, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (435, 334, 11, 117, '100.00', '20.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (436, 335, 7, 33, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (437, 336, 23, 398, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (438, 337, 11, 63, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (439, 337, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (440, 337, 11, 420, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (441, 337, 11, 56, '30.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (442, 337, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (443, 337, 11, 67, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (444, 338, 23, 475, '1500.00', '250.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (445, 339, 24, 24, '3000.00', '500.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (446, 340, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (447, 340, 11, 58, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (448, 340, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (449, 340, 11, 102, '180.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (450, 340, 11, 437, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (451, 340, 11, 75, '120.00', '0.00', '0.00');
INSERT INTO `labtest_bill_deta