#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `balance` double(18,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (2, 'SALARY', '', '0.00', '2022-03-14 13:23:33', '2022-03-14 13:23:33');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (3, 'DR PRIYA', '', '0.00', '2022-03-14 13:28:11', '2022-03-18 13:00:27');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (4, 'QSC EXPENSE', '', '-1738.00', '2022-03-14 14:09:21', '2022-03-18 13:49:37');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (6, 'PUYAPALLY', '', '100000.00', '2022-03-14 14:18:00', '2022-03-21 09:53:53');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (8, 'HOME EXPENSE', '', '-2030.00', '2022-03-18 12:54:30', '2022-03-18 13:34:44');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (9, 'DOCTORS FEE', '', '0.00', '2022-03-18 12:55:26', '2022-03-18 12:55:26');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (10, 'SALARY ADVANCE', '', '0.00', '2022-03-18 12:55:52', '2022-03-18 12:55:52');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (11, 'OLAYIL', '', '-8550.00', '2022-03-18 12:56:45', '2022-03-18 13:43:03');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (12, 'VEHICLE EXPENSE', '', '-100.00', '2022-03-18 12:57:02', '2022-03-18 13:39:32');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (13, 'INSURANCE', '', '0.00', '2022-03-18 12:57:10', '2022-03-18 12:57:10');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (14, 'NEW CENTRE KPLY', '', '-2850.00', '2022-03-18 12:57:45', '2022-03-18 13:32:34');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (15, 'DR VINOD JACOB', '', '-820.00', '2022-03-18 12:58:14', '2022-03-18 13:33:45');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (16, 'ECHO,TMT,ECG,EEG,FNAC,NCV,BMD,OPG', '', '-1000.00', '2022-03-18 13:36:40', '2022-03-18 13:41:31');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (17, 'Collecton', '', '0.00', '2022-03-26 11:11:56', '2022-03-26 11:11:56');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` varchar(20) NOT NULL,
  `doctor_id` varchar(20) NOT NULL,
  `patient_id` varchar(20) NOT NULL,
  `consultation_fees` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL,
  `schedule` varchar(50) NOT NULL,
  `remarks` text NOT NULL,
  `appointment_date` date NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `appointment` (`id`, `appointment_id`, `doctor_id`, `patient_id`, `consultation_fees`, `discount`, `schedule`, `remarks`, `appointment_date`, `status`, `created_at`) VALUES (1, '0001', '28', '17', '', '0.00', '1', 'test', '2022-03-21', 1, '2022-03-16 14:45:03');


#
# TABLE STRUCTURE FOR: chemical
#

DROP TABLE IF EXISTS `chemical`;

CREATE TABLE `chemical` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(50) NOT NULL,
  `category_id` int(11) NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `sales_unit_id` int(11) NOT NULL,
  `unit_ratio` varchar(20) DEFAULT '1',
  `purchase_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `sales_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `available_stock` varchar(11) NOT NULL DEFAULT '0',
  `photo` varchar(100) DEFAULT NULL,
  `remarks` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `chemical` (`id`, `name`, `code`, `category_id`, `purchase_unit_id`, `sales_unit_id`, `unit_ratio`, `purchase_price`, `sales_price`, `available_stock`, `photo`, `remarks`, `created_at`, `updated_at`) VALUES (2, 'SANITIZER', 'SNTIZR', 4, 2, 2, '30', '515.00', '550.00', '0', NULL, '', '2022-03-14 18:04:38', '2022-03-14 18:04:38');


#
# TABLE STRUCTURE FOR: chemical_assigned
#

DROP TABLE IF EXISTS `chemical_assigned`;

CREATE TABLE `chemical_assigned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chemical_category
#

DROP TABLE IF EXISTS `chemical_category`;

CREATE TABLE `chemical_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (1, 'SGOT', '2022-03-14 11:07:05', '2022-03-14 11:07:05');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (2, 'Syringe', '2022-03-14 11:42:29', '2022-03-14 11:42:29');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (3, 'Fluoride Tube', '2022-03-14 11:43:23', '2022-03-14 11:43:23');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (4, 'STORES', '2022-03-14 18:02:40', '2022-03-14 18:02:40');


#
# TABLE STRUCTURE FOR: chemical_stock
#

DROP TABLE IF EXISTS `chemical_stock`;

CREATE TABLE `chemical_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inovice_no` varchar(25) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `date` date DEFAULT NULL,
  `stock_quantity` varchar(20) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `stock_by` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_stock` (`id`, `inovice_no`, `chemical_id`, `date`, `stock_quantity`, `remarks`, `stock_by`, `created_at`, `updated_at`) VALUES (1, 'C/05279', '1', '2022-03-14', '200', '', '1', '2022-03-14 11:49:03', '2022-03-14 11:49:03');


#
# TABLE STRUCTURE FOR: chemical_unit
#

DROP TABLE IF EXISTS `chemical_unit`;

CREATE TABLE `chemical_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (1, 'NOS', '2022-03-14 11:04:06', '2022-03-14 18:01:30');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (2, 'Ltr', '2022-03-14 11:04:11', '2022-03-14 11:04:11');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (3, 'Kit', '2022-03-14 11:31:37', '2022-03-14 11:31:37');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (4, 'Box', '2022-03-14 11:45:52', '2022-03-14 11:45:52');


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('05dnl9vb8fgb7dss56quoc8ba4e66rum', '133.242.140.127', 1649501286, '__ci_last_regenerate|i:1649501286;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1cpcrp9vaqneanrleffpp6me8rcuooc0', '103.170.55.195', 1649494275, '__ci_last_regenerate|i:1649494247;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('534b8htifqmf4lpmcqd5u26ga265qg3s', '59.88.238.108', 1649503976, '__ci_last_regenerate|i:1649503690;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6i855gq3oqgrbrtvemc2cuu38icj41kd', '61.1.233.161', 1649500538, '__ci_last_regenerate|i:1649500537;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6j56s39dgir1uvb9mj39lscb8bfo151p', '167.248.133.119', 1649494094, '__ci_last_regenerate|i:1649494094;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8p1s84stfgj5987g4nc4pr8ngcrhqbi5', '133.242.140.127', 1649501279, '__ci_last_regenerate|i:1649501279;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cenltnlssbdcoslg4ub7e1cqm2a1tjrc', '133.242.174.119', 1649501280, '__ci_last_regenerate|i:1649501280;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('doee87hc0etb9r943fklffco2tciagfg', '133.242.174.119', 1649501279, '__ci_last_regenerate|i:1649501279;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lkb4dulr5b96i7d3lo85cv9jtkgtbn37', '65.154.226.167', 1649501838, '__ci_last_regenerate|i:1649501838;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n4tm55it1g4ob1etqo6qc1redkt766l3', '51.81.167.146', 1649494172, '__ci_last_regenerate|i:1649494172;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ng7ne2q90828dpnhqineaautl0rcb6ko', '59.88.238.108', 1649503068, '__ci_last_regenerate|i:1649502880;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('or81d1htletc2mim2qqef0u9uobs587n', '167.248.133.119', 1649494095, '__ci_last_regenerate|i:1649494095;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ppuuq4p0gd7s12d2jftu2eggijhpu13d', '42.104.149.12', 1649487575, '__ci_last_regenerate|i:1649487310;redirect_url|s:90:\"https://knpy.quilonscans.com/billing/test_bill_invoice/48/1eb60e634dc9104441fcde58cb78977b\";name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q8mag40fhhkd4orgdeuvmr8i5uhi4sl7', '61.1.233.161', 1649500255, '__ci_last_regenerate|i:1649500135;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t437luqutjkmdl84jgrm8k39murrhshc', '59.88.238.108', 1649503690, '__ci_last_regenerate|i:1649503690;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('to1i5hd2vhrgsrar2vsfg0fug4skugdq', '59.88.238.108', 1649504111, '__ci_last_regenerate|i:1649504002;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(200) DEFAULT NULL,
  `email_protocol` varchar(10) NOT NULL,
  `smtp_host` varchar(25) NOT NULL,
  `smtp_user` varchar(25) DEFAULT NULL,
  `smtp_pass` text NOT NULL,
  `smtp_port` varchar(100) NOT NULL,
  `smtp_encryption` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email`, `email_protocol`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `smtp_encryption`) VALUES (1, 'example@gmail.com', 'sendmail', 'smtp.gmail.com', 'example@gmail.com', '1234', '25', 'ssl');


#
# TABLE STRUCTURE FOR: email_templates
#

DROP TABLE IF EXISTS `email_templates`;

CREATE TABLE `email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_type` varchar(200) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `template_body` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `notified` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (1, 'account_registered', 'Account Registered', '', '{institute_name}, {name}, {username}, {password}, {user_role}, {login_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (2, 'forgot_password', 'Forgot Password', '', '{institute_name}, {name}, {username}, {reset_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (5, 'payslip_generated', 'Payslip generated', '', '{institute_name}, {name}, {month_year}, {payslip_no}, {payslip_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (6, 'absent', 'Absent Notice', '', '{institute_name}, {name}, {date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (7, 'leave_approve', 'Your leave request has been approved', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (8, 'leave_reject', 'Your leave request has been reject', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (9, 'appointment_confirmation', 'Appointment Confirmation', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (10, 'appointment_canceled', 'Appointment Canceled', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);


#
# TABLE STRUCTURE FOR: front_cms_about
#

DROP TABLE IF EXISTS `front_cms_about`;

CREATE TABLE `front_cms_about` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `page_title` varchar(255) NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `about_image` varchar(255) NOT NULL,
  `elements` mediumtext NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_about` (`id`, `title`, `subtitle`, `page_title`, `content`, `banner_image`, `about_image`, `elements`, `meta_description`, `meta_keyword`) VALUES (1, 'Welcome to Hospitals', 'Best Medical &amp; Healthcare Needs to Our Patients', 'About Us', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut volutpat rutrum eros amet sollicitudin interdum. Suspendisse pulvinar, velit nec pharetra interdum, ante tellus ornare mi, et mollis tellus neque vitae elit. Mauris adipiscing mauris fringilla turpis interdum sed pulvinar nisi malesuada. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n\r\n<p>Donec sed odio dui. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Duis mollis, est non commodo luctus, nisi erat porttitor ligula. Mauris sit amet neque nec nunc gravida.</p>\r\n\r\n<div class=\"row\">\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n	<li><a href=\"#\">Dermitology</a></li>\r\n</ul>\r\n</div>\r\n\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n</ul>\r\n</div>\r\n</div>', 'about.jpg', 'about.jpg', '{\"cta_title\":\"Get in touch to join our community\",\"button_text\":\"Contact Our Office\",\"button_url\":\"contact\"}', '', '');


#
# TABLE STRUCTURE FOR: front_cms_appointment
#

DROP TABLE IF EXISTS `front_cms_appointment`;

CREATE TABLE `front_cms_appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_appointment` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Make An Appoinment', '<p><span style=\"color: rgb(156, 156, 156); font-family: Poppins, sans-serif; font-size: 14px; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;\">Lorem ipsum dolor sit amet, eum illum dolore concludaturque ex, ius latine adipisci no. Pro at nullam laboramus definitiones. Mandamusconceptam omittantur cu cum. Brute appetere it scriptorem ei eam, ne vim velit novum nominati. Causae volutpat percipitur at sed ne.</span></p>\r\n', 'Appointment', 'appointment.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_contact
#

DROP TABLE IF EXISTS `front_cms_contact`;

CREATE TABLE `front_cms_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `box_title` varchar(255) DEFAULT NULL,
  `box_description` varchar(500) DEFAULT NULL,
  `box_image` varchar(255) DEFAULT NULL,
  `form_title` varchar(355) DEFAULT NULL,
  `address` varchar(355) DEFAULT NULL,
  `phone` varchar(355) DEFAULT NULL,
  `email` varchar(355) DEFAULT NULL,
  `submit_text` varchar(355) NOT NULL,
  `map_iframe` text,
  `page_title` varchar(255) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_contact` (`id`, `box_title`, `box_description`, `box_image`, `form_title`, `address`, `phone`, `email`, `submit_text`, `map_iframe`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'WE\'D LOVE TO HEAR FROM YOU', 'Fusce convallis diam vitae velit tempus rutrum. Donec nisl nisl, vulputate eu sapien sed, adipiscing vehicula massa. Mauris eget commodo neque, id molestie enim.', 'contact-info-box.png', 'Get in touch by filling the form below', '4896  Romrog Way, LOS ANGELES,\r\nCalifornia', '954-648-1802, \r\n963-612-1782', 'info@example.com\r\nsupport@example.com', 'Send', '<iframe width=\"100%\" height=\"350\" id=\"gmap_canvas\" src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3313.3833161665298!2d-118.03745848530627!3d33.85401093559897!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80dd2c6c97f8f3ed%3A0x47b1bde165dcc056!2sOak+Dr%2C+La+Palma%2C+CA+90623%2C+USA!5e0!3m2!1sen!2sbd!4v1544238752504\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\"></iframe>', 'Contact Us', 'contact.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_doctor_bio
#

DROP TABLE IF EXISTS `front_cms_doctor_bio`;

CREATE TABLE `front_cms_doctor_bio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(20) NOT NULL,
  `biography` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_doctor_bio` (`id`, `doctor_id`, `biography`) VALUES (1, '2', '<p>Senior Surgeon</p>');


#
# TABLE STRUCTURE FOR: front_cms_doctors
#

DROP TABLE IF EXISTS `front_cms_doctors`;

CREATE TABLE `front_cms_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Doctors', 'doctors.jpg', '', '');
INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (2, 'Doctor Profile', 'doctor_profile.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq
#

DROP TABLE IF EXISTS `front_cms_faq`;

CREATE TABLE `front_cms_faq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_faq` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Frequently Asked Questions', '<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.</p>\r\n\r\n<p>Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven&#39;t heard of them accusamus labore sustainable VHS.</p>', 'Faq', 'faq.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq_list
#

DROP TABLE IF EXISTS `front_cms_faq_list`;

CREATE TABLE `front_cms_faq_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (1, 'Any Information you provide on applications for disability, life or accidental insurance ?', '<p>\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.\r\n</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</li>\r\n<li>Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact.</li>\r\n<li>That a reader will be distracted by the readable content of a page when looking at its layout.</li>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</li>\r\n<li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n<li>Readable content of a page when looking at its layout.</li>\r\n<li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n<li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n</ul>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (2, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (3, 'Opposed to using \'Content here, content here\', making it look like readable English ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (4, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (5, 'What types of documents are required to travel?', '<p><strong>Lorem ipsum</strong> dolor sit amet, an labores explicari qui, eu nostrum copiosae argumentum has. Latine propriae quo no, unum ridens expetenda id sit, at usu eius eligendi singulis. Sea ocurreret principes ne. At nonumy aperiri pri, nam quodsi copiosae intellegebat et, ex deserunt euripidis usu. Per ad ullum lobortis. Duo volutpat imperdiet ut, postea salutatus imperdiet ut per, ad utinam debitis invenire has.</p>\r\n\r\n<ol>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari quilabores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n</ol>');


#
# TABLE STRUCTURE FOR: front_cms_home
#

DROP TABLE IF EXISTS `front_cms_home`;

CREATE TABLE `front_cms_home` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `item_type` varchar(20) NOT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `elements` mediumtext NOT NULL,
  `active` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (1, 'We Offer Fast &amp; Reliable', 'Medical &amp; Healthcare Needs', 'wellcome', 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using content.\r\n\r\nMaking it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).', '{\"image\":\"wellcome.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (2, 'Experience Doctor Team', NULL, 'doctors', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident.', '{\"doctor_start\":\"1\",\"image\":\"featured-parallax.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (3, 'Our Best Medical Services', NULL, 'services', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (4, 'Online Hassle Free Appointment Booking', 'Medical Services', 'cta', '', '{\"mobile_no\":\"+2484-398-8987\",\"button_text\":\"Book your Appointment\",\"button_url\":\"appointment\",\"image\":\"appointment-booking-img.png\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (5, 'Best <span>Digital</span> Experience', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-left\",\"button_text1\":\"View Services\",\"button_url1\":\"#\",\"button_text2\":\"Learn More\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743357.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (6, 'Main Heading <span>Some Caption</span> Here', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-center\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Get Started\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743366.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (7, 'Here creative & professional <span>PHP</span> template', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-right\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Contact us\",\"button_url2\":\"contact\",\"image\":\"home-slider-1578743373.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (8, 'Qualified Doctors', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-user-md\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (9, 'Regular Checkup', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-stethoscope\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (10, 'Neurosurgeon', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-vial\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (11, '24 Hours  Service', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"far fa-clock\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (12, 'Our Happy Patients Opinion', NULL, 'testimonial', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);


#
# TABLE STRUCTURE FOR: front_cms_home_seo
#

DROP TABLE IF EXISTS `front_cms_home_seo`;

CREATE TABLE `front_cms_home_seo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_home_seo` (`id`, `page_title`, `meta_keyword`, `meta_description`) VALUES (1, 'Home', '', '');


#
# TABLE STRUCTURE FOR: front_cms_menu
#

DROP TABLE IF EXISTS `front_cms_menu`;

CREATE TABLE `front_cms_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `ordering` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT '0',
  `open_new_tab` int(11) NOT NULL DEFAULT '0',
  `ext_url` int(11) NOT NULL DEFAULT '0',
  `ext_url_address` text,
  `publish` int(11) NOT NULL,
  `system` varchar(10) NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (1, 'Home', 'index', 1, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (2, 'Appointment', 'appointment', 3, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (3, 'Doctors', 'doctors', 4, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (4, 'About Us', 'about', 2, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (5, 'FAQ', 'faq', 5, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (6, 'Contact Us', 'contact', 6, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');


#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `content` longtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `menu_id` int(11) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_services
#

DROP TABLE IF EXISTS `front_cms_services`;

CREATE TABLE `front_cms_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `parallax_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_services` (`id`, `title`, `subtitle`, `parallax_image`) VALUES (1, 'Get Well Soon', 'Our Hosptial <span>Services</span>', 'service_parallax.jpg');


#
# TABLE STRUCTURE FOR: front_cms_services_list
#

DROP TABLE IF EXISTS `front_cms_services_list`;

CREATE TABLE `front_cms_services_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (1, 'First Aid', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text.', 'fas fa-medal');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (2, 'Dental Care', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-heartbeat');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (3, '24x7 Ambulance', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model.', 'fas fa-ambulance');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (4, 'Qualified Doctors', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will.', 'fas fa-capsules');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (5, 'Medical Pharmacy', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-stethoscope');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (6, 'Pulmonary', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a for \'lorem ipsum\' will uncover.', 'fas fa-medkit');


#
# TABLE STRUCTURE FOR: front_cms_setting
#

DROP TABLE IF EXISTS `front_cms_setting`;

CREATE TABLE `front_cms_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_title` varchar(255) NOT NULL,
  `captcha_status` varchar(20) NOT NULL,
  `recaptcha_site_key` varchar(255) NOT NULL,
  `recaptcha_secret_key` varchar(255) NOT NULL,
  `address` varchar(350) NOT NULL,
  `mobile_no` varchar(60) NOT NULL,
  `fax` varchar(60) NOT NULL,
  `receive_contact_email` varchar(255) NOT NULL,
  `email` varchar(60) NOT NULL,
  `footer_text` varchar(255) NOT NULL,
  `fav_icon` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `working_hours` varchar(300) NOT NULL,
  `facebook_url` varchar(100) NOT NULL,
  `twitter_url` varchar(100) NOT NULL,
  `youtube_url` varchar(100) NOT NULL,
  `google_plus` varchar(100) NOT NULL,
  `linkedin_url` varchar(100) NOT NULL,
  `pinterest_url` varchar(100) NOT NULL,
  `instagram_url` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_setting` (`id`, `application_title`, `captcha_status`, `recaptcha_site_key`, `recaptcha_secret_key`, `address`, `mobile_no`, `fax`, `receive_contact_email`, `email`, `footer_text`, `fav_icon`, `logo`, `working_hours`, `facebook_url`, `twitter_url`, `youtube_url`, `google_plus`, `linkedin_url`, `pinterest_url`, `instagram_url`) VALUES (1, 'DMS- Diagnostic Management System With CMS', 'disable', '', '', 'Quilon Scans', '+1-954-648-1802', '001 - 785 987 1234', 'info@example.com', 'info@demo.com', '©2022 <span>Quilon Scans</span> - Developed by Logiprompt Techno Solutions India Pvt Ltd', 'fav_icon.ico', 'logo.png', '<span>Hours : </span>  Mon To Fri - 9:00 - 20:00,  Sunday Closed', 'https://facebook.com', 'https://twitter.com', 'https://youtube.com', 'https://google.com', 'https://linkedin.com', 'https://pinterest.com', 'https://instagram.com');


#
# TABLE STRUCTURE FOR: front_cms_testimonial
#

DROP TABLE IF EXISTS `front_cms_testimonial`;

CREATE TABLE `front_cms_testimonial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_name` varchar(255) NOT NULL,
  `surname` varchar(355) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `rank` int(5) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (1, 'Gartrell Wright', 'Los Angeles', 'defualt.png', 'Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 1, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (2, 'Clifton Hyde', 'Newyork City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (3, 'Emily Lemus', 'Los Angeles', 'defualt.png', '“Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 5, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (4, 'Michel Jhon', 'CEO', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 3, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (5, 'Hilda Howard', 'Chicago City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, '2019-08-23 18:26:42');


#
# TABLE STRUCTURE FOR: global_settings
#

DROP TABLE IF EXISTS `global_settings`;

CREATE TABLE `global_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(255) NOT NULL,
  `institute_email` varchar(100) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(50) NOT NULL,
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `translation` varchar(20) NOT NULL,
  `footer_text` text NOT NULL,
  `animations` varchar(50) NOT NULL,
  `timezone` varchar(30) NOT NULL,
  `date_format` varchar(20) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `facebook_url` varchar(255) NOT NULL,
  `twitter_url` varchar(255) NOT NULL,
  `linkedin_url` varchar(255) NOT NULL,
  `youtube_url` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `global_settings` (`id`, `institute_name`, `institute_email`, `address`, `mobileno`, `currency`, `currency_symbol`, `translation`, `footer_text`, `animations`, `timezone`, `date_format`, `facebook_url`, `twitter_url`, `linkedin_url`, `youtube_url`, `created_at`, `updated_at`) VALUES (1, 'Quilon Scans', 'quilonscans@yahoo.com', 'Karunagappally', '9562506027 / 0474-2743114 / 0474 - 2743115', 'INR', '₹', 'english', '© 2022 Quilon Scans - Developed by Logiprompt Techno Solutions India Pvt Ltd', 'fadeInUp', 'Asia/Dhaka', '%d-%b-%Y', '', '', '', '', '2018-10-22 15:07:49', '2022-04-09 12:22:57');


#
# TABLE STRUCTURE FOR: lab_report_template
#

DROP TABLE IF EXISTS `lab_report_template`;

CREATE TABLE `lab_report_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `template` longtext NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=228 DEFAULT CHARSET=utf8;

INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (16, 'EXAMINATION OF STOOL', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">EXAMINATION OF STOOL</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;&nbsp;&nbsp;Brown&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Consistency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Formed&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Blood&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Mucus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>MICROSCOPICAL EXAMINATION</strong></span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ova&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Not Seen&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cysts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Not Seen&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;4-6 /HPF&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">R B Cs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Undigested food particles&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 11:11:22', '2022-04-05 12:44:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (17, 'OCCULT BLOOD TEST', '<p style=\"margin-bottom:14px\"><u><strong>OCCULT BLOOD TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Occult Blood&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;&nbsp;Negative</span></span></span></p>\r\n', '2022-03-17 11:14:06', '2022-04-05 12:52:46');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (18, 'EXAMINATION OF URINE ', '<p style=\"margin-bottom:14px\"><strong><u>EXAMINATION OF URINE</u></strong>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a) PHYSICAL CHARACTERS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Pale Yellow&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Transparency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Clear&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Acidic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>b) CHEMICAL CONSTITUENTS :&nbsp;</strong>&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c) MICROSCOPICAL EXAMINATION :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Amorphous Urates&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n', '2022-03-17 11:25:47', '2022-04-05 13:04:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (19, 'THYROID FUNCTION TEST (Child)            ', '<p style=\"margin-bottom:14px\"><u><strong>THYROID FUNCTION TEST (Child)</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;T3(CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;141.8ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Cord blood:15.0-75.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-3 Days:32.0-216.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-30 Days::50.0-250.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1-12 Months:105.0-280.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-5 Years:105.0-269.0,ng/dL&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">5-10Years:94.0-241.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">10-16Years:83.0-213.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">15-18 Years:80.0-210.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp; &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;9.3 ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cord blood :&nbsp;4.6-&nbsp;13.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 3 Days&nbsp; :&nbsp; 11.8-23.2,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-10 Days&nbsp; :&nbsp;&nbsp; 9.9-21.9,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10-45 Days :&nbsp;&nbsp; 8.2-16.2ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45-95 Days :&nbsp;&nbsp; 6.4-14.0ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3-12 Months:&nbsp;&nbsp; 7.8-16.5,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1- 5 Years :&nbsp;&nbsp; 7.3-15.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5-10 Years :&nbsp;&nbsp; 6.4-13.3,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0-15 Years :&nbsp;&nbsp; 5.6-11.7,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 15-18 Years :&nbsp;&nbsp; 4.2-11.8&#39;ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (CLIA-ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4.31 uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;1 Month : 0.4 - 20.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 Month to 10 Year : 0.4 - 10.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Above 10 Year : 0.4 - 4.5 uIU/mL</span></span></span></p>\r\n', '2022-03-17 11:36:11', '2022-04-05 13:18:12');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (20, 'DENGUE  IgM TEST', '<p style=\"margin-bottom:14px\"><u><strong>DENGUE &nbsp;IgM TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DENGUE&nbsp; IgM (serum by EIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;EQUIVOCAL(9.20)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Negative&nbsp; &nbsp;&lt; 9.0 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Equivocal 9-11 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive &gt; 11 PanBio Units</span></span></span></p>\r\n', '2022-03-17 11:53:23', '2022-04-05 13:22:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (21, 'LACTATE,PLASMA TEST                  ', '<p style=\"margin-bottom:14px\"><u><strong>LACTATE,PLASMA TEST</strong></u> &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lactate,Plasma&nbsp;(Plasma,Colorimetry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.3 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.4&nbsp;-&nbsp;2.0mmol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 11:58:12', '2022-04-05 13:30:14');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (22, 'E2 - ESTRADIOL LEVEL      ', '<p style=\"margin-bottom:14px\"><u><strong>E2 - ESTRADIOL LEVEL</strong></u><em><strong> </strong></em>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">E2 - Estradiol level&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 79.7 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal Menstruating Women:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Follicular phase: 21 to 251 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid cycle peak :38 - 649 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;Luteal phase :21 to 312 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;Menopause :&lt; 10 to 28 pg/mL</span></span></span></p>\r\n', '2022-03-17 12:04:42', '2022-04-05 15:52:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (23, 'SERUM PHOSPHORUS TEST', '<p style=\"margin-bottom:14px\"><u><strong>SERUM PHOSPHORUS TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Phosphorus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;5.4 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2.3 &ndash; 4.7 mg/dL</span></span></span></span></p>\r\n', '2022-03-17 12:13:08', '2022-04-05 13:31:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (24, 'SERUM CALCIUM TEST', '<p><u><strong>SERUM CALCIUM TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">S.Calcium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10.1 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Adult : 8.5 - 10. 1 mg/dL</span></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Children : 9 - 11 mg/dL</span></span></span></span></p>\r\n', '2022-03-17 12:23:24', '2022-04-05 13:34:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (25, 'WIDAL TEST TUBE METHOD', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">WIDAL TEST TUBE METHOD</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong>TEST&nbsp;</strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<strong>DILUTION</strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;<strong>NORMAL RANGE</strong></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;&nbsp; &nbsp;Salmonella typhi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;O&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella typhi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;H&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella paratyphi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&quot;AH&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella Paratyphi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;BH&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; 1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; (Significant Dilution&nbsp; 1: 80 or more)&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 12:31:44', '2022-04-05 13:39:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (26, 'URINE MICROALBUMINURIA REPORT', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE MICROALBUMINURIA REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microalbumin,urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;92.5 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Urine by Drychemistry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 505.7 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microalbuminuria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;18.3 ug/mgC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;30ug/mgC</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Microalbuminuria&nbsp; 30 - 300ug/mgC</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Clinical albuminuria &gt; 300ug/mgC</span></span></span></p>\r\n', '2022-03-17 12:36:50', '2022-04-05 15:13:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (27, ' LDH TEST', '<p><strong>&nbsp;</strong><u><strong>LDH TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LDH Lactate Dehydrogenase &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 241 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;125&nbsp; -&nbsp; 220 U/L</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;(Serum IFCC method )</span></span></span></p>\r\n', '2022-03-17 12:47:00', '2022-04-05 15:18:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (28, 'BETA HCG TEST', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">BETA HCG TEST</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCG Beta Subunit.Serum</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,ECLIA)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCG Beta Subunit&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1213.0 IU/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Non Pregnant:&lt; 10 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; Peri&amp;Post menopausal:5-50 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Pregnant: ReferInterpretation</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp;1 to2 Weeks:50 to 500 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; 2 to 3 Weeks:100 to 500 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; 3 to 4 Weeks:500 to 10000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp;4 to 5 Weeks:1000 to 50000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;5 to 6 Weeks:10.000 to1.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;6 to 8 Weeks:15.0000 to 2.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2&nbsp;to 3 Weeks : 10.000 to1.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;11 to 16 Weeks : 6000 to 30. 000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16 to 21 Weeks : 400 to 15,000 IU/L</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 21 to 39 Weeks:2,700 to 78,100&nbsp; IU/L</span></span></span></p>\r\n', '2022-03-17 12:58:57', '2022-04-05 15:42:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (29, 'FREE TESTOSTERONE', '<p><u><strong>FREE TESTOSTERONE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free Testosterone(serum by RIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.70 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal Female:0.29-3.18 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase: 0.45-3.17 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Luteal Phase:0.46-2.48 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Oral Contraceptives:0.29-1.73 pg/mL</span></span></span></p>\r\n', '2022-03-17 13:02:11', '2022-04-05 15:40:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (30, 'ANTI CARDIOLIPIN ANTIBODY-IgG ', '<p><u><strong>ANTI CARDIOLIPIN ANTIBODY-IgG&nbsp;</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Cardiolipin antibody-IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative(4.00) GPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Negative : &lt;10 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;High Positive:&gt;=40 GPL U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Low Positive:10-20 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Moderate Positive:20.01-40 GPLU/mL</span></span></span></p>\r\n', '2022-03-17 13:05:22', '2022-04-05 15:38:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (31, 'Anti CARDIOLIPIN ANTIBODY-IgM ', '<p><u><strong>Anti CARDIOLIPIN ANTIBODY-IgM&nbsp;</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Cardiolipin Antibody-IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative(3.80)&nbsp; MPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative :&lt; 7 MPL U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive :&gt; = 7 MPL U/mL</span></span></span></p>\r\n', '2022-03-17 13:08:44', '2022-04-05 16:12:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (32, 'APA -(PHOSPHOLIPIDS)-lgG ', '<p><u><strong>APA -(PHOSPHOLIPIDS)-lgG&nbsp;</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">APA -(Phospholipids)-lgG(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative(6.40) GPL/U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Negative: &lt;=10 GPLU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive: &gt;10 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 13:12:38', '2022-04-05 16:11:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (33, 'APA -(PHOSPHOLIPIDS)-lgM ', '<p><strong><u>APA -(PHOSPHOLIPIDS)-lgM&nbsp;</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">APA -(Phospholipids)-lgM(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Negative(5.20) MPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative &lt;=10 MPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive: &gt; 10 MPL U/mL</span></span></span></p>\r\n', '2022-03-17 13:18:16', '2022-04-05 16:13:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (34, 'LUPUS ANTICOAGULANT *             ', '<p><u><strong>LUPUS ANTICOAGULANT * </strong></u>&nbsp; &nbsp; &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lupus Anticoagulant * (Citrated Plasma)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.0&nbsp; Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -1.3 Ratio </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 13:21:41', '2022-04-05 16:14:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (35, 'BETA-2-GLYCOPROTEIN 1-IgG* ', '<p><u><strong>BETA-2-GLYCOPROTEIN 1-IgG*&nbsp;</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Glycoprotein 1-IgG* (Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Negative(7) RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-17 13:26:34', '2022-04-05 16:17:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (36, 'BETA-2-GLYCOPROTEIN 1-IgM*', '<p><u><strong>BETA-2-GLYCOPROTEIN 1-IgM*</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Glycoprotein 1-IgM*&nbsp;(Serum,ELA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative(8.8) RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-17 13:30:03', '2022-04-05 16:20:15');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (37, 'TESTOSTERONE(TOTAL)', '<p><u><strong>TESTOSTERONE(TOTAL)</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Testosterone(Total),(serum by CLIA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;751.56 ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; 260-1000&nbsp; ng/dL</span></span></span></p>\r\n', '2022-03-17 14:37:07', '2022-04-05 16:23:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (38, 'FSH-FOLLICLE STIMULATING HORMONE', '<p><u><strong>FSH-FOLLICLE STIMULATING HORMONE</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">FSH-Follicle Stimulating Hormone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;2.00mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Follicular Phase:1.4-9.9 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid Cycle Peak :0.2-17.2 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Luteal Phase&nbsp;&nbsp; :1.1-9.2 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post Menopausal:19.3-100.6 mIU/mL</span></span></span></p>\r\n', '2022-03-17 14:39:45', '2022-04-05 16:27:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (39, 'LH-LEUTINISING HORMONE', '<p><u><strong>LH-LEUTINISING HORMONE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LH-Leutinising Hormone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;8.40 mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase:1.7-15 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid Cycle Peak:21.9-56.6 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Lutel Phase&nbsp;&nbsp;&nbsp;&nbsp; :0.6-16.3 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post Menopausal :14.2-52.3mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 14:41:29', '2022-04-05 16:32:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (40, 'PROGESTERONE', '<p><u><strong>PROGESTERONE</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Progesterone&nbsp;(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.00 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Menstrual Cycle:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; FollicularPhase: &lt;0.3ng/mL&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;LutealPhase:1.2-15.9ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post menopausal:&lt;0.2ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Pregnancy:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; First Trimester:2.8-147.3ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:22.5-95.3ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; Third trimester:27.9-242.5ng/mL</span></span></span></p>\r\n', '2022-03-17 14:45:04', '2022-04-05 16:37:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (42, 'DHEAS', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">DHEAS</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DHEAS Serum bby RIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100 - 800 ng/dL</span></span></span></p>\r\n', '2022-03-17 14:46:53', '2022-04-05 16:43:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (43, 'ALDOSTERONE', '<p><u><strong>ALDOSTERONE</strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Aldosterone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;380.0 pg/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Supine:8-12 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Upright:30-355 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Children:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; At birth:300-1900 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;1month to 2years:20-1100 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;From 3-16years:12-340 pg/ml&nbsp;</span></span></span></p>\r\n', '2022-03-17 14:48:31', '2022-04-05 16:49:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (44, 'LEPTOSPIRA-IgM              ', '<p><u><strong>LEPTOSPIRA-IgM</strong></u></p>\r\n\r\n<p>&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Leptospira-IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative(2) PanBio Units&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Negative:&lt;9 PanBio Units </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; Equivocal 9-11 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Positive:&gt;=11 PanBio Units</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 14:52:00', '2022-04-05 17:15:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (45, 'LEPTOSPIRA-IgG       ', '<p><u><strong>LEPTOSPIRA-IgG </strong></u>&nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Leptospira-IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive 2.8 NTU&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt;9 NTU</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Weak Reactive:9 -11 NTU</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive:&gt;=9 NTU&nbsp; </span></span></span></p>\r\n', '2022-03-17 14:53:40', '2022-04-05 17:23:18');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (47, ' CPK', '<p><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span></strong><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CPK</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Phospho Kinase(CPK)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;170.0 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;30 - 200 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum by IFCC)</span></span></span></p>\r\n', '2022-03-17 15:02:22', '2022-04-05 17:26:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (48, 'CK MB', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CK MB</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MB Fraction of Creatinine Kinase(CK MB)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 30.0 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 24.0 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,ECLIA&nbsp;)</span></span></span></p>\r\n', '2022-03-17 15:03:28', '2022-04-05 17:30:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (49, 'TROPONIN T QUANTITATIVE', '<p><u><strong>TROPONIN T QUANTITATIVE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Troponin T Quantitative(Serum by ECLIA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.01 ug/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative : 0.01 ug/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive : &gt; 0.01 ug/L</span></span></span></p>\r\n', '2022-03-17 15:05:30', '2022-04-05 17:34:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (50, 'TROPONIN-I               ', '<p><u><strong>TROPONIN-I</strong></u><strong> &nbsp; &nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Troponin-l&nbsp;&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.00 ug/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative : &lt;0.11ug/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 15:08:37', '2022-04-05 17:42:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (51, 'URINE VMA', '<p><u><strong>URINE VMA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Vanillyl Mandelic Acid(VMA),Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.8 ug/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal &lt; 4.5 ug/mL</span></span></span></p>\r\n', '2022-03-17 15:09:25', '2022-04-05 17:45:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (52, 'HELICOBACTER PYLORI -IgG       ', '<p><u><strong>HELICOBACTER PYLORI -IgG</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Helicobacter pylori -IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15.3 Eu/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt;20 Eu/ml</span></span></span>&nbsp;</p>\r\n', '2022-03-17 15:10:51', '2022-04-05 17:47:46');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (53, 'HELICOBACTER PYLORI -IgM       ', '<p><u><strong>HELICOBACTER PYLORI -IgM</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Helicobacter pylori -IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0&nbsp; U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Negative:&lt; 8 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; quivocal:8-12U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;12 U/mL</span></span></span></p>\r\n', '2022-03-17 15:12:38', '2022-04-05 17:52:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (54, 'FREE-PSA*', '<p><u><strong>FREE-PSA*</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free-PSA(Prostate Specific Antigen)*&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 0.975 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0 - 0.5 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,CMIA)</span></span></span></p>\r\n', '2022-03-17 15:14:31', '2022-04-06 10:09:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (55, 'PSA', '<p><strong><u>PSA</u></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PSA-Prostate Specific Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Coventional for all ages : 0 - 4ng/mL&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; (Serum,ECLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 60 - 69 Yrs : 0- 4.5 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:16:35', '2022-04-07 15:14:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (56, 'CEA', '<p><strong><u><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CEA</span></span></span></u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Carcino Embryonic Antigen(CEA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;NonSmoking0-2.5 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum by CLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Smoking 0 - 50.0 ng/mL&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 15:18:00', '2022-04-06 10:24:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (57, 'LITHIUM TEST', '<p><strong><u>LITHIUM TEST</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lithium(Serum,Colorimetry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Therapeutic range : 0.6 - 1.2 mmol/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Toxic :Potentially: &gt; 1.5 mmol/L&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Toxic :Severely&nbsp;&nbsp; : &gt; 2.0 mmol/L</span></span></span></p>\r\n', '2022-03-17 15:19:40', '2022-04-06 10:32:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (58, 'ANTI HCV', '<p><u><strong>ANTI HCV</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IMMUNOASSAY :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCV-Antibody&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.08(Non-Reactive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Reactive : &gt;=1.0 Cut Off Index</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Non-Reactive : &lt;1.0 Cut Off Index</span></span></span></p>\r\n', '2022-03-17 15:22:23', '2022-04-06 10:41:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (59, 'HEV-IgM', '<p><strong><u>HEV-IgM</u></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HEV-IgM Hepatitis E virus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;NEGATIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;COV:Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &gt;COV:Positive</span></span></span></p>\r\n', '2022-03-17 15:23:13', '2022-04-06 10:50:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (60, 'HAV-IgG', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgG</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgG Ab to Hepatitis A Virus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive(14.1) S/CO&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Non Reactive : &lt; 1.0 S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive : &gt;=1.0 S/CO</span></span></span></p>\r\n', '2022-03-17 15:26:50', '2022-04-06 10:59:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (61, 'HAV-IgM', '<p><strong><u><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HAV-IgM</span></span></span></u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgM Ab to Hepatitis A Virus &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive(0.377) &nbsp;S/COratio&nbsp; &nbsp; &nbsp; &nbsp; NonRactive:&lt;0.80 S/COratio</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Grayzone:0.80-1.2 S/COratio</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;Reactive: &gt;1.2 S/COratio</span></span></span></p>\r\n', '2022-03-17 15:28:34', '2022-04-06 11:11:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (62, 'ANTI HBs', '<p><u><strong>ANTI HBs</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti HBs by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Immune : &gt;=10 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Immune : &lt;10 mIU/mL</span></span></span></p>\r\n', '2022-03-17 15:31:04', '2022-04-06 11:15:17');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (63, 'ANTI HBc', '<p><u><strong>ANTI HBc</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti HBc by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 13.2(Reactive)&nbsp;&nbsp; COI&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Reactive : &gt; 1.01 COI</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive : &lt;=1.00 COI</span></span></span></p>\r\n', '2022-03-17 15:31:59', '2022-04-06 11:17:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (64, 'CORTISOL', '<p><u><strong>CORTISOL</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cortisol,Serum(8AM)by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0&nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;AM: 5 - 23 ug/dL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; PM: 3 - 16 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; PM:Values are normally 50% of AM value</span></span></span></p>\r\n', '2022-03-17 15:33:32', '2022-04-06 11:24:27');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (65, 'PROLACTIN', '<p><strong><u>PROLACTIN</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Prolactin,serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0&nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;2.5 - 18.2 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:38:57', '2022-04-06 11:31:34');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (66, 'THYROID ANTIBODY REPORT', '<p><u><strong>THYROID ANTIBODY REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microsomal ( TPO ) Antibody&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0 IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 60.0 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Thyroglobulin Antibody ( ATA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;&lt; 60.0 IU/mL&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 15:41:20', '2022-04-06 11:43:24');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (67, 'VIT D3(25 HYDROXY)', '<p><u><strong>VIT D3(25 HYDROXY)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">25 Hydroxy (OH) Vit D3,Serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Deficiency : &lt; 10 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Insufficiency : 10-30ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sufficiency :30-100 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypervitaminosis:&gt;100 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:43:11', '2022-04-06 11:54:09');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (68, 'THYROID FUNCTION TEST (TFT) FEMALE', '<p><strong><u>THYROID FUNCTION TEST (TFT)</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">THYROID PANEL-1 (T3,T4,TSH) Serum, ECLIA</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;180ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1st Trimester:81-190 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2nd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3rd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 11.5ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5.0&nbsp; -&nbsp; 11.5 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (Ultrasensitive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.5uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.4&nbsp; -&nbsp; 4.5 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1st&nbsp;Trimester:0.1-&nbsp;2.5uIU/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">2nd Trimester:0.2-3.0uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:0.3-3.0uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n', '2022-03-17 15:51:00', '2022-04-06 12:05:43');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (69, 'T3 (Total)Female', '<p><u><strong>T3 (Total)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 180ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1st Trimester:81-190 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2nd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:100-260ng/dL</span></span></span></p>\r\n', '2022-03-17 15:53:00', '2022-04-05 15:49:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (70, 'T4 (Total)Female', '<p><u><strong>T4 (Total)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;11.5ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5.0&nbsp; -&nbsp; 11.5 ug/dL</span></span></span></p>\r\n', '2022-03-17 15:56:03', '2022-04-05 15:55:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (71, ' TSH (FEMALE)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">TSH</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (Ultrasensitive)(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.5uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.4&nbsp; -&nbsp; 4.5 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1st Trimester:0.1-2.5uIU/mL&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2nd Trimester:0.2-3.0uIU/mL&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:0.3-3.0uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 15:57:00', '2022-04-07 15:30:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (72, 'E3', '<p><u><strong>E3</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">E3-Unconjugated Estriol serum by RIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Weeks&nbsp;&nbsp; Ref.Range</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post LMP&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; (ng/ mL)</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 12&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.25-0.95&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 13&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.28-1.10&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 14&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.34-1.30&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 15&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.38-1.60&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 16&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.43-2.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 17&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.48-2.40&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 18&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.53-2.90&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 19&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.58-3.40&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 20&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.65-4.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 21&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.75-4.70&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 22-24&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.80-6.20&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 24-26&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.10-7.60&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 26-28&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.50-9.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 28-30&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.30-10.3&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30-32&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.10-11.9&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32-34&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.00-15.7&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 34-36&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.90-20.1&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 36-38&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5.80-22.7&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 38-40&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.40-24.0&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40-42&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.50-24.4&nbsp; ng/ mL</span></span></span></p>\r\n', '2022-03-17 16:07:11', '2022-04-05 16:21:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (73, 'AFP', '<p><u><strong>AFP</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Alpha Feto Protein(AFP)(Serum ,CLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;47.2ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nonpregnant :0.0-10.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15weeks : 6.5-70.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16weeks : 7.0-82.9 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;18weeks : 10.5-102 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;19-23weeks : 26.5-165 ng/ mL</span></span></span></p>\r\n', '2022-03-17 16:08:21', '2022-04-05 16:26:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (74, 'ANA', '<p><u><strong>ANA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody Screening(Serum,EIA)&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative (2.4)U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=10 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt;10 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 16:09:21', '2022-04-06 12:14:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (75, 'ANTI CCP', '<p><u><strong>ANTI CCP</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CCP Antibody Cyclic Citrullinated Peptide&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative &lt;5 U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative &lt;5 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; (Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;Positive &gt;= 5 U/mL </span></span></span></p>\r\n', '2022-03-17 16:11:36', '2022-04-06 12:21:52');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (76, 'LE Cell', '<p><u><strong>LE Cell</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Systemic Lupus Erythematosus Cells (LE Cell)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Not Detected</span></span></span></p>\r\n', '2022-03-17 16:13:00', '2022-04-06 12:23:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (77, 'HBeAg', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HBeAg</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HBeAg-HepatitsBEnvelopeAntigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 1.0 COI: NON REACTIVE</span></span></span></p>\r\n', '2022-03-17 16:14:02', '2022-04-06 12:25:02');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (78, 'RA Factor     ', '<p><u><strong>RA Factor</strong></u>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RA Factor&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 8 IU/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Slide Agglutination Method Dillution : 1:16 </span></span></span></strong></p>\r\n\r\n<p><strong>&nbsp; &nbsp; &nbsp;</strong></p>\r\n', '2022-03-17 16:15:20', '2022-04-06 12:27:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (79, 'A.S.O Titre    ', '<p><u><strong>A.S.O Titre</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;A.S.O Titre&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 200 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Silde Agglutination Method Dillution : 1:2</span></span></span></p>\r\n\r\n<p>&nbsp; &nbsp;</p>\r\n', '2022-03-17 16:16:28', '2022-04-06 12:33:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (80, 'C.R.P (C - REACTIVE PROTEIN )  ', '<p><u><strong>C.R.P (C - REACTIVE PROTEIN </strong></u><strong><u>)</u> </strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C.R.P (C - Reactive Protein )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative : &lt; 6 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Slide Agglutination Method Dillution : 1:16&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 16:17:53', '2022-04-06 12:35:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (81, 'CA-125', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CA-125</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cancer Antigen-125(CA-125)(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30.1 U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;30.2 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:18:43', '2022-04-05 16:56:46');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (82, 'CERULOPLASMIN', '<p><u><strong>CERULOPLASMIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ceruloplasmin&nbsp;(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 60 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 20 - 60 mg/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:26:53', '2022-04-06 12:39:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (83, 'SERUM IgE', '<p><u><strong>SERUM IgE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IgE Total antibody,(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100 IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 100 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:28:29', '2022-04-06 12:41:08');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (84, 'SERUM lgG', '<p><u><strong>SERUM lgG</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lgG Total&nbsp;(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1600 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 700 -1600 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:29:28', '2022-04-06 12:43:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (85, 'HbcAb-Total', '<p><u><strong>HbcAb-Total</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbcAb-Total Ab to Hep-B Core Ag (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive(0.21) &lt;1 Index&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt;1 Index</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive: &gt;= 1 Index</span></span></span></p>\r\n', '2022-03-17 16:32:11', '2022-04-05 17:14:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (86, 'HbcAb-lgM Ab', '<p><u><strong>HbcAb-lgM Ab</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbcAb-lgM Ab Hepatitis B Core antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt; 1.0 S/CO&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt; 1.0 S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive: &gt;= 1.0 S/CO</span></span></span></p>\r\n', '2022-03-17 16:38:06', '2022-04-05 17:21:02');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (87, 'INDIRECT COOMB&amp;amp;amp;amp;amp;#039;S TEST(ICT', '<p><u><strong>INDIRECT COOMB&#39;S TEST(ICT)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Coomb&#39;s Test -lndirect(Serum,Gel Card&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Centrifugation)&nbsp;</span></span></span></p>\r\n', '2022-03-17 16:40:04', '2022-04-06 12:49:49');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (89, 'FREE T3 (FEMALE)', '<p><u><strong>FREE T3</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free T3 (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4.2 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.4 - 4.2 pg/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Pregnacy : 2.3-8 pg/mL</span></span></span></strong></p>\r\n', '2022-03-17 16:41:18', '2022-04-06 12:51:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (90, 'FREE T4 (FEMALE)                                  ', '<p><u><strong>FREE T4</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free T4(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.8 - 1.8 ng/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; First Trimester:0.7 -2.0 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Second Trimester:0.5 -1.6 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Third Trimester:0.5-1.6 ng/dL&nbsp;&nbsp;</span></span></span></strong></p>\r\n', '2022-03-17 16:42:48', '2022-04-06 12:55:44');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (91, 'AMYLASE TEST   ', '<p><u><strong>AMYLASE TEST</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Amylase Level&nbsp;(Serum CNPG3 Substrate)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 125 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 25-125 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:44:13', '2022-04-06 12:53:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (92, 'LIPASE TEST', '<p><u><strong>LIPASE TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lipase(Serum Neumann Colorimetric)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10 - 160U/L</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 16:45:30', '2022-04-06 13:02:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (93, 'D-DlMER Quantitative          ', '<p><u><strong>D-DlMER Quantitative</strong></u> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">D-DlMER Quantitative&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;163 ngFEU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 - 500 ngFEU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Citrated plasma,lmmunoturbidimetry)&nbsp; &nbsp; </span></span></span></p>\r\n', '2022-03-17 16:46:41', '2022-04-06 13:04:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (94, 'PROTHROBIN TIME(PT INR)', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PROTHROBIN TIME (PT) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TEST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 11&nbsp; -&nbsp; 16 Seconds&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CONTROL&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PT(INR) Value&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Normal Population:0.8 - 1.2</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Standard Therapy:2 to 3</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;High dose Therapy: 3 to 4.5</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 16:51:54', '2022-04-06 13:05:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (95, 'APTT', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ACTIVATED PARTIAL THROMBOPLASTIN TIME (APTT) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TEST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 - 40 Seconds</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CONTROL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:53:40', '2022-04-06 13:06:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (96, 'HbA1C', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">GLYCATED HAEMOGLOBIN (HbA1C) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbA1C-Glycated Haemoglobin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;5.6 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non diabetic:&lt;= 5.6 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Pre diabetic:5.7-6.4 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Diabetic : &gt;= 6.5 %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Estimated Average Glucose(eAG)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 122.63 mg/dL</span></span></span></p>\r\n', '2022-03-17 16:58:51', '2022-04-07 11:44:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (97, 'PERIPHERAL SMEAR', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PERIPHERAL SMEAR REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RBCs appear&nbsp; Normochromic and Normocytic. </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">WBC count normal.No atypical cells seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Platelets adequate&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; P 58%&nbsp;&nbsp; L 37 %&nbsp;&nbsp; E 05%&nbsp;&nbsp; M 00%&nbsp;&nbsp;&nbsp; B 00%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IMPRESSION: Peripheral smear appears within normal limit.</span></span></span></p>\r\n', '2022-03-17 17:00:16', '2022-03-17 17:00:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (98, 'PTH', '<p><u><strong>PTH REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PTH-(lNTACT Molecule)(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;65 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 15 -65 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:01:38', '2022-04-06 13:08:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (99, 'URINE PROTEIN/CREATININE RATIO', '<p><u><strong>URINE PROTEIN/CREATININE RATIO</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE CHEMISTRY</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE PROTEIN/CREATININE RATIO: </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein,Urine by Pyrogallol red method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by Jaffe Method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein - Creatinine Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 0-0.3</span></span></span></p>\r\n', '2022-03-17 17:03:41', '2022-04-06 13:09:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (100, 'INSULIN', '<p><u><strong>INSULIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Insulin(Random)*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post glucose samples after:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 minutes : 18 - 172 ulU/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;60 minutes : 12 - 134 ulU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;90 minutes : 12 - 107 ulU/mL&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;120 minutes: 12 - 82 ulU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;180 minutes: 2 -23 ulU/mL</span></span></span></p>\r\n', '2022-03-17 17:06:32', '2022-04-06 13:10:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (101, 'FERRITIN', '<p><u><strong>FERRITIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ferritin&nbsp;(Serum,ECILA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.6 -204 ng/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:20:30', '2022-04-06 13:10:52');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (102, '24 HR URINE CREATININE CLEARANCE TEST', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">24 hr Urine Creatinine Clearance Test</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Clearance Test</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.9- 1.3 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by jaffe Method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(24 Hrs Urine jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Urine volume in 24 hours&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,24hrs Urine(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 58 mg/ 24 hrs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1000 - 2000</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Body surface area&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Sq m</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Clearence (Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;44 ml/min/1.73 sq m&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 76-120</span></span></span></p>\r\n', '2022-03-17 17:26:09', '2022-04-06 13:11:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (103, 'AMH', '<p><u><strong>AMH</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">AMH Mullerian Inhibiting Substance(Serum,ECLlA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.9 -9.5 ng/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 17:28:07', '2022-04-06 13:13:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (104, 'HbsAg( CMIA)', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HbsAg</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbsAg,CMlA*&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive(4640.39)S/CO&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt;1.0S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive: &gt;=1.0S/CO</span></span></span></p>\r\n', '2022-03-17 17:30:05', '2022-04-06 11:44:12');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (105, 'CA- 15.3                      ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>CA- 15.3</strong></u></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CA- 15.3&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 31.3&nbsp; U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 - 31.3 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><strong>&nbsp;</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 17:31:05', '2022-04-06 11:51:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (106, 'VITAMIN B12', '<p><u><strong>VITAMIN B12</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Vitamin B12 level(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 771 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 197 - 771 pg/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:31:57', '2022-04-06 11:56:08');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (107, 'CMV IgG', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CMV IgG</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CMV IgG,Serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.0 a U/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive : &lt;6.0 aU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive&nbsp; : &gt;=6.0 aU/ml&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:14:59', '2022-04-06 12:02:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (108, 'SPUTUM AFB', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">SPUTUM AFB</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SPUTUM EXAMINATION REPORT</span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(1). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum&nbsp; (1st day)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(2). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum (2nd day)&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(3). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum (3rd day)&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:18:29', '2022-04-06 12:01:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (109, 'FOLIC ACID               ', '<p><u><strong>Folic Acid</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Folic Acid&nbsp;(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0&nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;1.2 - 7.1 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 22:20:17', '2022-04-06 12:05:37');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (110, 'Urea Nitrogen(BUN)', '<p><u><strong>Urea Nitrogen(BUN)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">BUN- Blood Urea Nitrogen(Serum,Urease)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 8.9 - 20.6 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 22:21:32', '2022-04-06 12:10:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (111, 'MANTOUX TEST', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MANTOUX TEST REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PPD 10TU GIVEN ON THE LEFT FORE ARM&nbsp; AT 12:30 PM</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">INDURATION&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2 X 2 mm</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ERYTHEMA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RESULTS &amp; INTERPRETATION</span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">POSITIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;INDURATION MEASURING 10mm OR MORE.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DOUBTFUL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; INDURATION MEASURING BETWEEN 5mm AND 9mm.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">NEGATIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;INDURATION OF LESS THAN 5mm.&nbsp;</span></span></span></p>\r\n', '2022-03-17 22:24:16', '2022-04-06 12:36:10');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (112, 'LDL CHOLESTEROL          ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>LDL CHOLESTEROL TEST</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LDL CHOLESTEROL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;000 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Optimal : &lt; 100 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Near Optimal/above Potimal :</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;100-129 mg/ dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Borderline High : 130-159 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; High : 160-189 mg/dL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Very High : &gt;=189 mg/ dL</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:26:13', '2022-04-06 12:43:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (113, 'Toxoplasma IgG', '<p><u><strong>Toxoplasma IgG</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Toxoplasma IgG(Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.0 IU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive : &lt;1.6 IU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Grayzone : 1.6-3.0 IU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive : &gt;=3.0 IU/ml</span></span></span></p>\r\n', '2022-03-17 22:28:01', '2022-04-06 12:52:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (114, 'Toxoplasma IgM', '<p><u><strong>Toxoplasma IgM</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Toxoplasma IgM(Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 Index&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; Non Reactive: &lt; 0.5&nbsp;&nbsp; Index&nbsp; &nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Grayzone:0.5-0.59 Index&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive:&gt;=0.6 Index</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:30:17', '2022-04-06 13:07:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (115, 'Anti Sperm Antibody (ASAB)', '<p><u><strong>Anti Sperm Antibody (ASAB) TEST</strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Sperm Antibody (ASAB)(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 U/mL&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt;=60 U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Positive:&gt; 60U/mL&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:33:40', '2022-04-06 13:25:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (116, 'Albumin/Creatinine Ratio Urine          ', '<p><u><strong>Albumin/Creatinine Ratio Urine</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Creatinine Ratio Urine&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Urine)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin in Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(immuno Turbidiometry)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&gt; 50 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Jaffes kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &lt; 0.3 &gt; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:36:01', '2022-04-06 13:34:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (117, '125 VITAMIN D', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">125 VITAMIN D</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Vitamin D-125 Dihydroxy,serum by CLIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00.0 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;19.9&nbsp; -&nbsp; 79.3 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Please note&nbsp;change&nbsp;</span></span></span><font face=\"Calibri, sans-serif\">&nbsp;</font></p>\r\n\r\n<p style=\"margin-bottom:14px\"><font face=\"Calibri, sans-serif\"><span style=\"font-size: 14.6667px;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span>&nbsp;</font><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">in ref.range and method.</span></span></span></p>\r\n', '2022-03-22 10:33:41', '2022-04-06 13:41:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (118, 'S.Acid Phosphatase(Total)', '<p><u><strong>S.Acid Phosphatase(Total)</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">S.Acid Phosphatase(Total)</span></span><span style=\"tab-stops:346.85pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Enzymatic</span></span></span><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.3 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.3 &nbsp;-&nbsp; 9.2 U/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:346.85pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></span></p>\r\n', '2022-03-22 10:34:45', '2022-04-06 13:49:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (119, '24 HRS URINE PROTEINS', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PROTEINS URINE 24Hrs</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-family: Calibri, sans-serif; font-size: 11pt;\">Urine Chemistry :</span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein Urine 24 hrs,Colourimetry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;150mg/24hrs.&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;upto 150mg/24hrs.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein,Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by Drychemistry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein-Creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal:&lt;0.3:1</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Calcium Creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt; 0.3:1</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 10:47:24', '2022-04-05 12:39:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (120, 'ANTI DS  DNA', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>DNA(Double Strand)Antibody</strong></u></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DNA(Double Strand)Antibody(Serum,ELISA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:20 IU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt; 25 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt; 25 IU/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 10:58:40', '2022-04-05 12:45:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (121, ' ACE', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ACE (Angiotensin Converting Enzyme)</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ACE (Angiotensin Converting Enzyme)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;50 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 40 U/L</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; (Serum,Kinetic Assay)&nbsp;</span></span></span></strong></p>\r\n', '2022-03-22 11:00:39', '2022-04-05 12:51:52');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (122, ' DHEA', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">DHEA TEST</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-left:250px; text-indent:-186.75pt; margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DHEA &ndash; Dehydroepiandrostenedione&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.2 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1.2 - 6.3 ng/mL </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; (Serum,ELISA)&nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom: 14px;\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; Please note the change&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">in&nbsp;reference range</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom: 14px;\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span></p>\r\n', '2022-03-22 11:03:21', '2022-04-05 13:26:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (123, ' Iron', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Iron Test</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Iron(Serum,Ferrozine Method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;100 Ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 33-193 Ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:04:21', '2022-04-05 13:28:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (124, 'TIBC', '<p><u><strong>TIBC TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TIBC&nbsp;&nbsp;(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 300&nbsp;Ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 250-450 Ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ferritin&nbsp;(SERUM,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 13 -150 ng/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Transferin Saturation(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;39 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 14 - 50 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 11:05:53', '2022-04-05 13:32:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (125, 'lron, lCPMS**           ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>lron,Serum, lCPMS**</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lron,Serum, lCPMS**(Serum,lCPMS)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100 ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 55 - 120 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reference : Rodushkin l. et al.,Pure &amp; Applied Chem.,2001,5,pp 51-66.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:09:11', '2022-04-05 13:36:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (126, 'GAMMA GT                ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Gamma GT (GGTP)</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Gamma GT (GGTP)(Serum,IFCC method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;32 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;9 -36 U/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:11:26', '2022-04-05 13:38:37');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (127, 'Anti Nuclear Antibody, IFA', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody, IFA</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody , lFA&nbsp;&nbsp;(Serum,lmmunofluorescence)&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Result&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pattern&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; -&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Grade&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; -&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; -</span></span></span></p>\r\n', '2022-03-22 11:13:32', '2022-03-22 11:13:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (128, 'AFP-Alpha Feto Protein             ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>AFP-Alpha Feto Protein</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">AFP-Alpha Feto ProteinSerum,ECLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 7 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:14:36', '2022-04-05 14:56:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (129, 'C3(Complement-3)', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">C3(Complement-3)</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C3(Complement-3),Serum by Nephelometry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 110 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 90&nbsp;-&nbsp;180 mg/dL</span></span></span></p>\r\n', '2022-03-22 11:15:43', '2022-04-05 14:58:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (130, 'C4(Complement-4)', '<p><u><strong>C4(Complement-4)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C4(Complement-4),Serum by Nephelometry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10&nbsp;-&nbsp;40 mg/dL</span></span></span></p>\r\n', '2022-03-22 11:16:38', '2022-04-05 15:01:04');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (131, 'Homogentisic Acid   ', '<p><u><strong>Homogentisic Acid Test</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Homogentisic Acid(Alkaptanuria)(Urine)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:24:06', '2022-04-05 15:02:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (132, 'Osmolality Urine*             ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Osmolality Urine*</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Osmolality Urine*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1300 mOsm/kg&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 50 -1400 mosm/kg</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Urine,Freezing Point Depression)&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:25:01', '2022-04-05 15:08:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (133, 'Valproic Acid                  ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Valproic Acid</strong></u>&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Valproic Acid(Serum,CLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;50 ug/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Therapeutic range:50-100 ug/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:25:45', '2022-04-05 15:11:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (134, 'S.Homocysteine', '<p><u><strong>S.Homocysteine</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Homocysteine(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10.2 umol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5.46 -16.2 umol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:26:32', '2022-04-05 15:15:24');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (135, 'C-Peptide                   ', '<p style=\"margin-bottom:14px\"><u><strong>C-Peptide</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C-Peptide(Serum CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1676 pMol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Fasting:259 -1728 pMol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Stimulated: 500 -3000pMol/L</span></span></span></p>\r\n', '2022-03-22 11:27:39', '2022-04-05 15:19:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (136, 'CRP-C Reactive protein        ', '<p><u><strong>CRP-C Reactive protein</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CRP-C Reactive protein&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;&nbsp;6 mg/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,Nephelometry)</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:28:58', '2022-04-05 15:24:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (137, 'ASO titre        ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>ASO titre&nbsp;</strong></u>&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ASO titre Quantitative&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;150 IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 200 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum Nephelometry)&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:30:11', '2022-04-05 15:25:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (138, 'URINE CULTURE &  SENSITIVITY', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE CULTURE &amp; SENSITIVITY</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Urine</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH&nbsp; : Culture shows no growth after 48 hours of incubation at 37 C.</span></span></span></p>\r\n', '2022-03-22 11:32:18', '2022-04-05 15:56:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (139, ' SODIUM', '<p><u><strong>SODIUM</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SODIUM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;137 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 135 - 148 mmol/L&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:33:52', '2022-04-05 15:30:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (140, 'POTASSIUM', '<p><u><strong>POTASSIUM TEST</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">POTASSIUM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4.1 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.5 - 5.1 mmol/L</span></span></span></p>\r\n', '2022-03-22 11:34:35', '2022-04-05 15:32:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (141, 'Serotonin', '<p><span style=\"font-size:18px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Serotonin</span></span></strong></u></span></p>\r\n\r\n<p><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Serotonin , Serum&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 200 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 - 400 ng/mL</span></span></span></strong></p>\r\n', '2022-03-22 11:35:15', '2022-04-05 15:35:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (142, 'CA-19.9                       ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>CA-19.9</strong></u>&nbsp;</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CA-19.9(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 25 U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;&nbsp;27 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:35:58', '2022-04-05 15:37:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (143, 'BLOOD CULTURE & SENSITIVITY ', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">BLOOD CULTURE &amp; SENSITIVITY </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;:&nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH : Blood culture shows no Pathogenic Organism seen after 7 days of incubation at 37 C.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CULTURE&amp;SENSITIVITY-BLOOD</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Microscopy Result&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;Sample Date :</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Report Date :</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Blood&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Gram Stain&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;No micro-Organisms seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <u>Final Report</u></span></span></b></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Organism(s)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; :&nbsp;&nbsp;&nbsp; No growth after one week of incubation.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:37:33', '2022-04-05 15:46:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (144, 'SEMEN ANALYSIS', '<p><u><strong>SEMEN ANALYSIS REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PHYSICAL CHARACTERISTICS</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Volume&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ml&nbsp;( 2&nbsp; -&nbsp; 5 ml )</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; :</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Consistency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Liquefaction Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROSCOPICAL EXAMINATION</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Total Sperm Count&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Millions/ml&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MOTILITY GRADING</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a).(Rapid Progressive)&nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">b).(Slow Progressive)&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c).(Non-progressive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;20 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">d).(Immobile)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MORPHOLOGICAL GRADING</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Normal&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 40 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Abnormal&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 60 %&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; 1-2 /hpf</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;Nil /hpf</span></span></span></p>\r\n', '2022-03-22 11:43:46', '2022-04-05 15:47:44');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (145, 'HLA B27', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27(Human Luecocyte Antigen B27)&nbsp;(EDTA Whole Blood)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27 Detection&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Remark&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp;:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Result Confirmed by Molecularmethod</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Method&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Flow Cytometry&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:59:57', '2022-04-05 15:48:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (146, '17 Hydroxy Progesterone ', '<p style=\"margin-bottom:14px\"><u><strong>17 Hydroxy Progesterone</strong></u><strong>&nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">17 Hydroxy Progesterone &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.12 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Adult Female&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;(serum by RIA Method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Follicular Phase 0.15 - 1.1ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Luteal phase 0.7 - 5.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Pregnancy&nbsp; 2.5&nbsp; -&nbsp; 18.9 ng/ mL</span></span></span></p>\r\n', '2022-03-22 12:02:53', '2022-04-05 15:51:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (147, 'Dengue (NS1)', '<p><u><strong>Dengue (NS1)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Dengue (NS1) Antigen(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Negative :&nbsp; 9PanBio Units&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative : &lt;9PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Equivocal:9-11PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;11PanBio Units</span></span></span></p>\r\n', '2022-03-22 12:04:16', '2022-04-05 15:56:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (148, 'ACTH', '<p><u><strong>ACTH</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ACTH-Adreno Corticotropic Hormone(Plasma)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;3.6 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 to 46pg/mL&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:05:22', '2022-04-05 15:58:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (149, 'AMMONIA', '<p><u><strong>AMMONIA</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ammonia(Heparin Whole Blood,Enzymatic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;40 umol/L&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;30 - 65 umol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:06:56', '2022-04-05 16:00:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (150, 'SEMEN CULTURE & SENSITIVITY', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SEMEN CULTURE &amp; SENSITIVITY</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH&nbsp; :&nbsp; Culture shows no growth after 48 hours of incubation at 37 C.</span></span></span></p>\r\n', '2022-03-22 12:08:56', '2022-04-05 16:06:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (151, 'TPHA', '<p><u><strong>TPHA</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TPHA(Serum)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lnterpretation:&nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Treponema Pallidium Haemagglutination (TPHA)</span></span></span></p>\r\n', '2022-03-22 12:09:50', '2022-04-05 16:07:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (152, 'HIV 1&11', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HIV 1&amp;11</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HIV 1&amp;11,CMIA*&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive:&nbsp; &nbsp; &nbsp;COl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive: &lt; 1.0 COl</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive&nbsp;&nbsp;&nbsp; : &gt;=1.0 COl</span></span></span></p>\r\n', '2022-03-22 12:11:44', '2022-04-05 16:10:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (153, 'Hepatitis B Surface Antibody', '<p><u><strong>Hepatitis B Surface Antibody</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Hepatitis B Surface Antibody(Anti HBs)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;10 mlU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp;(Serum,CMlA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;(Below Protection):&lt;10mlU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive(Protective):&gt;=10mlU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span></p>\r\n', '2022-03-22 12:14:03', '2022-04-05 16:16:15');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (154, 'MPO- ANCA', '<p><u><strong>MPO- ANCA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MPO- ANCA(p-ANCA)*(Serum,ELISA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt; 20 RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt; 20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-22 12:29:56', '2022-04-05 16:18:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (155, 'PR3 -ANCA                         ', '<p><u><strong>PR3 -ANCA</strong></u><strong> </strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PR3 -ANCA (c -ANCA)*(Serum,EIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;20 RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;=20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ADDITIONAL TEST : PLA2R(phospholipase A2 receptor)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Antibody : A novel marker for IMN(ldiopathic Membranous Nephropathy)</span></span></span></p>\r\n\r\n<p><strong>&nbsp;</strong> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>\r\n', '2022-03-22 12:31:17', '2022-04-05 16:20:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (156, 'GFR', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">GFR</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">GFR With Creatinine(Serum)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine(jaffes kinetic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;0.9 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.8-1.3 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">eGFR(CKD-EPl)(jaffe)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ml/min/1.73 sqm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal OR high:&gt;=90</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mild or decrease:60 -89</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mild to moderate decrease:45-59</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mild to severe decrease:30-44</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; severe decrease:15-29</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Kidney failure:&lt;15</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Note: Equation is notvalid for patients below 18 years of age Caculated</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;by lDMS-TraceableCKD-EPl Creatinine equation.</span></span></span></p>\r\n', '2022-03-22 12:34:43', '2022-04-05 16:26:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (157, 'HsCRP', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HsCRP</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HsCRP-High Sensitivity CRP*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;= 2mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;= 3 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;(Serum,Nephelometry)&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:35:54', '2022-04-05 16:28:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (158, 'Lipoprotein(a)*               ', '<p><u><strong>Lipoprotein(a)*</strong></u> &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lipoprotein(a)*(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;23 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -30 mg/dl</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 12:36:39', '2022-04-05 16:28:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (159, 'Bicarbonate', '<p><u><strong>Bicarbonate</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Bicarbonate&nbsp;(Serum,Enzymatic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 17&nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 16 - 25 mmol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:37:26', '2022-04-05 16:31:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (160, ' G6PD', '<p><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span></strong><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">G6PD</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">G6PD-quantitative,&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Not Deficiennt(7.1)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;6.97-20.5 Units/gm of HB</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">blood by kinetic method*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Units/gm of HB&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(EDTA Whole Blood,Enzymatic)</span></span></span></p>\r\n', '2022-03-22 12:38:23', '2022-04-05 16:37:12');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (161, 'Protein S Activity*            ', '<p><u><strong>Protein S Activity*</strong></u><strong> &nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein S Activity*&nbsp;(Citrated plasma)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;55 -123 &nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Pregnant: 55 -123 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;First Trimester: 57 -95%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:42 68%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Third Trimester: 16 42%</span></span></span></p>\r\n', '2022-03-22 12:39:55', '2022-04-05 16:44:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (162, 'Protein C Activity*           ', '<p><u><strong>Protein C Activity*</strong></u>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein C Activity*(Citrated plasma)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;70 -130 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Pregnant: 70 -130%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;First Trimester:78 -121%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:83 -133%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Third Trimester:67 -135%</span></span></span></p>\r\n', '2022-03-22 12:41:44', '2022-04-05 16:46:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (163, 'Beta-2-Microglobulin*                ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Beta-2-Microglobulin*</strong></u><strong>&nbsp;</strong>&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Microglobulin*(Serum,ELFA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.143 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.670-2.143 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:43:19', '2022-04-05 16:48:08');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (164, 'MICRO FILARIA ', '<p><u><strong>MICRO FILARIA<span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">(MF)</span></span></span></strong></u>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Filaria Antigen detection(EDTA Whole Blood)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Filaria Antibody detection(Serum)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Method&nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Immunochromatography</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 12:45:52', '2022-04-05 16:49:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (165, 'HSV-1&amp;2', '<p><u><strong>HSV-1&amp;2</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HSV-1&amp;2 (Herpes Simplex&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 0.8 lndex&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Negative:&lt; 0.8 lndex</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Virus-1&amp;2)lgG antibody*(Serum,CLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Equivocal:0.8-1.1 lndex</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;=1.1 lndex</span></span></span></p>\r\n', '2022-03-22 12:47:31', '2022-04-05 16:52:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (166, 'HSV-1&2 IgM', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HSV-1&amp;2 IgM</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HSV-1&amp;2 IgM antibody*(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&lt;0.8&nbsp;Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;0.8 Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Borderline:0.8-1.1 Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;1.1 Ratio&nbsp;&nbsp;&nbsp;&nbsp;</strong>&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:49:36', '2022-04-05 16:55:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (167, '24 HRS Urine  Albumin Quantitative ', '<p><u><strong>24 HRS Urine &nbsp;Albumin Quantitative</strong></u><strong>&nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin QuantitativeUrine 24H(24 Hrs URINE)</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin in Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;23 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;= 30 mg/L</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; (lmmunoturbidimetry)&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Urine Volume in 24 hours&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin urea&nbsp; by&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;200 mg/24hrs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Normal: &lt; 150 mg/24hrs&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lmmunoturbidimetry</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;(lmmunoturbidimetry)</span></span></span></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 13:06:38', '2022-04-05 16:59:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (168, ' EPTOIN', '<p><strong>&nbsp;</strong><u><strong>EPTOIN</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Phenytoin(Eptoin)(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 14&nbsp; ug/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Therapeutic range : 10-20 ugmL </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Toxic range : &gt; 20 ug/mL</span></span></span></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 13:08:04', '2022-04-05 17:01:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (169, 'LIVER FUNCTION TEST           ', '<p><u><strong>LIVER FUNCTION TEST</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Serum Bilirubin - Total&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.1&nbsp;mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Upto 1.2 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Serum Bilirubin -&nbsp; Direct&nbsp;&nbsp;&nbsp;&nbsp; </span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">0.2</span></span>&nbsp;<span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;<span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Upto 0.2 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">SGOT / AST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M Upto 40 F Upto 31 U/L&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp;SGPT / ALT&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;28 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; M Upto 40 F Upto 31 U/L&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Serum Alkaline Phosphatase&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 110 U/L&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">80 - 290 U/L&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Children 245 - 770 U/L&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Total Protein </span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp; &nbsp;&nbsp; 7.0 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">6.0 - 8.0 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 4.4 gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.7 - 5.3 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Globulin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.3 gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2.3 - 3.6 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">A/G Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 1.0 -2.3&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;&nbsp;&nbsp;</span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 14:56:36', '2022-04-05 17:39:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (170, 'Serum Bilirubin - Total       ', '<p><span style=\"font-size:16px;\"><u><strong>Serum Bilirubin - Total</strong></u><strong> &nbsp;</strong></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Serum Bilirubin - Total&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.2&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Upto 1.2 mg/dL</span></span></b></span></p>\r\n', '2022-03-22 15:16:48', '2022-04-05 17:43:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (171, 'Serum Bilirubin -  Direct     ', '<p><span style=\"font-size:16px;\"><u><strong>Serum Bilirubin - &nbsp;Direct</strong></u></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Serum Bilirubin -&nbsp; Direct&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.1 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Upto 0.2 mg/dL &nbsp;&nbsp;</span></span></b></span></p>\r\n', '2022-03-22 15:18:33', '2022-04-05 17:45:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (172, 'SGOT / AST                    ', '<p><span style=\"font-size:16px;\"><u><strong>SGOT / AST&nbsp;</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">SGOT / AST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L&nbsp;&nbsp;</span></span></b></span></p>\r\n', '2022-03-22 15:20:06', '2022-04-05 17:47:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (173, 'SGPT / ALT                    ', '<p><span style=\"font-size:16px;\"><u><strong>SGPT / ALT</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"color:#000000;\">SGPT / ALT</span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L&nbsp;</span> &nbsp; &nbsp;</span></span></span></b></p>\r\n', '2022-03-22 15:21:58', '2022-04-05 17:49:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (174, 'Serum Alkaline Phosphatase    ', '<p><span style=\"font-size:16px;\"><u><strong>Serum Alkaline Phosphatase</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:14px;\"><strong>Serum Alkaline Phosphatase&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-family:Arial,Helvetica,sans-serif;\">&nbsp;</span></strong><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"line-height:115%\">290 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;80 - 290 U/L&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></b></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"line-height:115%\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></b><span style=\"line-height:normal\"><b>Children 245 - 770 U/L</b></span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:14px;\"> </span>&nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b></p>\r\n', '2022-03-22 15:25:29', '2022-04-05 17:53:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (175, 'Total Protein                 ', '<p><span style=\"font-size:16px;\"><u><strong>Total Protein</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Total Protein&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;7.1 gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.0 - 8.0 gm %</span></span></b></span></p>\r\n', '2022-03-22 15:26:39', '2022-04-06 10:03:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (176, 'S.Albumin', '<p><span style=\"font-size:16px;\"><u><strong>S.Albumin</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.3 gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.7 - 5.3 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></b></span></p>\r\n', '2022-03-22 15:28:02', '2022-04-06 10:08:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (177, 'Globulin', '<p><span style=\"font-size:18px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Globulin</span></span></strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Globulin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.4 gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.3 - 3.6 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></b></span></p>\r\n', '2022-03-22 15:29:09', '2022-04-06 10:10:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (178, 'COMPLETE  BLOOD  COUNT        ', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><b><span style=\"line-height:115%\"><u>COMPLETE&nbsp; BLOOD&nbsp; COUNT</u></span></b></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;Hb&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 11.5&nbsp;gm%&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;M:12.5-18 F:11.5-16gm%</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">WBC:-</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10,000 Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4,000 -11,000 Cells/cmm</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;Differential Count:-</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Polymorphs&nbsp;</span></b></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">45&nbsp;</span></b></span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;45 - 74 %&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 16 - 45 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;7&nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -&nbsp; 7 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4 - 10 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;0 -&nbsp; 2 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;millions/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M: 5.5-6.5 F:4.0-5.5milli</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Platelet Count&nbsp;</span></b></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; 1.5</span></b></span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;lakhs/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.5 - 4.0 lakhs/cmm</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">PCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 40 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M : 40-54 % F: 36-47 %&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">MCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;82.0&nbsp; fl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;82.0 - 96.0 fl&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">MCH&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;27.0&nbsp;pg&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 27.0 - 34.0 pg&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">MCHC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32.0&nbsp;g/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32.0 - 38.0 g/dl&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15 mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:0-9F:0-15 mm/hr</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:40:29', '2022-04-08 10:09:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (179, 'Hb  ', '<p><span style=\"font-size:16px;\"><u><strong>Hb</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"line-height:115%\">Hb</span></b><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.00&nbsp;</strong></span><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">gm%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:12.5-18 F:11.5-16gm%&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span> &nbsp;&nbsp;</span></span></b></span></p>\r\n\r\n<p>&nbsp; &nbsp;</p>\r\n', '2022-03-22 15:42:54', '2022-04-06 10:37:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (180, 'WBC', '<p><span style=\"font-size:16px;\"><u><strong>WBC</strong></u></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00,000 Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4,000 -11,000 Cells/cmm&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:44:30', '2022-04-06 11:48:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (181, 'Differential Count', '<p><span style=\"font-size:16px;\"><u><strong>Differential Count</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Polymorphs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 45 - 74 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16 - 45 %&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0 -&nbsp; 7 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4 - 10 %</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0&nbsp;-&nbsp; 2 %&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:49:05', '2022-04-06 12:02:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (182, 'RBC', '<p><span style=\"font-size:16px;\"><u><strong>RBC</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.0 millions/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M: 5.5-6.5 F:4.0-5.5millions/cmm</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:51:27', '2022-04-08 10:14:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (183, 'Platelet Count                ', '<p><span style=\"font-size:16px;\"><u><strong>Platelet Count</strong></u><strong>&nbsp;</strong></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"line-height:normal\"><b>&nbsp;Platelet Count&nbsp;&nbsp;</b></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;<strong>3.0&nbsp;</strong><span style=\"line-height:normal\"><b>lakhs/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.5 - 4.0 lakhs/cmm&nbsp;&nbsp;</b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\n&nbsp;</p>\r\n', '2022-03-22 15:52:53', '2022-04-07 09:59:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (184, ' PCV                           ', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><span style=\"line-height:115%\">&nbsp;</span><strong><u><span style=\"line-height:115%\">PCV</span></u><span style=\"line-height:115%\">&nbsp;</span></strong></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;PCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M : 40-54 % F: 36-47 %&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:54:34', '2022-04-06 12:16:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (185, 'ESR', '<p><span style=\"font-size:16px;\"><u><strong>ESR</strong></u></span></p>\r\n\r\n<p><br />\r\n<span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0-15 mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:0-9F:0-15 mm/hr</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:56:01', '2022-04-06 12:21:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (186, 'LIPID PROFILE                 ', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:14px;\"><u><strong>LIPID PROFILE</strong></u><strong>&nbsp;</strong></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Total Cholesterol&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><span style=\"font-size:14px;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">140 mg/dL&nbsp;</span></span></span><span style=\"font-size:14px;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">Adults:140-200mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span>C<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">hildren :&lt;150 mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Triglycerides&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 100&nbsp;</span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 40-165&nbsp; mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">HDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45&nbsp;</span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:30-55 F: 45-65 mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">LDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-size:12.0pt\">140 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Upto 150&nbsp; mg/dL&nbsp;</span></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">VLDL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; Upto 40&nbsp; mg/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\n&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:02:53', '2022-04-07 10:59:22');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (187, 'Total Cholesterol             ', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><strong><u><span style=\"line-height:115%\">Total Cholesterol</span></u></strong></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">&nbsp;&nbsp;</span>&nbsp;</span></span></span></b></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Total Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;200&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Adults:140-200mg/dL&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">children :&lt;150 mg/dL&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:05:18', '2022-04-06 12:34:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (188, 'Triglycerides', '<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\">Triglycerides</span></strong></u></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:16px;\"><strong><span style=\"line-height:115%\">Triglycerides&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;100&nbsp;</span></strong></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;40-165&nbsp; mg/dL&nbsp;&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:06:35', '2022-04-06 12:57:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (189, 'HDL - Cholesterol             ', '<p><span style=\"font-size:16px;\"><u><strong>HDL - Cholesterol</strong></u><strong> </strong></span>&nbsp; &nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">HDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 55 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M:30-55 F: 45-65 mg/dL&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:10:19', '2022-04-06 12:59:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (191, 'RENAL FUNCTION TEST           ', '<p><span style=\"font-size:16px;\"><u><strong>RENAL FUNCTION TEST</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Blood Urea&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 87 mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;14 - 40&nbsp;&nbsp; mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">S.Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2.0&nbsp;mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M :- 0.6 - 1.2 mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;F :- 0.5 - 1.1 mg%&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">S.Uric Acid&nbsp;</span></b></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\"font-size:16px;\"><strong>10.2&nbsp;</strong></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\"><span style=\"font-size:16px;\">mg%&nbsp; </span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;M :- 3.5 - 7.2 mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; F : - 2.6 - 6.0 mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><strong>&nbsp;</strong></span> &nbsp; &nbsp;</p>\r\n', '2022-03-22 16:16:22', '2022-04-06 14:04:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (192, 'Blood Urea   ', '<p><span style=\"font-size:16px;\"><u><strong>Blood Urea</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Blood Urea&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;30 mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;14 - 40&nbsp;mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:19:50', '2022-04-06 13:23:07');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (193, ' S.Creatinine                  ', '<p><strong>&nbsp;</strong><span style=\"font-size:16px;\"><u><strong>S.Creatinine</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp;S.Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.2 mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M :- 0.6 - 1.2 mg%&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;F :- 0.5 - 1.1 mg%</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:21:24', '2022-04-07 12:45:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (194, 'S.Uric Acid                   ', '<p><span style=\"font-size:16px;\"><u><strong>S.Uric Acid</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;S.Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;7.2 mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M :- 3.5 - 7.2 mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;F : - 2.6 - 6.0 mg%&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:23:25', '2022-04-05 15:21:55');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (195, 'Blood Sugar (Random)          ', '<p><span style=\"font-size:16px;\"><u><strong>Blood Sugar</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Blood Sugar (Random)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;150 mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Upto 150 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><b><span style=\"font-size:12.0pt\">Corr .Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:31:16', '2022-04-06 11:20:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (196, 'Blood Sugar(Fasting)', '<p><strong><u><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">BLOOD SUGAR</span></span></span></u></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Sugar(Fasting)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;110 mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;70-110 mg/dl&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Corr .Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 16:32:57', '2022-04-07 10:40:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (197, 'Blood Sugar ( PPBS )          ', '<p><u><strong><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">BLOOD&nbsp; SUGAR</span></span></span></strong></u><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;</span></span></span></b></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Sugar ( PPBS )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;140 mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Up to 140 mg/dl&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Corr. Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Green</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:34:25', '2022-04-07 10:38:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (198, 'BLOOD GROUPING                ', '<p><u><strong>BLOOD GROUPING</strong></u>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;BLOOD GROUPING&nbsp; &nbsp;</span></b></span></span></span><span style=\"font-size:16px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&quot;B&quot;&nbsp;&nbsp;&nbsp;&nbsp;</span></b></span></span><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Rh TYPING</span></b></span></span></span><span style=\"font-size:16px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;</span></b></span></span><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:38:00', '2022-04-05 15:57:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (199, 'GLUCOSE TOLERANCE TEST', '<p><u><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">GLUCOSE TOLERANCE TEST</span></span></span></b></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;After 75gm Glucose :-&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp;2&nbsp; Hour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;110 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp;Corr. Urine Sugar&nbsp;&nbsp;</span></span></b></span></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Nil&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span>&nbsp;</p>\r\n', '2022-03-22 16:39:34', '2022-04-06 13:37:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (200, 'GCT ', '<p><span style=\"font-size:16px;\"><u><strong>GCT&nbsp;</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Blood Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 140 mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Up to 140 mg/dl&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;(1 hr after 50gm glucose given)</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Corr.Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:41:32', '2022-04-05 16:16:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (201, 'BLOOD  ROUTINE(R/E)', '<p><span style=\"font-size:16px;\"><u><strong>BLOOD &nbsp;ROUTINE(R/E)</strong></u></span></p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-size:14px;\">EXAMINATION OF BLOOD&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></b></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><b>&nbsp;Hb&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;12.2 gm%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:12.5-18 F:11.5-16gm%</b></p>\r\n\r\n<p><b>WBC:-</b></p>\r\n\r\n<p><b>Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 8,900&nbsp;Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4,000 -11,000 Cells/cmm</b></p>\r\n\r\n<p><b>Differential Count:-</b></p>\r\n\r\n<p><b>Polymorphs&nbsp;</b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<strong>75</strong><b><strong>%&nbsp; &nbsp;</strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;45 - 74 %</b></p>\r\n\r\n<p><b>Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;22%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6 - 45 %</b></p>\r\n\r\n<p><b>Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;03%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -&nbsp; 7 %</b></p>\r\n\r\n<p><b>Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;4 - 10 %</b></p>\r\n\r\n<p><b>Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;00%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -&nbsp; 2 %</b></p>\r\n\r\n<p><b>ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;05mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M:0-9F:0-15 mm/hr</b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:48:36', '2022-04-07 09:57:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (202, 'SEROLOGY', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">SEROLOGY</span></span></strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HBs Ag&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HIV 1 &amp; 2&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:53:25', '2022-04-05 16:44:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (203, 'HBs Ag(Card)                    ', '<p><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:18px;\"><strong><u>HBs Ag</u></strong>&nbsp;</span>&nbsp;</span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HBs Ag&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:56:03', '2022-04-05 16:49:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (204, 'HIV 1&2                     ', '<p><span style=\"font-size:16px;\"><u><strong>HIV 1 &amp; 2 </strong></u></span>&nbsp; &nbsp;</p>\r\n\r\n<p><span style=\"font-family:Arial,Helvetica,sans-serif;\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">HIV 1 &amp; 2&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">Negative&nbsp;&nbsp; </span></span></b></span></p>\r\n', '2022-03-22 16:57:05', '2022-04-07 11:17:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (205, 'VDRL', '<p><span style=\"font-size:18px;\"><u><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL</span></span></b></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:58:05', '2022-04-05 16:54:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (206, 'HCV ', '<p><span style=\"font-size:16px;\"><u><strong>HCV</strong></u><strong>&nbsp;</strong></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:59:24', '2022-04-05 16:58:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (207, 'Bleeding Time, Clotting Time', '<p><u><strong><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bleeding Time, Clotting Time</span></span></span></strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Bleeding Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1&#39; 15&quot;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 - 3&nbsp; minutes&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Clotting Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2&#39; 50&quot;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3- 7&nbsp; minutes&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:00:53', '2022-04-05 17:08:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (208, 'ABSOLUTE EOSINOPHIL COUNT (AEC)', '<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">ABSOLUTE EOSINOPHIL COUNT (AEC)</span></span></span></b></span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">ABOLUTE EOSINOPHIL COUNT&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40-440 Cells/ cmm&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:02:07', '2022-04-05 17:14:42');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (210, 'Urine Pregnancy', '<p><span style=\"font-size:16px;\"><u><strong>Urine Pregnancy Test</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Urine Pregnancy Test&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:04:23', '2022-04-05 17:24:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (211, 'Urine B J Protein             ', '<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:16px;\"><u>Urine B J Protein&nbsp;</u></span>&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Urine B J Protein&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:05:23', '2022-04-05 17:28:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (212, ' ELECTROPHORESIS', '<p><span style=\"font-size:16px;\"><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></strong><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ELECTROPHORESIS</span></span></strong></u></span></p>\r\n', '2022-03-22 17:06:28', '2022-03-22 17:06:28');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (213, 'ANA PROFILE', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ANA PROFILE</span></span></strong></u></span></p>\r\n', '2022-03-22 17:06:48', '2022-03-22 17:06:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (214, 'SERUM ELECTROLYTES          ', '<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><u>SERUM ELECTROLYTES</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Sodium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 155&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;135 -&nbsp; 155&nbsp; mmol / L&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><font face=\"Times New Roman, serif\"><span style=\"font-size: 16px;\"><b>Potassium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5.5&nbsp;</b></span></font><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.5 -&nbsp; 5.5&nbsp; mmol /&nbsp; L&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Bicarbonate&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;21 - 32 mmol/L&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Chloride&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;107&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;98 - 107 mmol/L&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:10:26', '2022-04-06 12:01:18');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (215, 'Chloride', '<p><span style=\"font-size:16px;\"><u><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Chloride</span></span></b></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Chloride&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;107 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 98 - 107 mmol/L&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:11:37', '2022-04-06 12:07:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (216, 'Urine Albumin', '<p><span style=\"font-size:16px;\"><u><strong>Urine Albumin</strong></u></span></p>\r\n\r\n<p><strong>Urine Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; Nill</strong></p>\r\n', '2022-03-22 17:16:06', '2022-04-06 12:25:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (217, 'Urine Sugar', '<p><span style=\"font-size:16px;\"><strong><u>Urine Sugar</u>&nbsp;</strong></span>&nbsp;</p>\r\n\r\n<p><strong>Urine Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil</strong></p>\r\n', '2022-03-22 17:17:17', '2022-04-06 12:34:47');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (218, 'MICROSCOPICAL EXAMINATION (Deposit)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">MICROSCOPICAL EXAMINATION (Deposit)</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Amorphous Urates&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:23:10', '2022-04-06 13:02:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (219, 'Urine Bile                    ', '<p><span style=\"font-size:16px;\"><u><strong>Urine Bile</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bile Pigment&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bile salt&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:24:56', '2022-04-06 13:08:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (220, 'THYROID FUNCTION TEST (MALE)', '<p style=\"margin-bottom:14px\"><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">THYROID FUNCTION TEST</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (CLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;180ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 60 - 180 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 60 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 180 ng/dL </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 ( CLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;11.5ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Euthyroid : 5 - 11.5 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; Hypothyroid : Below 5.0 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 11.5 ug/dL&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T.S.H(CLIA- ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.0uIU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid:0.4-4.0 uIU/ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Above 4.0uIU/ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Below 0.4 uIU/ml</span></span></span></strong></p>\r\n', '2022-03-22 17:27:31', '2022-04-05 13:06:10');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (221, 'T3(MALE)', '<p><span style=\"font-size:16px;\"><u><strong>T3</strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (ECLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;120&nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 60 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 180 ng/dL </span></span></span></p>\r\n', '2022-03-22 17:30:23', '2022-04-05 12:55:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (222, 'T4 (MALE)', '<p><u><strong><span style=\"font-size:16px;\">T4</span></strong></u><strong><span style=\"font-size:16px;\">&nbsp;</span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 ( ECLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 5 - 11.5 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 5.0 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 11.5 ug/dL</strong>&nbsp; </span></span></span></p>\r\n', '2022-03-22 17:37:22', '2022-04-05 12:50:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (223, 'TSH(MALE)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">T.S.H(MALE)</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T.S.H(ECLIA- ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;uIU/ mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Euthyroid:0.4-4.0 uIU/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Above 4.0uIU/ mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Below 0.4 uIU/ mL</span></span></span></strong></p>\r\n', '2022-03-22 17:38:45', '2022-04-05 12:43:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (224, 'FREE T4(MALE)', '<p><span style=\"font-size:14px;\"><u><strong>FREE T4</strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>Free T4(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.8 - 1.8 ng/ dL&nbsp;&nbsp;</strong>&nbsp; </span></span></span></p>\r\n', '2022-03-22 17:40:48', '2022-04-05 12:36:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (225, 'FREE T3 (MALE)', '<p><u><strong>FREE T3</strong></u></p>\r\n\r\n<p><strong>Free T3 (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.4 - 4.2 pg/mL</strong></p>\r\n\r\n<p><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</strong></p>\r\n', '2022-03-22 17:55:38', '2022-04-05 12:29:17');


#
# TABLE STRUCTURE FOR: lab_test
#

DROP TABLE IF EXISTS `lab_test`;

CREATE TABLE `lab_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `name` varchar(155) NOT NULL,
  `patient_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `production_cost` decimal(18,2) NOT NULL DEFAULT '0.00',
  `test_code` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=461 DEFAULT CHARSET=utf8;

INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (4, 16, 'OPG', '600.00', '500.00', 'OPG', '2022-03-14', 1, '2022-03-14 13:56:20', '2022-03-28 15:22:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (6, 10, 'CONSUMERABLE ITEMS', '50.00', '35.00', 'CONS', '2022-03-14', 1, '2022-03-14 16:00:17', '2022-03-14 16:00:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (8, 9, 'X-RAY LUMBO SACRAL SPINE AP-LAT', '300.00', '250.00', 'LSS', '2022-03-14', 1, '2022-03-14 17:07:27', '2022-04-07 19:08:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (9, 9, 'X-RAY CERVICAL SPINE AP-LAT', '300.00', '250.00', 'CS', '2022-03-14', 1, '2022-03-14 17:07:56', '2022-04-07 19:10:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (10, 9, 'X-RAY THORACIC SPINE AP-LAT', '300.00', '250.00', 'TS', '2022-03-14', 1, '2022-03-14 17:08:30', '2022-04-07 19:10:35');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (11, 9, 'X-RAY PELVIS AP', '250.00', '200.00', 'PEL', '2022-03-14', 1, '2022-03-14 17:09:01', '2022-04-07 19:10:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (12, 9, 'X-RAY CHEST PA', '250.00', '200.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:09:53', '2022-04-07 19:11:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (13, 9, 'X-RAY CHEST PA WITH REPORT', '300.00', '250.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:13:41', '2022-04-07 19:11:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (14, 9, 'X-RAY CHEST AP', '300.00', '250.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:14:06', '2022-04-07 19:11:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (15, 9, 'X-RAY KUB', '250.00', '200.00', 'KUB', '2022-03-14', 1, '2022-03-14 17:17:13', '2022-04-07 19:12:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (16, 9, 'X-RAY KNEE RIGHT AP-LAT', '300.00', '250.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:17:47', '2022-04-07 19:12:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (17, 9, 'X-RAY KNEE LEFT AP-LAT', '300.00', '250.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:18:48', '2022-04-07 19:13:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (18, 9, 'X-RAY KNEE AP-LAT-SUNRISE', '350.00', '300.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:19:24', '2022-04-07 19:13:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (19, 17, 'MAMMOGRAM SINGLE', '1250.00', '1000.00', 'MMG', '2022-03-15', 1, '2022-03-15 13:04:13', '2022-03-29 09:43:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (20, 17, 'MAMMOGRAM BOTH', '2500.00', '2200.00', 'MMG', '2022-03-15', 1, '2022-03-15 13:05:13', '2022-03-29 09:43:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (23, 16, 'CEPH', '250.00', '100.00', 'CEPH', '2022-03-15', 1, '2022-03-15 15:49:30', '2022-03-28 15:22:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (24, 24, '5D/4D DOPPLER', '3000.00', '2000.00', '5D', '2022-03-15', 1, '2022-03-15 16:27:25', '2022-03-29 10:06:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (30, 14, 'ECG WITH REPORT', '250.00', '100.00', 'ECG REPORT', '2022-03-16', 1, '2022-03-16 13:27:11', '2022-03-16 13:27:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (31, 23, 'DOPPLER NECK', '1300.00', '500.00', 'DOPP.', '2022-03-16', 1, '2022-03-16 13:29:32', '2022-03-29 09:36:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (33, 7, 'USG NB/NT', '1000.00', '500.00', 'NB/NT', '2022-03-16', 1, '2022-03-16 13:31:59', '2022-03-16 13:31:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (34, 7, 'USG ABDOMEN PELVIS(F)', '950.00', '400.00', 'ABD/PEL(F)', '2022-03-16', 1, '2022-03-16 13:33:42', '2022-03-16 13:37:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (36, 7, 'USG ABDOMEM(M)', '850.00', '400.00', 'ABD(M)', '2022-03-16', 1, '2022-03-16 13:37:05', '2022-03-16 13:37:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (37, 9, 'OPG...', '650.00', '300.00', 'MEDICITY', '2022-03-16', 1, '2022-03-16 13:41:18', '2022-03-16 13:41:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (40, 15, 'BMD', '2500.00', '1000.00', 'BMD MEDICITY', '2022-03-16', 1, '2022-03-16 13:46:45', '2022-03-16 13:46:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (41, 8, 'CT BRAIN AND LIMITED PNS', '3850.00', '2500.00', 'CT', '2022-03-16', 1, '2022-03-16 13:47:42', '2022-03-17 12:38:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (42, 10, 'CONSUMERABLE 5D', '100.00', '50.00', 'CONS', '2022-03-16', 1, '2022-03-16 17:15:32', '2022-03-16 17:15:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (43, 9, 'X-RAY SKULL AP-LAT', '350.00', '300.00', 'SKL', '2022-03-17', 1, '2022-03-17 13:54:55', '2022-04-07 19:13:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (44, 9, 'X-RAY PNS', '250.00', '200.00', 'PNS', '2022-03-17', 1, '2022-03-17 13:55:23', '2022-04-07 19:14:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (45, 9, 'X-RAY MASTOID', '250.00', '200.00', 'MAST', '2022-03-17', 1, '2022-03-17 13:55:58', '2022-04-07 19:15:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (46, 9, 'X-RAY NASAL BONE LAT', '250.00', '200.00', 'NSL B', '2022-03-17', 1, '2022-03-17 13:56:57', '2022-04-07 19:16:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (47, 9, 'X-RAY ADENOID', '250.00', '200.00', 'ADN', '2022-03-17', 1, '2022-03-17 13:57:32', '2022-04-07 19:16:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (48, 9, 'X-RAY NECK AP-LAT', '300.00', '250.00', 'NECK', '2022-03-17', 1, '2022-03-17 13:58:14', '2022-04-07 19:17:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (49, 9, 'X-RAY NECK LAT', '250.00', '200.00', 'NE', '2022-03-17', 1, '2022-03-17 13:59:06', '2022-04-07 19:18:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (50, 9, 'X-RAY SHOULDER AP', '250.00', '200.00', 'SHLD', '2022-03-17', 1, '2022-03-17 13:59:37', '2022-04-07 19:18:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (51, 9, 'X-RAY SHOULDER AP-LAT', '300.00', '250.00', 'SHLD', '2022-03-17', 1, '2022-03-17 14:00:15', '2022-04-07 19:19:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (52, 9, 'X-RAY SHOULDER AP-AXIAL', '250.00', '200.00', 'SHLD', '2022-03-17', 1, '2022-03-17 14:00:44', '2022-04-07 19:20:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (53, 9, 'X-RAY CLAVICLE AP', '250.00', '200.00', 'CVCL', '2022-03-17', 1, '2022-03-17 14:06:27', '2022-04-07 19:20:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (54, 7, 'USG ABDOMEN PELVIS UNM', '850.00', '500.00', 'UNM', '2022-03-17', 1, '2022-03-17 15:27:52', '2022-03-17 15:27:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (56, 11, 'BLOOD SUGAR FASTING', '50.00', '30.00', 'FB', '2022-03-24', 1, '2022-03-24 09:34:00', '2022-03-24 09:34:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (57, 11, 'BLOOD SUGAR PPS', '50.00', '30.00', 'PPS', '2022-03-24', 1, '2022-03-24 09:34:58', '2022-03-24 09:34:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (58, 11, 'BLOOD SUGAR RANDAM', '50.00', '30.00', 'RBS', '2022-03-24', 1, '2022-03-24 09:37:17', '2022-03-24 09:37:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (59, 11, 'BLOOD RE', '200.00', '150.00', 'BRE', '2022-03-24', 1, '2022-03-24 09:37:51', '2022-03-24 09:37:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (60, 11, 'COMPLET BLOOD COUNT', '250.00', '200.00', 'CBC', '2022-03-24', 1, '2022-03-24 09:40:05', '2022-03-24 09:40:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (61, 11, 'HEMO GLOBIN', '40.00', '30.00', 'HB', '2022-03-24', 1, '2022-03-24 09:41:17', '2022-03-24 09:41:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (62, 11, 'ESR', '30.00', '20.00', 'ESR', '2022-03-24', 1, '2022-03-24 09:45:07', '2022-03-24 09:45:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (63, 11, 'LIVER FUNCTION TEST', '400.00', '350.00', 'LFT', '2022-03-24', 1, '2022-03-24 09:45:57', '2022-03-24 09:45:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (64, 11, 'THYROID FUNCTION TEST', '450.00', '400.00', 'TFT', '2022-03-24', 1, '2022-03-24 09:46:38', '2022-03-24 09:46:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (65, 11, 'RENAL FUNCTION TEST', '400.00', '350.00', 'RFT', '2022-03-24', 1, '2022-03-24 09:48:03', '2022-03-24 09:48:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (66, 11, 'LIPID PROFILE', '400.00', '350.00', 'LIPID', '2022-03-24', 1, '2022-03-24 09:51:44', '2022-03-24 09:51:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (67, 11, 'HBA1C', '500.00', '300.00', 'HBA1C', '2022-03-24', 1, '2022-03-24 09:52:20', '2022-03-24 09:52:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (68, 11, 'THYROID ANTIBODIES', '1000.00', '800.00', 'THYROID PROFILE', '2022-03-24', 1, '2022-03-24 09:53:28', '2022-03-24 09:53:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (69, 11, 'UREA', '130.00', '50.00', 'UREA', '2022-03-24', 1, '2022-03-24 09:53:56', '2022-03-24 09:53:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (70, 11, 'CREATINE', '130.00', '100.00', 'CREATINE', '2022-03-24', 1, '2022-03-24 09:54:16', '2022-03-24 09:54:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (71, 11, 'URIC ACID', '130.00', '100.00', 'UA', '2022-03-24', 1, '2022-03-24 09:54:43', '2022-03-24 09:54:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (72, 11, 'PLATELET COUNT', '130.00', '100.00', 'PLATELET', '2022-03-24', 1, '2022-03-24 09:55:30', '2022-03-24 09:55:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (73, 11, 'PSA', '500.00', '300.00', 'PSA', '2022-03-24', 1, '2022-03-24 09:55:47', '2022-03-24 09:55:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (75, 11, 'URINE RE', '100.00', '50.00', 'URINE ROUTINE', '2022-03-24', 1, '2022-03-24 09:57:14', '2022-03-24 09:57:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (76, 11, 'URINE CULTURE', '160.00', '100.00', 'UC', '2022-03-24', 1, '2022-03-24 09:57:35', '2022-03-24 09:57:35');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (77, 11, 'SGPT', '130.00', '100.00', 'SGPT', '2022-03-24', 1, '2022-03-24 09:57:57', '2022-03-24 09:57:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (78, 11, 'SGOT', '130.00', '100.00', 'SGOT', '2022-03-24', 1, '2022-03-24 09:58:15', '2022-03-24 09:58:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (79, 11, 'CA 125', '990.00', '500.00', 'CA', '2022-03-24', 1, '2022-03-24 09:58:56', '2022-03-24 09:58:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (80, 11, 'BETA 2 GLYCOPROTEIN', '1300.00', '1000.00', 'BETA', '2022-03-24', 1, '2022-03-24 10:00:28', '2022-03-24 10:00:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (81, 11, 'BICARBONATE', '130.00', '120.00', 'BICARBONATE', '2022-03-24', 1, '2022-03-24 10:02:13', '2022-03-24 10:02:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (82, 11, 'BILLRUBINE(T)', '130.00', '120.00', 'BILLRUBINE TOTAL', '2022-03-24', 1, '2022-03-24 10:04:27', '2022-03-24 10:04:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (83, 11, 'BILLRUBIN(D)', '130.00', '120.00', 'BLIIRUBIN DIRECT', '2022-03-24', 1, '2022-03-24 10:05:27', '2022-03-24 10:05:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (84, 11, 'AMH', '1700.00', '1000.00', 'AMH', '2022-03-24', 1, '2022-03-24 10:35:28', '2022-03-24 10:35:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (85, 11, 'BJ PROTEIN', '300.00', '250.00', 'BJP', '2022-03-24', 1, '2022-03-24 10:40:17', '2022-03-24 10:40:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (86, 11, 'BLOOD GROUP &RH TYPE', '100.00', '90.00', 'BLOOD GROUP', '2022-03-24', 1, '2022-03-24 10:42:03', '2022-03-24 10:42:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (87, 11, 'PREGNANCY TEST', '150.00', '100.00', 'PREGNANCY TEST', '2022-03-24', 1, '2022-03-24 10:44:33', '2022-03-24 10:44:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (88, 11, 'PROGESTERONE', '500.00', '450.00', 'PROGESTRONE', '2022-03-24', 1, '2022-03-24 10:45:48', '2022-03-24 10:45:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (89, 11, 'PROJESTRONE 17 OH', '1400.00', '1300.00', 'P 17 OH', '2022-03-24', 1, '2022-03-24 10:47:37', '2022-03-24 10:47:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (90, 11, 'PROLACTIN', '500.00', '450.00', 'PROLACTIN', '2022-03-24', 1, '2022-03-24 10:48:24', '2022-03-24 10:48:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (91, 11, 'PROSTATE SPECIFIC ANTIGEN (PSA)', '500.00', '400.00', 'PSA', '2022-03-24', 1, '2022-03-24 10:50:00', '2022-03-24 10:50:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (92, 11, 'TSH', '200.00', '150.00', 'TSH', '2022-03-24', 1, '2022-03-24 11:18:18', '2022-03-24 11:18:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (93, 11, 'PROSTATIC ACID PROSTATE (PAP)', '200.00', '150.00', 'PAP', '2022-03-24', 1, '2022-03-24 11:19:56', '2022-03-24 11:19:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (94, 11, 'PAPPA', '900.00', '800.00', 'PAPPA', '2022-03-24', 1, '2022-03-24 11:26:00', '2022-03-24 11:26:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (95, 11, 'DS DNA', '1100.00', '1000.00', 'DS DNA', '2022-03-24', 1, '2022-03-24 12:16:34', '2022-03-24 12:16:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (96, 11, 'ELECTROLYTE', '450.00', '400.00', 'ELECTROLYTE', '2022-03-24', 1, '2022-03-24 12:23:12', '2022-03-24 12:23:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (97, 11, 'ELECTROPHORSIS', '600.00', '450.00', 'ELEPH', '2022-03-24', 1, '2022-03-24 12:25:20', '2022-03-24 12:25:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (98, 11, 'ERYTHROPROTIEN(EPO)', '2000.00', '1900.00', 'EPO', '2022-03-24', 1, '2022-03-24 12:27:52', '2022-03-24 12:27:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (99, 11, 'ESTRADIOL', '500.00', '400.00', 'ESTRADIOL', '2022-03-24', 1, '2022-03-24 12:30:10', '2022-03-24 12:30:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (100, 11, 'FREE PSA', '1200.00', '1100.00', 'F PSA', '2022-03-24', 1, '2022-03-24 12:31:43', '2022-03-24 12:31:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (101, 11, 'FREE T3', '180.00', '150.00', 'FREE T3', '2022-03-24', 1, '2022-03-24 12:32:21', '2022-03-24 12:32:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (102, 11, 'FREE T4', '180.00', '170.00', 'FREE T4', '2022-03-24', 1, '2022-03-24 12:32:54', '2022-03-24 12:32:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (103, 11, 'FREE TESTISTRONE', '1800.00', '1700.00', 'F TEST', '2022-03-24', 1, '2022-03-24 12:34:19', '2022-03-24 12:34:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (104, 11, 'FSH', '500.00', '400.00', 'FSH', '2022-03-24', 1, '2022-03-24 12:37:40', '2022-03-24 12:37:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (105, 11, 'FTA ABS', '2350.00', '1250.00', 'FTA', '2022-03-24', 1, '2022-03-24 12:39:20', '2022-03-24 12:39:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (106, 11, 'FTA ABS 1GG', '1250.00', '1200.00', 'FA IGG', '2022-03-24', 1, '2022-03-24 12:40:30', '2022-03-24 12:40:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (107, 11, 'CULTURE FUNGUS', '130.00', '120.00', 'FUNGUS', '2022-03-24', 1, '2022-03-24 12:41:22', '2022-03-24 12:41:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (108, 11, 'G6PD', '550.00', '500.00', 'G6PD', '2022-03-24', 1, '2022-03-24 12:42:14', '2022-03-24 12:42:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (109, 11, 'GAMA GT', '350.00', '300.00', 'GGT', '2022-03-24', 1, '2022-03-24 12:43:40', '2022-03-24 12:43:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (110, 11, 'GCT', '200.00', '150.00', 'GCT', '2022-03-24', 1, '2022-03-24 12:44:17', '2022-03-24 12:44:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (111, 11, 'GLOBULIN', '160.00', '150.00', 'GLOBULIN', '2022-03-24', 1, '2022-03-24 12:46:34', '2022-03-24 12:46:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (112, 11, 'FTI (FREE THYROXINE INDEX)', '300.00', '200.00', 'FTI', '2022-03-24', 1, '2022-03-24 12:50:17', '2022-03-24 12:50:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (113, 11, 'GLUCOESTOLERENT TEST(EXTENDED)', '300.00', '200.00', 'GT', '2022-03-24', 1, '2022-03-24 12:55:34', '2022-03-24 12:55:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (114, 11, 'GLYCATE HB (HBA1C)', '500.00', '400.00', 'GHB', '2022-03-24', 1, '2022-03-24 14:11:50', '2022-03-24 14:11:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (115, 11, 'GRAMSTAIN', '60.00', '40.00', 'GRAMSTAIN', '2022-03-24', 1, '2022-03-24 14:13:06', '2022-03-24 14:13:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (116, 11, 'GRAM STAINING FOR GONOCOCCI', '80.00', '70.00', 'G S G', '2022-03-24', 1, '2022-03-24 14:14:50', '2022-03-24 14:14:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (117, 11, 'GROUP RH TYPING', '100.00', '90.00', 'GROUP', '2022-03-24', 1, '2022-03-24 14:16:28', '2022-03-24 14:16:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (118, 11, 'GROWTH HORMONE', '600.00', '500.00', 'GH', '2022-03-24', 1, '2022-03-24 14:17:09', '2022-03-24 14:17:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (119, 11, 'GTT', '300.00', '200.00', 'GTT', '2022-03-24', 1, '2022-03-24 14:17:39', '2022-03-24 14:17:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (120, 11, 'HPYLORI IGG', '1450.00', '1400.00', 'H IGG', '2022-03-24', 1, '2022-03-24 14:18:54', '2022-03-24 14:18:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (121, 11, 'HPYLORI IGM', '950.00', '900.00', 'H IGM', '2022-03-24', 1, '2022-03-24 14:20:30', '2022-03-24 14:20:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (122, 11, 'HAEMOGLOBIN ELECTROPHO', '800.00', '700.00', 'HB ELECTROPHORISIS', '2022-03-24', 1, '2022-03-24 14:35:14', '2022-03-24 14:35:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (123, 11, 'HAEMOGRAM', '150.00', '100.00', 'HG', '2022-03-24', 1, '2022-03-24 14:46:44', '2022-03-24 14:46:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (124, 11, 'HANGING DROP (VIBRIO CHOLERAC)', '200.00', '190.00', 'HD', '2022-03-24', 1, '2022-03-24 14:49:15', '2022-03-24 14:49:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (125, 11, 'HAV 1GM', '700.00', '600.00', 'HAV', '2022-03-24', 1, '2022-03-24 14:50:16', '2022-03-24 14:50:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (126, 11, 'HB  ANTIBODY(ANTI HBEG)', '500.00', '400.00', 'HB ANTIBODY', '2022-03-24', 1, '2022-03-24 14:53:43', '2022-03-24 14:53:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (127, 11, 'HBA2', '350.00', '300.00', 'HBA2', '2022-03-24', 1, '2022-03-24 14:56:13', '2022-03-24 14:56:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (128, 11, 'HBC 1GM', '600.00', '500.00', 'HBC', '2022-03-24', 1, '2022-03-24 15:01:42', '2022-03-24 15:01:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (129, 11, 'HB ELECTRO PHORASIS', '1200.00', '1000.00', 'HB E', '2022-03-24', 1, '2022-03-24 15:03:33', '2022-03-24 15:03:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (130, 11, 'HBCAB', '400.00', '300.00', 'HBCAB', '2022-03-24', 1, '2022-03-24 15:06:36', '2022-03-24 15:06:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (131, 11, 'HBEAB', '700.00', '600.00', 'HBE', '2022-03-24', 1, '2022-03-24 15:07:08', '2022-03-24 15:07:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (132, 11, 'HB TITER', '950.00', '900.00', 'HBT', '2022-03-24', 1, '2022-03-24 15:07:48', '2022-03-24 15:07:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (133, 11, 'HBV ANTOBODY', '550.00', '500.00', 'HBV', '2022-03-24', 1, '2022-03-24 15:10:00', '2022-03-24 15:10:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (134, 11, 'HCV//', '600.00', '500.00', 'HCV', '2022-03-24', 1, '2022-03-24 15:10:30', '2022-03-24 15:10:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (135, 11, 'HCV 1 GM', '600.00', '500.00', 'HCV 1 GM', '2022-03-24', 1, '2022-03-24 15:11:02', '2022-03-24 15:11:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (136, 11, 'HDL', '200.00', '150.00', 'HDL', '2022-03-24', 1, '2022-03-24 15:11:30', '2022-03-24 15:11:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (137, 11, 'HDL CHOLESTEROL', '200.00', '150.00', 'HDL', '2022-03-24', 1, '2022-03-24 15:13:08', '2022-03-24 15:13:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (138, 11, 'HIV 1&2', '400.00', '300.00', 'HIV', '2022-03-24', 1, '2022-03-24 15:13:54', '2022-03-24 15:13:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (139, 11, 'HIV ELISA', '400.00', '300.00', 'HIV ELISA', '2022-03-24', 1, '2022-03-24 15:14:32', '2022-03-24 15:14:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (140, 11, 'HLAB27', '2000.00', '1900.00', 'HLA', '2022-03-24', 1, '2022-03-24 15:15:24', '2022-03-24 15:15:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (141, 11, 'HOMOCYSTINURIA', '200.00', '180.00', 'HOMO', '2022-03-24', 1, '2022-03-24 15:16:38', '2022-03-24 15:16:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (142, 11, 'HSV 1&2 IGG & 1GM', '1280.00', '1200.00', 'HSV', '2022-03-24', 1, '2022-03-24 15:17:56', '2022-03-24 15:17:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (143, 11, 'HSV IGG &IGM', '600.00', '500.00', 'HSV', '2022-03-24', 1, '2022-03-24 15:19:47', '2022-03-24 15:19:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (144, 11, 'HZV IGG& IGM', '700.00', '600.00', 'HZV', '2022-03-24', 1, '2022-03-24 15:20:49', '2022-03-24 15:20:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (145, 11, 'IGA', '500.00', '400.00', 'IGA', '2022-03-24', 1, '2022-03-24 15:21:21', '2022-03-24 15:21:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (146, 11, 'IGE', '650.00', '600.00', 'IGE', '2022-03-24', 1, '2022-03-24 15:21:53', '2022-03-24 15:21:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (147, 11, 'IGG', '520.00', '500.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:23:14', '2022-03-24 15:23:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (148, 11, 'IGG HBC', '600.00', '500.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:23:52', '2022-03-24 15:23:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (149, 11, 'IGM', '520.00', '500.00', 'IGM', '2022-03-24', 1, '2022-03-24 15:24:19', '2022-03-24 15:24:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (150, 11, 'IMMUNOGLOBULIN IGE', '400.00', '300.00', 'IG IGE', '2022-03-24', 1, '2022-03-24 15:25:29', '2022-03-24 15:25:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (151, 11, 'IMMUNO PROFILE', '800.00', '700.00', 'IP', '2022-03-24', 1, '2022-03-24 15:26:55', '2022-03-24 15:26:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (152, 11, 'INDIAN INK CRYPTOCOCCI', '100.00', '90.00', 'IIC', '2022-03-24', 1, '2022-03-24 15:27:40', '2022-03-24 15:27:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (153, 11, 'INDIRECT COOMBS TEST(ICT)', '400.00', '300.00', 'ICT', '2022-03-24', 1, '2022-03-24 15:29:02', '2022-03-24 15:29:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (154, 11, 'INSULIN', '500.00', '400.00', 'INSULIN', '2022-03-24', 1, '2022-03-24 15:29:37', '2022-03-24 15:29:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (155, 11, 'KETONE', '70.00', '60.00', 'KT', '2022-03-24', 1, '2022-03-24 15:30:08', '2022-03-24 15:30:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (156, 11, 'LA IGG IGM', '700.00', '600.00', 'LA', '2022-03-24', 1, '2022-03-24 15:30:58', '2022-03-24 15:30:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (157, 11, 'LACATE', '100.00', '90.00', 'LA', '2022-03-24', 1, '2022-03-24 15:31:34', '2022-03-24 15:31:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (158, 11, 'LDH', '250.00', '200.00', 'LDH', '2022-03-24', 1, '2022-03-24 15:33:21', '2022-03-24 15:33:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (159, 11, 'LDL', '250.00', '200.00', 'LDL', '2022-03-24', 1, '2022-03-24 15:33:53', '2022-03-24 15:33:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (160, 11, 'LE CELL', '330.00', '300.00', 'LE', '2022-03-24', 1, '2022-03-24 15:34:36', '2022-03-24 15:34:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (161, 11, 'LACTATE', '600.00', '400.00', 'LACTATE', '2022-03-24', 1, '2022-03-24 15:35:36', '2022-03-24 15:35:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (162, 11, 'LEPTO SPIRAL ANTIBODY IGM ELIS', '900.00', '800.00', 'LEPTO', '2022-03-24', 1, '2022-03-24 15:36:50', '2022-03-24 15:36:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (163, 11, 'LEPTO SPIRAL ANTIBODY IGG', '900.00', '800.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:37:55', '2022-03-24 15:37:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (164, 11, 'LEPTO SPIRAL ANTIBODY IGG..', '900.00', '800.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:38:48', '2022-03-24 15:38:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (165, 11, 'LUPUS ANTICOAGULANT', '450.00', '400.00', 'LUPAS', '2022-03-24', 1, '2022-03-24 15:39:47', '2022-03-24 15:39:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (166, 11, 'LH', '500.00', '400.00', 'LH', '2022-03-24', 1, '2022-03-24 15:40:04', '2022-03-24 15:40:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (167, 11, 'LIPOPROTIN', '500.00', '300.00', 'LIPO', '2022-03-24', 1, '2022-03-24 15:41:11', '2022-03-24 15:41:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (168, 11, 'LIPOPROTIN..', '500.00', '300.00', 'LIPO', '2022-03-24', 1, '2022-03-24 15:41:34', '2022-03-24 15:41:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (169, 11, 'LITHIUM', '250.00', '200.00', 'LITHIYAM', '2022-03-24', 1, '2022-03-24 15:41:56', '2022-03-24 15:41:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (170, 11, 'LUPOUS ANTICOAGULANT(LA)', '500.00', '400.00', 'LA', '2022-03-24', 1, '2022-03-24 15:42:48', '2022-03-24 15:42:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (171, 11, 'LYMES ANTIBODY', '750.00', '700.00', 'LYMES', '2022-03-24', 1, '2022-03-24 15:43:15', '2022-03-24 15:43:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (172, 11, 'MAGNESIUM', '350.00', '300.00', 'MEG', '2022-03-24', 1, '2022-03-24 15:43:42', '2022-03-24 15:43:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (173, 11, 'MALARIAL PARASITE', '200.00', '150.00', 'MALA', '2022-03-24', 1, '2022-03-24 15:44:08', '2022-03-24 15:44:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (174, 11, 'MANTOUX TEST', '150.00', '100.00', 'MANTO', '2022-03-24', 1, '2022-03-24 15:44:31', '2022-03-24 15:44:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (175, 11, 'MCV,PCV,MCH,MCHC', '100.00', '90.00', 'MCV', '2022-03-24', 1, '2022-03-24 15:45:04', '2022-03-24 15:45:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (176, 11, 'METANEPHRINE', '1300.00', '1200.00', 'METAN', '2022-03-24', 1, '2022-03-24 15:45:38', '2022-03-24 15:45:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (177, 11, 'MICRO ALBUMIN', '500.00', '400.00', 'MICRO', '2022-03-24', 1, '2022-03-24 15:46:51', '2022-03-24 15:46:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (178, 11, 'MICRFILERIA', '60.00', '50.00', 'MICRO', '2022-03-24', 1, '2022-03-24 15:47:21', '2022-03-24 15:47:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (179, 11, 'MOTION OCCULT BLOOD', '120.00', '100.00', 'OCCULT MBLOOD', '2022-03-24', 1, '2022-03-24 15:48:24', '2022-03-24 15:48:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (180, 11, 'MOTION RE', '100.00', '90.00', 'REM', '2022-03-24', 1, '2022-03-24 15:49:02', '2022-03-24 15:49:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (181, 11, 'MAYOGLOBIN', '350.00', '300.00', 'MAYO', '2022-03-24', 1, '2022-03-24 15:49:44', '2022-03-24 15:49:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (182, 11, 'NEONATAL BILRUBIN', '60.00', '50.00', 'NEO', '2022-03-24', 1, '2022-03-24 15:50:24', '2022-03-24 15:50:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (183, 11, 'NEUTROPHIL COUNT', '40.00', '30.00', 'COUNT', '2022-03-24', 1, '2022-03-24 15:51:22', '2022-03-24 15:51:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (184, 11, 'OESTROGEN', '600.00', '400.00', 'OES', '2022-03-24', 1, '2022-03-24 15:52:04', '2022-03-24 15:52:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (185, 11, 'OZMOTIC FRAGILITY', '350.00', '300.00', 'OF', '2022-03-24', 1, '2022-03-24 15:53:14', '2022-03-24 15:53:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (186, 11, 'P ANCA', '850.00', '800.00', 'P ANCA', '2022-03-24', 1, '2022-03-24 15:53:46', '2022-03-24 15:53:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (187, 11, 'PAPPA..', '900.00', '800.00', 'PAPPA', '2022-03-24', 1, '2022-03-24 15:54:27', '2022-03-24 15:54:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (188, 11, 'PAPPA TEST', '1500.00', '1400.00', 'PA', '2022-03-24', 1, '2022-03-24 15:54:58', '2022-03-24 15:54:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (189, 11, 'PARA THYROID HORMONEITACT(PTH)', '1000.00', '900.00', 'PTH', '2022-03-24', 1, '2022-03-24 15:57:29', '2022-03-24 15:57:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (190, 11, 'PAUL BUNNEL TEST(IM)', '130.00', '100.00', 'IM', '2022-03-24', 1, '2022-03-24 15:58:54', '2022-03-24 15:58:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (191, 8, 'CT ABDOMEN PLAIN', '4900.00', '4000.00', 'CT A', '2022-03-24', 1, '2022-03-24 16:01:12', '2022-03-24 16:01:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (192, 8, 'CT ANKLE', '4500.00', '4000.00', 'CT A', '2022-03-24', 1, '2022-03-24 16:02:40', '2022-03-24 16:02:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (193, 8, 'CT BRAIN PLAIN', '2350.00', '2000.00', 'CT B', '2022-03-24', 1, '2022-03-24 16:03:38', '2022-03-24 16:03:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (194, 8, 'CT BRAIN AND PNS PLAIN', '4800.00', '4000.00', 'CT BRA P', '2022-03-24', 1, '2022-03-24 16:06:04', '2022-03-24 16:06:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (195, 8, 'CT CERVICAL SPINE', '4750.00', '4000.00', 'CT C', '2022-03-24', 1, '2022-03-24 16:06:58', '2022-03-24 16:06:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (196, 8, 'CT THORAX PLAIN', '4900.00', '4000.00', 'CT T', '2022-03-24', 1, '2022-03-24 16:07:59', '2022-03-24 16:07:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (197, 8, 'CT HRCT PLAIN', '4900.00', '400.00', 'CT H', '2022-03-24', 1, '2022-03-24 16:08:30', '2022-03-24 16:08:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (198, 8, 'CT THORACIC SPINE', '4900.00', '4000.00', 'CT TS', '2022-03-24', 1, '2022-03-24 16:09:30', '2022-03-24 16:09:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (199, 8, 'CT LUMBO SACRAL SPINE', '4750.00', '4000.00', 'CT LS', '2022-03-24', 1, '2022-03-24 16:12:05', '2022-04-08 09:43:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (200, 8, 'CT PELVIS', '4500.00', '4000.00', 'CT PEL', '2022-03-24', 1, '2022-03-24 16:13:15', '2022-03-24 16:13:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (201, 8, 'CT  CLAVICLE', '3500.00', '2500.00', 'CT C', '2022-03-24', 1, '2022-03-24 16:14:27', '2022-03-24 16:14:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (202, 8, 'CT ELBOW JOINT', '3750.00', '2500.00', 'CT EL', '2022-03-24', 1, '2022-03-24 16:15:23', '2022-03-24 16:15:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (203, 8, 'CT SHOULDER  JOINT', '3750.00', '3500.00', 'CT SH', '2022-03-24', 1, '2022-03-24 16:16:56', '2022-03-24 16:16:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (205, 8, 'CT WRIST JOINT', '3750.00', '2500.00', 'CT WR', '2022-03-24', 1, '2022-03-24 16:18:17', '2022-03-24 16:18:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (206, 8, 'CT FACIAL BONE AXIAL & CORONAL', '4500.00', '3500.00', 'CT FB', '2022-03-24', 1, '2022-03-24 16:19:39', '2022-03-24 16:19:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (207, 8, 'CT FINGER', '3250.00', '2500.00', 'CT FR', '2022-03-24', 1, '2022-03-24 16:20:16', '2022-03-24 16:20:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (208, 8, 'CT HAND', '3500.00', '3000.00', 'CT HA', '2022-03-24', 1, '2022-03-24 16:20:56', '2022-03-24 16:20:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (209, 8, 'CT HIP JOINT', '4000.00', '3500.00', 'CT HI', '2022-03-24', 1, '2022-03-24 16:21:47', '2022-03-24 16:21:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (210, 8, 'CT KNEE SINGLE', '3750.00', '3000.00', 'CT KNEE', '2022-03-24', 1, '2022-03-24 16:22:50', '2022-03-24 16:22:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (211, 8, 'CT KNEE  BOTH', '4000.00', '3500.00', 'CT KN', '2022-03-24', 1, '2022-03-24 16:23:38', '2022-03-24 16:23:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (212, 8, 'CT MANDIBLE AXIAL & CORONAL', '4500.00', '3500.00', 'CT MAN', '2022-03-24', 1, '2022-03-24 16:24:44', '2022-03-24 16:24:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (213, 8, 'CT NECK PLAIN', '4900.00', '4000.00', 'CT NE', '2022-03-24', 1, '2022-03-24 16:25:18', '2022-03-24 16:25:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (214, 8, 'CT THYROID PLAIN', '4500.00', '3500.00', 'CT THY', '2022-03-24', 1, '2022-03-24 16:25:47', '2022-03-24 16:25:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (215, 8, 'CT ORBIT AXIAL& CORONAL', '4500.00', '3500.00', 'CT ORB', '2022-03-24', 1, '2022-03-24 16:26:29', '2022-03-24 16:26:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (216, 8, 'CT PNS PLAIN', '2450.00', '2000.00', 'CT PN', '2022-03-24', 1, '2022-03-24 16:27:02', '2022-03-24 16:27:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (217, 8, 'CT PNS PLAIN.', '2450.00', '2000.00', 'CT PN', '2022-03-24', 1, '2022-03-24 16:27:16', '2022-03-24 16:27:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (218, 8, 'CT SACRUM', '3500.00', '3000.00', 'CT SC', '2022-03-24', 1, '2022-03-24 16:27:44', '2022-03-24 16:27:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (220, 8, 'CT SCAPULA', '3500.00', '3000.00', 'CT SCA', '2022-03-24', 1, '2022-03-24 16:28:45', '2022-03-24 16:28:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (221, 8, 'CT SI JOINT', '3500.00', '3000.00', 'CT SI', '2022-03-24', 1, '2022-03-24 16:29:35', '2022-03-24 16:29:35');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (222, 8, 'CT TM JOINT AXIAL &CORONAL', '4000.00', '3000.00', 'CT TM', '2022-03-24', 1, '2022-03-24 16:30:21', '2022-03-24 16:30:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (223, 8, 'CT HRCT TEMPRAL BONE', '4000.00', '3500.00', 'CT HR', '2022-03-24', 1, '2022-03-24 16:31:05', '2022-03-24 16:31:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (224, 8, 'CT FOOT', '3750.00', '3000.00', 'CT FOO', '2022-03-24', 1, '2022-03-24 16:32:49', '2022-03-24 16:32:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (225, 8, 'CT LEG SINGLE', '4500.00', '3500.00', 'CT LE', '2022-03-24', 1, '2022-03-24 16:33:51', '2022-03-24 16:33:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (226, 8, 'CT FEMOUR', '4500.00', '3500.00', 'CT FE', '2022-03-24', 1, '2022-03-24 16:34:39', '2022-03-24 16:34:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (228, 8, 'CT FOREARM', '3750.00', '3500.00', 'CT FO', '2022-03-24', 1, '2022-03-24 16:36:02', '2022-03-24 16:36:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (229, 8, 'CT ARM', '3750.00', '3500.00', 'CT AR', '2022-03-24', 1, '2022-03-24 16:36:43', '2022-03-24 16:36:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (230, 8, 'CT DORASL SPINE', '4750.00', '4000.00', 'CT DOR', '2022-03-24', 1, '2022-03-24 16:43:20', '2022-03-24 16:43:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (231, 8, 'CT NASOPHARYNX', '3750.00', '3000.00', 'CT NS', '2022-03-24', 1, '2022-03-24 16:45:47', '2022-03-24 16:45:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (232, 8, 'CT FACIAL BONE 3D', '4750.00', '4000.00', 'CT F3D', '2022-03-24', 1, '2022-03-24 16:47:01', '2022-03-24 16:47:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (233, 8, 'CT CARPAL BONE', '3750.00', '3000.00', 'CT CAR', '2022-03-24', 1, '2022-03-24 16:48:07', '2022-03-24 16:48:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (234, 8, 'CT TOE', '2750.00', '2500.00', 'CT TOE', '2022-03-24', 1, '2022-03-24 16:49:58', '2022-03-24 16:49:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (235, 8, 'CT CALCANEUM', '3750.00', '3500.00', 'CT CAL', '2022-03-24', 1, '2022-03-24 16:51:59', '2022-03-24 16:51:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (236, 8, 'CT PAROTID GLAND', '4500.00', '3500.00', 'CT PARO', '2022-03-24', 1, '2022-03-24 16:52:54', '2022-03-24 16:52:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (237, 8, 'CT KUB PLAIN', '4900.00', '4000.00', 'CT KUB', '2022-03-24', 1, '2022-03-24 16:58:03', '2022-03-24 16:58:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (238, 11, 'MICROFILARIA', '60.00', '50.00', 'MF', '2022-03-25', 1, '2022-03-25 09:03:46', '2022-03-25 09:03:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (239, 11, 'PH', '30.00', '20.00', 'PH', '2022-03-25', 1, '2022-03-25 09:06:30', '2022-03-25 09:06:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (240, 11, 'PHENO BARBITONE', '400.00', '350.00', 'PB', '2022-03-25', 1, '2022-03-25 09:07:29', '2022-03-25 09:07:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (241, 11, 'PHOSPHOROUS', '130.00', '120.00', 'PP', '2022-03-25', 1, '2022-03-25 09:08:59', '2022-03-25 09:08:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (242, 11, 'PLASMA PROGESTRONE', '400.00', '300.00', 'PRG', '2022-03-25', 1, '2022-03-25 09:10:20', '2022-03-25 09:10:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (243, 11, 'PULERLE FLUID', '450.00', '400.00', 'PF', '2022-03-25', 1, '2022-03-25 09:17:52', '2022-03-25 09:17:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (244, 11, 'PLEURAL MICRO', '30.00', '20.00', 'PM', '2022-03-25', 1, '2022-03-25 09:18:36', '2022-03-25 09:18:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (245, 11, 'PLEURAL PROTEIN', '60.00', '50.00', 'PPROTEIN', '2022-03-25', 1, '2022-03-25 09:20:04', '2022-03-25 09:20:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (246, 11, 'PLEURAL SUGAR', '30.00', '20.00', 'PS', '2022-03-25', 1, '2022-03-25 09:21:05', '2022-03-25 09:21:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (247, 11, 'QUADRIPLET TEST', '3850.00', '3000.00', 'QT', '2022-03-25', 1, '2022-03-25 09:21:46', '2022-03-25 09:21:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (248, 11, 'RA TEST', '400.00', '300.00', 'RT', '2022-03-25', 1, '2022-03-25 09:22:25', '2022-03-25 09:22:25');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (249, 11, 'RBC COUNT', '40.00', '30.00', 'RC', '2022-03-25', 1, '2022-03-25 09:23:06', '2022-03-25 09:23:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (250, 11, 'RUBELLA IGG', '500.00', '450.00', 'R IGG', '2022-03-25', 1, '2022-03-25 10:55:55', '2022-03-25 10:55:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (251, 11, 'RUBELLA IGM', '500.00', '400.00', 'R IGM', '2022-03-25', 1, '2022-03-25 10:56:41', '2022-03-25 10:56:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (252, 11, 'RUBELLA IGG & IGM', '500.00', '450.00', 'R IGG&IGM', '2022-03-25', 1, '2022-03-25 10:57:26', '2022-03-25 10:57:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (253, 11, 'LAB', '0.00', '0.00', '0 BILL', '2022-03-25', 1, '2022-03-25 11:05:29', '2022-03-25 11:05:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (254, 11, 'S IRON', '300.00', '250.00', 'SI', '2022-03-25', 1, '2022-03-25 11:15:44', '2022-03-25 11:15:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (255, 11, 'SCALP VEIN', '20.00', '10.00', 'SV', '2022-03-25', 1, '2022-03-25 11:16:36', '2022-03-25 11:16:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (256, 11, 'SEL.70', '1500.00', '1300.00', 'S 70', '2022-03-25', 1, '2022-03-25 11:17:26', '2022-03-25 11:17:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (257, 11, 'SEMEN ANALYSIS', '250.00', '200.00', 'SA', '2022-03-25', 1, '2022-03-25 11:19:02', '2022-03-25 11:19:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (258, 11, 'SERUM PHOSPHORUS', '130.00', '120.00', 'SP', '2022-03-25', 1, '2022-03-25 11:20:17', '2022-03-25 11:20:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (259, 11, 'SERUM ALBUMIN', '160.00', '100.00', 'SA', '2022-03-25', 1, '2022-03-25 11:20:50', '2022-03-25 11:20:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (260, 11, 'SERUM FERTIN', '600.00', '500.00', 'SF', '2022-03-25', 1, '2022-03-25 11:21:47', '2022-03-25 11:21:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (261, 11, 'SERUM FOLATE', '1200.00', '1000.00', 'SF', '2022-03-25', 1, '2022-03-25 11:22:43', '2022-03-25 11:22:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (262, 11, 'SERUM PROTEINE', '160.00', '150.00', 'SP', '2022-03-25', 1, '2022-03-25 11:23:29', '2022-03-25 11:23:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (263, 11, 'SERUM ACE', '850.00', '800.00', 'ACE', '2022-03-25', 1, '2022-03-25 11:24:09', '2022-03-25 11:24:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (264, 11, 'SERUM AMALYIS', '300.00', '250.00', 'SA', '2022-03-25', 1, '2022-03-25 11:25:34', '2022-03-25 11:25:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (265, 11, 'SERUM ANTROGEN', '1850.00', '1800.00', 'SA', '2022-03-25', 1, '2022-03-25 11:26:41', '2022-03-25 11:26:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (266, 11, 'SERUM CALCIUM', '160.00', '140.00', 'SC', '2022-03-25', 1, '2022-03-25 11:27:20', '2022-03-25 11:27:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (267, 11, 'SERUM CHOLESTEROL', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:28:10', '2022-03-25 11:28:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (268, 11, 'SERUM COPPER', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:29:33', '2022-03-25 11:29:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (269, 11, 'SERUM COPPER ..', '2100.00', '1800.00', 'SC', '2022-03-25', 1, '2022-03-25 11:32:27', '2022-04-04 10:58:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (271, 11, 'SERUM CORTISOL', '500.00', '400.00', 'SC', '2022-03-25', 1, '2022-03-25 11:34:02', '2022-03-25 11:34:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (272, 11, 'SERUM CREATININE', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:36:01', '2022-03-25 11:36:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (273, 11, 'SERUM GONADO TROPY', '700.00', '400.00', 'SGT', '2022-03-25', 1, '2022-03-25 11:37:04', '2022-03-25 11:37:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (274, 11, 'SERUM IGE', '650.00', '500.00', 'S IGE', '2022-03-25', 1, '2022-03-25 11:37:37', '2022-03-25 12:34:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (275, 11, 'SERUM IRON', '300.00', '200.00', 'SI', '2022-03-25', 1, '2022-03-25 11:38:31', '2022-03-25 11:38:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (276, 11, 'SERUM  LIPAISE', '400.00', '300.00', 'SL', '2022-03-25', 1, '2022-03-25 11:40:05', '2022-03-25 11:40:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (277, 11, 'SERUM MAYOGLOBIN', '400.00', '300.00', 'SM', '2022-03-25', 1, '2022-03-25 11:40:45', '2022-03-25 11:40:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (278, 11, 'SERUM VITAMIN B12', '650.00', '600.00', 'S VB12', '2022-03-25', 1, '2022-03-25 11:42:46', '2022-03-25 11:42:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (279, 11, 'SERUM ZINC', '1900.00', '1800.00', 'S Z', '2022-03-25', 1, '2022-03-25 11:43:55', '2022-03-25 11:43:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (280, 11, 'SPUTUM A F P', '250.00', '200.00', 'S AFP', '2022-03-25', 1, '2022-03-25 11:45:29', '2022-03-25 11:45:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (281, 11, 'SPUTUM AFP 3 DAYS', '600.00', '500.00', 'S AFP 3 DAYS', '2022-03-25', 1, '2022-03-25 11:47:15', '2022-03-25 11:47:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (282, 11, 'T3', '160.00', '150.00', 'T3', '2022-03-25', 1, '2022-03-25 11:47:44', '2022-03-25 11:47:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (283, 11, 'T4', '160.00', '150.00', 'T4', '2022-03-25', 1, '2022-03-25 11:48:11', '2022-03-25 11:48:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (284, 11, 'TB IGA', '350.00', '300.00', 'TB IGA', '2022-03-25', 1, '2022-03-25 11:49:11', '2022-03-25 11:49:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (285, 11, 'TB IGA IGG IGM', '1100.00', '1000.00', 'TIII', '2022-03-25', 1, '2022-03-25 11:50:29', '2022-03-25 11:50:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (286, 11, 'TB IGG', '350.00', '240.00', 'TB IGG', '2022-03-25', 1, '2022-03-25 11:52:30', '2022-03-25 12:34:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (287, 11, 'TB IGM', '500.00', '300.00', 'TBI', '2022-03-25', 1, '2022-03-25 11:54:16', '2022-03-25 11:54:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (288, 11, 'TC', '40.00', '30.00', 'TC', '2022-03-25', 1, '2022-03-25 11:55:00', '2022-03-25 11:55:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (289, 11, 'TC,DC,HB', '120.00', '110.00', 'TDH', '2022-03-25', 1, '2022-03-25 11:56:42', '2022-03-25 11:56:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (290, 11, 'TIBC', '300.00', '200.00', 'TIBC', '2022-03-25', 1, '2022-03-25 11:57:28', '2022-03-25 11:57:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (291, 11, 'TORCH IGB IGM', '2500.00', '2400.00', 'T II', '2022-03-25', 1, '2022-03-25 12:00:44', '2022-03-25 12:00:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (292, 11, 'TROCH IGM', '1200.00', '1100.00', 'TI', '2022-03-25', 1, '2022-03-25 12:01:26', '2022-03-25 12:01:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (293, 11, 'TORCH SCREENING', '2200.00', '2100.00', 'TS', '2022-03-25', 1, '2022-03-25 12:02:31', '2022-03-25 12:02:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (294, 11, 'TORCH TEST IGB IGM', '2050.00', '2000.00', 'T T I I', '2022-03-25', 1, '2022-03-25 12:03:57', '2022-03-25 12:03:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (295, 11, 'TORCH IGG', '750.00', '700.00', 'TI', '2022-03-25', 1, '2022-03-25 12:04:34', '2022-03-25 12:04:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (296, 11, 'TOTAL IRON BINDING CAPACITY', '300.00', '200.00', 'TI', '2022-03-25', 1, '2022-03-25 12:05:56', '2022-03-25 12:05:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (297, 11, 'TOTAL PROTEIN', '160.00', '150.00', 'TP', '2022-03-25', 1, '2022-03-25 12:06:43', '2022-03-25 12:06:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (298, 11, 'TOTAL PROTEINS (AIB,GLB)', '160.00', '150.00', 'TP', '2022-03-25', 1, '2022-03-25 12:07:53', '2022-03-25 12:07:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (299, 11, 'TOTAL TESTISTRONE', '400.00', '300.00', 'TT', '2022-03-25', 1, '2022-03-25 12:08:53', '2022-03-25 12:08:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (300, 11, 'TOXOPLASMA IGG', '450.00', '400.00', 'TI', '2022-03-25', 1, '2022-03-25 12:10:41', '2022-03-25 12:10:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (301, 11, 'TOXOPLASMA IGM', '500.00', '450.00', 'TP', '2022-03-25', 1, '2022-03-25 12:11:36', '2022-03-25 12:11:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (302, 11, 'TPHA', '700.00', '600.00', 'TPHA', '2022-03-25', 1, '2022-03-25 12:12:16', '2022-03-25 12:12:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (303, 11, 'TPO', '450.00', '400.00', 'TPO', '2022-03-25', 1, '2022-03-25 12:13:57', '2022-03-25 12:13:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (304, 11, 'TPSH', '350.00', '300.00', 'TPSH', '2022-03-25', 1, '2022-03-25 12:14:26', '2022-03-25 12:14:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (305, 11, 'TRAN FERIN FLARATION', '800.00', '700.00', 'TF', '2022-03-25', 1, '2022-03-25 12:16:20', '2022-03-25 12:16:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (306, 11, 'TRIGLYCERIDES', '200.00', '150.00', 'T', '2022-03-25', 1, '2022-03-25 12:18:14', '2022-03-25 12:18:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (307, 11, 'TRIPPIL TEST', '2100.00', '2000.00', 'TT', '2022-03-25', 1, '2022-03-25 12:19:01', '2022-03-25 12:19:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (308, 11, 'TROP I', '950.00', '900.00', 'TROP I', '2022-03-25', 1, '2022-03-25 12:19:49', '2022-03-25 12:19:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (309, 11, 'TROPINE I', '1300.00', '1200.00', 'TROPINE I', '2022-03-25', 1, '2022-03-25 12:24:58', '2022-03-25 12:24:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (310, 11, 'TROPINE T', '850.00', '800.00', 'TT', '2022-03-25', 1, '2022-03-25 12:25:45', '2022-03-25 12:25:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (311, 11, 'URINE VMA', '1300.00', '1200.00', 'URINE VMA', '2022-03-25', 1, '2022-03-25 12:28:13', '2022-03-25 12:28:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (312, 11, 'URINE AFB', '80.00', '70.00', 'UA', '2022-03-25', 1, '2022-03-25 12:28:50', '2022-03-25 12:28:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (313, 11, 'URINE ACETONE', '50.00', '40.00', 'UA', '2022-03-25', 1, '2022-03-25 12:29:59', '2022-03-25 12:29:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (314, 11, 'URINE ALBUMIN', '70.00', '60.00', 'UA', '2022-03-25', 1, '2022-03-25 12:30:42', '2022-03-25 12:30:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (315, 11, 'URINE BJ PROTEIN', '250.00', '200.00', 'U BJ P', '2022-03-25', 1, '2022-03-25 12:33:33', '2022-03-25 12:33:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (316, 11, 'URINE BP & BS', '50.00', '40.00', 'U BP BS', '2022-03-25', 1, '2022-03-25 12:37:19', '2022-03-25 12:37:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (317, 11, 'URINE COMPLETE', '40.00', '30.00', 'UC', '2022-03-25', 1, '2022-03-25 12:37:56', '2022-03-25 12:37:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (318, 11, 'URINE DEPOSIT', '30.00', '20.00', 'UD', '2022-03-25', 1, '2022-03-25 12:38:41', '2022-03-25 12:38:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (319, 11, 'URINE GC', '70.00', '60.00', 'U GC', '2022-03-25', 1, '2022-03-25 12:39:14', '2022-03-25 12:39:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (320, 11, 'URINE MICROSCOPY', '30.00', '20.00', 'UM', '2022-03-25', 1, '2022-03-25 12:39:57', '2022-03-25 12:39:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (321, 11, 'URINE PC RATIO', '400.00', '300.00', 'UPR', '2022-03-25', 1, '2022-03-25 12:40:36', '2022-03-25 12:40:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (322, 11, 'URINE PROTEIN', '140.00', '120.00', 'UP', '2022-03-25', 1, '2022-03-25 12:42:06', '2022-03-25 12:42:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (323, 11, 'URINE PROTEIN 24 HRS', '300.00', '200.00', 'UP', '2022-03-25', 1, '2022-03-25 12:43:12', '2022-03-25 12:43:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (324, 11, 'URINE PROTEIN CREATINE RATIO', '400.00', '300.00', 'UPCR', '2022-03-25', 1, '2022-03-25 12:44:32', '2022-03-25 12:44:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (325, 11, 'ABSOLUTE ESINOPHIL COUNT', '140.00', '130.00', 'AEC', '2022-03-25', 1, '2022-03-25 12:46:59', '2022-03-25 12:46:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (326, 11, 'ACA,IGG,IGM', '1400.00', '1000.00', 'ACA', '2022-03-25', 1, '2022-03-25 12:47:54', '2022-03-25 12:47:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (327, 11, 'ACA&IGM', '950.00', '900.00', 'ACA', '2022-03-25', 1, '2022-03-25 12:48:39', '2022-03-25 12:48:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (328, 11, 'ACA IGG', '950.00', '900.00', 'AI', '2022-03-25', 1, '2022-03-25 12:49:21', '2022-03-25 12:49:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (329, 11, 'ACCP', '1200.00', '1100.00', 'ACCP', '2022-03-25', 1, '2022-03-25 12:49:50', '2022-03-25 12:49:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (330, 11, 'ACE', '800.00', '700.00', 'ACE', '2022-03-25', 1, '2022-03-25 12:51:51', '2022-03-25 12:51:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (331, 11, 'ACETAMINOPHAN/PARACETAMOL', '1500.00', '1000.00', 'AP', '2022-03-25', 1, '2022-03-25 12:57:50', '2022-03-25 12:57:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (332, 11, 'ACID PHOSPHATUSE', '180.00', '170.00', 'AP', '2022-03-25', 1, '2022-03-25 12:59:13', '2022-03-25 12:59:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (333, 11, 'ACID PHOSPATUSE (PROSTATIC)', '300.00', '200.00', 'ACID PP', '2022-03-25', 1, '2022-03-25 13:00:34', '2022-03-25 13:00:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (334, 11, 'ACTH', '1200.00', '1100.00', 'ACTH', '2022-03-25', 1, '2022-03-25 13:01:14', '2022-03-25 13:01:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (335, 11, 'ADA (ADENOSINE DEAMINASE)', '550.00', '400.00', 'ADA', '2022-03-25', 1, '2022-03-25 13:02:38', '2022-03-25 13:02:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (336, 11, 'AFB C&S', '1000.00', '900.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:03:28', '2022-03-25 13:03:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (337, 11, 'AFB SPUTUM (CONCENTRATION)', '150.00', '120.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:04:49', '2022-03-25 13:04:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (338, 11, 'AFB PCR', '2500.00', '2000.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:05:46', '2022-03-25 13:05:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (339, 11, 'AFP', '750.00', '700.00', 'AFP', '2022-03-25', 1, '2022-03-25 13:06:12', '2022-03-25 13:06:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (340, 11, 'ALBUMIN', '70.00', '60.00', 'ALBUMIN', '2022-03-25', 1, '2022-03-25 13:06:55', '2022-03-25 13:06:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (341, 11, 'ALDOSTERONE', '1000.00', '900.00', 'ALD', '2022-03-25', 1, '2022-03-25 13:07:44', '2022-03-25 13:07:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (342, 11, 'ALKALINE PHOSPHATASE', '200.00', '100.00', 'AP', '2022-03-25', 1, '2022-03-25 13:08:44', '2022-03-25 13:08:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (343, 11, 'ALPHA FETA PROTIEN', '750.00', '700.00', 'AFP', '2022-03-25', 1, '2022-03-25 13:09:45', '2022-03-25 13:09:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (344, 11, 'AMALYSE', '500.00', '400.00', 'AMLYSE', '2022-03-25', 1, '2022-03-25 13:10:14', '2022-03-25 13:10:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (345, 11, 'AMINI ACIDS QUANTITATIVE', '6200.00', '6000.00', 'AAQ', '2022-03-25', 1, '2022-03-25 13:12:26', '2022-03-25 13:12:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (346, 11, 'AMONIA', '700.00', '600.00', 'AMONIA', '2022-03-25', 1, '2022-03-25 13:12:56', '2022-03-25 13:12:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (347, 11, 'ANA', '1000.00', '900.00', 'ANA', '2022-03-25', 1, '2022-03-25 13:13:20', '2022-03-25 13:13:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (348, 11, 'ANA PROFILE', '4950.00', '4000.00', 'ANAP', '2022-03-25', 1, '2022-03-25 13:14:01', '2022-03-25 13:14:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (349, 11, 'ANCA', '1590.00', '1500.00', 'ANCA', '2022-03-25', 1, '2022-03-25 13:14:56', '2022-03-25 13:14:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (350, 11, 'ANDROGEN PROFILE', '3880.00', '3000.00', 'AP', '2022-03-25', 1, '2022-03-25 13:15:51', '2022-03-25 13:15:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (351, 11, 'ANTI CARDIOLIPINE', '1200.00', '1100.00', 'ACL', '2022-03-25', 1, '2022-03-25 13:59:23', '2022-03-25 13:59:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (352, 11, 'ANTIGEN', '600.00', '500.00', 'AN', '2022-03-25', 1, '2022-03-25 14:05:08', '2022-03-25 14:05:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (353, 11, 'ANTIHERPEX 1&2', '1300.00', '1200.00', 'AN 1&2', '2022-03-25', 1, '2022-03-25 14:07:27', '2022-03-25 14:07:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (354, 11, 'ANTIPHOSPHO LIPID', '950.00', '850.00', 'AL', '2022-03-25', 1, '2022-03-25 14:09:04', '2022-03-25 14:09:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (355, 11, 'ANTISERUM ANTIBODY', '750.00', '650.00', 'AA', '2022-03-25', 1, '2022-03-25 14:10:10', '2022-03-25 14:10:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (356, 11, 'APLA', '1610.00', '1510.00', 'APLA', '2022-03-25', 1, '2022-03-25 14:11:07', '2022-03-25 14:11:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (357, 11, 'APTT', '250.00', '150.00', 'APTT', '2022-03-25', 1, '2022-03-25 14:12:12', '2022-03-25 14:12:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (358, 11, 'ASO TITRE', '400.00', '300.00', 'AT', '2022-03-25', 1, '2022-03-25 14:13:41', '2022-03-25 14:13:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (359, 11, 'B2 GLYCOPROTEIN IGG IGGM', '1800.00', '1700.00', 'B2G', '2022-03-25', 1, '2022-03-25 14:16:37', '2022-03-25 14:16:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (360, 11, 'CA-15', '1050.00', '950.00', 'CA', '2022-03-25', 1, '2022-03-25 14:35:10', '2022-03-25 14:35:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (361, 11, 'CALCITONIM', '1350.00', '1250.00', 'CAL', '2022-03-25', 1, '2022-03-25 14:35:55', '2022-03-25 14:35:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (362, 11, 'CALCIUM', '160.00', '150.00', 'CAL', '2022-03-25', 1, '2022-03-25 14:36:30', '2022-03-25 14:36:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (363, 11, 'CARBAMAPZINE', '450.00', '440.00', 'CAR', '2022-03-25', 1, '2022-03-25 14:38:01', '2022-03-25 14:38:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (364, 11, 'CARDIOLIPIN AB IGG', '500.00', '480.00', 'CARD', '2022-03-25', 1, '2022-03-25 14:39:18', '2022-03-25 14:39:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (365, 11, 'CARDIOLIPIN AB IGM', '500.00', '480.00', 'CARD', '2022-03-25', 1, '2022-03-25 14:40:22', '2022-03-25 14:40:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (366, 11, 'CEA', '580.00', '550.00', 'CE', '2022-03-25', 1, '2022-03-25 14:40:56', '2022-03-25 14:40:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (367, 11, 'CERULOPLASMIN', '500.00', '400.00', 'C', '2022-03-25', 1, '2022-03-25 14:54:26', '2022-03-25 14:54:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (368, 11, 'CERUOPLASMIN', '1200.00', '1100.00', 'CP', '2022-03-25', 1, '2022-03-25 14:55:44', '2022-03-25 14:55:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (369, 11, 'CERVICAL SMEAR', '200.00', '100.00', 'CS', '2022-03-25', 1, '2022-03-25 15:00:34', '2022-03-25 15:00:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (370, 11, 'CHLAMYDIAL AB IGG', '700.00', '600.00', 'CA', '2022-03-25', 1, '2022-03-25 15:01:40', '2022-03-25 15:01:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (371, 11, 'CHLORIDE', '120.00', '110.00', 'CH', '2022-03-25', 1, '2022-03-25 15:11:54', '2022-03-25 15:11:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (372, 11, 'CHLAMYDIAL IGM', '700.00', '600.00', 'CH, IGM', '2022-03-25', 1, '2022-03-25 15:13:43', '2022-03-25 15:13:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (373, 11, 'CK-MB(CL)', '200.00', '100.00', 'CK', '2022-03-25', 1, '2022-03-25 15:17:14', '2022-03-25 15:17:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (374, 11, 'CHOLINESTERASE', '350.00', '250.00', 'CHOL', '2022-03-25', 1, '2022-03-25 15:29:06', '2022-03-25 15:29:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (375, 11, 'CHROMOSOMAL ANTIBODY', '2250.00', '2150.00', 'CHR AN', '2022-03-25', 1, '2022-03-25 15:30:32', '2022-03-25 15:30:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (376, 11, 'CHROMOSOMAL STUDY', '2750.00', '2650.00', 'CHR ST', '2022-03-25', 1, '2022-03-25 15:31:29', '2022-03-25 15:31:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (377, 11, 'CK-MB(ENZYMATIC)', '200.00', '100.00', 'CK-EN', '2022-03-25', 1, '2022-03-25 15:32:33', '2022-03-25 15:32:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (378, 11, 'CK(CPK)', '280.00', '270.00', 'CK (C)', '2022-03-25', 1, '2022-03-25 15:33:41', '2022-03-25 15:33:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (379, 11, 'BETA-HCG', '600.00', '500.00', 'B-H', '2022-03-25', 1, '2022-03-25 15:36:06', '2022-03-28 14:17:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (380, 11, 'BRUCELLA AGGLUTINATION', '850.00', '750.00', 'BA', '2022-03-25', 1, '2022-03-25 15:39:07', '2022-03-25 15:39:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (381, 11, 'BRUCELLA IGG', '840.00', '740.00', 'B I', '2022-03-25', 1, '2022-03-25 15:40:34', '2022-03-25 15:40:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (382, 11, 'BRUCELLA IGM', '800.00', '700.00', 'BR IGM', '2022-03-25', 1, '2022-03-25 15:41:32', '2022-03-25 15:41:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (383, 11, 'BSL-13', '1350.00', '1250.00', 'BSL', '2022-03-25', 1, '2022-03-25 15:42:23', '2022-03-25 15:42:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (384, 11, 'BT&CT', '80.00', '70.00', 'BT- CT', '2022-03-25', 1, '2022-03-25 15:43:04', '2022-03-25 15:43:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (385, 11, 'CA 15.3', '1500.00', '1400.00', 'CA.15.3', '2022-03-25', 1, '2022-03-25 15:44:42', '2022-03-25 15:44:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (386, 11, 'C ANCA', '1350.00', '1250.00', 'C ANCA', '2022-03-25', 1, '2022-03-25 15:46:13', '2022-03-25 15:46:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (387, 11, 'CPK', '280.00', '180.00', 'CPK', '2022-03-25', 1, '2022-03-25 15:47:15', '2022-03-25 15:47:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (388, 11, 'C PEPTIDE', '1450.00', '1350.00', 'C P', '2022-03-25', 1, '2022-03-25 15:48:48', '2022-03-25 15:48:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (389, 11, 'C-REACTIVE PROTEIN', '300.00', '400.00', 'C-R P', '2022-03-25', 1, '2022-03-25 15:50:23', '2022-03-25 15:50:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (390, 11, 'CA 19.9', '1050.00', '950.00', 'CA 19.9', '2022-03-25', 1, '2022-03-25 15:53:14', '2022-03-25 15:53:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (391, 14, 'ECG', '200.00', '150.00', 'ECG', '2022-03-26', 1, '2022-03-26 09:23:43', '2022-03-26 09:23:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (392, 15, 'BONE MINERAL DENSITY', '2300.00', '2000.00', 'BMD', '2022-03-26', 1, '2022-03-26 12:39:16', '2022-03-26 12:39:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (393, 8, 'CT CHEST', '4900.00', '0.00', 'CT', '2022-03-26', 1, '2022-03-26 13:58:41', '2022-03-26 14:02:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (394, 9, 'XRAY', '250.00', '250.00', 'XX', '2022-03-26', 1, '2022-03-26 14:19:24', '2022-03-26 14:19:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (395, 7, 'USG OBG', '850.00', '300.00', 'OBG', '2022-03-26', 1, '2022-03-26 15:11:23', '2022-03-26 15:11:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (397, 23, '4D FOLLOW UP', '1000.00', '1000.00', '4DF', '2022-03-26', 1, '2022-03-26 15:28:59', '2022-03-29 10:38:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (398, 23, 'DOPPLER OBG', '1300.00', '1300.00', 'OBG', '2022-03-26', 1, '2022-03-26 15:46:04', '2022-03-29 09:37:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (399, 17, 'SONOMAMMOGRAM(SINGLE)', '1100.00', '600.00', 'SONO', '2022-03-26', 1, '2022-03-26 16:32:31', '2022-03-29 09:46:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (400, 17, 'SONOMAMMOGRAM(BOTH)', '2200.00', '1000.00', 'SONO', '2022-03-26', 1, '2022-03-26 16:34:46', '2022-03-29 09:47:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (401, 13, 'EEG', '1500.00', '1000.00', 'EEG', '2022-03-26', 1, '2022-03-26 17:42:28', '2022-03-26 17:42:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (402, 12, 'NCV', '1750.00', '1000.00', 'NCV', '2022-03-26', 1, '2022-03-26 17:43:10', '2022-03-26 17:43:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (403, 20, 'TMT', '1850.00', '1000.00', 'TMT', '2022-03-26', 1, '2022-03-26 17:44:19', '2022-03-29 09:33:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (404, 22, 'ECHO', '1650.00', '1000.00', 'ECHO', '2022-03-26', 1, '2022-03-26 17:47:18', '2022-03-26 17:47:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (405, 19, 'HSG', '2100.00', '1500.00', 'HSG', '2022-03-26', 1, '2022-03-26 17:48:04', '2022-03-26 17:48:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (406, 23, 'DOPPLER THYROID', '1100.00', '1000.00', 'DOP THY', '2022-03-28', 1, '2022-03-28 09:11:52', '2022-03-29 09:38:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (407, 23, 'DOPPLER LOWER LIMB(BOTH)', '3000.00', '1200.00', 'DOP LIMB', '2022-03-28', 1, '2022-03-28 09:14:46', '2022-03-29 09:38:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (408, 23, 'DOPPLER CAROTID', '1850.00', '1000.00', 'DOP CAROTID', '2022-03-28', 1, '2022-03-28 09:17:10', '2022-03-29 09:39:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (409, 23, 'DOPPLER PAROTID', '1300.00', '1000.00', 'DOP PAROTID', '2022-03-28', 1, '2022-03-28 09:21:11', '2022-03-29 09:39:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (410, 7, 'FOLLICULAR STUDY', '1300.00', '1000.00', 'FOLLICULAR', '2022-03-28', 1, '2022-03-28 09:26:54', '2022-03-28 09:26:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (411, 23, 'DOPPLER SCROTUM', '1300.00', '1000.00', 'DOP SCROTUM', '2022-03-28', 1, '2022-03-28 09:33:05', '2022-03-29 09:39:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (412, 7, 'ANOMALY SCAN', '1300.00', '1000.00', 'ANOMALY', '2022-03-28', 1, '2022-03-28 09:34:28', '2022-03-28 09:34:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (413, 23, 'DOPPLER UPPER LIMB', '3000.00', '2000.00', 'DOPPLER U LIMB', '2022-03-28', 1, '2022-03-28 09:42:13', '2022-03-29 09:40:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (414, 23, 'DOPPLER UPPER LIMB (SINGLE)', '1500.00', '1400.00', 'DOPPLER U LIMB SINGL', '2022-03-28', 1, '2022-03-28 09:44:02', '2022-03-29 09:40:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (415, 7, 'NEUROSONOGRAME', '1300.00', '1200.00', 'NSG', '2022-03-28', 1, '2022-03-28 09:44:43', '2022-03-28 09:44:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (416, 7, 'B SCAN (BOTH EYE)', '1750.00', '1700.00', 'EYE', '2022-03-28', 1, '2022-03-28 09:45:36', '2022-03-28 09:45:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (417, 7, 'USG CHEST', '1300.00', '1200.00', 'CHEST', '2022-03-28', 1, '2022-03-28 09:47:33', '2022-03-28 09:47:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (418, 7, 'USG PELVIS', '850.00', '800.00', 'PELVIS', '2022-03-28', 1, '2022-03-28 10:04:24', '2022-03-28 10:04:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (419, 23, 'DOPPLER PELVIS', '1850.00', '1000.00', 'DP', '2022-03-28', 1, '2022-03-28 11:09:27', '2022-03-29 09:41:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (420, 11, 'VITAMIN D3', '1250.00', '1000.00', 'D3', '2022-03-28', 1, '2022-03-28 13:02:49', '2022-03-28 13:02:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (421, 11, 'WIDAL TEST', '200.00', '150.00', 'WT', '2022-03-28', 1, '2022-03-28 13:17:26', '2022-03-28 13:17:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (422, 11, 'WESTERN BLOAT', '2000.00', '1800.00', 'WB', '2022-03-28', 1, '2022-03-28 13:19:00', '2022-03-28 13:19:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (423, 11, 'WBC COUNT', '30.00', '20.00', 'WC', '2022-03-28', 1, '2022-03-28 13:19:36', '2022-03-28 13:19:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (424, 11, 'WATER ANALYSIS', '200.00', '150.00', 'WA', '2022-03-28', 1, '2022-03-28 13:21:26', '2022-03-28 13:21:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (425, 11, 'VMA', '1050.00', '1000.00', 'VMA', '2022-03-28', 1, '2022-03-28 13:21:53', '2022-03-28 13:21:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (426, 11, 'VLDL', '20.00', '10.00', 'VLDL', '2022-03-28', 1, '2022-03-28 13:22:30', '2022-03-28 13:22:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (427, 11, 'VITAMIN 25 OH', '1250.00', '1200.00', 'VIT 25 OH', '2022-03-28', 1, '2022-03-28 13:23:13', '2022-03-28 13:23:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (428, 11, 'VITAMIN 125 OH-', '3200.00', '300.00', 'VIT 125OH', '2022-03-28', 1, '2022-03-28 13:24:45', '2022-03-28 13:24:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (429, 11, 'VDRL', '130.00', '100.00', 'VD', '2022-03-28', 1, '2022-03-28 13:25:49', '2022-03-28 13:25:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (430, 11, 'URINE ALBUMIN DEPOSIT', '70.00', '40.00', 'UAD', '2022-03-28', 1, '2022-03-28 13:27:01', '2022-03-28 13:27:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (431, 11, 'URINE UROBILIN OGEN', '70.00', '40.00', 'UUO', '2022-03-28', 1, '2022-03-28 13:28:38', '2022-03-28 13:28:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (432, 11, 'URINE SPECIFIC GRAVITY', '50.00', '20.00', 'USG', '2022-03-28', 1, '2022-03-28 13:30:01', '2022-03-28 13:30:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (433, 23, 'DOPPLER AXICILLA', '1300.00', '1000.00', 'DOP AXICILLA', '2022-03-28', 1, '2022-03-28 14:07:55', '2022-03-29 09:41:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (434, 16, 'OPG/CEPH', '850.00', '500.00', 'OPG CEPH', '2022-03-29', 1, '2022-03-29 09:36:03', '2022-03-29 09:36:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (435, 11, 'ANTI SPERM ANTI BODY', '1350.00', '1200.00', 'ASAB', '2022-04-01', 1, '2022-04-01 11:52:00', '2022-04-01 11:52:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (436, 11, 'PHERIPHERAL SMEAR', '180.00', '150.00', 'PS', '2022-04-01', 1, '2022-04-01 11:52:51', '2022-04-01 17:16:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (437, 11, 'CHOLESTEROL', '130.00', '120.00', 'CHOL', '2022-04-01', 1, '2022-04-01 12:12:02', '2022-04-01 12:12:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (439, 7, 'DOPPLER LOWER LIMB(SINGLE)', '1500.00', '1400.00', 'DLL', '2022-04-02', 1, '2022-04-02 14:50:38', '2022-04-02 14:50:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (440, 11, 'CRP', '400.00', '300.00', 'CRP', '2022-04-04', 1, '2022-04-04 09:41:00', '2022-04-04 09:41:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (441, 11, 'HBA', '900.00', '800.00', 'HBA', '2022-04-04', 1, '2022-04-04 10:11:01', '2022-04-04 10:11:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (442, 11, 'HBSAG', '800.00', '700.00', 'HBSAG', '2022-04-04', 1, '2022-04-04 10:11:36', '2022-04-04 10:11:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (443, 11, 'HCV', '800.00', '700.00', 'HCV', '2022-04-04', 1, '2022-04-04 10:12:34', '2022-04-04 10:12:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (444, 11, 'HEV', '1000.00', '900.00', 'HEV', '2022-04-04', 1, '2022-04-04 10:13:15', '2022-04-04 10:13:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (445, 7, '4D FOLLOW UP TWINS', '1500.00', '1200.00', 'FOLLOW UP', '2022-04-04', 1, '2022-04-04 13:26:54', '2022-04-04 13:26:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (446, 11, 'FNAC', '2000.00', '1800.00', 'FNAC', '2022-04-04', 1, '2022-04-04 15:47:44', '2022-04-04 15:47:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (447, 16, 'TMJ', '500.00', '400.00', 'TMJ', '2022-04-06', 1, '2022-04-06 13:01:11', '2022-04-06 13:02:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (448, 11, 'ABSLUTE ESNOPHIL COUNT', '140.00', '100.00', 'AEC', '2022-04-06', 1, '2022-04-06 17:14:56', '2022-04-06 17:14:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (449, 7, '5D DOPPLER TWINS', '3500.00', '2000.00', '4D/5D', '2022-04-07', 1, '2022-04-07 18:08:05', '2022-04-07 18:08:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (450, 9, 'X-RAY THORACO LUMBAR SPINE AP-LAT', '300.00', '250.00', 'TLS', '2022-04-07', 1, '2022-04-07 18:55:34', '2022-04-07 19:21:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (451, 9, 'LSS WITH PELVIS AP LSS LAT', '350.00', '300.00', 'LSS', '2022-04-07', 1, '2022-04-07 18:56:18', '2022-04-07 18:56:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (452, 9, 'TOE AP-OBL', '300.00', '250.00', 'TOE', '2022-04-07', 1, '2022-04-07 18:56:57', '2022-04-07 18:56:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (453, 9, 'FINGER AP LAT', '300.00', '250.00', 'FING', '2022-04-07', 1, '2022-04-07 18:57:41', '2022-04-07 18:57:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (454, 9, 'XRAY PELVIS INLET VIEW', '250.00', '200.00', 'PEL', '2022-04-07', 1, '2022-04-07 19:23:47', '2022-04-07 19:23:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (455, 9, 'X-RAY PELVIS OUTLET VIEW', '250.00', '200.00', 'PEL OUT', '2022-04-07', 1, '2022-04-07 19:24:25', '2022-04-07 19:24:25');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (456, 9, 'X-RAY BOTH HIP AP/ OBL', '300.00', '200.00', 'HIP A', '2022-04-07', 1, '2022-04-07 19:25:17', '2022-04-07 19:25:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (457, 11, 'HBSAG(ELIZA)', '500.00', '400.00', 'HBSAG', '2022-04-08', 1, '2022-04-08 14:32:13', '2022-04-08 14:32:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (458, 11, 'SODIUM', '130.00', '100.00', 'SODIUM', '2022-04-09', 1, '2022-04-09 08:04:03', '2022-04-09 08:04:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (459, 11, 'POTTASIUM', '130.00', '100.00', 'K+', '2022-04-09', 1, '2022-04-09 08:04:44', '2022-04-09 08:04:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (460, 11, 'D DIMER', '950.00', '900.00', 'DD', '2022-04-09', 1, '2022-04-09 10:11:03', '2022-04-09 10:11:03');


#
# TABLE STRUCTURE FOR: lab_test_category
#

DROP TABLE IF EXISTS `lab_test_category`;

CREATE TABLE `lab_test_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (7, 'USG', '2022-03-14 12:10:04', '2022-03-14 12:10:04');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (8, 'CT Scaning', '2022-03-14 12:10:31', '2022-03-14 12:10:31');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (9, 'X-RAY', '2022-03-14 13:54:45', '2022-03-14 13:54:45');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (10, 'CONSUMERABLE', '2022-03-14 15:59:19', '2022-03-14 15:59:19');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (11, 'LAB', '2022-03-14 16:47:09', '2022-03-14 16:47:09');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (12, 'NCV', '2022-03-15 13:01:47', '2022-03-15 13:01:47');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (13, 'EEG', '2022-03-15 13:01:59', '2022-03-15 13:01:59');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (14, 'ECG', '2022-03-15 13:02:13', '2022-03-15 13:02:13');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (15, 'BMD / DEXA', '2022-03-15 13:02:27', '2022-03-28 15:20:05');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (16, 'OPG', '2022-03-15 13:02:35', '2022-03-15 13:02:35');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (17, 'MAMMOGRAM', '2022-03-15 13:03:01', '2022-03-15 13:03:01');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (18, 'FNAC', '2022-03-15 15:46:03', '2022-03-15 15:46:03');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (19, 'HSG', '2022-03-17 17:52:54', '2022-03-17 17:52:54');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (20, 'TMT', '2022-03-17 17:53:07', '2022-03-17 17:53:07');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (22, 'ECHO', '2022-03-26 17:46:13', '2022-03-26 17:46:13');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (23, 'DOPPLER', '2022-03-28 15:17:47', '2022-03-28 15:17:47');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (24, '5D / 4D', '2022-03-28 15:18:18', '2022-04-05 11:07:13');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (25, 'FOLLOW UP 4D / 5D', '2022-04-05 11:08:01', '2022-04-05 11:08:01');


#
# TABLE STRUCTURE FOR: labtest_bill
#

DROP TABLE IF EXISTS `labtest_bill`;

CREATE TABLE `labtest_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(10) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `referral_id` int(11) NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `tax_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission` decimal(18,2) DEFAULT '0.00',
  `paid` decimal(18,2) NOT NULL DEFAULT '0.00',
  `due` decimal(18,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL,
  `date` date DEFAULT NULL,
  `hash` varchar(50) NOT NULL,
  `prepared_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (1, '0001', 1, 28, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-04-09', 'ddb08818878f2b820c960001455948d4', 1, '2022-04-09 17:02:55', '2022-04-09 17:02:55');


#
# TABLE STRUCTURE FOR: labtest_bill_details
#

DROP TABLE IF EXISTS `labtest_bill_details`;

CREATE TABLE `labtest_bill_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (1, 1, 7, 36, '850.00', '0.00', '0.00');


#
# TABLE STRUCTURE FOR: labtest_payment_history
#

DROP TABLE IF EXISTS `labtest_payment_history`;

CREATE TABLE `labtest_payment_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `collect_by` int(11) DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `method_id` int(11) NOT NULL,
  `remarks` text NOT NULL,
  `paid_on` date NOT NULL,
  `coll_type` tinyint(4) NOT NULL DEFAULT '0',
  `cash` decimal(18,2) NOT NULL,
  `upi` decimal(18,2) NOT NULL,
  `online` decimal(18,2) NOT NULL,
  `card` decimal(18,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (1, 1, 1, '850.00', 1, '', '2022-04-09', 0, '850.00', '0.00', '0.00', '0.00', '0.00');


#
# TABLE STRUCTURE FOR: labtest_report
#

DROP TABLE IF EXISTS `labtest_report`;

CREATE TABLE `labtest_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `delivery_time` time DEFAULT NULL,
  `report_description` longtext,
  `report_remarks` text,
  `test_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `test_id`, `category_id`, `status`) VALUES (1, 1, NULL, '2022-04-09', '04:30:00', NULL, '', 36, 7, 1);


#
# TABLE STRUCTURE FOR: language_list
#

DROP TABLE IF EXISTS `language_list`;

CREATE TABLE `language_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `lang_field` varchar(100) NOT NULL,
  `status` varchar(11) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (1, 'English', 'english', '1', '2018-11-15 17:36:31', '2020-01-09 11:45:23');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (2, 'Bengali', 'bengali', '0', '2018-11-15 17:36:31', '2022-03-16 17:38:48');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (3, 'Arabic', 'arabic', '0', '2018-11-15 17:36:31', '2020-01-07 13:22:02');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (4, 'German', 'german', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:26');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (5, 'Greek', 'greek', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:28');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (6, 'Spanish', 'spanish', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:29');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (7, 'French', 'french', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:31');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (8, 'Hindi', 'hindi', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:33');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (9, 'Hungarian', 'hungarian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:34');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (10, 'Indonesian', 'indonesian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:35');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (11, 'Italian', 'italian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:37');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (12, 'Japanese', 'japanese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:38');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (13, 'Korean', 'korean', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:40');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (14, 'Latin', 'latin', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:41');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'dutch', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:43');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (16, 'Portuguese', 'portuguese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:44');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (17, 'Russian', 'russian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:46');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (18, 'Thai', 'thai', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:47');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (19, 'Turkish', 'turkish', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:49');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (20, 'Urdu', 'urdu', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:50');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (21, 'Chinese', 'chinese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:51');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `english` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `bengali` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `arabic` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `german` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `greek` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `spanish` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `french` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `hindi` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `hungarian` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `indonesian` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `italian` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `japanese` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `korean` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `latin` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `dutch` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `portuguese` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `russian` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `thai` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `turkish` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `urdu` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `chinese` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=464 DEFAULT CHARSET=utf32 COLLATE=utf32_unicode_ci;

INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (1, 'dashboard', 'Dashboard', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (2, 'create', 'Create', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (3, 'patient', 'Patient', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (4, 'test', 'Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (5, 'bill', 'Bill', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (6, 'commission', 'Commission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (7, 'withdrawal', 'Withdrawal', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (8, 'appointment', 'Appointment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (9, 'voucher', 'Voucher', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (10, 'income_vs_expense', 'Income Vs Expense', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (11, 'search', 'Search', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (12, 'visit_home_page', 'Visit Home Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (13, 'language', 'Language', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (14, 'logout', 'Logout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (15, 'profile', 'Profile', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (16, 'reset_password', 'Reset Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (17, 'global', 'Global', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (18, 'settings', 'Settings', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (19, 'frontend', 'Frontend', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (20, 'setting', 'Setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (21, 'menu', 'Menu', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (22, 'page', 'Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (23, 'section', 'Section', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (24, 'manage', 'Manage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (25, 'slider', 'Slider', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (26, 'features', 'Features', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (27, 'testimonial', 'Testimonial', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (28, 'service', 'Service', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (29, 'faq', 'Faq', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (30, 'details', 'Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (31, 'list', 'List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (32, 'category', 'Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (33, 'login_deactivate', 'Login Deactivate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (34, 'inventory', 'Inventory', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (35, 'chemical', 'Chemical', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (36, 'supplier', 'Supplier', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (37, 'unit', 'Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (38, 'purchase', 'Purchase', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (39, 'stock', 'Stock', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (40, 'reagent', 'Reagent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (41, 'assigned', 'Assigned', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (42, 'reports', 'Reports', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (43, 'report', 'Report', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (44, 'payment', 'Payment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (45, 'schedule', 'Schedule', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (46, 'add', 'Add', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (47, 'requested_list', 'Requested List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (48, 'employee', 'Employee', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (49, 'department', 'Department', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (50, 'designation', 'Designation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (51, 'hrm', 'Human Resource', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (52, 'payroll', 'Payroll', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (53, 'salary', 'Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (54, 'template', 'Template', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (55, 'assign', 'Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (56, 'summary', 'Summary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (57, 'leaves', 'Leaves', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (58, 'my_leave', 'My Leave', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (59, 'leave_manage', 'Leave Manage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (60, 'attendance', 'Attendance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (61, 'set', 'Set', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (62, 'pathology', 'Pathology', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (63, 'lab', 'Lab', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (64, 'refer_manager', 'Refer Manager', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (65, 'referral', 'Referral', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (66, 'my_commission', 'My Commission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (67, 'statement', 'Statement', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (68, 'payout', 'Payout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (69, 'office_accounting', 'Office Accounting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (70, 'account', 'Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (71, 'head', 'Head', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (72, 'income', 'Income', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (73, 'repots', 'Repots', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (74, 'expense', 'Expense', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (75, 'transitions', 'Transitions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (76, 'balance', 'Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (77, 'sheet', 'Sheet', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (78, 'billing', 'Billing', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (79, 'due', 'Due', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (80, 'paid', 'Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (81, 'collect', 'Collect', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (82, 'investigation', 'Investigation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (83, 'sms', 'Sms', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (84, 'email', 'Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (85, 'role', 'Role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (86, 'permission', 'Permission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (87, 'database', 'Database', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (88, 'backup', 'Backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (89, 'invoice', 'Invoice', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (90, 'today_total', 'Today Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (91, 'annual', 'Annual', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (92, 'total_strength', 'Total Strength', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (93, 'doctor', 'Doctor', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (94, 'pending', 'Pending', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (95, 'request', 'Request', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (96, 'fees', 'Fees', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (97, 'net', 'Net', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (98, 'payable', 'Payable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (99, 'total', 'Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (100, 'this_value_is_required', 'This Value Is Required', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (101, 'enter_valid_email', 'Enter Valid Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (102, 'are_you_sure', 'Are You Sure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (103, 'delete_this_information', 'Delete This Information', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (104, 'yes_continue', 'Yes Continue', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (105, 'cancel', 'Cancel', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (106, 'deleted_note', '*Note : This Data Will Be Permanently Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (107, 'deleted', 'Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (108, 'information_deleted', 'Information Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (109, 'website', 'Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (110, 'application', 'Application', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (111, 'name', 'Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (112, 'receive_email_to', 'Receive Email To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (113, 'captcha_status', 'Captcha Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (114, 'select', 'Select', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (115, 'disable', 'Disable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (116, 'enable', 'Enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (117, 'recaptcha_site_key', 'Recaptcha Site Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (118, 'recaptcha_secret_key', 'Recaptcha Secret Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (119, 'working_hours', 'Working Hours', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (120, 'logo', 'Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (121, 'fav_icon', 'Fav Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (122, 'address', 'Address', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (123, 'mobile_no', 'Mobile No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (124, 'fax', 'Fax', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (125, 'footer_text', 'Footer Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (126, 'facebook_url', 'Facebook Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (127, 'twitter_url', 'Twitter Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (128, 'youtube_url', 'Youtube Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (129, 'google_plus', 'Google Plus', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (130, 'linkedin_url', 'Linkedin Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (131, 'pinterest_url', 'Pinterest Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (132, 'instagram_url', 'Instagram Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (133, 'save', 'Save', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (134, 'website_page', 'Website Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (135, 'welcome', 'Welcome', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (136, 'message', 'Message', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (137, 'doctors', 'Doctors', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (138, 'services', 'Services', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (139, 'call_to_action_section', 'Call To Action Section', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (140, 'options', 'Options', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (141, 'title', 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (142, 'subtitle', 'Subtitle', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (143, 'description', 'Description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (144, 'photo', 'Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (145, 'cta', 'Cta', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (146, 'button_text', 'Button Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (147, 'button_url', 'Button Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (148, '_title', ' Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (149, 'meta', 'Meta', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (150, 'keyword', 'Keyword', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (151, 'banner_photo', 'Banner Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (152, 'about', 'About', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (153, 'content', 'Content', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (154, 'about_photo', 'About Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (155, 'parallax_photo', 'Parallax Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (156, 'sl', 'Sl', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (157, 'url', 'Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (158, 'action', 'Action', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (159, 'my_appointment', 'My Appointment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (160, 'appointment_status', 'Appointment Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (161, 'date', 'Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (162, 'time_slot', 'Time Slot', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (163, 'consultation_fees', 'Consultation Fees', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (164, 'discount', 'Discount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (165, 'remarks', 'Remarks', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (166, 'exploring', 'Exploring', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (167, 'no_schedule_found', 'No Schedule Found', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (168, 'information_has_been_saved_successfully', 'Information Has Been Saved Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (169, 'id', 'Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (170, 'consultation', 'Consultation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (171, 'serial', 'Serial', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (172, 'status', 'Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (173, 'confirmed', 'Confirmed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (174, 'available', 'Available', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (175, 'staff_id', 'Staff Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (176, 'general', 'General', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (177, 'theme', 'Theme', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (178, 'institute_name', 'Institute Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (179, 'currency', 'Currency', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (180, 'currency_symbol', 'Currency Symbol', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (181, 'timezone', 'Timezone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (182, 'date_format', 'Date Format', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (183, 'system_logo', 'System Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (184, 'text_logo', 'Text Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (185, 'upload', 'Upload', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (186, 'select_ground', 'Select Ground', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (187, 'filter', 'Filter', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (188, 'bill_no', 'Bill No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (189, 'delivery', 'Delivery', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (190, 'lab_test', 'Lab Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (191, 'edit', 'Edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (192, 'code', 'Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (193, 'purchase_unit', 'Purchase Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (194, 'sale_unit', 'Sale Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (195, 'unit_ratio', 'Unit Ratio', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (196, 'purchase_price', 'Purchase Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (197, 'sales_price', 'Sales Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (198, 'all_select', 'All Select', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (199, 'unpaid', 'Unpaid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (200, 'partly_paid', 'Partly Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (201, 'total_paid', 'Total Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (202, 'type', 'Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (203, 'ref_no', 'Ref No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (204, 'pay_via', 'Pay Via', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (205, 'amount', 'Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (206, 'dr', 'Dr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (207, 'cr', 'Cr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (208, 'ref', 'Ref', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (209, 'attachment', 'Attachment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (210, 'login', 'Login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (211, 'welcome_to', 'Welcome To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (212, 'username', 'Username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (213, 'password', 'Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (214, 'remember', 'Remember', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (215, 'lose_your_password', 'Lose Your Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (216, 'position', 'Position', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (217, 'publish', 'Publish', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (218, 'target_new_window', 'Target New Window', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (219, 'external_url', 'External Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (220, 'external_link', 'External Link', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (221, 'successfully', 'Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (222, 'access_denied', 'Access Denied', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (223, 'username_has_already_been_used', 'Username Has Already Been Used', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (224, 'week_day', 'Week Day', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (225, 'time_start', 'Time Start', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (226, 'time_end', 'Time End', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (227, 'per_patient_duration', 'Per Patient Duration', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (228, 'make_closed', 'Make Closed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (229, 'the_consultation_completed', 'The Consultation Completed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (230, 'done', 'Done', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (231, 'the_consultation_has_been_closed', 'The Consultation Has Been Closed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (232, 'requested', 'Requested', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (233, 'create_at', 'Create At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (234, 'canceled', 'Canceled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (235, 'apply', 'Apply', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (236, 'close', 'Close', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (237, 'information_has_been_updated_successfully', 'Information Has Been Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (238, 'birthday', 'Birthday', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (239, 'joining_date', 'Joining Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (240, 'basic_details', 'Basic Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (241, 'gender', 'Gender', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (242, 'male', 'Male', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (243, 'female', 'Female', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (244, 'religion', 'Religion', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (245, 'blood_group', 'Blood Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (246, 'marital_status', 'Marital Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (247, 'single', 'Single', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (248, 'married', 'Married', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (249, 'profile_picture', 'Profile Picture', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (250, 'login_details', 'Login Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (251, 'office_details', 'Office Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (252, 'qualification', 'Qualification', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (253, 'social_links', 'Social Links', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (254, 'update', 'Update', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (255, 'patient_id', 'Patient Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (256, 'guardian', 'Guardian', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (257, 'authentication', 'Authentication', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (258, 'basic', 'Basic', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (259, 'age', 'Age', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (260, 'blood_pressure', 'Blood Pressure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (261, 'height', 'Height', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (262, 'weight', 'Weight', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (263, 'emergency_contact', 'Emergency Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (264, 'relationship', 'Relationship', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (265, 'history', 'History', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (266, 'completed', 'Completed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (267, 'undelivered', 'Undelivered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (268, 'login_authentication_deactivate', 'Login Authentication Deactivate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (269, 'deactivate_account', 'Deactivate Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (270, 'authentication_activate', 'Authentication Activate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (271, 'referred_by', 'Referred By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (272, 'time', 'Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (273, 'price', 'Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (274, 'add_rows', 'Add Rows', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (275, 'sub_total', 'Sub Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (276, 'tax', 'Tax', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (277, 'received', 'Received', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (278, 'enter_payment_amount', 'Enter Payment Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (279, 'write_your_remarks', 'Write Your Remarks', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (280, 'roles', 'Roles', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (281, 'system_role', 'System Role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (282, 'yes', 'Yes', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (283, 'role_permission_for', 'Role Permission For', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (284, 'feature', 'Feature', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (285, 'view', 'View', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (286, 'delete', 'Delete', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (287, 'ordered', 'Ordered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (288, 'quantity', 'Quantity', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (289, 'net_total', 'Net Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (290, 'bill_view', 'Bill View', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (291, 'add_payment', 'Add Payment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (292, 'to', 'To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (293, 'company', 'Company', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (294, 'sub', 'Sub', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (295, 'paid_amount', 'Paid Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (296, 'prepared_by', 'Prepared By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (297, 'authorised_by', 'Authorised By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (298, 'print', 'Print', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (299, 'paid_on', 'Paid On', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (300, 'attach_document', 'Attach Document', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (301, 'the_configuration_has_been_updated', 'The Configuration Has Been Updated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (302, 'retype_password', 'Retype Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (303, 'contact_number', 'Contact Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (304, 'company_name', 'Company Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (305, 'product', 'Product', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (306, 'stock_by', 'Stock By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (307, 'inovice_no', 'Inovice No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (308, 'sales_unit', 'Sales Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (309, 'for', 'For', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (310, 'select_multiple_chemical', 'Select Multiple Chemical', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (311, 'payment_history', 'Payment History', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (312, 'sex', 'Sex', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (313, 'from', 'From', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (314, 'net_payable', 'Net Payable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (315, 'collect_by', 'Collect By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (316, 'unpublished_on_website', 'Unpublished On Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (317, 'published_on_website', 'Published On Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (318, 'grade', 'Grade', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (319, 'overtime', 'Overtime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (320, 'allowances', 'Allowances', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (321, 'name_of_allowance', 'Name Of Allowance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (322, 'deductions', 'Deductions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (323, 'name_of_deductions', 'Name Of Deductions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (324, 'allowance', 'Allowance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (325, 'deduction', 'Deduction', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (326, 'salary_details', 'Salary Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (327, 'no_information_available', 'No Information Available', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (328, 'transactions', 'Transactions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (329, 'sms_config', 'Sms Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (330, 'sms_template', 'Sms Template', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (331, 'select_a_sms_service', 'Select A Sms Service', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (332, 'disabled', 'Disabled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (333, 'clickatell_username', 'Clickatell Username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (334, 'clickatell_password', 'Clickatell Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (335, 'clickatell_api_key', 'Clickatell Api Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (336, 'registered_number', 'Registered Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (337, 'account_sid', 'Account Sid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (338, 'auth_token', 'Auth Token', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (339, 'account_registered', 'Account Registered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (340, 'notify_enable', 'Notify Enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (341, 'body', 'Body', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (342, 'appointment_confirmation', 'Appointment Confirmation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (343, 'appointment_canceled', 'Appointment Canceled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (344, 'appointment_request', 'Appointment Request', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (345, 'reporting', 'Reporting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (346, 'button_text_1', 'Button Text 1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (347, 'button_url_1', 'Button Url 1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (348, 'button_text_2', 'Button Text 2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (349, 'button_url_2', 'Button Url 2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (350, 'left', 'Left', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (351, 'center', 'Center', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (352, 'right', 'Right', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (353, 'icon', 'Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (354, 'surname', 'Surname', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (355, 'rank', 'Rank', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (356, 'staff', 'Staff', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (357, 'paid_by', 'Paid By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (358, 'user', 'User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (359, 'payslip', 'Payslip', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (360, 'add_employee', 'Add Employee', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (361, 'bank_details', 'Bank Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (362, 'skipped_bank_details', 'Skipped Bank Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (363, 'bank_name', 'Bank Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (364, 'holder_name', 'Holder Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (365, 'bank', 'Bank', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (366, 'branch', 'Branch', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (367, 'ifsc_code', 'Ifsc Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (368, 'account_no', 'Account No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (369, 'restore', 'Restore', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (370, 'create_backup', 'Create Backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (371, 'file', 'File', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (372, 'backup_size', 'Backup Size', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (373, 'file_upload', 'File Upload', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (374, 'flag', 'Flag', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (375, 'stats', 'Stats', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (376, 'created_at', 'Created At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (377, 'updated_at', 'Updated At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (378, 'edit_word', 'Edit Word', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (379, 'flag_icon', 'Flag Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (380, 'language_unpublished', 'Language Unpublished', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (381, 'language_published', 'Language Published', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (382, 'transaction', 'Transaction', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (383, 'month_of_salary', 'Month Of Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (384, 'basic_salary', 'Basic Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (385, 'payment_type', 'Payment Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (386, 'bank_account', 'Bank Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (387, 'actions', 'Actions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (388, 'document', 'Document', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (389, 'download', 'Download', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (390, 'opening_balance', 'Opening Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (391, 'total_dr', 'Total Dr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (392, 'total_cr', 'Total Cr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (393, 'contact', 'Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (394, 'box_title', 'Box Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (395, 'box_description', 'Box Description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (396, 'box_photo', 'Box Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (397, 'form_title', 'Form Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (398, 'phone', 'Phone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (399, 'submit_button_text', 'Submit Button Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (400, 'map_iframe', 'Map Iframe', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (401, 'system_name', 'System Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (402, 'month', 'Month', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (403, 'patient_price', 'Patient Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (404, 'production_cost', 'Production Cost', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (405, 'created_by', 'Created By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (406, 'test_category', 'Test Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (407, 'test_name', 'Test Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (408, 'test_code', 'Test Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (409, 'staff_name', 'Staff Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (410, 'percentage', 'Percentage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (411, 'salary_assign', 'Salary Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (412, 'pay_now', 'Pay Now', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (413, 'overtime_total_hour', 'Overtime Total Hour', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (414, 'overtime_amount', 'Overtime Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (415, 'leave_category', 'Leave Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (416, 'days', 'Days', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (417, 'leave', 'Leave', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (418, 'date_of_start', 'Date Of Start', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (419, 'date_of_end', 'Date Of End', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (420, 'leave_type', 'Leave Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (421, 'reason', 'Reason', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (422, 'comments', 'Comments', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (423, 'accepted', 'Accepted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (424, 'start_date', 'Start Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (425, 'end_date', 'End Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (426, 'approved', 'Approved', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (427, 'reject', 'Reject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (428, 'select_all', 'Select All', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (429, 'not_selected', 'Not Selected', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (430, 'present', 'Present', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (431, 'absent', 'Absent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (432, 'holiday', 'Holiday', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (433, 'late', 'Late', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (434, 'current_balance', 'Current Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (435, 'no', 'No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (436, 'current', 'Current', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (437, 'qty', 'Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (438, 'payment_successfull', 'Payment Successfull', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (439, 'payment_by', 'Payment By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (440, 'chemical_wise_stock', 'Chemical Wise Stock', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (441, 'sale', 'Sale', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (442, 'in_qty', 'In Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (443, 'out_qty', 'Out Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (444, 'sale_profit', 'Sale Profit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (445, 'paid_via', 'Paid Via', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (446, 'collected_by', 'Collected By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (447, 'all', 'All', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (448, 'add_short_bio', 'Add Short Bio', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (449, 'email_config', 'Email Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (450, 'email_triggers', 'Email Triggers', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (451, 'system_email', 'System Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (452, 'subject', 'Subject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (453, 'forgot_password', 'Forgot Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (454, 'payslip_generated', 'Payslip Generated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (455, 'leave_approve', 'Leave Approve', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (456, 'leave_reject', 'Leave Reject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (457, 'password_restoration', 'Password Restoration', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (458, 'forgot', 'Forgot', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (459, 'back_to_login', 'Back To Login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (460, 'username_password_incorrect', 'Username Password Incorrect', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (461, 'word', 'Word', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (462, 'translations', 'Translations', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (463, 'referred', 'Referred', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');


#
# TABLE STRUCTURE FOR: leave_application
#

DROP TABLE IF EXISTS `leave_application`;

CREATE TABLE `leave_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `category_id` varchar(20) NOT NULL,
  `reason` text CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `leave_days` varchar(20) NOT NULL DEFAULT '0',
  `status` varchar(10) NOT NULL DEFAULT '1',
  `apply_date` datetime NOT NULL,
  `orig_file_name` varchar(255) NOT NULL,
  `enc_file_name` varchar(255) NOT NULL,
  `approved_by` longtext NOT NULL,
  `comments` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: leave_category
#

DROP TABLE IF EXISTS `leave_category`;

CREATE TABLE `leave_category` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `days` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: login_credential
#

DROP TABLE IF EXISTS `login_credential`;

CREATE TABLE `login_credential` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(250) NOT NULL,
  `role` int(11) NOT NULL,
  `active` int(11) NOT NULL COMMENT '1(active) 0(deactivate)',
  `last_login` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=793 DEFAULT CHARSET=utf8;

INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (1, 1, 'admin@gmail.com', '$2y$10$Jeo3lJWDGnf6rwBg4m75KOZPStXOpbrqdDL828fbCY5nhFpfp7eCu', 1, 1, '2022-04-09 17:29:03', '2022-03-08 15:54:41', '2022-04-09 16:59:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (3, 2, 'papachan@gmail.com', '$2y$10$vUQPIIcORYFg6ic1zaOU/O27zYgwaUOsJyV6BBovgy/W8uwENJtiC', 3, 1, NULL, '2022-03-08 21:26:18', '2022-03-08 21:26:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (5, 3, 'dr.vinodjacob', '$2y$10$GU07aJJfPrOJTTumkmW3oO55GUPMbXaDDKIsql3LrdANgUSSyvWRm', 3, 1, NULL, '2022-03-14 12:02:20', '2022-03-14 12:02:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (8, 4, 'ashifa', '$2y$10$hFKnPy8QxrW6NMBqrMxXBOO7Z9bMES5aHdLxNW98.5U3tUlbGVrc2', 3, 1, NULL, '2022-03-14 16:18:43', '2022-03-14 16:18:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (10, 5, 'omprakash', '$2y$10$xSCc.VyCkC.3FxSErb/V0e6eC0bvqRD3pEVo76i4q.mww2NiNMvGW', 3, 1, NULL, '2022-03-14 17:04:42', '2022-03-14 17:04:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (11, 6, 'harikumar', '$2y$10$CIsJAZHBcu3hCejPHnv6/umPLkWOUMOzsUZRBppPYtu/VYqm.mLdC', 3, 1, NULL, '2022-03-15 14:07:16', '2022-03-15 14:07:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (17, 7, 'mini', '$2y$10$A0xkEbA6AaYuHh2K15USdOR7t1hyROhUzfY6SUnwpjP6m3Nw10RMi', 3, 1, NULL, '2022-03-15 15:01:22', '2022-03-15 15:01:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (18, 8, 'jayaprakash', '$2y$10$lVOeiOT/m2YjPMUFpX9nKOG8cr2f.7g25mAQ61bTYu3Mnq2NRV0q6', 3, 1, NULL, '2022-03-15 15:02:18', '2022-03-15 15:02:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (19, 9, 'jacob', '$2y$10$1eT38YfHfZ/Gam/4kNjXNeJWru6l3WrtDuUCGeoBOIu0ZOTCAWytK', 3, 1, NULL, '2022-03-15 15:03:42', '2022-03-15 15:03:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (30, 16, '', '$2y$10$m6PZgdUqbnN8DU7XdLC0eOuQDSuYUbPCFGfFQ8miOD3nKjSQ/VrTu', 3, 1, NULL, '2022-03-16 12:48:26', '2022-03-16 12:48:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (31, 17, '', '$2y$10$V0zTqxp64RVvT6icZ7zwEevHx/iStjHkEyvNkDF7360FC86x7Gen6', 3, 1, NULL, '2022-03-16 12:49:42', '2022-03-16 12:49:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (32, 18, '', '$2y$10$iY7iTtAV2eJCR3q0Szu5GeBfsWWTfTYDdh7JeI/qSJgi/MDyeVLki', 3, 1, NULL, '2022-03-16 12:55:30', '2022-03-16 12:55:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (33, 19, '', '$2y$10$X4YtiyiDarsaN6zeJ5cWJOd9bhpvMDPRMnTE752MLSW/.FkA2cSdK', 3, 1, NULL, '2022-03-16 12:56:47', '2022-03-16 12:56:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (34, 20, '', '$2y$10$/S9OCQdy0p/CFq4mEEG.q.yw44TR.KQyw1koFRVkYBcRSGs7eaeOe', 3, 1, NULL, '2022-03-16 13:03:33', '2022-03-16 13:03:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (35, 21, '', '$2y$10$U1UmMZvKw3tLcfnktoe8K.Zw7noB0Octeuv/779LCfrrS/hOA5Om.', 3, 1, NULL, '2022-03-16 13:04:20', '2022-03-16 13:04:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (36, 22, '', '$2y$10$H1u43gNBAbmO8cuMnmTy6u2k2QMepcmIn65DIEdVhSrkMkVCyP9vO', 3, 1, NULL, '2022-03-16 13:13:14', '2022-03-16 13:13:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (37, 23, '', '$2y$10$rGCFC2fb0Hua/7.cW9VVZOW/7sb/uPv/kGVchbJVGnh2.dlpujhfW', 3, 1, NULL, '2022-03-16 13:13:52', '2022-03-16 13:13:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (39, 24, '', '$2y$10$IiH70h6qoQWsIJP/BxTti.8quiXeA7t9LNSViB6i33qAO8Rfi6C9e', 3, 1, NULL, '2022-03-16 13:30:41', '2022-03-16 13:30:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (40, 25, '', '$2y$10$X2MW.s7G4bTY5ZJq6ce/QuabV5O11PuXyq7olkFJbMWYhoi4Y63FW', 3, 1, NULL, '2022-03-16 13:31:56', '2022-03-16 13:31:56');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (41, 26, '', '$2y$10$edrwnZPjdIx/fP.WlWh8Wur3FyUfdaauwZmDyPTDwzArOF3MDEv9m', 3, 1, NULL, '2022-03-16 13:33:21', '2022-03-16 13:33:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (42, 27, '', '$2y$10$mja8wtYM2fnV9QBPIh66zOpAi7vmnGVBeT/g5Df7yIJVHoAIW4zCW', 3, 1, NULL, '2022-03-16 13:34:37', '2022-03-16 13:34:37');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (43, 28, '', '$2y$10$Mk82t4emNcRYZ7qH6Y5v2eRFHZreTW.h2X6zGoNtcxlQGTScOEJm.', 3, 1, NULL, '2022-03-16 13:38:30', '2022-03-16 13:38:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (44, 29, '', '$2y$10$jWhExFQ0btMwx2OomVCcM./1LxufKBBmXqKo1K6OVEe0Yd.3KC4y.', 3, 1, NULL, '2022-03-16 13:39:42', '2022-03-16 13:39:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (45, 30, '', '$2y$10$nuINFW6uyd9uS1x/XW3qQer1WXAdZwhv2g7INRU7LX/nMIWbk04eK', 3, 1, NULL, '2022-03-16 13:49:35', '2022-03-16 13:49:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (46, 16, '', '$2y$10$m9HriAWxgC2/oxrh0PFKHO/yxSesVeFixONCXEADsOPMdb.HeF1L.', 7, 1, NULL, '2022-03-16 13:50:40', '2022-03-16 13:50:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (47, 31, '', '$2y$10$e52Ozbts14hex.lyZCyTDuJcIJs2O0eT8SAoqwXbY4Wy11dJjE3z2', 3, 1, NULL, '2022-03-16 13:51:11', '2022-03-16 13:51:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (48, 32, '', '$2y$10$gHmhRUASrEf4fzi2rBCRdeV48XKhRP0Uf.kJ4s5alNdFIyG13VkFK', 3, 1, NULL, '2022-03-16 13:52:24', '2022-03-16 13:52:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (49, 33, '', '$2y$10$dRf7Ur/j0ZQosY/wV.3az.BwK69macOcnRbMuyXWFcdpiVmWCbS.O', 3, 1, NULL, '2022-03-16 13:53:39', '2022-03-16 13:53:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (50, 34, '', '$2y$10$f8tJr57qD4R7.l0LK0g3OeCWOuWJG.Hgu5emLY89dfS4VSec7YOeW', 3, 1, NULL, '2022-03-16 13:54:50', '2022-03-16 13:54:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (51, 35, '', '$2y$10$P9OokRoEAx9ECzzHsS.QRuPQmTMOf1DU15z0HKYAW6IwidKAmJyjy', 3, 1, NULL, '2022-03-16 13:55:48', '2022-03-16 13:55:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (52, 36, '', '$2y$10$lI5etedgvofblVJKAG4nFOdXBahswrKSrWffYl1rlIybCwLJRocfe', 3, 1, NULL, '2022-03-16 13:56:55', '2022-03-16 13:56:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (53, 37, '', '$2y$10$NHdO28pA4l7AV4KswoTyK.EH8Y/De52BtifrxsZ2l7xcd9HTotN3i', 3, 1, NULL, '2022-03-16 14:13:21', '2022-03-16 14:13:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (54, 38, '', '$2y$10$rp0tCwaF/o/PKvfXUQxuHeCsdf73ZLZquQicv7fuZtaNKfjsL7iJW', 3, 1, NULL, '2022-03-16 14:14:36', '2022-03-16 14:14:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (56, 39, '', '$2y$10$qXlCIWdvybaGwOz9SmRAm.E1ltjYLidk4BpnUFODS3tjBxfeXkboq', 3, 1, NULL, '2022-03-16 15:34:39', '2022-03-16 15:34:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (57, 40, '', '$2y$10$PWlgCpDqdqUvGRVuAQCiBeGkYOFtoT.oleWfWZp3EENmXuwTCe4n2', 3, 1, NULL, '2022-03-16 15:35:46', '2022-03-16 15:35:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (58, 41, '', '$2y$10$GAR4/zJVDnJeP4nUwlr6zOmdM7LJrmL/saqgyyCVpIrVeBsSkKtki', 3, 1, NULL, '2022-03-16 15:44:53', '2022-03-16 15:44:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (59, 42, '', '$2y$10$Bxn377uB2Nakz.T8Bv8FtOzkcibiBCnGOxScc1kw5M6J.H76adRWe', 3, 1, NULL, '2022-03-16 15:46:22', '2022-03-16 15:46:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (60, 43, '', '$2y$10$JcDER.xitDs/51TZ5tKPL.L2bRdP82VP5fFsHtd6DMoausIHszwxm', 3, 1, NULL, '2022-03-16 15:51:08', '2022-03-16 15:51:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (61, 44, '', '$2y$10$rLEXrZ0QYcD4USv3uSokkOUwaz/Ti6kD1eR/kkv8vlOYKs.V2ARs6', 3, 1, NULL, '2022-03-16 15:52:17', '2022-03-16 15:52:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (62, 45, '', '$2y$10$tndAxs6v1yQh3XEqq98qou0c38Yh/fpRheEI02QPK3l3zMJ1jFwhW', 3, 1, NULL, '2022-03-16 15:53:32', '2022-03-16 15:53:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (63, 46, '', '$2y$10$pVl1s7Oi0AngoyZRRTm.4.BxpTc1qTQwP5QA1ENZzZNhduJgYPCki', 3, 1, NULL, '2022-03-16 15:54:32', '2022-03-16 15:54:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (64, 47, '', '$2y$10$QkTEyHtc6atqSAIUMpKcWu3bT7GOR26vcquEGl7o8rQfCsygZHst6', 3, 1, NULL, '2022-03-16 15:55:21', '2022-03-16 15:55:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (65, 48, '', '$2y$10$9/7FD85XpXn81fQKNkwChuKODAzp8pTjqWoAHL0YHXbfPop0.nzR6', 3, 1, NULL, '2022-03-16 15:56:30', '2022-03-16 15:56:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (66, 49, '', '$2y$10$iT07eULM74IYm/EPcY9YM.4T5JBgi575NncmCGVRCwcHzvh8HIZkO', 3, 1, NULL, '2022-03-16 15:57:34', '2022-03-16 15:57:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (67, 50, '', '$2y$10$FfI57nJQf9kHrzXLxsrRcer0B6gzLo10c8lwq.OXlX52GpeIEvud6', 3, 1, NULL, '2022-03-16 15:58:42', '2022-03-16 15:58:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (68, 51, '', '$2y$10$E.iKM5NxR2lnwUcZgCJ0/.NuoegmlOn8ZkhL0vV5k8/vryJofrjtS', 3, 1, NULL, '2022-03-16 15:59:55', '2022-03-16 15:59:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (69, 18, '', '$2y$10$6aixlmeY47gAr6Zq3//g0.Oogn.VymTInKjMp8hfNAW5cpf331wsy', 7, 1, NULL, '2022-03-16 17:05:38', '2022-03-16 17:05:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (70, 19, '', '$2y$10$CrqUBqE.2AvpGowXr4mpaOq09a125ub0IuNDr2AXhj1bUDUaIh3ce', 7, 1, NULL, '2022-03-16 17:13:13', '2022-03-16 17:13:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (71, 20, '', '$2y$10$Hp3.MBOakhQ6ucit7U9O1OboBD34bOA5vjuYR0AxpOWqVqnad.q.S', 7, 1, NULL, '2022-03-16 17:18:24', '2022-03-16 17:18:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (76, 25, '', '$2y$10$IyT2ywk.UCOevnp5kolwG.jf.qAr0FGhkHSOfEdjkXMVZCfUIjwRG', 7, 1, NULL, '2022-03-17 13:23:38', '2022-03-17 13:23:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (77, 26, '', '$2y$10$psJhKygHEhjfVXF5hF8t4eI4xwrLisf5bw1WpuS370ylZldhnM6tm', 7, 1, NULL, '2022-03-17 13:24:34', '2022-03-17 13:24:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (78, 27, '', '$2y$10$00PGSQAMc0tS8a8AbFBpVuH6kgmLsiOhEjsQBtkQBKuim9Xf3Ub/e', 7, 1, NULL, '2022-03-17 13:25:11', '2022-03-17 13:25:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (79, 28, '', '$2y$10$qRA.iB69DoLaaAnn7gBv9eDBIPPcXN0u1WURZ2lptuFeens5pVNz2', 7, 1, NULL, '2022-03-17 13:25:55', '2022-03-17 13:25:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (80, 29, '', '$2y$10$noVTtxQhxC9ADgag.PZZDe0SCdchNZ/0zB6HkpqxA0JavqJJ4fQz6', 7, 1, NULL, '2022-03-17 13:27:29', '2022-03-17 13:27:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (81, 30, '', '$2y$10$8CWidgh0udUAJzo/VU9wWOP377AJKpY9Ey/a8t1OTWH0v7tV2FaKm', 7, 1, NULL, '2022-03-17 13:28:29', '2022-03-17 13:28:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (82, 31, '', '$2y$10$sv4g88ojxARDBuffPts2z.k7yJRBB0KIpaX/uBUChO1cSqp2dC/Cq', 7, 1, NULL, '2022-03-17 13:30:53', '2022-03-17 13:30:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (83, 32, '', '$2y$10$L2OTrdgf9TMqB1RSdkqcuek8Lp9uhlPpF/ryvpdPkdoQ8sfSTEOyq', 7, 1, NULL, '2022-03-17 13:32:22', '2022-03-17 13:32:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (84, 33, '', '$2y$10$MiJRCjZazFBnLsBZf81sXOIYzL1myVck/7tEDm3gRqLnE1HQU7T8i', 7, 1, NULL, '2022-03-17 14:50:21', '2022-03-17 14:50:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (85, 34, '', '$2y$10$6uE3K/klsGdcx11T4gwJWefLTS6WwpvHiScSLg19UGOPQAW03GHyi', 7, 1, NULL, '2022-03-17 14:51:10', '2022-03-17 14:51:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (86, 35, '', '$2y$10$5GDSDWiCy3rLFubNPNmwDOX0LnBI5WRV4BYU/88KWPWvUVInqrLA2', 7, 1, NULL, '2022-03-17 14:52:08', '2022-03-17 14:52:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (87, 36, '', '$2y$10$s4o04c3OAS7snBrVjZhn4uok0uo8a7d9f8rmCfi/UK0ZYtUdTVRrS', 7, 1, NULL, '2022-03-17 14:53:24', '2022-03-17 14:53:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (88, 37, '', '$2y$10$605n/xy4ilm4uBSe/cRpCel8sJkMECbhs7rAushQomX1vKFCtepn2', 7, 1, NULL, '2022-03-17 14:57:12', '2022-03-17 14:57:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (89, 38, '', '$2y$10$dnHBAri4fxRjVxTqnhmBS.TJiIwW37qwz6VNM4qkyv65l4qnVUjDS', 7, 1, NULL, '2022-03-17 15:00:17', '2022-03-17 15:00:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (90, 39, '', '$2y$10$RyXWjjJ9iTYQyJf1p4Rq7uljndvzTeYKS2IFAj7s7wQCYed3.RqTq', 7, 1, NULL, '2022-03-17 15:04:37', '2022-03-17 15:04:37');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (91, 40, '', '$2y$10$TrbFrjUJPbnSDBEqb.eHx.ia6fXIULzAg69V/wrlJuBtd55tRh8UG', 7, 1, NULL, '2022-03-17 15:05:16', '2022-03-17 15:05:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (92, 41, '', '$2y$10$R3XTLrBqMdyOgKB8VhJXNOb3wtgdIs/Ku0vDWsYmnrQ.AkK02Zq9O', 7, 1, NULL, '2022-03-17 15:05:56', '2022-03-17 15:05:56');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (93, 42, '', '$2y$10$DM3OdVqKb2XARCTDzEsej.OITvp.TB.N3zhMOcr93kbkBHa6sX2Ee', 7, 1, NULL, '2022-03-17 15:07:19', '2022-03-17 15:07:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (94, 43, '', '$2y$10$z2I1Szd6Gq3FQaa6BvkM/u4APuIdBXX7Y1kWsOkclJdPHdxdNbruq', 7, 1, NULL, '2022-03-17 15:08:18', '2022-03-17 15:08:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (95, 44, '', '$2y$10$iCw0KSPHr2uro0JmlIu2Yehr5qnx5cai7rbzkDLcN9w3pBN5jNBP2', 7, 1, NULL, '2022-03-17 15:08:48', '2022-03-17 15:08:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (96, 45, '', '$2y$10$/9G3dqhQiTJmPTpNTgzwwuNQJ3srvA7M4Ugqz1fizPBQRIxvZ7MRq', 7, 1, NULL, '2022-03-17 15:09:22', '2022-03-17 15:09:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (97, 52, '', '$2y$10$2KEN6LsT/UQSBsULIFmbvOXGHSahMwSjFzfBLyNqpENjVtbslcq32', 3, 1, NULL, '2022-03-17 15:12:27', '2022-03-17 15:12:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (98, 53, '', '$2y$10$pvuK.eEf9zd.wBPJ1djeyuvY7/SAEmKWZA40eJQntzqiHavHiY..C', 3, 1, NULL, '2022-03-17 15:13:46', '2022-03-17 15:13:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (99, 54, '', '$2y$10$8Y5eqhpGq1GXiZeNfxBBQ.jWzrXLiuy13Vvngc6T.O2bm2FKzrOK.', 3, 1, NULL, '2022-03-17 15:17:03', '2022-03-17 15:17:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (100, 55, '', '$2y$10$9UmA9qg2H2Uyo8WtVnaSwukPJiFAvk8tXHJR1ml0tdWvkyF5F11W6', 3, 1, NULL, '2022-03-18 11:24:32', '2022-03-18 11:24:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (101, 56, '', '$2y$10$4Pq/Wlfr3A4J31jc5HvMjOrDiC09Cmn8EzXMFtDmcIlAAaTgtB8KS', 3, 1, NULL, '2022-03-18 11:27:02', '2022-03-18 11:27:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (102, 57, '', '$2y$10$PO79/VOhxcjUNP7KmF7MyOQ.sMXJsONcF8CLstNU8DbKrPd1mNmkm', 3, 1, NULL, '2022-03-18 11:28:21', '2022-03-18 11:28:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (103, 58, '', '$2y$10$HFFSXV5oBsfap6vX22.g4u3Y4xDmJ7bM02CibkhXJ/Lo24LD8xLrm', 3, 1, NULL, '2022-03-18 11:29:34', '2022-03-18 11:29:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (104, 59, '', '$2y$10$W0DuiXQM5zU05bUFRpqfRe2fsQgvJIuu0YJVb.RDqo/1X33lWNXI.', 3, 1, NULL, '2022-03-18 11:34:26', '2022-03-18 11:34:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (105, 60, '', '$2y$10$/x78cPG6tcuqrgH75AFcOOmrDaFyT2SDUxekw/zRjKurwZOTcNUMq', 3, 1, NULL, '2022-03-18 11:48:17', '2022-03-18 11:48:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (106, 61, '', '$2y$10$JojkfPk2SzMXg67VMv8RaOKi1ULL4cYYL66w8J6aHfcQVjTHJ3y1q', 3, 1, NULL, '2022-03-18 11:58:38', '2022-03-18 11:58:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (107, 62, '', '$2y$10$3Iqc.J6ebD/zzuomYGdM1.jqxIvcNee8rcAoUeq78I0FrCuibqWx6', 3, 1, NULL, '2022-03-18 12:03:49', '2022-03-18 12:03:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (108, 63, '', '$2y$10$4qt.6lOVDLUjaRwCLF0ime447EpGWeolaC2pKkrP3WxHr/Bpr4jKa', 3, 1, NULL, '2022-03-18 12:06:30', '2022-03-18 12:06:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (109, 64, '', '$2y$10$IXkGq1bP58h0nKUmjgnTJu4YF08v.w/q1IZzn63xtbwu0OxSR/i2q', 3, 1, NULL, '2022-03-18 12:10:26', '2022-03-18 12:10:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (110, 65, '', '$2y$10$z.Qmiu7PP7AijCW7PxFB/Ojyh46rm3Jtt17D.I.SlX4uDYZTKw5aC', 3, 1, NULL, '2022-03-18 12:11:11', '2022-03-18 12:11:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (111, 66, '', '$2y$10$neFPN/1nDJiSkPfDB0hQYO6CnuTDr72drFib1TypaynZ6nkczcWoy', 3, 1, NULL, '2022-03-18 12:12:12', '2022-03-18 12:12:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (112, 67, '', '$2y$10$gxa5p12akew71HOtiwufSe3loW6G/YLuWb50d1QG5hMQIcuLtvcoG', 3, 1, NULL, '2022-03-18 12:13:16', '2022-03-18 12:13:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (113, 68, '', '$2y$10$5fbrVTtDC6RFLBwOAXWUEuQa4CuvEgbuwt5j/WMndUiC1iuVaaoOu', 3, 1, NULL, '2022-03-18 12:14:24', '2022-03-18 12:14:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (114, 69, '', '$2y$10$zry7TvZejT/NxGikSONBjuNWaAiuQAbd7B9a5cEpZAHwRu/aCDZYq', 3, 1, NULL, '2022-03-18 12:15:13', '2022-03-18 12:15:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (115, 70, '', '$2y$10$8MUSOJRyfYwSi5qDXUkN2eqMi93UVxRTC/vzvfqepgwCb8RLXWtaG', 3, 1, NULL, '2022-03-18 12:16:01', '2022-03-18 12:16:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (117, 72, '', '$2y$10$.Ht84qS2WaUIY0QN92BB6uYBsl6F90AOmHSIW9A8n19Dt15ZWvq8.', 3, 1, NULL, '2022-03-18 12:18:17', '2022-03-18 12:18:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (118, 73, '', '$2y$10$gfI1I0Vfjsmz5hheILN0o.7nlctJLCsBPB5OBJ9H5R7pWK8NCgNlC', 3, 1, NULL, '2022-03-18 12:19:37', '2022-03-18 12:19:37');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (119, 74, '', '$2y$10$/MMU/OTY5LcRcPZwjGUJyu/3g6Ef0rY0oIfOualAEuS3.I4eqW./y', 3, 1, NULL, '2022-03-18 12:22:20', '2022-03-18 12:22:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (120, 75, '', '$2y$10$oen1xDpYaA36VtuWjfCr5.HqBxyxb/UztxHm1xznT35RU5qMGGWY.', 3, 1, NULL, '2022-03-18 12:34:57', '2022-03-18 12:34:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (121, 76, '', '$2y$10$MWLTMYFGoOd2yKx0I9BVgO04xJMUbbPDUVBBJ/f11elwhR/.q5bNi', 3, 1, NULL, '2022-03-19 15:07:57', '2022-03-19 15:07:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (122, 77, '', '$2y$10$mXMYWfbboTgpupu1YE9t.eAs7tFMa0TXWT./pqygH84/76zNrvyii', 3, 1, NULL, '2022-03-19 15:10:04', '2022-03-19 15:10:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (123, 78, '', '$2y$10$UdmWZQ1RL4ASz3R5RmDlcuMJMsRK8PwNjYP7Kfn3UgnwjwAFHT1ay', 3, 1, NULL, '2022-03-19 15:12:36', '2022-03-19 15:12:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (124, 79, '', '$2y$10$kWzBxVafmT0Pj9Mf39IP9u1eGunnjR.MhauDvEG4dlUS4GZ7tsY0K', 3, 1, NULL, '2022-03-19 15:13:58', '2022-03-19 15:13:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (125, 80, '', '$2y$10$BcIeIFTJQHSDXYfHWspJgOY.L2HvH5yi05Kefm7mtITWq5OCq7.x.', 3, 1, NULL, '2022-03-19 15:15:16', '2022-03-19 15:15:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (126, 81, '', '$2y$10$dId7aVRIXffvtjh3ulRgsuyxZbYohhFvSainMtEwdjf7nL/0tfyu.', 3, 1, NULL, '2022-03-19 15:30:22', '2022-03-19 15:30:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (127, 82, '', '$2y$10$iCla/V2r6zFw.I3a6oyL4uvWISS5YnJ5IGbLonPKmUbLp7KBH5442', 3, 1, NULL, '2022-03-19 15:33:38', '2022-03-19 15:33:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (128, 83, '', '$2y$10$HGN3RNWBigaMzPLwYxKsW.nP1Y5GuV4gMTh7X/aleNp/OD/2ca4De', 3, 1, NULL, '2022-03-19 15:36:20', '2022-03-19 15:36:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (130, 85, '', '$2y$10$ibnA9AnG2lUAgF6Vy.BEWOORdz4/yFtln.ucIFjI9xnCfiOcd2YKG', 3, 1, NULL, '2022-03-19 15:40:09', '2022-03-19 15:40:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (131, 86, '', '$2y$10$Ye39XTFvCtbnitRH4oQZ1.UTYKjkkCEDjAWwENnwvlzDwFp0dyxvu', 3, 1, NULL, '2022-03-19 15:41:29', '2022-03-19 15:41:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (132, 87, '', '$2y$10$2/KBVVzag7E5GuOyjtV4N.kyy70xdkKn7/NLs1PfR6SNktIBbWpKe', 3, 1, NULL, '2022-03-19 15:43:49', '2022-03-19 15:43:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (133, 88, '', '$2y$10$jNDYzAAVupYLGFMkwURAMOe44ytS6CcxQZ1N6.WUMrApV4EuvW8n6', 3, 1, NULL, '2022-03-22 12:42:33', '2022-03-22 12:42:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (134, 89, '', '$2y$10$fiDel1OEOORvs2BB6GKUo.HK73vlclKjZJyRNUZb/EHXeRI5mJpEe', 3, 1, NULL, '2022-03-22 12:46:17', '2022-03-22 12:46:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (135, 90, '', '$2y$10$aPCzakb59lzHMCumumsi1O3NMFWhDMOrdkVLaC66c9Rd5nf942KnG', 3, 1, NULL, '2022-03-22 12:49:27', '2022-03-22 12:49:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (136, 91, '', '$2y$10$bQTP3HKDR54sHf7hmSE17.WgyxASFvqOlK7Sird.dID55tVWm16lm', 3, 1, NULL, '2022-03-22 12:52:08', '2022-03-22 12:52:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (137, 92, '', '$2y$10$PCHrf7HZLZn9dByZKgQeYeKR9w1lg2NhixrTIWZa0GIVzeZBZG0gS', 3, 1, NULL, '2022-03-22 12:53:17', '2022-03-22 12:53:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (138, 93, '', '$2y$10$kTrviugGJOzoImG5Ryi6xuWo6hadyyEkeY.5vhrwWZ.H332N2n8mm', 3, 1, NULL, '2022-03-22 12:54:13', '2022-03-22 12:54:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (139, 94, '', '$2y$10$5ut6oSK9i6MyR/274B.tZO6vJTRyFWI5q7Qyv7l.K14xB3oI/eSWe', 3, 1, NULL, '2022-03-22 12:54:13', '2022-03-22 12:54:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (140, 95, '', '$2y$10$4ZLzCbinZAkXOVw3HHMTmuerQX..i7/2HE49Vtn4t8Gdq229i8iF.', 3, 1, NULL, '2022-03-22 12:55:17', '2022-03-22 12:55:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (141, 96, '', '$2y$10$3qxix27rJY9RY43oX1.kPuNW7r3MqMJluiIOwZ0zPQTR95QGMZ1N.', 3, 1, NULL, '2022-03-22 12:56:16', '2022-03-22 12:56:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (142, 97, '', '$2y$10$hZ9Z7bdtl4lvX.hA854daOOXkP1gN.kCu1bfwmxtkr77Uzh.2ObkS', 3, 1, NULL, '2022-03-22 12:58:03', '2022-03-22 12:58:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (143, 98, '', '$2y$10$Ovdf6Um2GsVht1L21.MD7uQfEs.EAw12/8oEUYh/9xr2p6tQB8ekW', 3, 1, NULL, '2022-03-22 13:00:26', '2022-03-22 13:00:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (144, 46, '', '$2y$10$j3/j7fGygq9uzFTcFQqbV.uRcNoXwd8S8WLRqoHSYNj/dx65vMAv2', 7, 1, NULL, '2022-03-22 15:54:50', '2022-03-22 15:54:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (145, 99, '', '$2y$10$zMJZKGJotUCmmJumbuvgOOD3DNGdMGa.fHpFMDIVlccuQWlKNdJvm', 3, 1, NULL, '2022-03-22 15:55:08', '2022-03-22 15:55:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (146, 100, '', '$2y$10$T3.JTw7p4gh4N8MgOrSO2eGj07teujKwmny20cPW2BTb.1HGh1c6u', 3, 1, NULL, '2022-03-22 15:55:09', '2022-03-22 15:55:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (148, 47, 'RAJANI SUNIL', '$2y$10$H0/j0llV/H..2T4wF70IauysDUmw5YKI/E9cqUUhQY44dG0f.VVgW', 7, 1, NULL, '2022-03-22 16:00:57', '2022-03-22 16:00:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (149, 48, 'NISHA', '$2y$10$EWlllkXMx.lieGKFVB2kWe5W80.FPA/SodDHQHO.MungFpjFngq7W', 7, 1, '2022-03-23 21:08:42', '2022-03-22 16:06:12', '2022-03-23 20:38:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (150, 102, '', '$2y$10$pD26E8CU05fCj09NMH7kfemGx.3jYCkWwdb7Va3C3HO1a5YtHK7yi', 3, 1, NULL, '2022-03-22 16:09:18', '2022-03-22 16:09:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (151, 103, '', '$2y$10$ORdESx9UwnctlNNDWO3Yx.zUTspyvdIJsKRl/pI32kL3c7BSq1t4i', 3, 1, NULL, '2022-03-22 16:13:20', '2022-03-22 16:13:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (152, 104, '', '$2y$10$s764iFucMI6hBxeVLTwqR.iKeGXzHFkxGL/AYQOOOw8vkJhxPl.b2', 3, 1, NULL, '2022-03-22 16:14:16', '2022-03-22 16:14:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (153, 105, '', '$2y$10$Mbn3edxX0WHTdaP4N4DE3.XueZzcMuJ/9bVEY4sS6SN4whoDbXAUO', 3, 1, NULL, '2022-03-22 16:14:58', '2022-03-22 16:14:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (154, 106, '', '$2y$10$sFOFpbu1YHACJh8zOIFaAe.zqE31HQfDJTAR/jtyD2eR98Kgqlfvy', 3, 1, NULL, '2022-03-22 16:15:53', '2022-03-22 16:15:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (155, 107, '', '$2y$10$d2Y16Trm.dfhnd2KlZrcVuhwmBbPAK5TP1NIQHEEtbYqWernQoJIu', 3, 1, NULL, '2022-03-22 16:17:20', '2022-03-22 16:17:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (156, 108, '', '$2y$10$PrLMgFVwq/5yH2Cc5IAtw.cfu89WrxQTIAV8q6xCp.2LIXWPGbVjG', 3, 1, NULL, '2022-03-22 16:18:24', '2022-03-22 16:18:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (157, 109, '', '$2y$10$SR.To5ghq8guFQs6K83r4uyDHigqMgvLrZXywA0EGeuTs9tUw0L.y', 3, 1, NULL, '2022-03-22 16:20:05', '2022-03-22 16:20:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (158, 110, '', '$2y$10$AkQVC.P84eHCKmzDZjX8/eP/K3k4P5.lamGMiU7G7v/cEVzbLQUre', 3, 1, NULL, '2022-03-22 16:21:55', '2022-03-22 16:21:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (159, 111, '', '$2y$10$lnie6iNZ1wk5getZUFvaH.5jMuqwc2hQGAVW/tJn/94cfjy8MvI7i', 3, 1, NULL, '2022-03-22 16:24:22', '2022-03-22 16:24:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (160, 112, '', '$2y$10$u9HIHilFDaXtHGKxpVv9Kexh3Hl.E5ao6nVCI3ANW/DqPSqFW7zxS', 3, 1, NULL, '2022-03-22 16:25:10', '2022-03-22 16:25:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (161, 113, '', '$2y$10$Lw86med/Zirpinb9/E6.CujuCwT6kr.jzwgLmazKTsfN1P/8GEGhW', 3, 1, NULL, '2022-03-22 16:26:27', '2022-03-22 16:26:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (162, 114, '', '$2y$10$VjyURjTp5QdSoCb/gWAHvOEtijz.Fr1WjmXn/Sf7vFA.TaYGmkhMG', 3, 1, NULL, '2022-03-22 16:28:46', '2022-03-22 16:28:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (163, 115, '', '$2y$10$QeySVccvALH63kJbrBQxXew6qqERAlyyz/B/MQpkJRxDATUr3gIC6', 3, 1, NULL, '2022-03-22 16:31:46', '2022-03-22 16:31:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (164, 116, '', '$2y$10$dl1RRG3xz0EznmzM7AjtcupwmYmdNK2c77va9Y/2yaSHTGcAPh9EO', 3, 1, NULL, '2022-03-22 16:33:07', '2022-03-22 16:33:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (165, 117, '', '$2y$10$HC1Zy.vKU/fQC71nv5UlY.V9RK/8paCsENBn5sGYHz7nZZPMNsZYq', 3, 1, NULL, '2022-03-22 16:34:29', '2022-03-22 16:34:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (166, 118, '', '$2y$10$fvFQ3DnotolUoLZcVJO6wOIwzGClMFQs6uHhyV.2ayWEF2Rw8vIga', 3, 1, NULL, '2022-03-22 16:36:00', '2022-03-22 16:36:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (167, 119, '', '$2y$10$RC6OOrB212SPSbOp5.HKjuhGmED2xQW6s3/.Cfe1CO/iynlBdKwUO', 3, 1, NULL, '2022-03-22 16:37:15', '2022-03-22 16:37:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (168, 120, '', '$2y$10$I9e8A.eWBWmbrqmLKUfu..xOXtkEQKpz1DNKSvK/TWS9tng93vX/6', 3, 1, NULL, '2022-03-22 16:39:13', '2022-03-22 16:39:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (169, 121, '', '$2y$10$ZC2PkMCwK.LkZb1s.8wvWuW1X1PrTEUspcxPJWqMK68x125FsmY6G', 3, 1, NULL, '2022-03-22 16:39:55', '2022-03-22 16:39:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (170, 122, '', '$2y$10$J0Wq64EN9yIfiGbLHcRdUuW565yfZEdjn4oGZNn7GI6jrEOEyVSJa', 3, 1, NULL, '2022-03-22 16:40:39', '2022-03-22 16:40:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (171, 123, '', '$2y$10$TpajjXYqBW9Msutw9/WTp.mCwKt0T4bJKlVKfnf3KBK92PmtW5X4G', 3, 1, NULL, '2022-03-22 16:41:27', '2022-03-22 16:41:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (172, 124, '', '$2y$10$Gk9z8hL60P8xHt5kuFtfquulh6ZdieN729zNzZsXfyjfpyVN7WR9C', 3, 1, NULL, '2022-03-22 16:43:06', '2022-03-22 16:43:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (173, 125, '', '$2y$10$JQ3GJoCkj/n9Q3f5BOGvM.p17Pn3aqS20GIkARSxh7QBS3Zqn9bby', 3, 1, NULL, '2022-03-22 16:48:58', '2022-03-22 16:48:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (174, 126, '', '$2y$10$4cn9s4wEqnqIwxrgauyGjexDURHlB3cQMfY2RGBOK058rg16bbA.q', 3, 1, NULL, '2022-03-22 16:49:49', '2022-03-22 16:49:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (175, 127, '', '$2y$10$GmLmKIK.X0kXA59xuPmpWuRBakqvec54/dJ.aCttYYxD2xt8.R9Ce', 3, 1, NULL, '2022-03-22 16:51:49', '2022-03-22 16:51:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (176, 128, '', '$2y$10$BrU.gOf.k5v1ls7nSbXKr.LXKbVpFYDQ7uIDld/e5.PivtLOf5ZRC', 3, 1, NULL, '2022-03-22 16:52:42', '2022-03-22 16:52:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (177, 129, '', '$2y$10$0dz/Bac8dOzD0M4q81JT5OPyPF.ZPKAa9q/IFmLcwp582PHaYwLqW', 3, 1, NULL, '2022-03-22 16:54:29', '2022-03-22 16:54:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (178, 130, '', '$2y$10$XDCjktWHODCYicxavvOLCOEXWV.EXEQa7//Yv6ex6CDQVp6y01Hbq', 3, 1, NULL, '2022-03-22 16:55:08', '2022-03-22 16:55:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (179, 131, '', '$2y$10$WmKULElfxKAHQorYgcplEeu8HJB7MrrcU9HuaJKFL7aXxzppmlRPu', 3, 1, NULL, '2022-03-22 16:57:11', '2022-03-22 16:57:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (180, 132, '', '$2y$10$OC.A45Z3YbCss6SH2uO2Xeif1DuGEBrgdeb0fW8PdIn5NEJroDhuW', 3, 1, NULL, '2022-03-22 16:59:24', '2022-03-22 16:59:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (181, 133, '', '$2y$10$GPDFQaIPZ6Of8fqdRhWeEO4EtBDka0kRf/AxwjG4BQZPq/X.oS.5y', 3, 1, NULL, '2022-03-22 17:03:04', '2022-03-22 17:03:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (182, 134, '', '$2y$10$jL5ag0A/UGNoDvqDBiQIsO2ZhHc36TzrbYqckA4PYzYmOSaboaKje', 3, 1, NULL, '2022-03-22 17:03:47', '2022-03-22 17:03:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (183, 135, '', '$2y$10$HLbyX3QQzhPPef23tL1N7uajHh8wW9.rd0FRPz23MwznbxikW9Cv.', 3, 1, NULL, '2022-03-22 17:05:59', '2022-03-22 17:05:59');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (184, 136, '', '$2y$10$edvhKJ1nBh4mjT34ULwMre/a0wmBH/lgw3TcFSKGKn4is8QmqxDVO', 3, 1, NULL, '2022-03-22 17:06:52', '2022-03-22 17:06:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (185, 137, '', '$2y$10$z.7nDxCsjg4E50SmUTWzqeyaOAzOKSawHkMsf1q.B4eq2yTkjqMea', 3, 1, NULL, '2022-03-22 17:28:22', '2022-03-22 17:28:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (186, 138, '', '$2y$10$WjLVBXzE0vRUe9B/kTbrTO0NrLxm2lPyUsbwJNbjV/CK0Jvp/vLrC', 3, 1, NULL, '2022-03-22 17:28:57', '2022-03-22 17:28:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (187, 139, '', '$2y$10$TSW2YoDrWSQvjylo5KmfIOfA3KRL1BHL8tPyPWBCRsoQz1.CXBBK2', 3, 1, NULL, '2022-03-22 17:29:39', '2022-03-22 17:29:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (188, 140, '', '$2y$10$xXnDdTf009kLB1JBpCwwoOFmU7HZB9mu/9/4OFyX/Fr06lo86VCO6', 3, 1, NULL, '2022-03-22 17:32:16', '2022-03-22 17:32:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (189, 141, '', '$2y$10$C3zXj/AolIXMuYp351YGn.6itn1I3N/MZJSRUas/vigfiDkBelYd6', 3, 1, NULL, '2022-03-22 17:33:33', '2022-03-22 17:33:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (190, 142, '', '$2y$10$CS7T5SGYs5wQaa17WEufgusvLQ7aSl1EqJioMJPR8rzNN.sV1/bBC', 3, 1, NULL, '2022-03-22 17:34:34', '2022-03-22 17:34:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (191, 143, '', '$2y$10$WY9YJroj3VkKMDslZ4Jj7OPDzFSoHlb.WPK4K/n76rS2IW39wlZUO', 3, 1, NULL, '2022-03-22 17:35:30', '2022-03-22 17:35:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (192, 144, '', '$2y$10$ybos7IP0werqKY8fLJDyMuNwASqt3WkFrQIsBmZy1SCuoFQJyItFa', 3, 1, NULL, '2022-03-22 17:36:43', '2022-03-22 17:36:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (193, 49, '', '', 7, 1, NULL, '2022-03-22 18:34:53', '2022-03-22 18:34:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (194, 50, '', '', 7, 1, NULL, '2022-03-22 18:34:53', '2022-03-22 18:34:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (195, 51, '', '', 7, 1, NULL, '2022-03-23 09:20:00', '2022-03-23 09:20:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (196, 52, '', '', 7, 1, NULL, '2022-03-23 16:54:00', '2022-03-23 16:54:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (197, 53, '', '', 7, 1, NULL, '2022-03-24 09:43:58', '2022-03-24 09:43:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (198, 54, '', '$2y$10$F.NnGfapnDfjee6gS7llIeCQMWdFOT/TCRlT3RHYcxS.9IUBCafhW', 7, 1, NULL, '2022-03-24 17:03:02', '2022-03-24 17:03:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (199, 55, '', '$2y$10$/1gM.n0afgixDfAhvnQGZubuPaPc.3v4coYOWfcsoQ1a6V4SaDy3W', 7, 1, NULL, '2022-03-24 17:19:27', '2022-03-24 17:19:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (200, 56, '', '', 7, 1, NULL, '2022-03-25 09:58:20', '2022-03-25 09:58:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (201, 57, '', '', 7, 1, NULL, '2022-03-25 10:41:53', '2022-03-25 10:41:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (202, 58, '', '', 7, 1, NULL, '2022-03-25 10:49:00', '2022-03-25 10:49:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (203, 59, '', '', 7, 1, NULL, '2022-03-26 09:09:20', '2022-03-26 09:09:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (204, 145, '', '', 3, 1, NULL, '2022-03-26 09:09:20', '2022-03-26 09:09:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (205, 60, '', '$2y$10$U0aPrjM3j9mzHXD0sIcgouKh9IlANl/OW323VmvRG.bhgUxDP3Hoq', 7, 1, NULL, '2022-03-26 09:32:49', '2022-03-26 09:32:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (206, 61, '', '', 7, 1, NULL, '2022-03-26 10:30:13', '2022-03-26 10:30:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (207, 146, '', '', 3, 1, NULL, '2022-03-26 10:30:13', '2022-03-26 10:30:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (208, 62, '', '', 7, 1, NULL, '2022-03-26 12:02:00', '2022-03-26 12:02:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (209, 147, '', '', 3, 1, NULL, '2022-03-26 12:02:00', '2022-03-26 12:02:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (210, 63, '', '$2y$10$fieGBZMTKtrExWGu9X3eieM668jyzIILOF/LPsdNSrT.Ifa41M50e', 7, 1, NULL, '2022-03-26 12:08:36', '2022-03-26 12:08:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (211, 64, '', '', 7, 1, NULL, '2022-03-26 12:33:48', '2022-03-26 12:33:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (212, 65, '', '', 7, 1, NULL, '2022-03-26 12:45:00', '2022-03-26 12:45:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (213, 148, '', '', 3, 1, NULL, '2022-03-26 12:45:00', '2022-03-26 12:45:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (214, 66, '', '', 7, 1, NULL, '2022-03-26 13:00:15', '2022-03-26 13:00:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (215, 149, '', '', 3, 1, NULL, '2022-03-26 13:00:15', '2022-03-26 13:00:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (216, 67, '', '', 7, 1, NULL, '2022-03-26 13:07:18', '2022-03-26 13:07:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (217, 68, '', '', 7, 1, NULL, '2022-03-26 13:10:39', '2022-03-26 13:10:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (218, 69, '', '', 7, 1, NULL, '2022-03-26 14:13:01', '2022-03-26 14:13:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (219, 150, '', '', 3, 1, NULL, '2022-03-26 14:13:01', '2022-03-26 14:13:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (220, 70, '', '', 7, 1, NULL, '2022-03-26 14:21:10', '2022-03-26 14:21:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (221, 71, '', '', 7, 1, NULL, '2022-03-26 14:30:29', '2022-03-26 14:30:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (222, 151, '', '', 3, 1, NULL, '2022-03-26 14:30:29', '2022-03-26 14:30:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (223, 72, '', '', 7, 1, NULL, '2022-03-26 14:32:41', '2022-03-26 14:32:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (224, 73, '', '', 7, 1, NULL, '2022-03-26 14:36:51', '2022-03-26 14:36:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (225, 152, '', '', 3, 1, NULL, '2022-03-26 14:36:51', '2022-03-26 14:36:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (226, 74, '', '', 7, 1, NULL, '2022-03-26 15:20:08', '2022-03-26 15:20:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (227, 75, '', '', 7, 1, NULL, '2022-03-26 15:21:57', '2022-03-26 15:21:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (228, 76, '', '', 7, 1, NULL, '2022-03-26 15:23:57', '2022-03-26 15:23:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (229, 77, '', '', 7, 1, NULL, '2022-03-26 15:31:19', '2022-03-26 15:31:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (230, 78, '', '', 7, 1, NULL, '2022-03-26 15:43:49', '2022-03-26 15:43:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (231, 79, '', '', 7, 1, NULL, '2022-03-26 15:58:18', '2022-03-26 15:58:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (232, 80, '', '', 7, 1, NULL, '2022-03-26 16:00:25', '2022-03-26 16:00:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (233, 81, '', '', 7, 1, NULL, '2022-03-26 16:02:10', '2022-03-26 16:02:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (234, 82, '', '', 7, 1, NULL, '2022-03-26 16:03:17', '2022-03-26 16:03:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (235, 153, '', '', 3, 1, NULL, '2022-03-26 16:03:17', '2022-03-26 16:03:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (236, 83, '', '', 7, 1, NULL, '2022-03-26 16:15:52', '2022-03-26 16:15:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (237, 84, '', '', 7, 1, NULL, '2022-03-26 16:16:43', '2022-03-26 16:16:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (238, 85, '', '', 7, 1, NULL, '2022-03-26 16:20:56', '2022-03-26 16:20:56');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (239, 86, '', '', 7, 1, NULL, '2022-03-26 16:22:27', '2022-03-26 16:22:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (240, 87, '', '', 7, 1, NULL, '2022-03-26 16:23:47', '2022-03-26 16:23:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (241, 88, '', '', 7, 1, NULL, '2022-03-26 16:26:44', '2022-03-26 16:26:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (242, 154, '', '', 3, 1, NULL, '2022-03-26 16:26:44', '2022-03-26 16:26:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (243, 89, '', '', 7, 1, NULL, '2022-03-26 16:37:56', '2022-03-26 16:37:56');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (244, 90, '', '', 7, 1, NULL, '2022-03-26 16:41:38', '2022-03-26 16:41:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (245, 155, '', '', 3, 1, NULL, '2022-03-26 16:41:38', '2022-03-26 16:41:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (246, 91, '', '', 7, 1, NULL, '2022-03-26 16:52:03', '2022-03-26 16:52:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (247, 92, '', '', 7, 1, NULL, '2022-03-26 16:54:03', '2022-03-26 16:54:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (248, 93, '', '', 7, 1, NULL, '2022-03-26 16:56:51', '2022-03-26 16:56:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (249, 94, '', '', 7, 1, NULL, '2022-03-26 16:59:44', '2022-03-26 16:59:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (250, 95, '', '', 7, 1, NULL, '2022-03-26 17:00:57', '2022-03-26 17:00:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (251, 96, '', '', 7, 1, NULL, '2022-03-26 17:04:06', '2022-03-26 17:04:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (252, 97, '', '', 7, 1, NULL, '2022-03-26 17:07:03', '2022-03-26 17:07:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (253, 98, '', '', 7, 1, NULL, '2022-03-26 17:26:19', '2022-03-26 17:26:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (254, 156, '', '', 3, 1, NULL, '2022-03-26 17:26:19', '2022-03-26 17:26:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (255, 99, '', '', 7, 1, NULL, '2022-03-28 08:38:36', '2022-03-28 08:38:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (256, 100, '', '', 7, 1, NULL, '2022-03-28 08:50:39', '2022-03-28 08:50:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (257, 157, '', '', 3, 1, NULL, '2022-03-28 08:50:39', '2022-03-28 08:50:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (258, 101, '', '', 7, 1, NULL, '2022-03-28 09:28:51', '2022-03-28 09:28:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (259, 158, '', '', 3, 1, NULL, '2022-03-28 09:28:51', '2022-03-28 09:28:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (260, 102, '', '', 7, 1, NULL, '2022-03-28 09:50:18', '2022-03-28 09:50:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (261, 159, '', '', 3, 1, NULL, '2022-03-28 09:50:18', '2022-03-28 09:50:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (262, 103, '', '', 7, 1, NULL, '2022-03-28 10:33:25', '2022-03-28 10:33:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (263, 104, '', '', 7, 1, NULL, '2022-03-28 10:42:41', '2022-03-28 10:42:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (264, 160, '', '', 3, 1, NULL, '2022-03-28 10:42:41', '2022-03-28 10:42:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (265, 105, '', '', 7, 1, NULL, '2022-03-28 10:49:13', '2022-03-28 10:49:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (266, 161, '', '', 3, 1, NULL, '2022-03-28 10:49:13', '2022-03-28 10:49:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (267, 106, '', '', 7, 1, NULL, '2022-03-28 10:55:38', '2022-03-28 10:55:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (268, 107, '', '', 7, 1, NULL, '2022-03-28 11:00:55', '2022-03-28 11:00:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (269, 108, '', '', 7, 1, NULL, '2022-03-28 11:06:37', '2022-03-28 11:06:37');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (270, 162, '', '', 3, 1, NULL, '2022-03-28 11:06:37', '2022-03-28 11:06:37');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (271, 109, '', '', 7, 1, NULL, '2022-03-28 11:10:43', '2022-03-28 11:10:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (272, 110, '', '', 7, 1, NULL, '2022-03-28 11:14:02', '2022-03-28 11:14:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (273, 111, '', '', 7, 1, NULL, '2022-03-28 11:18:25', '2022-03-28 11:18:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (274, 112, '', '', 7, 1, NULL, '2022-03-28 11:22:38', '2022-03-28 11:22:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (275, 113, '', '', 7, 1, NULL, '2022-03-28 11:29:01', '2022-03-28 11:29:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (276, 163, '', '', 3, 1, NULL, '2022-03-28 11:29:01', '2022-03-28 11:29:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (277, 114, '', '', 7, 1, NULL, '2022-03-28 11:38:08', '2022-03-28 11:38:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (278, 115, '', '', 7, 1, NULL, '2022-03-28 11:57:00', '2022-03-28 11:57:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (279, 164, '', '', 3, 1, NULL, '2022-03-28 11:57:00', '2022-03-28 11:57:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (280, 116, '', '', 7, 1, NULL, '2022-03-28 12:01:40', '2022-03-28 12:01:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (281, 117, '', '', 7, 1, NULL, '2022-03-28 12:05:09', '2022-03-28 12:05:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (282, 118, '', '', 7, 1, NULL, '2022-03-28 12:10:07', '2022-03-28 12:10:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (283, 165, '', '', 3, 1, NULL, '2022-03-28 12:10:07', '2022-03-28 12:10:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (284, 119, '', '', 7, 1, NULL, '2022-03-28 12:22:18', '2022-03-28 12:22:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (285, 166, '', '', 3, 1, NULL, '2022-03-28 12:22:18', '2022-03-28 12:22:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (286, 120, '', '', 7, 1, NULL, '2022-03-28 12:36:34', '2022-03-28 12:36:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (287, 167, '', '', 3, 1, NULL, '2022-03-28 12:36:34', '2022-03-28 12:36:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (288, 121, '', '', 7, 1, NULL, '2022-03-28 12:40:01', '2022-03-28 12:40:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (290, 122, '', '', 7, 1, NULL, '2022-03-28 12:51:11', '2022-03-28 12:51:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (291, 169, '', '', 3, 1, NULL, '2022-03-28 12:51:11', '2022-03-28 12:51:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (292, 123, '', '', 7, 1, NULL, '2022-03-28 13:05:00', '2022-03-28 13:05:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (293, 170, '', '', 3, 1, NULL, '2022-03-28 13:05:00', '2022-03-28 13:05:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (294, 124, '', '', 7, 1, NULL, '2022-03-28 14:02:52', '2022-03-28 14:02:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (295, 125, '', '', 7, 1, NULL, '2022-03-28 14:10:19', '2022-03-28 14:10:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (296, 126, '', '', 7, 1, NULL, '2022-03-28 14:40:51', '2022-03-28 14:40:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (297, 171, '', '', 3, 1, NULL, '2022-03-28 14:40:51', '2022-03-28 14:40:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (298, 127, '', '', 7, 1, NULL, '2022-03-28 14:45:15', '2022-03-28 14:45:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (299, 128, '', '', 7, 1, NULL, '2022-03-28 14:51:19', '2022-03-28 14:51:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (300, 172, '', '', 3, 1, NULL, '2022-03-28 14:51:19', '2022-03-28 14:51:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (301, 129, '', '', 7, 1, NULL, '2022-03-28 15:10:25', '2022-03-28 15:10:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (302, 130, '', '', 7, 1, NULL, '2022-03-28 15:47:19', '2022-03-28 15:47:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (303, 131, '', '', 7, 1, NULL, '2022-03-28 16:39:39', '2022-03-28 16:39:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (304, 132, '', '', 7, 1, NULL, '2022-03-28 16:47:12', '2022-03-28 16:47:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (305, 173, '', '', 3, 1, NULL, '2022-03-28 16:47:12', '2022-03-28 16:47:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (306, 133, '', '', 7, 1, NULL, '2022-03-28 17:53:21', '2022-03-28 17:53:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (307, 134, '', '', 7, 1, NULL, '2022-03-28 18:00:23', '2022-03-28 18:00:23');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (308, 135, '', '', 7, 1, NULL, '2022-03-29 08:32:16', '2022-03-29 08:32:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (309, 174, '', '', 3, 1, NULL, '2022-03-29 08:32:16', '2022-03-29 08:32:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (310, 136, '', '', 7, 1, NULL, '2022-03-29 08:47:51', '2022-03-29 08:47:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (311, 175, '', '', 3, 1, NULL, '2022-03-29 08:47:51', '2022-03-29 08:47:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (312, 137, '', '', 7, 1, NULL, '2022-03-29 10:00:33', '2022-03-29 10:00:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (313, 138, '', '', 7, 1, NULL, '2022-03-29 10:09:58', '2022-03-29 10:09:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (314, 176, '', '', 3, 1, NULL, '2022-03-29 10:09:58', '2022-03-29 10:09:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (315, 139, '', '', 7, 1, NULL, '2022-03-29 10:32:23', '2022-03-29 10:32:23');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (316, 177, '', '', 3, 1, NULL, '2022-03-29 10:32:23', '2022-03-29 10:32:23');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (317, 140, '', '', 7, 1, NULL, '2022-03-29 10:48:03', '2022-03-29 10:48:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (318, 178, '', '', 3, 1, NULL, '2022-03-29 10:48:03', '2022-03-29 10:48:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (319, 141, '', '', 7, 1, NULL, '2022-04-01 09:10:52', '2022-04-01 09:10:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (320, 142, '', '', 7, 1, NULL, '2022-04-01 09:14:19', '2022-04-01 09:14:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (321, 143, '', '', 7, 1, NULL, '2022-04-01 09:17:06', '2022-04-01 09:17:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (322, 144, '', '', 7, 1, NULL, '2022-04-01 09:41:54', '2022-04-01 09:41:54');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (323, 145, '', '', 7, 1, NULL, '2022-04-01 09:48:52', '2022-04-01 09:48:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (324, 179, '', '', 3, 1, NULL, '2022-04-01 09:48:52', '2022-04-01 09:48:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (325, 146, '', '', 7, 1, NULL, '2022-04-01 09:55:25', '2022-04-01 09:55:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (326, 147, '', '', 7, 1, NULL, '2022-04-01 10:07:59', '2022-04-01 10:07:59');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (327, 148, '', '', 7, 1, NULL, '2022-04-01 10:13:03', '2022-04-01 10:13:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (328, 180, '', '', 3, 1, NULL, '2022-04-01 10:13:03', '2022-04-01 10:13:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (329, 149, '', '', 7, 1, NULL, '2022-04-01 10:15:14', '2022-04-01 10:15:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (330, 150, '', '', 7, 1, NULL, '2022-04-01 10:27:13', '2022-04-01 10:27:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (331, 151, '', '', 7, 1, NULL, '2022-04-01 10:35:31', '2022-04-01 10:35:31');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (332, 181, '', '', 3, 1, NULL, '2022-04-01 10:35:31', '2022-04-01 10:35:31');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (333, 152, '', '', 7, 1, NULL, '2022-04-01 10:38:18', '2022-04-01 10:38:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (334, 153, '', '', 7, 1, NULL, '2022-04-01 10:43:18', '2022-04-01 10:43:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (335, 154, '', '', 7, 1, NULL, '2022-04-01 10:50:09', '2022-04-01 10:50:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (336, 155, '', '', 7, 1, NULL, '2022-04-01 11:02:57', '2022-04-01 11:02:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (337, 156, '', '', 7, 1, NULL, '2022-04-01 11:07:45', '2022-04-01 11:07:45');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (339, 157, '', '', 7, 1, NULL, '2022-04-01 11:14:10', '2022-04-01 11:14:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (340, 183, '', '', 3, 1, NULL, '2022-04-01 11:14:10', '2022-04-01 11:14:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (341, 158, '', '', 7, 1, NULL, '2022-04-01 11:24:29', '2022-04-01 11:24:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (342, 159, '', '', 7, 1, NULL, '2022-04-01 11:28:35', '2022-04-01 11:28:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (343, 160, '', '', 7, 1, NULL, '2022-04-01 11:38:57', '2022-04-01 11:38:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (344, 184, '', '', 3, 1, NULL, '2022-04-01 11:38:57', '2022-04-01 11:38:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (345, 161, '', '', 7, 1, NULL, '2022-04-01 11:46:32', '2022-04-01 11:46:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (346, 185, '', '', 3, 1, NULL, '2022-04-01 11:46:32', '2022-04-01 11:46:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (347, 162, '', '', 7, 1, NULL, '2022-04-01 11:59:47', '2022-04-01 11:59:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (348, 186, '', '', 3, 1, NULL, '2022-04-01 11:59:47', '2022-04-01 11:59:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (349, 163, '', '', 7, 1, NULL, '2022-04-01 12:06:29', '2022-04-01 12:06:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (350, 187, '', '', 3, 1, NULL, '2022-04-01 12:06:29', '2022-04-01 12:06:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (351, 164, '', '', 7, 1, NULL, '2022-04-01 12:17:20', '2022-04-01 12:17:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (352, 165, '', '', 7, 1, NULL, '2022-04-01 12:21:46', '2022-04-01 12:21:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (353, 166, '', '', 7, 1, NULL, '2022-04-01 12:36:28', '2022-04-01 12:36:28');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (354, 167, '', '', 7, 1, NULL, '2022-04-01 12:41:02', '2022-04-01 12:41:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (355, 188, '', '', 3, 1, NULL, '2022-04-01 12:41:02', '2022-04-01 12:41:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (356, 168, '', '', 7, 1, NULL, '2022-04-01 12:45:02', '2022-04-01 12:45:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (357, 169, '', '', 7, 1, NULL, '2022-04-01 13:04:27', '2022-04-01 13:04:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (358, 189, '', '', 3, 1, NULL, '2022-04-01 13:04:27', '2022-04-01 13:04:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (359, 170, '', '', 7, 1, NULL, '2022-04-01 13:32:04', '2022-04-01 13:32:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (360, 190, '', '', 3, 1, NULL, '2022-04-01 13:32:04', '2022-04-01 13:32:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (361, 171, '', '', 7, 1, NULL, '2022-04-01 13:35:09', '2022-04-01 13:35:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (362, 191, '', '', 3, 1, NULL, '2022-04-01 13:35:09', '2022-04-01 13:35:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (363, 172, '', '', 7, 1, NULL, '2022-04-01 13:53:33', '2022-04-01 13:53:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (364, 192, '', '', 3, 1, NULL, '2022-04-01 13:53:33', '2022-04-01 13:53:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (365, 173, '', '', 7, 1, NULL, '2022-04-01 14:07:58', '2022-04-01 14:07:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (366, 174, '', '', 7, 1, NULL, '2022-04-01 14:53:47', '2022-04-01 14:53:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (367, 193, '', '', 3, 1, NULL, '2022-04-01 14:53:47', '2022-04-01 14:53:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (368, 175, '', '', 7, 1, NULL, '2022-04-01 15:05:55', '2022-04-01 15:05:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (369, 176, '', '', 7, 1, NULL, '2022-04-01 15:09:37', '2022-04-01 15:09:37');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (370, 194, '', '', 3, 1, NULL, '2022-04-01 15:09:37', '2022-04-01 15:09:37');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (371, 177, '', '', 7, 1, NULL, '2022-04-01 16:05:06', '2022-04-01 16:05:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (372, 195, '', '', 3, 1, NULL, '2022-04-01 16:05:06', '2022-04-01 16:05:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (373, 178, '', '', 7, 1, NULL, '2022-04-01 17:03:01', '2022-04-01 17:03:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (374, 196, '', '', 3, 1, NULL, '2022-04-01 17:03:01', '2022-04-01 17:03:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (375, 179, '', '', 7, 1, NULL, '2022-04-01 17:22:05', '2022-04-01 17:22:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (376, 180, '', '', 7, 1, NULL, '2022-04-01 17:25:16', '2022-04-01 17:25:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (377, 181, '', '', 7, 1, NULL, '2022-04-01 17:50:04', '2022-04-01 17:50:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (378, 182, '', '', 7, 1, NULL, '2022-04-01 18:10:04', '2022-04-01 18:10:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (379, 183, '', '', 7, 1, NULL, '2022-04-02 09:03:36', '2022-04-02 09:03:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (380, 184, '', '', 7, 1, NULL, '2022-04-02 09:11:13', '2022-04-02 09:11:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (381, 197, '', '', 3, 1, NULL, '2022-04-02 09:11:13', '2022-04-02 09:11:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (382, 185, '', '', 7, 1, NULL, '2022-04-02 09:21:02', '2022-04-02 09:21:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (383, 186, '', '', 7, 1, NULL, '2022-04-02 09:30:07', '2022-04-02 09:30:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (384, 187, '', '', 7, 1, NULL, '2022-04-02 09:40:16', '2022-04-02 09:40:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (385, 198, '', '', 3, 1, NULL, '2022-04-02 09:40:16', '2022-04-02 09:40:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (386, 188, '', '', 7, 1, NULL, '2022-04-02 09:56:42', '2022-04-02 09:56:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (387, 199, '', '', 3, 1, NULL, '2022-04-02 09:56:42', '2022-04-02 09:56:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (388, 189, '', '', 7, 1, NULL, '2022-04-02 10:17:48', '2022-04-02 10:17:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (389, 190, '', '', 7, 1, NULL, '2022-04-02 10:31:18', '2022-04-02 10:31:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (390, 200, '', '', 3, 1, NULL, '2022-04-02 10:31:18', '2022-04-02 10:31:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (391, 191, '', '', 7, 1, NULL, '2022-04-02 10:36:02', '2022-04-02 10:36:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (392, 201, '', '', 3, 1, NULL, '2022-04-02 10:36:02', '2022-04-02 10:36:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (393, 192, '', '', 7, 1, NULL, '2022-04-02 10:48:36', '2022-04-02 10:48:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (394, 193, '', '', 7, 1, NULL, '2022-04-02 10:53:52', '2022-04-02 10:53:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (395, 202, '', '', 3, 1, NULL, '2022-04-02 10:53:52', '2022-04-02 10:53:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (396, 194, '', '', 7, 1, NULL, '2022-04-02 11:00:50', '2022-04-02 11:00:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (397, 195, '', '', 7, 1, NULL, '2022-04-02 11:06:46', '2022-04-02 11:06:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (398, 203, '', '', 3, 1, NULL, '2022-04-02 11:06:46', '2022-04-02 11:06:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (399, 196, '', '', 7, 1, NULL, '2022-04-02 11:12:09', '2022-04-02 11:12:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (400, 204, '', '', 3, 1, NULL, '2022-04-02 11:12:09', '2022-04-02 11:12:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (401, 197, '', '', 7, 1, NULL, '2022-04-02 11:15:37', '2022-04-02 11:15:37');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (402, 198, '', '', 7, 1, NULL, '2022-04-02 11:28:05', '2022-04-02 11:28:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (403, 199, '', '', 7, 1, NULL, '2022-04-02 11:30:43', '2022-04-02 11:30:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (404, 200, '', '', 7, 1, NULL, '2022-04-02 11:35:04', '2022-04-02 11:35:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (405, 205, '', '', 3, 1, NULL, '2022-04-02 11:35:04', '2022-04-02 11:35:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (406, 201, '', '', 7, 1, NULL, '2022-04-02 11:38:41', '2022-04-02 11:38:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (407, 206, '', '', 3, 1, NULL, '2022-04-02 11:38:41', '2022-04-02 11:38:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (408, 202, '', '', 7, 1, NULL, '2022-04-02 12:06:22', '2022-04-02 12:06:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (409, 207, '', '', 3, 1, NULL, '2022-04-02 12:06:22', '2022-04-02 12:06:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (410, 203, '', '', 7, 1, NULL, '2022-04-02 12:09:15', '2022-04-02 12:09:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (411, 204, '', '', 7, 1, NULL, '2022-04-02 12:17:16', '2022-04-02 12:17:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (412, 205, '', '', 7, 1, NULL, '2022-04-02 12:37:16', '2022-04-02 12:37:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (413, 206, '', '', 7, 1, NULL, '2022-04-02 12:39:53', '2022-04-02 12:39:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (414, 207, '', '', 7, 1, NULL, '2022-04-02 12:50:04', '2022-04-02 12:50:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (415, 208, '', '', 7, 1, NULL, '2022-04-02 13:48:12', '2022-04-02 13:48:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (416, 208, '', '', 3, 1, NULL, '2022-04-02 13:48:12', '2022-04-02 13:48:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (417, 209, '', '', 7, 1, NULL, '2022-04-02 13:53:18', '2022-04-02 13:53:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (418, 210, '', '', 7, 1, NULL, '2022-04-02 13:58:07', '2022-04-02 13:58:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (419, 209, '', '', 3, 1, NULL, '2022-04-02 13:58:07', '2022-04-02 13:58:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (420, 211, '', '', 7, 1, NULL, '2022-04-02 14:13:52', '2022-04-02 14:13:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (421, 210, '', '', 3, 1, NULL, '2022-04-02 14:13:52', '2022-04-02 14:13:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (422, 212, '', '', 7, 1, NULL, '2022-04-02 14:17:42', '2022-04-02 14:17:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (423, 211, '', '', 3, 1, NULL, '2022-04-02 14:17:42', '2022-04-02 14:17:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (424, 213, '', '', 7, 1, NULL, '2022-04-02 14:30:32', '2022-04-02 14:30:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (425, 214, '', '', 7, 1, NULL, '2022-04-02 14:34:51', '2022-04-02 14:34:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (426, 212, '', '', 3, 1, NULL, '2022-04-02 14:34:51', '2022-04-02 14:34:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (427, 215, '', '', 7, 1, NULL, '2022-04-02 14:37:51', '2022-04-02 14:37:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (428, 216, '', '', 7, 1, NULL, '2022-04-02 14:42:36', '2022-04-02 14:42:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (429, 213, '', '', 3, 1, NULL, '2022-04-02 14:42:36', '2022-04-02 14:42:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (430, 217, '', '', 7, 1, NULL, '2022-04-02 14:52:35', '2022-04-02 14:52:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (431, 218, '', '', 7, 1, NULL, '2022-04-02 14:55:28', '2022-04-02 14:55:28');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (432, 214, '', '', 3, 1, NULL, '2022-04-02 14:55:28', '2022-04-02 14:55:28');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (433, 219, '', '', 7, 1, NULL, '2022-04-02 15:06:13', '2022-04-02 15:06:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (434, 215, '', '', 3, 1, NULL, '2022-04-02 15:06:13', '2022-04-02 15:06:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (435, 220, '', '', 7, 1, NULL, '2022-04-02 15:11:22', '2022-04-02 15:11:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (436, 221, '', '', 7, 1, NULL, '2022-04-02 15:16:38', '2022-04-02 15:16:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (437, 216, '', '', 3, 1, NULL, '2022-04-02 15:16:38', '2022-04-02 15:16:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (438, 222, '', '', 7, 1, NULL, '2022-04-02 15:23:21', '2022-04-02 15:23:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (439, 217, '', '', 3, 1, NULL, '2022-04-02 15:23:21', '2022-04-02 15:23:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (440, 223, '', '', 7, 1, NULL, '2022-04-02 15:29:28', '2022-04-02 15:29:28');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (441, 218, '', '', 3, 1, NULL, '2022-04-02 15:29:28', '2022-04-02 15:29:28');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (442, 224, '', '', 7, 1, NULL, '2022-04-02 16:03:20', '2022-04-02 16:03:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (443, 219, '', '', 3, 1, NULL, '2022-04-02 16:03:20', '2022-04-02 16:03:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (444, 225, '', '', 7, 1, NULL, '2022-04-02 16:28:12', '2022-04-02 16:28:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (445, 226, '', '', 7, 1, NULL, '2022-04-02 16:57:43', '2022-04-02 16:57:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (446, 227, '', '', 7, 1, NULL, '2022-04-02 17:18:11', '2022-04-02 17:18:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (447, 220, '', '', 3, 1, NULL, '2022-04-02 17:18:11', '2022-04-02 17:18:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (448, 228, '', '', 7, 1, NULL, '2022-04-02 18:09:54', '2022-04-02 18:09:54');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (449, 229, '', '', 7, 1, NULL, '2022-04-02 18:26:18', '2022-04-02 18:26:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (450, 221, '', '', 3, 1, NULL, '2022-04-02 18:26:18', '2022-04-02 18:26:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (451, 230, '', '', 7, 1, NULL, '2022-04-04 08:49:55', '2022-04-04 08:49:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (452, 231, '', '', 7, 1, NULL, '2022-04-04 08:54:33', '2022-04-04 08:54:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (453, 232, '', '', 7, 1, NULL, '2022-04-04 09:03:23', '2022-04-04 09:03:23');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (454, 233, '', '', 7, 1, NULL, '2022-04-04 09:14:08', '2022-04-04 09:14:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (455, 234, '', '', 7, 1, NULL, '2022-04-04 09:29:35', '2022-04-04 09:29:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (456, 235, '', '', 7, 1, NULL, '2022-04-04 09:47:01', '2022-04-04 09:47:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (457, 236, '', '', 7, 1, NULL, '2022-04-04 09:51:51', '2022-04-04 09:51:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (458, 222, '', '', 3, 1, NULL, '2022-04-04 09:51:51', '2022-04-04 09:51:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (459, 237, '', '', 7, 1, NULL, '2022-04-04 09:54:06', '2022-04-04 09:54:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (460, 238, '', '', 7, 1, NULL, '2022-04-04 10:17:26', '2022-04-04 10:17:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (461, 239, '', '', 7, 1, NULL, '2022-04-04 10:41:43', '2022-04-04 10:41:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (462, 223, '', '', 3, 1, NULL, '2022-04-04 10:41:43', '2022-04-04 10:41:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (463, 240, '', '', 7, 1, NULL, '2022-04-04 10:46:22', '2022-04-04 10:46:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (464, 224, '', '', 3, 1, NULL, '2022-04-04 10:46:22', '2022-04-04 10:46:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (465, 241, '', '', 7, 1, NULL, '2022-04-04 11:08:09', '2022-04-04 11:08:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (466, 242, '', '', 7, 1, NULL, '2022-04-04 11:14:35', '2022-04-04 11:14:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (467, 225, '', '', 3, 1, NULL, '2022-04-04 11:14:35', '2022-04-04 11:14:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (468, 243, '', '', 7, 1, NULL, '2022-04-04 11:19:20', '2022-04-04 11:19:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (469, 226, '', '', 3, 1, NULL, '2022-04-04 11:19:20', '2022-04-04 11:19:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (470, 244, '', '', 7, 1, NULL, '2022-04-04 11:21:20', '2022-04-04 11:21:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (471, 245, '', '', 7, 1, NULL, '2022-04-04 11:26:53', '2022-04-04 11:26:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (472, 246, '', '', 7, 1, NULL, '2022-04-04 11:29:05', '2022-04-04 11:29:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (473, 247, '', '', 7, 1, NULL, '2022-04-04 11:32:50', '2022-04-04 11:32:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (474, 227, '', '', 3, 1, NULL, '2022-04-04 11:32:50', '2022-04-04 11:32:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (475, 248, '', '', 7, 1, NULL, '2022-04-04 11:38:09', '2022-04-04 11:38:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (476, 249, '', '', 7, 1, NULL, '2022-04-04 11:45:27', '2022-04-04 11:45:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (477, 228, '', '', 3, 1, NULL, '2022-04-04 11:45:27', '2022-04-04 11:45:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (478, 250, '', '', 7, 1, NULL, '2022-04-04 11:52:20', '2022-04-04 11:52:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (479, 229, '', '', 3, 1, NULL, '2022-04-04 11:52:20', '2022-04-04 11:52:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (480, 251, '', '', 7, 1, NULL, '2022-04-04 11:55:18', '2022-04-04 11:55:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (481, 252, '', '', 7, 1, NULL, '2022-04-04 12:00:09', '2022-04-04 12:00:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (482, 230, '', '', 3, 1, NULL, '2022-04-04 12:00:09', '2022-04-04 12:00:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (483, 253, '', '', 7, 1, NULL, '2022-04-04 12:09:22', '2022-04-04 12:09:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (484, 231, '', '', 3, 1, NULL, '2022-04-04 12:09:22', '2022-04-04 12:09:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (485, 254, '', '', 7, 1, NULL, '2022-04-04 12:15:15', '2022-04-04 12:15:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (486, 255, '', '', 7, 1, NULL, '2022-04-04 12:25:08', '2022-04-04 12:25:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (487, 256, '', '', 7, 1, NULL, '2022-04-04 12:42:48', '2022-04-04 12:42:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (488, 232, '', '', 3, 1, NULL, '2022-04-04 12:42:48', '2022-04-04 12:42:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (489, 257, '', '', 7, 1, NULL, '2022-04-04 13:28:50', '2022-04-04 13:28:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (490, 233, '', '', 3, 1, NULL, '2022-04-04 13:28:50', '2022-04-04 13:28:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (491, 258, '', '', 7, 1, NULL, '2022-04-04 13:33:53', '2022-04-04 13:33:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (492, 234, '', '', 3, 1, NULL, '2022-04-04 13:33:53', '2022-04-04 13:33:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (493, 259, '', '', 7, 1, NULL, '2022-04-04 13:59:29', '2022-04-04 13:59:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (494, 260, '', '', 7, 1, NULL, '2022-04-04 14:03:29', '2022-04-04 14:03:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (495, 261, '', '', 7, 1, NULL, '2022-04-04 14:14:36', '2022-04-04 14:14:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (496, 262, '', '', 7, 1, NULL, '2022-04-04 14:19:29', '2022-04-04 14:19:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (497, 263, '', '', 7, 1, NULL, '2022-04-04 14:51:48', '2022-04-04 14:51:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (498, 264, '', '', 7, 1, NULL, '2022-04-04 15:11:41', '2022-04-04 15:11:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (499, 235, '', '', 3, 1, NULL, '2022-04-04 15:11:41', '2022-04-04 15:11:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (500, 265, '', '', 7, 1, NULL, '2022-04-04 15:16:25', '2022-04-04 15:16:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (501, 266, '', '', 7, 1, NULL, '2022-04-04 15:25:51', '2022-04-04 15:25:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (502, 236, '', '', 3, 1, NULL, '2022-04-04 15:25:51', '2022-04-04 15:25:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (503, 267, '', '', 7, 1, NULL, '2022-04-04 15:30:59', '2022-04-04 15:30:59');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (504, 237, '', '', 3, 1, NULL, '2022-04-04 15:30:59', '2022-04-04 15:30:59');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (505, 268, '', '', 7, 1, NULL, '2022-04-04 15:35:46', '2022-04-04 15:35:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (506, 238, '', '', 3, 1, NULL, '2022-04-04 15:35:46', '2022-04-04 15:35:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (507, 269, '', '', 7, 1, NULL, '2022-04-04 15:40:33', '2022-04-04 15:40:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (508, 239, '', '', 3, 1, NULL, '2022-04-04 15:40:33', '2022-04-04 15:40:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (509, 270, '', '', 7, 1, NULL, '2022-04-04 16:16:49', '2022-04-04 16:16:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (510, 271, '', '', 7, 1, NULL, '2022-04-04 16:19:27', '2022-04-04 16:19:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (511, 272, '', '', 7, 1, NULL, '2022-04-04 16:21:29', '2022-04-04 16:21:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (512, 273, '', '', 7, 1, NULL, '2022-04-04 16:24:20', '2022-04-04 16:24:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (513, 274, '', '', 7, 1, NULL, '2022-04-04 16:26:43', '2022-04-04 16:26:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (514, 275, '', '', 7, 1, NULL, '2022-04-04 16:28:50', '2022-04-04 16:28:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (515, 276, '', '', 7, 1, NULL, '2022-04-04 16:33:24', '2022-04-04 16:33:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (516, 277, '', '', 7, 1, NULL, '2022-04-04 16:36:49', '2022-04-04 16:36:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (517, 278, '', '', 7, 1, NULL, '2022-04-04 16:43:44', '2022-04-04 16:43:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (518, 240, '', '', 3, 1, NULL, '2022-04-04 16:43:44', '2022-04-04 16:43:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (519, 279, '', '', 7, 1, NULL, '2022-04-04 16:53:04', '2022-04-04 16:53:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (520, 280, '', '', 7, 1, NULL, '2022-04-04 17:06:25', '2022-04-04 17:06:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (521, 241, '', '', 3, 1, NULL, '2022-04-04 17:06:25', '2022-04-04 17:06:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (522, 281, '', '', 7, 1, NULL, '2022-04-05 08:22:09', '2022-04-05 08:22:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (523, 242, '', '', 3, 1, NULL, '2022-04-05 08:22:09', '2022-04-05 08:22:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (524, 282, '', '', 7, 1, NULL, '2022-04-05 08:48:02', '2022-04-05 08:48:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (525, 243, '', '', 3, 1, NULL, '2022-04-05 08:48:02', '2022-04-05 08:48:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (526, 283, '', '', 7, 1, NULL, '2022-04-05 08:57:25', '2022-04-05 08:57:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (527, 284, '', '', 7, 1, NULL, '2022-04-05 09:23:40', '2022-04-05 09:23:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (528, 285, '', '', 7, 1, NULL, '2022-04-05 09:40:25', '2022-04-05 09:40:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (529, 286, '', '', 7, 1, NULL, '2022-04-05 09:48:59', '2022-04-05 09:48:59');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (530, 287, '', '', 7, 1, NULL, '2022-04-05 10:01:26', '2022-04-05 10:01:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (531, 244, '', '', 3, 1, NULL, '2022-04-05 10:01:26', '2022-04-05 10:01:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (532, 288, '', '', 7, 1, NULL, '2022-04-05 10:08:52', '2022-04-05 10:08:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (533, 245, '', '', 3, 1, NULL, '2022-04-05 10:08:52', '2022-04-05 10:08:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (534, 289, '', '', 7, 1, NULL, '2022-04-05 10:14:41', '2022-04-05 10:14:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (535, 246, '', '', 3, 1, NULL, '2022-04-05 10:14:41', '2022-04-05 10:14:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (536, 290, '', '', 7, 1, NULL, '2022-04-05 10:18:56', '2022-04-05 10:18:56');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (537, 247, '', '', 3, 1, NULL, '2022-04-05 10:18:56', '2022-04-05 10:18:56');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (538, 291, '', '', 7, 1, NULL, '2022-04-05 10:39:58', '2022-04-05 10:39:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (539, 292, '', '', 7, 1, NULL, '2022-04-05 10:46:16', '2022-04-05 10:46:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (540, 293, '', '', 7, 1, NULL, '2022-04-05 11:12:42', '2022-04-05 11:12:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (541, 294, '', '', 7, 1, NULL, '2022-04-05 11:15:47', '2022-04-05 11:15:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (542, 248, '', '', 3, 1, NULL, '2022-04-05 11:15:47', '2022-04-05 11:15:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (543, 295, '', '', 7, 1, NULL, '2022-04-05 11:30:11', '2022-04-05 11:30:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (544, 296, '', '', 7, 1, NULL, '2022-04-05 11:33:01', '2022-04-05 11:33:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (545, 297, '', '', 7, 1, NULL, '2022-04-05 12:24:23', '2022-04-05 12:24:23');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (546, 298, '', '', 7, 1, NULL, '2022-04-05 12:28:14', '2022-04-05 12:28:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (547, 249, '', '', 3, 1, NULL, '2022-04-05 12:28:14', '2022-04-05 12:28:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (548, 299, '', '', 7, 1, NULL, '2022-04-05 12:33:33', '2022-04-05 12:33:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (549, 300, '', '', 7, 1, NULL, '2022-04-05 12:58:30', '2022-04-05 12:58:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (550, 301, '', '', 7, 1, NULL, '2022-04-05 13:06:35', '2022-04-05 13:06:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (551, 250, '', '', 3, 1, NULL, '2022-04-05 13:06:35', '2022-04-05 13:06:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (552, 302, '', '', 7, 1, NULL, '2022-04-05 13:49:38', '2022-04-05 13:49:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (553, 303, '', '', 7, 1, NULL, '2022-04-05 14:23:29', '2022-04-05 14:23:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (554, 251, '', '', 3, 1, NULL, '2022-04-05 14:23:29', '2022-04-05 14:23:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (555, 304, '', '', 7, 1, NULL, '2022-04-05 14:34:44', '2022-04-05 14:34:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (556, 305, '', '', 7, 1, NULL, '2022-04-05 14:47:29', '2022-04-05 14:47:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (557, 252, '', '', 3, 1, NULL, '2022-04-05 14:47:29', '2022-04-05 14:47:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (558, 306, '', '', 7, 1, NULL, '2022-04-05 16:17:19', '2022-04-05 16:17:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (559, 307, '', '', 7, 1, NULL, '2022-04-05 17:27:34', '2022-04-05 17:27:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (560, 308, '', '', 7, 1, NULL, '2022-04-05 18:03:45', '2022-04-05 18:03:45');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (561, 309, '', '', 7, 1, NULL, '2022-04-05 18:10:46', '2022-04-05 18:10:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (562, 253, '', '', 3, 1, NULL, '2022-04-05 18:10:46', '2022-04-05 18:10:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (563, 310, '', '', 7, 1, NULL, '2022-04-05 18:49:32', '2022-04-05 18:49:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (564, 311, '', '', 7, 1, NULL, '2022-04-05 18:52:38', '2022-04-05 18:52:38');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (565, 312, '', '', 7, 1, NULL, '2022-04-05 19:03:48', '2022-04-05 19:03:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (566, 313, '', '', 7, 1, NULL, '2022-04-05 19:19:56', '2022-04-05 19:19:56');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (567, 254, '', '', 3, 1, NULL, '2022-04-05 19:19:56', '2022-04-05 19:19:56');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (568, 314, '', '', 7, 1, NULL, '2022-04-06 08:27:19', '2022-04-06 08:27:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (569, 255, '', '', 3, 1, NULL, '2022-04-06 08:27:19', '2022-04-06 08:27:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (570, 315, '', '', 7, 1, NULL, '2022-04-06 08:47:05', '2022-04-06 08:47:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (571, 256, '', '', 3, 1, NULL, '2022-04-06 08:47:05', '2022-04-06 08:47:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (572, 316, '', '', 7, 1, NULL, '2022-04-06 08:51:34', '2022-04-06 08:51:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (573, 317, '', '', 7, 1, NULL, '2022-04-06 08:57:42', '2022-04-06 08:57:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (574, 318, '', '', 7, 1, NULL, '2022-04-06 09:12:59', '2022-04-06 09:12:59');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (575, 319, '', '', 7, 1, NULL, '2022-04-06 09:17:36', '2022-04-06 09:17:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (576, 257, '', '', 3, 1, NULL, '2022-04-06 09:17:36', '2022-04-06 09:17:36');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (577, 320, '', '', 7, 1, NULL, '2022-04-06 09:28:30', '2022-04-06 09:28:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (578, 321, '', '', 7, 1, NULL, '2022-04-06 09:45:18', '2022-04-06 09:45:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (579, 258, '', '', 3, 1, NULL, '2022-04-06 09:45:18', '2022-04-06 09:45:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (580, 322, '', '', 7, 1, NULL, '2022-04-06 09:47:25', '2022-04-06 09:47:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (581, 323, '', '', 7, 1, NULL, '2022-04-06 09:58:29', '2022-04-06 09:58:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (582, 324, '', '', 7, 1, NULL, '2022-04-06 10:03:15', '2022-04-06 10:03:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (583, 325, '', '', 7, 1, NULL, '2022-04-06 10:08:02', '2022-04-06 10:08:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (584, 259, '', '', 3, 1, NULL, '2022-04-06 10:08:02', '2022-04-06 10:08:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (585, 326, '', '', 7, 1, NULL, '2022-04-06 10:11:58', '2022-04-06 10:11:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (586, 327, '', '', 7, 1, NULL, '2022-04-06 10:23:01', '2022-04-06 10:23:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (587, 328, '', '', 7, 1, NULL, '2022-04-06 10:33:22', '2022-04-06 10:33:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (588, 260, '', '', 3, 1, NULL, '2022-04-06 10:33:22', '2022-04-06 10:33:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (589, 329, '', '', 7, 1, NULL, '2022-04-06 10:38:14', '2022-04-06 10:38:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (590, 330, '', '', 7, 1, NULL, '2022-04-06 10:47:35', '2022-04-06 10:47:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (591, 331, '', '', 7, 1, NULL, '2022-04-06 10:56:06', '2022-04-06 10:56:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (592, 261, '', '', 3, 1, NULL, '2022-04-06 10:56:06', '2022-04-06 10:56:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (593, 332, '', '', 7, 1, NULL, '2022-04-06 11:06:18', '2022-04-06 11:06:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (594, 333, '', '', 7, 1, NULL, '2022-04-06 11:29:11', '2022-04-06 11:29:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (595, 262, '', '', 3, 1, NULL, '2022-04-06 11:29:11', '2022-04-06 11:29:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (596, 334, '', '', 7, 1, NULL, '2022-04-06 11:31:29', '2022-04-06 11:31:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (597, 335, '', '', 7, 1, NULL, '2022-04-06 11:42:00', '2022-04-06 11:42:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (598, 263, '', '', 3, 1, NULL, '2022-04-06 11:42:00', '2022-04-06 11:42:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (599, 336, '', '', 7, 1, NULL, '2022-04-06 12:30:20', '2022-04-06 12:30:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (600, 264, '', '', 3, 1, NULL, '2022-04-06 12:30:20', '2022-04-06 12:30:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (601, 337, '', '', 7, 1, NULL, '2022-04-06 12:32:25', '2022-04-06 12:32:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (602, 338, '', '', 7, 1, NULL, '2022-04-06 12:37:50', '2022-04-06 12:37:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (603, 265, '', '', 3, 1, NULL, '2022-04-06 12:37:50', '2022-04-06 12:37:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (604, 339, '', '', 7, 1, NULL, '2022-04-06 12:41:13', '2022-04-06 12:41:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (605, 340, '', '', 7, 1, NULL, '2022-04-06 12:41:51', '2022-04-06 12:41:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (606, 341, '', '', 7, 1, NULL, '2022-04-06 12:43:33', '2022-04-06 12:43:33');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (607, 342, '', '', 7, 1, NULL, '2022-04-06 12:46:24', '2022-04-06 12:46:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (608, 343, '', '', 7, 1, NULL, '2022-04-06 12:54:48', '2022-04-06 12:54:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (609, 344, '', '', 7, 1, NULL, '2022-04-06 13:05:43', '2022-04-06 13:05:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (610, 266, '', '', 3, 1, NULL, '2022-04-06 13:05:43', '2022-04-06 13:05:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (611, 345, '', '', 7, 1, NULL, '2022-04-06 13:35:58', '2022-04-06 13:35:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (612, 346, '', '', 7, 1, NULL, '2022-04-06 14:04:05', '2022-04-06 14:04:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (613, 347, '', '', 7, 1, NULL, '2022-04-06 14:44:13', '2022-04-06 14:44:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (614, 348, '', '', 7, 1, NULL, '2022-04-06 14:49:44', '2022-04-06 14:49:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (615, 267, '', '', 3, 1, NULL, '2022-04-06 14:49:44', '2022-04-06 14:49:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (616, 349, '', '', 7, 1, NULL, '2022-04-06 14:53:09', '2022-04-06 14:53:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (617, 268, '', '', 3, 1, NULL, '2022-04-06 14:53:09', '2022-04-06 14:53:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (618, 350, '', '', 7, 1, NULL, '2022-04-06 15:00:48', '2022-04-06 15:00:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (619, 351, '', '', 7, 1, NULL, '2022-04-06 15:14:08', '2022-04-06 15:14:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (620, 352, '', '', 7, 1, NULL, '2022-04-06 15:16:19', '2022-04-06 15:16:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (621, 353, '', '', 7, 1, NULL, '2022-04-06 15:18:49', '2022-04-06 15:18:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (622, 354, '', '', 7, 1, NULL, '2022-04-06 15:21:49', '2022-04-06 15:21:49');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (623, 355, '', '', 7, 1, NULL, '2022-04-06 15:43:00', '2022-04-06 15:43:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (624, 356, '', '', 7, 1, NULL, '2022-04-06 15:46:40', '2022-04-06 15:46:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (625, 269, '', '', 3, 1, NULL, '2022-04-06 15:46:40', '2022-04-06 15:46:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (626, 357, '', '', 7, 1, NULL, '2022-04-06 16:07:19', '2022-04-06 16:07:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (627, 270, '', '', 3, 1, NULL, '2022-04-06 16:07:19', '2022-04-06 16:07:19');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (628, 358, '', '', 7, 1, NULL, '2022-04-06 16:21:20', '2022-04-06 16:21:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (629, 359, '', '', 7, 1, NULL, '2022-04-06 17:01:10', '2022-04-06 17:01:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (630, 360, '', '', 7, 1, NULL, '2022-04-06 17:10:39', '2022-04-06 17:10:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (631, 361, '', '', 7, 1, NULL, '2022-04-06 17:23:27', '2022-04-06 17:23:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (632, 271, '', '', 3, 1, NULL, '2022-04-06 17:23:27', '2022-04-06 17:23:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (633, 362, '', '', 7, 1, NULL, '2022-04-06 17:41:20', '2022-04-06 17:41:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (634, 363, '', '', 7, 1, NULL, '2022-04-06 18:20:29', '2022-04-06 18:20:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (635, 364, '', '', 7, 1, NULL, '2022-04-07 09:04:04', '2022-04-07 09:04:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (636, 272, '', '', 3, 1, NULL, '2022-04-07 09:04:04', '2022-04-07 09:04:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (637, 365, '', '', 7, 1, NULL, '2022-04-07 09:26:48', '2022-04-07 09:26:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (638, 366, '', '', 7, 1, NULL, '2022-04-07 09:30:28', '2022-04-07 09:30:28');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (639, 367, '', '', 7, 1, NULL, '2022-04-07 09:45:34', '2022-04-07 09:45:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (640, 273, '', '', 3, 1, NULL, '2022-04-07 09:45:34', '2022-04-07 09:45:34');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (641, 368, '', '', 7, 1, NULL, '2022-04-07 09:48:41', '2022-04-07 09:48:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (642, 369, '', '', 7, 1, NULL, '2022-04-07 09:55:35', '2022-04-07 09:55:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (643, 370, '', '', 7, 1, NULL, '2022-04-07 10:00:05', '2022-04-07 10:00:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (644, 274, '', '', 3, 1, NULL, '2022-04-07 10:00:05', '2022-04-07 10:00:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (645, 371, '', '', 7, 1, NULL, '2022-04-07 10:09:32', '2022-04-07 10:09:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (646, 275, '', '', 3, 1, NULL, '2022-04-07 10:09:32', '2022-04-07 10:09:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (647, 372, '', '', 7, 1, NULL, '2022-04-07 10:18:05', '2022-04-07 10:18:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (648, 373, '', '', 7, 1, NULL, '2022-04-07 10:20:44', '2022-04-07 10:20:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (649, 276, '', '', 3, 1, NULL, '2022-04-07 10:20:44', '2022-04-07 10:20:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (650, 374, '', '', 7, 1, NULL, '2022-04-07 10:22:50', '2022-04-07 10:22:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (651, 277, '', '', 3, 1, NULL, '2022-04-07 10:22:50', '2022-04-07 10:22:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (652, 375, '', '', 7, 1, NULL, '2022-04-07 10:28:31', '2022-04-07 10:28:31');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (653, 376, '', '', 7, 1, NULL, '2022-04-07 10:53:54', '2022-04-07 10:53:54');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (654, 377, '', '', 7, 1, NULL, '2022-04-07 11:01:04', '2022-04-07 11:01:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (655, 378, '', '', 7, 1, NULL, '2022-04-07 11:06:01', '2022-04-07 11:06:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (656, 379, '', '', 7, 1, NULL, '2022-04-07 11:09:52', '2022-04-07 11:09:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (657, 380, '', '', 7, 1, NULL, '2022-04-07 11:12:27', '2022-04-07 11:12:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (658, 381, '', '', 7, 1, NULL, '2022-04-07 11:23:07', '2022-04-07 11:23:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (659, 382, '', '', 7, 1, NULL, '2022-04-07 11:26:26', '2022-04-07 11:26:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (660, 383, '', '', 7, 1, NULL, '2022-04-07 11:43:07', '2022-04-07 11:43:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (661, 384, '', '', 7, 1, NULL, '2022-04-07 11:45:46', '2022-04-07 11:45:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (662, 385, '', '', 7, 1, NULL, '2022-04-07 12:26:54', '2022-04-07 12:26:54');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (663, 386, '', '', 7, 1, NULL, '2022-04-07 13:29:44', '2022-04-07 13:29:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (664, 387, '', '', 7, 1, NULL, '2022-04-07 13:36:18', '2022-04-07 13:36:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (665, 388, '', '', 7, 1, NULL, '2022-04-07 13:42:48', '2022-04-07 13:42:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (666, 389, '', '', 7, 1, NULL, '2022-04-07 13:44:08', '2022-04-07 13:44:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (667, 390, '', '', 7, 1, NULL, '2022-04-07 13:45:15', '2022-04-07 13:45:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (668, 278, '', '', 3, 1, NULL, '2022-04-07 13:45:15', '2022-04-07 13:45:15');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (669, 391, '', '', 7, 1, NULL, '2022-04-07 13:50:39', '2022-04-07 13:50:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (670, 279, '', '', 3, 1, NULL, '2022-04-07 13:50:39', '2022-04-07 13:50:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (671, 392, '', '', 7, 1, NULL, '2022-04-07 14:10:29', '2022-04-07 14:10:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (672, 393, '', '', 7, 1, NULL, '2022-04-07 15:04:44', '2022-04-07 15:04:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (673, 394, '', '', 7, 1, NULL, '2022-04-07 15:22:30', '2022-04-07 15:22:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (674, 395, '', '', 7, 1, NULL, '2022-04-07 15:57:12', '2022-04-07 15:57:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (675, 280, '', '', 3, 1, NULL, '2022-04-07 15:57:12', '2022-04-07 15:57:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (676, 396, '', '', 7, 1, NULL, '2022-04-07 16:02:55', '2022-04-07 16:02:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (677, 397, '', '', 7, 1, NULL, '2022-04-07 16:55:25', '2022-04-07 16:55:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (678, 398, '', '', 7, 1, NULL, '2022-04-07 17:05:05', '2022-04-07 17:05:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (679, 281, '', '', 3, 1, NULL, '2022-04-07 17:05:05', '2022-04-07 17:05:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (680, 399, '', '', 7, 1, NULL, '2022-04-07 17:12:40', '2022-04-07 17:12:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (681, 400, '', '', 7, 1, NULL, '2022-04-07 17:35:05', '2022-04-07 17:35:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (682, 282, '', '', 3, 1, NULL, '2022-04-07 17:35:05', '2022-04-07 17:35:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (683, 401, '', '', 7, 1, NULL, '2022-04-07 17:49:01', '2022-04-07 17:49:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (684, 402, '', '', 7, 1, NULL, '2022-04-07 18:10:05', '2022-04-07 18:10:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (685, 403, '', '', 7, 1, NULL, '2022-04-07 18:22:58', '2022-04-07 18:22:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (686, 283, '', '', 3, 1, NULL, '2022-04-07 18:22:58', '2022-04-07 18:22:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (687, 404, '', '', 7, 1, NULL, '2022-04-07 18:45:20', '2022-04-07 18:45:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (688, 405, '', '', 7, 1, NULL, '2022-04-07 19:28:03', '2022-04-07 19:28:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (689, 406, '', '', 7, 1, NULL, '2022-04-07 19:31:16', '2022-04-07 19:31:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (690, 407, '', '', 7, 1, NULL, '2022-04-07 20:11:52', '2022-04-07 20:11:52');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (691, 408, '', '', 7, 1, NULL, '2022-04-07 20:51:02', '2022-04-07 20:51:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (692, 284, '', '', 3, 1, NULL, '2022-04-07 20:51:02', '2022-04-07 20:51:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (693, 409, '', '', 7, 1, NULL, '2022-04-07 20:54:39', '2022-04-07 20:54:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (694, 285, '', '', 3, 1, NULL, '2022-04-07 20:54:39', '2022-04-07 20:54:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (695, 410, '', '', 7, 1, NULL, '2022-04-08 08:05:55', '2022-04-08 08:05:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (696, 286, '', '', 3, 1, NULL, '2022-04-08 08:05:55', '2022-04-08 08:05:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (697, 411, '', '', 7, 1, NULL, '2022-04-08 08:47:16', '2022-04-08 08:47:16');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (698, 412, '', '', 7, 1, NULL, '2022-04-08 08:49:48', '2022-04-08 08:49:48');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (699, 413, '', '', 7, 1, NULL, '2022-04-08 08:55:21', '2022-04-08 08:55:21');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (700, 414, '', '', 7, 1, NULL, '2022-04-08 09:06:39', '2022-04-08 09:06:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (701, 287, '', '', 3, 1, NULL, '2022-04-08 09:06:39', '2022-04-08 09:06:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (702, 415, '', '', 7, 1, NULL, '2022-04-08 09:11:57', '2022-04-08 09:11:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (703, 288, '', '', 3, 1, NULL, '2022-04-08 09:11:57', '2022-04-08 09:11:57');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (704, 416, '', '', 7, 1, NULL, '2022-04-08 09:14:27', '2022-04-08 09:14:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (705, 417, '', '', 7, 1, NULL, '2022-04-08 09:24:32', '2022-04-08 09:24:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (706, 418, '', '', 7, 1, NULL, '2022-04-08 09:39:50', '2022-04-08 09:39:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (707, 289, '', '', 3, 1, NULL, '2022-04-08 09:39:50', '2022-04-08 09:39:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (708, 419, '', '', 7, 1, NULL, '2022-04-08 09:57:04', '2022-04-08 09:57:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (709, 420, '', '', 7, 1, NULL, '2022-04-08 10:00:26', '2022-04-08 10:00:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (710, 421, '', '', 7, 1, NULL, '2022-04-08 10:13:05', '2022-04-08 10:13:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (711, 290, '', '', 3, 1, NULL, '2022-04-08 10:13:05', '2022-04-08 10:13:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (712, 422, '', '', 7, 1, NULL, '2022-04-08 10:38:42', '2022-04-08 10:38:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (713, 291, '', '', 3, 1, NULL, '2022-04-08 10:38:42', '2022-04-08 10:38:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (714, 423, '', '', 7, 1, NULL, '2022-04-08 10:50:41', '2022-04-08 10:50:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (715, 424, '', '', 7, 1, NULL, '2022-04-08 11:07:02', '2022-04-08 11:07:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (716, 292, '', '', 3, 1, NULL, '2022-04-08 11:07:02', '2022-04-08 11:07:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (717, 425, '', '', 7, 1, NULL, '2022-04-08 11:13:11', '2022-04-08 11:13:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (718, 293, '', '', 3, 1, NULL, '2022-04-08 11:13:11', '2022-04-08 11:13:11');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (719, 426, '', '', 7, 1, NULL, '2022-04-08 11:22:42', '2022-04-08 11:22:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (720, 294, '', '', 3, 1, NULL, '2022-04-08 11:22:42', '2022-04-08 11:22:42');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (721, 427, '', '', 7, 1, NULL, '2022-04-08 11:35:12', '2022-04-08 11:35:12');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (722, 428, '', '', 7, 1, NULL, '2022-04-08 11:43:07', '2022-04-08 11:43:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (723, 295, '', '', 3, 1, NULL, '2022-04-08 11:43:07', '2022-04-08 11:43:07');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (724, 429, '', '', 7, 1, NULL, '2022-04-08 11:50:02', '2022-04-08 11:50:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (725, 430, '', '', 7, 1, NULL, '2022-04-08 11:55:13', '2022-04-08 11:55:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (726, 296, '', '', 3, 1, NULL, '2022-04-08 11:55:13', '2022-04-08 11:55:13');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (727, 431, '', '', 7, 1, NULL, '2022-04-08 11:59:22', '2022-04-08 11:59:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (728, 297, '', '', 3, 1, NULL, '2022-04-08 11:59:22', '2022-04-08 11:59:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (729, 432, '', '', 7, 1, NULL, '2022-04-08 12:13:58', '2022-04-08 12:13:58');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (730, 433, '', '', 7, 1, NULL, '2022-04-08 12:20:55', '2022-04-08 12:20:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (731, 298, '', '', 3, 1, NULL, '2022-04-08 12:20:55', '2022-04-08 12:20:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (732, 434, '', '', 7, 1, NULL, '2022-04-08 12:22:41', '2022-04-08 12:22:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (733, 435, '', '', 7, 1, NULL, '2022-04-08 12:31:00', '2022-04-08 12:31:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (734, 436, '', '', 7, 1, NULL, '2022-04-08 12:35:32', '2022-04-08 12:35:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (735, 437, '', '', 7, 1, NULL, '2022-04-08 12:55:55', '2022-04-08 12:55:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (736, 299, '', '', 3, 1, NULL, '2022-04-08 12:55:55', '2022-04-08 12:55:55');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (737, 438, '', '', 7, 1, NULL, '2022-04-08 13:03:54', '2022-04-08 13:03:54');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (738, 439, '', '', 7, 1, NULL, '2022-04-08 13:29:31', '2022-04-08 13:29:31');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (739, 440, '', '', 7, 1, NULL, '2022-04-08 13:59:25', '2022-04-08 13:59:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (740, 441, '', '', 7, 1, NULL, '2022-04-08 14:37:24', '2022-04-08 14:37:24');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (741, 442, '', '', 7, 1, NULL, '2022-04-08 14:54:08', '2022-04-08 14:54:08');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (742, 443, '', '', 7, 1, NULL, '2022-04-08 15:33:30', '2022-04-08 15:33:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (743, 444, '', '', 7, 1, NULL, '2022-04-08 15:48:31', '2022-04-08 15:48:31');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (744, 445, '', '', 7, 1, NULL, '2022-04-08 16:03:01', '2022-04-08 16:03:01');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (745, 446, '', '', 7, 1, NULL, '2022-04-08 16:53:14', '2022-04-08 16:53:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (746, 447, '', '', 7, 1, NULL, '2022-04-08 16:58:14', '2022-04-08 16:58:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (747, 300, '', '', 3, 1, NULL, '2022-04-08 16:58:14', '2022-04-08 16:58:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (748, 448, '', '', 7, 1, NULL, '2022-04-08 17:09:44', '2022-04-08 17:09:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (749, 449, '', '', 7, 1, NULL, '2022-04-08 17:14:30', '2022-04-08 17:14:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (750, 301, '', '', 3, 1, NULL, '2022-04-08 17:14:30', '2022-04-08 17:14:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (751, 450, '', '', 7, 1, NULL, '2022-04-08 17:28:29', '2022-04-08 17:28:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (752, 451, '', '', 7, 1, NULL, '2022-04-08 17:33:10', '2022-04-08 17:33:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (753, 452, '', '', 7, 1, NULL, '2022-04-08 18:07:41', '2022-04-08 18:07:41');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (754, 453, '', '', 7, 1, NULL, '2022-04-08 18:37:14', '2022-04-08 18:37:14');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (755, 454, '', '', 7, 1, NULL, '2022-04-08 18:50:39', '2022-04-08 18:50:39');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (756, 455, '', '', 7, 1, NULL, '2022-04-08 18:59:29', '2022-04-08 18:59:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (757, 302, '', '', 3, 1, NULL, '2022-04-08 18:59:29', '2022-04-08 18:59:29');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (758, 456, '', '', 7, 1, NULL, '2022-04-08 19:18:46', '2022-04-08 19:18:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (759, 303, '', '', 3, 1, NULL, '2022-04-08 19:18:46', '2022-04-08 19:18:46');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (760, 457, '', '', 7, 1, NULL, '2022-04-08 19:43:26', '2022-04-08 19:43:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (761, 304, '', '', 3, 1, NULL, '2022-04-08 19:43:26', '2022-04-08 19:43:26');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (762, 458, '', '', 7, 1, NULL, '2022-04-09 09:42:53', '2022-04-09 09:42:53');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (763, 459, '', '', 7, 1, NULL, '2022-04-09 09:47:09', '2022-04-09 09:47:09');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (764, 460, '', '', 7, 1, NULL, '2022-04-09 10:04:05', '2022-04-09 10:04:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (765, 305, '', '', 3, 1, NULL, '2022-04-09 10:04:05', '2022-04-09 10:04:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (766, 461, '', '', 7, 1, NULL, '2022-04-09 10:08:45', '2022-04-09 10:08:45');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (767, 306, '', '', 3, 1, NULL, '2022-04-09 10:08:45', '2022-04-09 10:08:45');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (768, 462, '', '', 7, 1, NULL, '2022-04-09 10:17:30', '2022-04-09 10:17:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (769, 307, '', '', 3, 1, NULL, '2022-04-09 10:17:30', '2022-04-09 10:17:30');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (770, 463, '', '', 7, 1, NULL, '2022-04-09 10:20:43', '2022-04-09 10:20:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (771, 464, '', '', 7, 1, NULL, '2022-04-09 10:22:23', '2022-04-09 10:22:23');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (772, 465, '', '', 7, 1, NULL, '2022-04-09 10:26:05', '2022-04-09 10:26:05');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (773, 466, '', '', 7, 1, NULL, '2022-04-09 10:31:17', '2022-04-09 10:31:17');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (774, 467, '', '', 7, 1, NULL, '2022-04-09 10:35:50', '2022-04-09 10:35:50');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (775, 468, '', '', 7, 1, NULL, '2022-04-09 10:40:35', '2022-04-09 10:40:35');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (776, 469, '', '', 7, 1, NULL, '2022-04-09 10:44:44', '2022-04-09 10:44:44');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (777, 470, '', '', 7, 1, NULL, '2022-04-09 10:47:00', '2022-04-09 10:47:00');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (778, 471, '', '', 7, 1, NULL, '2022-04-09 11:01:22', '2022-04-09 11:01:22');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (779, 472, '', '', 7, 1, NULL, '2022-04-09 11:03:27', '2022-04-09 11:03:27');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (780, 473, '', '', 7, 1, NULL, '2022-04-09 11:09:51', '2022-04-09 11:09:51');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (781, 474, '', '', 7, 1, NULL, '2022-04-09 11:13:25', '2022-04-09 11:13:25');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (782, 475, '', '', 7, 1, NULL, '2022-04-09 11:17:31', '2022-04-09 11:17:31');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (783, 308, '', '', 3, 1, NULL, '2022-04-09 11:17:31', '2022-04-09 11:17:31');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (784, 476, '', '', 7, 1, NULL, '2022-04-09 11:21:40', '2022-04-09 11:21:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (785, 309, '', '', 3, 1, NULL, '2022-04-09 11:21:40', '2022-04-09 11:21:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (786, 477, '', '', 7, 1, NULL, '2022-04-09 11:32:18', '2022-04-09 11:32:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (787, 478, '', '', 7, 1, NULL, '2022-04-09 11:40:32', '2022-04-09 11:40:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (788, 310, '', '', 3, 1, NULL, '2022-04-09 11:40:32', '2022-04-09 11:40:32');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (789, 311, '', '', 3, 1, NULL, '2022-04-09 11:49:20', '2022-04-09 11:49:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (790, 479, '', '', 7, 1, NULL, '2022-04-09 11:57:06', '2022-04-09 11:57:06');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (791, 480, '', '', 7, 1, NULL, '2022-04-09 12:11:40', '2022-04-09 12:11:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (792, 1, '', '', 7, 1, NULL, '2022-04-09 17:02:55', '2022-04-09 17:02:55');


#
# TABLE STRUCTURE FOR: patient
#

DROP TABLE IF EXISTS `patient`;

CREATE TABLE `patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `patient_id` varchar(10) NOT NULL,
  `category_id` int(11) NOT NULL,
  `birthday` date NOT NULL,
  `sex` varchar(10) NOT NULL,
  `blood_group` varchar(10) NOT NULL,
  `blood_pressure` varchar(100) NOT NULL,
  `height` varchar(10) NOT NULL,
  `weight` varchar(10) NOT NULL,
  `marital_status` varchar(10) NOT NULL,
  `age` varchar(10) DEFAULT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(30) NOT NULL,
  `email` varchar(200) NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `guardian` varchar(200) NOT NULL,
  `relationship` varchar(200) NOT NULL,
  `gua_mobileno` varchar(30) NOT NULL,
  `source` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `patient` (`id`, `name`, `patient_id`, `category_id`, `birthday`, `sex`, `blood_group`, `blood_pressure`, `height`, `weight`, `marital_status`, `age`, `address`, `mobileno`, `email`, `photo`, `guardian`, `relationship`, `gua_mobileno`, `source`, `created_at`, `updated_at`) VALUES (1, 'JESUS', 'a5404ad', 0, '0000-00-00', 'male', '', '', '', '', '', '70', '', '656533788733', '', '', '', '', '', 1, '2022-04-09 17:02:55', '2022-04-09 17:02:55');


#
# TABLE STRUCTURE FOR: patient_category
#

DROP TABLE IF EXISTS `patient_category`;

CREATE TABLE `patient_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

INSERT INTO `patient_category` (`id`, `name`) VALUES (22, 'CHILD');
INSERT INTO `patient_category` (`id`, `name`) VALUES (23, 'TEENAGE');
INSERT INTO `patient_category` (`id`, `name`) VALUES (24, 'ADULT');
INSERT INTO `patient_category` (`id`, `name`) VALUES (25, 'MIDDLE AGE');
INSERT INTO `patient_category` (`id`, `name`) VALUES (26, 'SENIOR CITIZEN');


#
# TABLE STRUCTURE FOR: patient_documents
#

DROP TABLE IF EXISTS `patient_documents`;

CREATE TABLE `patient_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` varchar(100) NOT NULL,
  `remarks` text NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `enc_name` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `patient_documents` (`id`, `patient_id`, `title`, `type`, `remarks`, `file_name`, `enc_name`, `created_at`, `updated_at`) VALUES (1, 1, 'Blood Test', 'Blood Test', '', 'QO2DJCUV_QP21126258.PDF', '611a74937a8fc801ee4c67492b68913b.PDF', '2022-03-08 21:04:30', '2022-03-08 21:04:30');


#
# TABLE STRUCTURE FOR: payment_type
#

DROP TABLE IF EXISTS `payment_type`;

CREATE TABLE `payment_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `payment_type` (`id`, `name`) VALUES (1, 'Cash');
INSERT INTO `payment_type` (`id`, `name`) VALUES (2, 'UPI Payment');
INSERT INTO `payment_type` (`id`, `name`) VALUES (3, 'Online Payment');
INSERT INTO `payment_type` (`id`, `name`) VALUES (4, 'Card Payment');


#
# TABLE STRUCTURE FOR: payout_commission
#

DROP TABLE IF EXISTS `payout_commission`;

CREATE TABLE `payout_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `bill_no` varchar(11) NOT NULL,
  `before_payout` decimal(18,2) NOT NULL DEFAULT '0.00',
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `pay_via` int(11) NOT NULL,
  `remarks` text,
  `paid_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: payslip
#

DROP TABLE IF EXISTS `payslip`;

CREATE TABLE `payslip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `month` varchar(20) DEFAULT NULL,
  `year` varchar(20) NOT NULL,
  `basic_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `total_allowance` decimal(18,2) NOT NULL DEFAULT '0.00',
  `total_deduction` decimal(18,2) NOT NULL DEFAULT '0.00',
  `net_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `bill_no` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `pay_via` tinyint(1) NOT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `paid_by` int(11) NOT NULL,
  `payment_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: payslip_details
#

DROP TABLE IF EXISTS `payslip_details`;

CREATE TABLE `payslip_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payslip_id` varchar(20) NOT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `type` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: permission
#

DROP TABLE IF EXISTS `permission`;

CREATE TABLE `permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `show_view` tinyint(2) DEFAULT '1',
  `show_add` tinyint(2) DEFAULT '1',
  `show_edit` tinyint(2) DEFAULT '1',
  `show_delete` tinyint(2) DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8;

INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (1, 2, 'Patient', 'patient', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (2, 2, 'Patient Category', 'patient_category', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (3, 6, 'Employee', 'employee', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (4, 6, 'Department', 'department', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (5, 6, 'Designation', 'designation', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (6, 6, 'Login Deactivate', 'employee_disable_authentication', 1, 0, 1, 0, '2019-05-27 23:56:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (7, 7, 'Salary Template', 'salary_template', 1, 1, 1, 1, '2019-05